/**
 * @brief           SSC Primitive Header
 * @author          AXELL CORPORATION
 * @description     SSC Primitive񋟃wb_B<p>SSC PrimitivegpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _SSCPRM_H_
#define _SSCPRM_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include "lib_common/AG903_common.h"

#ifdef __cplusplus
extern "C" {
#endif

#define AG903_SSC_SYSINT_CH_NUM			(4)		/** VXeWX^CH */
#define	AG903_SSC_PINFUNC_REG_NUM		(2)		/** [q@\IWX^ */
#define AG903_SSC_PIN_SETUP_INDEX_MAX	(136)	/** [qݒINDEXől */
#define	AG903_SSC_GPIOEN_REG_NUM		(4)		/** [qGPIOIWX^ */
#define	AG903_SSC_GPIOPU_REG_NUM		(4)		/** [qGPIOvAbvݒ背WX^ */
#define	AG903_SSC_GPIOPD_REG_NUM		(4)		/** [qGPIOv_Eݒ背WX^ */
#define	AG903_SSC_DMASEL_REG_NUM		(4)		/** DMAytFC^[tF[XIWX^ */
#define AG903_SSC_TICKCNT_CH_NUM		(2)		/** TickJE^CH */
#define AG903_SSC_CVBSDEC_CH_NUM		(4)		/** R|WbgrfIfR[_CH */

#define AG903_SSC_PINDIR_INPUT 			(0)		/** [qo͎w () */
#define	AG903_SSC_PINDIR_OUTPUT			(1)		/** [qo͎w (o) */

#define AG903_SSC_SSPMODE_FLLDPLX 		(0)		/** Sd[h */
#define	AG903_SSC_SSPMODE_HLFDPLX		(1)		/** d[h */

#define	AG903_SSC_PBHWAIT_HWAIT			(0)		/** nHWAIT[qw */
#define AG903_SSC_PBHWAIT_BLP0BLGT 		(1)		/** BLP0_BLGT[qw */

#define	AG903_SSC_USBMODE_HOST			(0)		/** USB HOSTw */
#define AG903_SSC_USBMODE_DEVICE 		(1)		/** USB DEVICEw */


/** PIN SETUP DATÃrbg` */
#define AG903_SSC_PIN_SETUP_LS3V_POS	(7)											/** I/Odݒ ʒu */
#define AG903_SSC_PIN_SETUP_LS3V_MSK	(0x1UL<<AG903_SSC_PIN_SETUP_LS3V_POS)		/** I/Odݒ }XN */
#define AG903_SSC_PIN_SETUP_DV_POS		(5)											/** o͓dݒ ʒu */
#define AG903_SSC_PIN_SETUP_DV_MSK		(0x3UL<<AG903_SSC_PIN_SETUP_DV_POS)			/** o͓dݒ }XN */
#define AG903_SSC_PIN_SETUP_SR_POS		(4)											/** X[[gݒ ʒu */
#define AG903_SSC_PIN_SETUP_SR_MSK		(0x1UL<<AG903_SSC_PIN_SETUP_SR_POS)			/** X[[gݒ }XN */
#define AG903_SSC_PIN_SETUP_SMT_POS		(3)											/** V~bggKݒ ʒu */
#define AG903_SSC_PIN_SETUP_SMT_MSK		(0x1UL<<AG903_SSC_PIN_SETUP_SMT_POS)		/** V~bggKݒ }XN */
#define AG903_SSC_PIN_SETUP_LVST_POS	(0)											/** xL[vݒ ʒu */
#define AG903_SSC_PIN_SETUP_LVST_MSK	(0x7UL<<AG903_SSC_PIN_SETUP_LVST_POS)		/** xL[vݒ }XN */

/** WDT݃[h */
enum  _AG903_SSC_WdtIntMode {
	AG903_SSC_WDTINT_PULSE = 0,	/** pX */
	AG903_SSC_WDTINT_LEVEL,		/** x */
};

/** [qxp[^ */
enum  _AG903_SSC_PINSETUP_LVST {
	AG903_SSC_INPUT_DISABLE = 0,	/** ͖ */
	AG903_SSC_INPUT_DISABLE_PLDWN,	/** ͖,PullDown */
	AG903_SSC_INPUT_DISABLE_PLUP,	/** ͖,PullUp */
	AG903_SSC_INPUT_ENABLE  = 4,	/** ͗L */
	AG903_SSC_INPUT_ENABLE_PLDWN,	/** ͗L,PullDown */
	AG903_SSC_INPUT_ENABLE_PLUP,	/** ͗L,PullUp */
	AG903_SSC_INPUT_ENABLE_LVKP,	/** ͗L,LevelKeep */
};

/** NbN\[Xw */
enum  _AG903_SSC_TICK_SOURCE {
	AG903_SSC_TICKSRC_SYSCLK = 0,	/** VXeNbN */
	AG903_SSC_TICKSRC_INTERNAL,		/** Uo */
	AG903_SSC_TICKSRC_ALT0,			/** ALT0 CLK */
	AG903_SSC_TICKSRC_ALT1,			/** ALT1 CLK */
	AG903_SSC_TICKSRC_SSP0MCLK,		/** SSP0 MCLK */
	AG903_SSC_TICKSRC_SSP1MCLK,		/** SSP1 MCLK */
	AG903_SSC_TICKSRC_SSP2MCLK,		/** SSP2 MCLK */
	AG903_SSC_TICKSRC_SSP3MCLK,		/** SSP3 MCLK */
};



/** [qݒp[^ */
typedef struct _AG903_SSCPrmPinSetup{
	uint8_t		io3v;		/** I/Od (true=3[V],false=1.8[V]) */
	uint8_t		drive;		/** o͓dݒ */
	uint8_t		sr_slow;	/** X[[gݒ (true=Slow,false=Fast) */
	uint8_t		schmitt;	/** V~bggKݒ (true=,false=Ȃ) */
	uint8_t		lv_set;		/** xݒ */
	uint8_t		reserve[3];	/** \ */
}AG903_SSCPrmPinSetup;

/** CA5Xe[^X */
typedef struct _AG903_SSCPrmCpuRunStatus{
	uint8_t		sev_op;		/** SEVߎsL (true/false) */
	uint8_t		wfi_stby;	/** WFIX^oC (true/false) */
	uint8_t		wfe_stby;	/** WFEX^oC (true/false) */
	uint8_t		reset;		/** Zbg (true/false) */
	uint8_t		clk;		/** NbN (true/false) */
	uint8_t		reserve[3];	/** \ */
}AG903_SSCPrmCpuRunStatus;

/** \o͒[qݒ */
typedef struct _AG903_SSCPrmDspSetup{
	uint8_t		vsync0;		/** CMOS\o0VSYNC[q */
	uint8_t		field0;		/** CMOS\o0FIELD[q */
	uint8_t		dot0;		/** CMOS\o0̃hbgNbN[q */
	uint8_t		vsync1;		/** CMOS\o1VSYNC[q */
	uint8_t		field1;		/** CMOS\o1FIELD[q */
	uint8_t		dot1;		/** CMOS\o1̃hbgNbN[q */
	uint8_t		reserve[2];	/** \ */
}AG903_SSCPrmDspSetup;

/** SSP[qo͐ݒ */
typedef struct _AG903_SSCPrmSspSetup{
	uint8_t		mclk_div;	/** MCLKo͎̕ */
	uint8_t		mclk_dir;	/** MCLK[q̕ (d) */
	uint8_t		mode;		/** O[q[h (Sd / d) */
	uint8_t		dir;		/** O[q̕ (d) */
}AG903_SSCPrmSspSetup;

/** TDM[0-3]_SETUPݒp[^ */
typedef struct _AG903_SSCPrmTdmParam{
	uint8_t		enable;		/** TDMtH[}b^ L/ */
	uint8_t		sclk_pol;	/** NbNɐ */
	uint8_t		fs_pol;		/** FSMɐ */
	uint8_t		fs_txpw;	/** FSMpX */
	uint8_t		fs_dist;	/** FSMƃf[^M̊Jn^C~O */
	uint8_t		dir_tx;		/** [qo͐ */
	uint8_t		tdm_n;		/** d */
	uint8_t		sclk_n;		/** 1ch̃rbg */
} AG903_SSCPrmTdmParam;

/** TDM */
typedef struct _AG903_SSCPrmTdmStatus{
	uint8_t		rx_err;		/** MtH[}bgG[ */
	uint8_t		tx_stat;	/** M */
	uint8_t		rx_stat;	/** M */
	uint8_t		reserve[2];	/** \ */
} AG903_SSCPrmTdmStatus;

/** rfIADCݒp[^ */
typedef struct _AG903_SSCPrmVideoAdcParam{
	uint8_t		acq_clr;	/** ADCőlŏlWX^NA */
	uint8_t		acq_en;		/** ADCőlŏlWX^lXV */
	uint8_t		dat_en;		/** ADCo̓f[^Cl[u */
	uint8_t		clmp_tmg;	/** Nv^C~OI */
	uint8_t		clmp_lv;	/** NvxI */
	uint8_t		pga_ctl;	/** PGAI */
	uint8_t		reserve[2];	/** \ */
} AG903_SSCPrmVideoAdcParam;


void AG903_SSCPrmGetRevesion(uint32_t* rev);
void AG903_SSCPrmGetModeStatus(uint8_t* btmode, uint8_t* bttest, uint8_t* status);
void AG903_SSCPrmClrModeStatus(uint8_t clr);
void AG903_SSCPrmGetIrqStatus(uint32_t* lower, uint32_t* upper);
void AG903_SSCPrmGetIntBusStatus(uint8_t* status);
void AG903_SSCPrmSetIntBusEnable(uint8_t enable);
void AG903_SSCPrmGetIntBusEnable(uint8_t* status);
void AG903_SSCPrmGetSysIntStatus(uint32_t* lower, uint32_t* middle, uint32_t* upper);
void AG903_SSCPrmSetSysIntEnable(uint8_t ch, uint32_t lower, uint32_t middle, uint32_t upper);
void AG903_SSCPrmGetSysIntEnable(uint8_t ch, uint32_t* lower, uint32_t* middle, uint32_t* upper);
void AG903_SSCPrmSetGfxClkDuty(uint8_t clk, uint8_t duty);
void AG903_SSCPrmGetGfxClkDuty(uint8_t* clk, uint8_t* duty);
void AG903_SSCPrmSetGvdClkDuty(uint8_t duty);
void AG903_SSCPrmGetGvdClkDuty(uint8_t* duty);
void AG903_SSCPrmSetWdtIntMode(uint8_t mode);
void AG903_SSCPrmGetWdtIntMode(uint8_t* mode);
void AG903_SSCPrmClrWdtInt(void);
void AG903_SSCPrmSetWdtOutputMode(uint8_t rst_ini, uint8_t rst_wdt, uint8_t wdt_ena, uint8_t wdt_od);
void AG903_SSCPrmGetWdtOutputMode(uint8_t* rst_ini, uint8_t* rst_wdt, uint8_t* wdt_ena, uint8_t* wdt_od);
void AG903_SSCPrmSetPinFunction(uint8_t reg_no, uint32_t val);
void AG903_SSCPrmGetPinFunction(uint8_t reg_no, uint32_t* val);
void AG903_SSCPrmSetPinSetup(uint8_t tbl_no, AG903_SSCPrmPinSetup* setup);
void AG903_SSCPrmGetPinSetup(uint8_t tbl_no, AG903_SSCPrmPinSetup* setup);
void AG903_SSCPrmSetPinGpioEnable(uint8_t reg_no, uint32_t val);
void AG903_SSCPrmGetPinGpioEnable(uint8_t reg_no, uint32_t* val);
void AG903_SSCPrmSetPinGpioPullUp(uint8_t reg_no, uint32_t val);
void AG903_SSCPrmGetPinGpioPullUp(uint8_t reg_no, uint32_t* val);
void AG903_SSCPrmSetPinGpioPullDown(uint8_t reg_no, uint32_t val);
void AG903_SSCPrmGetPinGpioPullDown(uint8_t reg_no, uint32_t* val);
void AG903_SSCPrmSetCpuSetup(uint8_t clk, uint8_t rst, uint8_t vbit);
void AG903_SSCPrmGetCpuSetup(uint8_t* clk, uint8_t* rst, uint8_t* vbit);
void AG903_SSCPrmClrCpuEventOutStatus(void);
void AG903_SSCPrmGetCpuStatus(AG903_SSCPrmCpuRunStatus* status);
void AG903_SSCPrmSetCpuAcpSetup(uint32_t acp_addr);
void AG903_SSCPrmGetCpuAcpSetup(uint32_t* acp_addr);
void AG903_SSCPrmSetDmaInterface(uint8_t reg_no, uint32_t val);
void AG903_SSCPrmGetDmaInterface(uint8_t reg_no, uint32_t* val);
void AG903_SSCPrmSetPbdDmaInterface(uint8_t val);
void AG903_SSCPrmGetPbdDmaInterface(uint8_t* val);
void AG903_SSCPrmSetDspPinDir(AG903_SSCPrmDspSetup* dir);
void AG903_SSCPrmGetDspPinDir(AG903_SSCPrmDspSetup* dir);
void AG903_SSCPrmSetTickSetup(uint8_t ch, uint8_t clksel, uint32_t div);
void AG903_SSCPrmGetTickSetup(uint8_t ch, uint8_t* clksel, uint32_t* div);
void AG903_SSCPrmSetTimerPinDir(uint8_t tim_dir);
void AG903_SSCPrmGetTimerPinDir(uint8_t* tim_dir);
void AG903_SSCPrmSetSspSetup(uint8_t ch, AG903_SSCPrmSspSetup* param);
void AG903_SSCPrmGetSspSetup(uint8_t ch, AG903_SSCPrmSspSetup* param);
void AG903_SSCPrmSetPbdCheckAddr(uint32_t sta_addr, uint32_t end_addr);
void AG903_SSCPrmGetPbdCheckAddr(uint32_t* sta_addr, uint32_t* end_addr);
void AG903_SSCPrmSetPbdAddrCheckEnable(uint8_t enable);
void AG903_SSCPrmGetPbdAddrCheckEnable(uint8_t* enable);
void AG903_SSCPrmGetPbdAddrCheckStatus(uint8_t* status);
void AG903_SSCPrmGetBmuStatus(uint16_t* src_req, uint16_t* src_rdy, uint8_t* snk_req, uint8_t* snk_rdy);
void AG903_SSCPrmSetBmuControl(uint16_t set_src, uint16_t clr_src, uint8_t set_snk, uint8_t clr_snk);
void AG903_SSCPrmGetBmuTriggerStatus(uint16_t* src_req, uint16_t* src_rdy, uint8_t* snk_req, uint8_t* snk_rdy);
void AG903_SSCPrmClrBmuTriggerStatus(uint16_t src_req, uint16_t src_rdy, uint8_t snk_req, uint8_t snk_rdy);
void AG903_SSCPrmSetPortWait(uint16_t wait);
void AG903_SSCPrmGetPortWait(uint16_t* wait);
void AG903_SSCPrmSetPbhMode(uint8_t wait_sel);
void AG903_SSCPrmGetPbhMode(uint8_t* wait_sel);
void AG903_SSCPrmSetTdmSetup(uint8_t ch, AG903_SSCPrmTdmParam* param);
void AG903_SSCPrmGetTdmSetup(uint8_t ch, AG903_SSCPrmTdmParam* param, AG903_SSCPrmTdmStatus* stat);
void AG903_SSCPrmSetUsbPowerSetup(uint8_t mode, uint8_t int_ena, uint8_t prtct_ena);
void AG903_SSCPrmGetUsbPowerSetup(uint8_t* mode, uint8_t* int_ena, uint8_t* prtct_ena);
void AG903_SSCPrmGetUsbPowerStatus(uint8_t* vbus_lv, uint8_t* prtct_lv, uint8_t* prtct_stat);
void AG903_SSCPrmClrUsbPowerStatus(void);
void AG903_SSCPrmSetSdPowerSetup(uint8_t int_ena, uint8_t prtct_ena);
void AG903_SSCPrmGetSdPowerSetup(uint8_t* int_ena, uint8_t* prtct_ena);
void AG903_SSCPrmGetSdPowerStatus(uint8_t* prtct_lv, uint8_t* prtct_stat);
void AG903_SSCPrmClrSdPowerStatus(void);
void AG903_SSCPrmSetVideoAdcSetup(AG903_SSCPrmVideoAdcParam* param);
void AG903_SSCPrmGetVideoAdcSetup(AG903_SSCPrmVideoAdcParam* param);
void AG903_SSCPrmWriteCmpstVideoDec(uint8_t ch, uint16_t reg, uint16_t data);
void AG903_SSCPrmReadCmpstVideoDec(uint8_t ch, uint16_t reg, uint16_t* data);
void AG903_SSCPrmGetVideoAdcMaxMin(uint8_t ch, uint16_t* max, uint16_t* min);
void AG903_SSCPrmGetSgiStatus(uint32_t* stat);
void AG903_SSCPrmSetSgi(uint32_t set);
void AG903_SSCPrmClrSgi(uint32_t clr);
void AG903_SSCPrmSetCpuJumpAddr(uint32_t addr);
void AG903_SSCPrmGetCpuJumpAddr(uint32_t* addr);
void AG903_SSCPrmSetFreeRunCnt(uint32_t upper, uint32_t lower);
void AG903_SSCPrmGetFreeRunCnt(uint32_t* upper, uint32_t* lower);

#ifdef __cplusplus
}
#endif
#endif /* _SSCPRM_H_ */

