/** 
 * @brief           USBH MSC BOT StorUnit Header
 * @author          AXELL CORPORATION
 * @description     USBH MSC BOT StorUnit Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#ifndef __USB_MSC_BOT_STORUNIT_H__
#define __USB_MSC_BOT_STORUNIT_H__

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_msc_coreinclude.h"
#include "usb_msc_bot.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern STOR_UNIT* Usbh_Stor_CreateStorUnit(STOR_DEVICE *pParentDevice, uhs_ubit8_t u8UnitNumber);
extern uhs_boolean_t Usbh_Stor_DeleteStorUnit(STOR_UNIT *pThis);
extern STOR_UNIT* Usbh_Stor_CreateDummyUnit(STOR_DEVICE *pParentDevice);

extern uhs_ubit8_t* Usbh_Stor_StorUnit_CallocCB(STOR_UNIT *pStorUnit, uhs_ubit16_t u16Size);
extern uhs_boolean_t Usbh_Stor_StorUnit_FreeCB(STOR_UNIT *pStorUnit, uhs_ubit8_t *pCb);

extern uhs_ubit8_t* Usbh_Stor_StorUnit_MallocCBData(STOR_UNIT *pStorUnit, uhs_ubit32_t u32Size);
extern uhs_boolean_t Usbh_Stor_StorUnit_FreeCBData(STOR_UNIT *pStorUnit, uhs_ubit8_t *pCbData);
extern uhs_ubit8_t* Usbh_Stor_StorUnit_AssignCBData(STOR_UNIT *pStorUnit, uhs_ubit8_t *pCbData, uhs_ubit32_t u32Size);

extern uhs_ubit8_t Usbh_Stor_StorUnit_GetLUN(STOR_UNIT *pStorUnit);
extern USB_BOT_STATUS Usbh_Stor_StorUnit_ExecuteCb(STOR_UNIT *pStorUnit, uhs_ubit8_t *pCb, uhs_ubit8_t u8CbLen, uhs_ubit8_t *pDataBuf, uhs_ubit32_t u32DataLen, CB_DATA_DIR nDataDirection);
extern uhs_boolean_t Usbh_Stor_StorUnit_MakeCbw(STOR_UNIT *pStorUnit, uhs_ubit8_t *pCb, uhs_ubit8_t u8CbLen, uhs_ubit32_t u32DataLen, CB_DATA_DIR nDataDirection, STOR_BUFF *pCBW);
extern uhs_boolean_t Usbh_Stor_StorUnit_Check(STOR_UNIT *pStorUnit);

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_MSC_BOT_STORUNIT_H__ */
