/** 
 * @brief		USB HOST API Wrapper Header
 * @author      AXELL CORPORATION
 * @description	USB HOST API Wrapper񋟃wb_B
 * @note		none
 * @history     2017_02_22	
 * @history     2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
#ifndef __USBH_API_H__
    #define __USBH_API_H__
/* DOM-IGNORE-END */


// *************************************************************************************************
//	include
// *************************************************************************************************
//#include	"uhs_config.h"
#include	"uhs_type.h"
#include	"depend_cfg.h"														//	open_usbdi.h ł̎Qƃ}NL
#include	"open_usbdi.h"
#include	"wrapper_kernel.h"
#include	"usbc_api.h"

/** dԁiONj*/
#define USBH_RH_PORT_POWER_ON				(0x1U)
/** dԁiOFFj*/
#define USBH_RH_PORT_POWER_OFF				(0x0U)

/**	I[o[JgCALLBACKʁi[gHUBł̃I[o[Jgoj*/
#define	USBH_OVCR_KIND_ROOT_HUB				(1)
/**	I[o[JgCALLBACKʁiėpHUBŜł̃I[o[Jgoj*/
#define	USBH_OVCR_KIND_GENERIC_HUB			(2)
/**	I[o[JgCALLBACKʁiėpHUB̓|[gł̃I[o[Jgoj*/
#define	USBH_OVCR_KIND_GENERIC_PORT			(3)

/**	CALLBACK֐ReturnliOKj*/
#define	USBH_CBRTN_OK						(0)
/**	CALLBACK֐ReturnliNG[R킸]j*/
#define	USBH_CBRTN_NG						(-1)
/**	CALLBACK֐ReturnliNG[ڑOVER]j*/
#define	USBH_CBRTN_NG_TOOMANY				(-2)


/**	I[o[JgCALLBACKւ̃p[^` */
struct usbh_overcurrent_info {
    struct usbd_usb_deviceinfo		*usbhub;									/** ߓdnufoCX */
    uhs_ubit8_t						port_num;									/** ߓd|[gԍ */
	uhs_ubit8_t						ovcr_kind;									/**	I[o[Jg */
};

/**	Split Error Notify CALLBACKւ̃p[^` */
struct usbh_split_err_notify_info {

	struct	usbd_usb_spliterrinfo	*split_err_info;							/**	SplitG[̏
																					CLEAR_TT_BUFFERɕKvȏ̂݊܂ށB */
};


/*
 * foCXwɂ|[g֘A̐錾()
 */

/** foCX */
typedef struct usbd_usb_deviceinfo *PUSB_DEVICE;

/** foCX̃NX^Cv */
typedef enum {
    DEV_TYPE_NONE,																/** ` */
    DEV_TYPE_OTHER,																/** ̑̃foCX */
    DEV_TYPE_ROOT,																/** Root HUB */
    DEV_TYPE_HUB,																/** HUB foCX */
    DEV_TYPE_STOR,																/** Storage foCX */
    DEV_TYPE_CDC,																/** CDC foCX */
    DEV_TYPE_HID																/** HID foCX */
} DEVICE_TYPE;

/*
 * foCXwɂ|[g֘A̐錾(܂)
 */


/*
 * Xe[^Xʒm֘A̐錾()
 */

/** Oʎwp */
typedef enum _usb_logtype {
    USB_MSGMON_LOGTYPE_ANALYSIS,												/** ̓O */
    USB_MSGMON_LOGTYPE_NORMALOP													/** ^pO */
} usb_logtype;


/** ̓OpbZ[WtH[}bg<p>
    USB Host ew͖{\̂găbZ[W𓊂ĉB<p>
    ̓Ow莞AAvP[Vɂ͖{\̂Œʒms܂B */
typedef struct _usb_msgformat {
    uhs_ubit8_t  msglayer;														/** bZ[W̑MKw */
    uhs_ubit8_t  msgsublayer;													/** bZ[WMKw̕Kw */
    uhs_ubit8_t  msgtype;														/** bZ[W^Cv */
    uhs_ubit8_t  msglevel;														/** bZ[Wx */
    uhs_ubit16_t msgdata;														/** bZ[Wf[^ */
    uhs_ubit16_t extdatasize;													/** extdata ɃNꂽf[^TCY */
    void *       extdata;														/** gbZ[Wf[^ւ̃|C^ */
    SYSTIM      rcvdtime;														/** M */
} usb_msgformat;


/** ^ppbZ[WtH[}bg<p>
    ^pOw莞AAvP[Vɂ͖{\̂Œʒms܂B*/
typedef struct _usb_simple_msgformat {
    uhs_ubit8_t  msglayer;														/** bZ[W̑MKw */
    uhs_ubit8_t  msgsublayer;													/** bZ[WMKw̕Kw */
    uhs_ubit8_t  msgtype;														/** bZ[W^Cv */
    uhs_ubit8_t  msglevel;														/** bZ[Wx */
    uhs_ubit16_t msgdata;														/** bZ[Wf[^ */
    uhs_ubit16_t extdatasize;													/** extdata ɃNꂽf[^TCY */
    void *       extdata;														/** gbZ[Wf[^ւ̃|C^ */
    SYSTIM      rcvdtime;														/** M */
} usb_simple_msgformat;


/** bZ[W̑MKw ( msglayer ) */
typedef enum _usb_msglayer {
    USB_MSGMON_LAYER_USBH_HCD,													/**	HCD */
    USB_MSGMON_LAYER_USBH_CORE,													/**	RA */
    USB_MSGMON_LAYER_USBH_CLASSDRIVER,											/**	NXhCo */
    USB_MSGMON_LAYER_USBH_FILESYSTEM											/**	t@CVXe */
} usb_msglayer;


//--------------------------------------------------------------------------------------------------
// bZ[WMKw ( msgsublayer )
//--------------------------------------------------------------------------------------------------

// RA̕Kw͖Bmsgsublayer ɂ 0 wB

/** HCD ̕Kw */
typedef enum _usb_msgsublayer_hcd {
    USB_MSGMON_SUBLAYER_HCD_OHCI,												/**	OHCI hCo */
    USB_MSGMON_SUBLAYER_HCD_EHCI												/**	EHCI hCo */
} usb_msgsublayer_hcd;

/** NXhCo̕Kw */
typedef enum _usb_msgsublayer_clsdrv {
    USB_MSGMON_SUBLAYER_CLSDRV_STOR,											/** }XXg[WNXhCo */
    USB_MSGMON_SUBLAYER_CLSDRV_HUB,												/**	nuhCo */
    USB_MSGMON_SUBLAYER_CLSDRV_CDC,												/**	R~jP[VfoCXNXhCo */
    USB_MSGMON_SUBLAYER_CLSDRV_HID												/**	HIDNXhCo */
} usb_msgsublayer_clsdrv;

// t@CVXe̕Kw͖Bmsgsublayer ɂ 0 wB



/** bZ[Wx ( msglevel ) */
typedef enum _usg_msglevel {
    USB_MSGMON_MSGLVL_MILESTONE,												/**	ʏCxg */
    USB_MSGMON_MSGLVL_ERROR,													/**	G[ */
    USB_MSGMON_MSGLVL_WARNING													/**	x */
} usb_msglevel;


/** EHCI Xe[^XR[h( msgdata ) */
/**	C[KERR */
#define USBHC_ILLEGAL_ERROR			(1)
/**	\[XERR */
#define USBHC_RESOURCE_UNAVAIL		(2)
/**	p[^ERR */
#define USBHC_INVALID_PARAMETER		(3)
/**	FORCE_RESUME rbg0ɖ߂ȂB*/
#define	USBHC_RESUME_NOT_ZEORRTN	(4)


/** EHCI }CXg[ */
/**  */
#define USBHC_EHCI_INIT_COMP        (1)
/** 폜 */
#define USBHC_EHCI_EXIT_COMP        (2)
/** foCXڑ */
#define USBHC_DEVICE_CONNECT        (3)
/** foCXؒf */
#define USBHC_DEVICE_DISCONNECT     (4)
/** |[gON */
#define USBHC_EHCI_PORTPOWER_ON     (5)
/** |[gOFF */
#define USBHC_EHCI_PORTPOWER_OFF    (6)

/** CORE Xe[^XR[h( msgdata ) */
/** AhXERR */
#define USBC_INVALID_ADDRESS        (1)
/** C^[tF[XERR */
#define USBC_INVALID_INTERFACE      (2)
/** Gh|CgERR */
#define USBC_INVALID_ENDPOINT       (3)
/** pCvERR */
#define USBC_INVALID_PIPE           (4)
/** p[^ERR */
#define USBC_INVALID_PARAMETER      (5)
/** pCvHALT */
#define USBC_PIPE_HALT_ERROR        (6)
/** ohERR */
#define USBC_NO_BANDWIDTH           (7)
/** ERR */
#define USBC_INIT_ERROR             (8)
/** HOSTERR */
#define USBC_HOST_INIT_ERROR        (9)
/** C[KERR */
#define USBC_ILLEGAL_ERROR          (10)
/** \[XERR */
#define USBC_RESOURCE_UNAVAIL       (11)
/** pXSUSPEND */
#define USBC_BUS_SUSPEND            (12)
/** NGXgL[FULL */
#define USBC_REQUEST_QUEUE_FULL     (13)

/**	CORE  }CXg[ */
/**	CORE */
#define USBC_INIT_COMP              (1)
/**	COREI */
#define USBC_EXIT_COMP              (2)
/**	Gj[VJn */
#define USBC_ENUM_START             (3)
/**	Gj[VI */
#define USBC_ENUM_END               (4)

/** HUB Xe[^XR[h( msgdata ) */
/**	I[o[Jgo */
#define USBCLS_HUB_DETECT_OVERCURRENT   (1)
/**	C[KERR */
#define USBCLS_HUB_ILLEGAL_ERROR        (2)
/**	\[XERR */
#define USBCLS_HUB_RESOURCE_UNAVAIL     (3)
/**	p[^ERR */
#define USBCLS_HUB_INVALID_PARAMETER    (4)
/**	PORT_RESETɎs */
#define USBCLS_HUB_IMPORTANT_ERROR		(5)
/**	Xe[^XERR */
#define USBCLS_HUB_INVALID_STATUS		(6)
/**	ڑ\䐔I[o[ */
#define USBCLS_HUB_OVERCONN				(7)

/** HUB }CXg[ */
/**	HUB튮 */
#define USBCLS_HUB_INIT_COMP            (1)
/**	HUBI튮 */
#define USBCLS_HUB_EXIT_COMP            (2)
/**	PORTւ̗LfoCXڑo */
#define USBCLS_HUB_DEVICE_CONNECTED     (3)
/**	PORTɂ̃foCXؒfo */
#define USBCLS_HUB_DEVICE_DISCONNECTED  (4)
/**	HUBfoCXڑs */
#define	USBCLS_HUB_DEVICE_CONNECT_NG	(5)



/*
 * Xe[^Xʒm֘A̐錾(܂)
 */

//--------------------------------------------------------------------------------------------------
//	AssertʃR[h
//--------------------------------------------------------------------------------------------------
/** AssertʃR[h  TOPID */
#define		USBH_ASSERT_MEM_TOPID			(0x00010000)
/** AssertʃR[h  CREATE */
#define		USBH_ASSERT_MEM_CREATE			(USBH_ASSERT_MEM_TOPID | 0x00000001)
/** AssertʃR[h  ALLOC */
#define		USBH_ASSERT_MEM_ALLOC			(USBH_ASSERT_MEM_TOPID | 0x00000002)
/** AssertʃR[h  FREE */
#define		USBH_ASSERT_MEM_FREE			(USBH_ASSERT_MEM_TOPID | 0x00000003)
/** AssertʃR[h  DELETE */
#define		USBH_ASSERT_MEM_DELETE			(USBH_ASSERT_MEM_TOPID | 0x00000004)

/** AssertʃR[h Z}tH TOPID */
#define		USBH_ASSERT_SEM_TOPID			(0x00020000)						
/** AssertʃR[h Z}tH CREATE */
#define		USBH_ASSERT_SEM_CREATE			(USBH_ASSERT_SEM_TOPID | 0x00000001)
/** AssertʃR[h Z}tH ACQU */
#define		USBH_ASSERT_SEM_ACQU			(USBH_ASSERT_SEM_TOPID | 0x00000002)
/** AssertʃR[h Z}tH REL */
#define		USBH_ASSERT_SEM_REL				(USBH_ASSERT_SEM_TOPID | 0x00000003)
/** AssertʃR[h Z}tH DELETE */
#define		USBH_ASSERT_SEM_DELETE			(USBH_ASSERT_SEM_TOPID | 0x00000004)

/** AssertʃR[h CxgtO TOPID */
#define		USBH_ASSERT_EVF_TOPID			(0x00030000)						
/** AssertʃR[h CxgtO CREATE */
#define		USBH_ASSERT_EVF_CREATE			(USBH_ASSERT_EVF_TOPID | 0x00000001)
/** AssertʃR[h CxgtO SET */
#define		USBH_ASSERT_EVF_SET				(USBH_ASSERT_EVF_TOPID | 0x00000002)
/** AssertʃR[h CxgtO WAIT */
#define		USBH_ASSERT_EVF_WAIT			(USBH_ASSERT_EVF_TOPID | 0x00000003)
/** AssertʃR[h CxgtO DELETE */
#define		USBH_ASSERT_EVF_DELETE			(USBH_ASSERT_EVF_TOPID | 0x00000004)

/** AssertʃR[h f[^L[ TOPID */
#define		USBH_ASSERT_DTQ_TOPID			(0x00040000)						
/** AssertʃR[h f[^L[ CREATE */
#define		USBH_ASSERT_DTQ_CREATE			(USBH_ASSERT_DTQ_TOPID | 0x00000001)
/** AssertʃR[h f[^L[ SND */
#define		USBH_ASSERT_DTQ_SND				(USBH_ASSERT_DTQ_TOPID | 0x00000002)
/** AssertʃR[h f[^L[ RCV */
#define		USBH_ASSERT_DTQ_RCV				(USBH_ASSERT_DTQ_TOPID | 0x00000003)
/** AssertʃR[h f[^L[ DELETE */
#define		USBH_ASSERT_DTQ_DELETE			(USBH_ASSERT_DTQ_TOPID | 0x00000004)

/** AssertʃR[h 擾 TOPID */
#define		USBH_ASSERT_TIM_TOPID			(0x00050000)						
/** AssertʃR[h 擾 GET */	
#define		USBH_ASSERT_TIM_GET				(USBH_ASSERT_TIM_TOPID | 0x00000001)
/** AssertʃR[h 擾 WAIT */
#define		USBH_ASSERT_TIM_WAIT			(USBH_ASSERT_TIM_TOPID | 0x00000002)

/** AssertʃR[h nh TOPID */
#define		USBH_ASSERT_CYC_TOPID			(0x00060000)						
/** AssertʃR[h nh CREATE */
#define		USBH_ASSERT_CYC_CREATE			(USBH_ASSERT_CYC_TOPID | 0x00000001)
/** AssertʃR[h nh INACT */
#define		USBH_ASSERT_CYC_INACT			(USBH_ASSERT_CYC_TOPID | 0x00000002)
/** AssertʃR[h nh DELETE */
#define		USBH_ASSERT_CYC_DELETE			(USBH_ASSERT_CYC_TOPID | 0x00000003)

/** AssertʃR[h Xbh TOPID */
#define		USBH_ASSERT_THREAD_TOPID		(0x00070000)						
/** AssertʃR[h Xbh CREATE */
#define		USBH_ASSERT_THREAD_CREATE		(USBH_ASSERT_THREAD_TOPID | 0x00000001)
/** AssertʃR[h Xbh EXIT */
#define		USBH_ASSERT_THREAD_EXIT			(USBH_ASSERT_THREAD_TOPID | 0x00000002)
/** AssertʃR[h Xbh DELETE */
#define		USBH_ASSERT_THREAD_DELETE		(USBH_ASSERT_THREAD_TOPID | 0x00000003)

/** AssertʃR[h MailBox TOPID */
#define		USBH_ASSERT_MBOX_TOPID			(0x00080000)						
/** AssertʃR[h MailBox CREATE */
#define		USBH_ASSERT_MBOX_CREATE			(USBH_ASSERT_MBOX_TOPID | 0x00000001)
/** AssertʃR[h MailBox SND */
#define		USBH_ASSERT_MBOX_SND			(USBH_ASSERT_MBOX_TOPID | 0x00000002)
/** AssertʃR[h MailBox RCV */
#define		USBH_ASSERT_MBOX_RCV			(USBH_ASSERT_MBOX_TOPID | 0x00000003)
/** AssertʃR[h MailBox DELETE */
#define		USBH_ASSERT_MBOX_DELETE			(USBH_ASSERT_MBOX_TOPID | 0x00000004)

/** AssertʃR[h  TOPID */
#define		USBH_ASSERT_INT_TOPID			(0x00090000)						
/** AssertʃR[h  REG */
#define		USBH_ASSERT_INT_REG				(USBH_ASSERT_INT_TOPID | 0x00000001)
/** AssertʃR[h  ENA */
#define		USBH_ASSERT_INT_ENA				(USBH_ASSERT_INT_TOPID | 0x00000002)
/** AssertʃR[h  DIS */
#define		USBH_ASSERT_INT_DIS				(USBH_ASSERT_INT_TOPID | 0x00000003)
/** AssertʃR[h  UNREG */
#define		USBH_ASSERT_INT_UNREG			(USBH_ASSERT_INT_TOPID | 0x00000004)



/** NXhCo֐pR[obN^ */
typedef int (*usb_class_init_callback_t)(void * stCallback);



/**	eNXhCoCALLBACK<p>
    USB HostۂɃNXhCȍ֐AyсAAvP[Vx̃A^b`/f^b`
    CALLBACK֐̃|C^w肷邽߂̃f[^\B<p>
    Usbh_init ̌ďoɂāA{\̂ɒ`ꂽNXhCȍ֐ĂяoAUSB COREubN
    NXhCoo^܂B<p>
    {\͔̂zƂĐ錾邱ƂŁAUSB HOSTX^bN̏ɕ̃NXhCoo^鎖
    o܂B <p>
    ^C~O F USB Host<p>
    폜^C~O F USB HostACӂ̃^C~O */
typedef struct _app_callback_info {

    class_driver_type			clsdrv_type;									/**	foCX */
    usb_common_callback_t		attach_callback;								/** AvP[Vւ̐ڑR[obN */
    usb_common_callback_t		detach_callback;								/** AvP[Vւ̐ؒfR[obN */
	usb_class_init_callback_t	class_ini_callback;								/** NXhCo֐|C^(Reregist  Exit ́Aclass_driver_reginfo^ŕێ) */
    uhs_boolean_t				is_lastnode;									/** Ō̃m[hł TRUEBłȂ FALSEB */

} app_callback_info;


/**	USB HOST̏֐ɓn eCALLBACK<p>
    eR[obNNULLɐݒ肵ꍇ̓R[obN͍s܂B<p>
    ^C~O F USB Host<p>
    폜^C~O F USB HostACӂ̃^C~O */
typedef struct _usbh_regist_info {

	//	VXeɂP
	//^^^^^^^^^^^^^^^^^^
    usb_common_callback_t		overload_callback;								/** ߓdʒmR[obN */
    usb_common_callback_t		status_notify_callback;							/** Xe[^XʒmR[obN	(status monitor Ăяo) */
    usb_common_callback_t		split_err_notify_callback;						/** SplitʐMG[ʒmR[obN	(_@CLEAR_TT_BUFFER𔭍s) */
    usb_common_callback_t		assert_callback;								/** USB HOSTłAssertoɌĂяoR[obN */
    usb_logtype					logtype;										/** Xe[^XʒmO^Cv(feature use) */

	//	NhCo
	//^^^^^^^^^^^^^^^^^^
    app_callback_info 			* app_callback;									/**	NXhCoCB֐	z`ŕNXnB */

} usbh_regist_info;


extern uhs_status_t Usbh_Init( usbh_regist_info init );
extern uhs_status_t Usbh_Exit( void );
extern uhs_status_t Usbh_Api_RegistAppCallback( usbh_regist_info init );
extern uhs_status_t Usbh_Api_DriverRegister(struct class_driver_reginfo * driver_info);
extern void         Usbh_Api_DriverUnRegister(struct class_driver_reginfo * driver_info);
extern uhs_status_t Usbh_Api_OpenPipe(struct usb_control_block* ucb);
extern uhs_status_t Usbh_Api_ClosePipe(struct usb_control_block* ucb);
extern uhs_status_t Usbh_Api_ControlMsg(struct usb_control_block* ucb);
extern uhs_status_t Usbh_Api_BulkMsg(struct usb_control_block* ucb);
extern uhs_status_t Usbh_Api_IntMsg(struct usb_control_block* ucb);
extern uhs_status_t Usbh_Api_SyncControlMsg(struct usb_control_block* ucb, const udi_ubit8_t bmRequestType, const udi_ubit8_t bRequest, 
                                            const udi_ubit8_t wValue0, const udi_ubit8_t wValue1, const udi_ubit8_t wIndex0, const udi_ubit8_t wIndex1, void *buf, const uhs_ubit32_t size);
extern uhs_status_t Usbh_Api_SyncBulkMsg( struct usb_control_block* ucb );
extern uhs_status_t Usbh_Api_CancelPipe(struct usb_control_block* ucb);
extern uhs_status_t Usbh_Api_GetDescriptor(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, const uhs_ubit8_t type, const uhs_ubit8_t index, const uhs_ubit16_t wIndex, void *buf, const uhs_ubit32_t size);
extern uhs_status_t Usbh_Api_SetDescriptor(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, const uhs_ubit8_t type, const uhs_ubit8_t index, const uhs_ubit16_t wIndex, void *buf, const uhs_ubit32_t size);
extern uhs_status_t Usbh_Api_ClearFeature(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, const uhs_ubit8_t bmRequest, const uhs_ubit16_t feature_select, const uhs_ubit16_t wIndex);
extern uhs_status_t Usbh_Api_SetFeature(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, const uhs_ubit8_t bmRequest, const uhs_ubit16_t feature_select, const uhs_ubit16_t wIndex);
extern uhs_status_t Usbh_Api_GetStatus(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, const uhs_ubit8_t bmRequest, const uhs_ubit16_t wIndex, void *buf);
extern uhs_status_t Usbh_Api_SetAddress(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, const uhs_ubit16_t address);
extern uhs_status_t Usbh_Api_GetConfiguration(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, void *buf);
extern uhs_status_t Usbh_Api_SetConfiguration(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, const uhs_ubit16_t config_num);
extern uhs_status_t Usbh_Api_GetInterface(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, const uhs_ubit16_t wIndex, void *buf);
extern uhs_status_t Usbh_Api_SetInterface(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, const uhs_ubit16_t intf_num, const uhs_ubit16_t alt_num);
extern uhs_status_t Usbh_Api_AllocUsbCtrlBlock(struct usb_control_block ** ucb);
extern uhs_status_t Usbh_Api_FreeUsbCtrlBlock(struct usb_control_block * ucb);
extern void			Usbh_Api_FixupUsbCtrlBlock(struct usb_control_block * ucb, struct usbd_usb_deviceinfo* usbdev,  const uhs_ubit32_t pipe,  usb_device_request_t *setup_data, void *data_buf,  const uhs_ubit32_t data_len, const uhs_ubit8_t interval, usb_common_callback_t complete_func, void     *context);
extern void			Usbh_Api_FixupPipeInfo( uhs_ubit32_t *pipe, const uhs_ubit8_t usb_addr, const uhs_ubit8_t ep_num, const uhs_ubit8_t packet_id, const uhs_ubit8_t ep_type, const uhs_ubit32_t maxpkt_size);
extern uhs_boolean_t Usbh_Api_PipeIsOpened(struct usb_control_block* ucb);
extern uhs_ubit32_t Usbh_Api_GetPipeAddr(const uhs_ubit32_t pipe);
extern uhs_ubit32_t Usbh_Api_GetPipeEpNum(const uhs_ubit32_t pipe);
extern uhs_ubit32_t Usbh_Api_GetPipePID(const uhs_ubit32_t pipe);
extern uhs_boolean_t Usbh_Api_GetPipeDirIn(const uhs_ubit32_t pipe);
extern uhs_ubit32_t Usbh_Api_GetPipeEpType(const uhs_ubit32_t pipe);
extern uhs_ubit32_t Usbh_Api_GetPipeMaxPktSize(const uhs_ubit32_t pipe);
extern uhs_ubit8_t Usbh_Api_GetPortPower(struct usbd_usb_deviceinfo *usbhub, const uhs_ubit8_t port_num);
extern void 		Usbh_Api_SetPortPower(struct usbd_usb_deviceinfo *usbhub, const uhs_ubit8_t port_num, const uhs_ubit8_t stat);
extern struct usbd_usb_deviceinfo *   Usbh_Api_EnumRootHub( struct usbd_usb_deviceinfo * pRootHub );
extern struct usbd_usb_deviceinfo *   Usbh_Api_EnumDevice( struct usbd_usb_deviceinfo * pParent, struct usbd_usb_deviceinfo * pChild );
extern uhs_ubit8_t   Usbh_Api_GetDeviceType( struct usbd_usb_deviceinfo * pDev );
extern uhs_boolean_t Usbh_Api_GetVidPid( struct usbd_usb_deviceinfo * pDev, udi_ubit16_t *pVid, udi_ubit16_t *pPid );
extern uhs_boolean_t Usbh_Api_GetSerial( struct usbd_usb_deviceinfo * pDev, udi_ubit8_t *pSerial, udi_ubit8_t bufsize );
extern uhs_status_t  Usbh_Api_GetVersion(uhs_ubit8_t* pu8MajorVersion, uhs_ubit8_t* pu8MinorVersion);
extern	uhs_status_t	Usbh_Api_ResetTT(struct usbd_usb_deviceinfo *usbhub, const uhs_ubit16_t tt_num);
extern	uhs_status_t	Usbh_Api_ClearTTBuffer(struct usbd_usb_deviceinfo *usbhub, const uhs_ubit16_t tt_num, struct usbd_usb_spliterrinfo *split_err_info);
extern void Usb_Core_ReportStatus( const char *pFileName, uhs_ubit32_t nLine, usb_msglevel level, uhs_ubit16_t msgdata );
extern void Hcd_EHCI_ReportStatus( const char *pFileName, uhs_ubit32_t nLine, usb_msglevel level, uhs_ubit16_t msgdata );
extern	uhs_status_t Usbh_Api_ReqDisableAttDet( void );
extern	uhs_status_t Usbh_Api_CancelDisableAttDet( void );
extern uhs_status_t Usbh_Api_ReqSuspend( void );
extern uhs_status_t Usbh_Api_ReqResume( void );


// *************************************************************************************************
//  }N`
// *************************************************************************************************
/** Rg[]pUCBݒAPI */
#define Usbh_FixupCtrlUcb(ucb, usbdev, pipe, setup, buf, size, function, context)   \
            Usbh_Api_FixupUsbCtrlBlock(ucb, usbdev, pipe, setup, buf, size, 0x00, function, context)
/** oN]pUCBݒAPI */
#define Usbh_FixupBulkUcb(ucb, usbdev, pipe, buf, size, function, context)  \
            Usbh_Api_FixupUsbCtrlBlock(ucb, usbdev, pipe, NULL, buf, size, 0, function, context)
/** C^vg]pUCBݒAPI */
#define Usbh_FixupIntrUcb(ucb, usbdev, pipe, buf, size, interval, function, context)    \
            Usbh_Api_FixupUsbCtrlBlock(ucb, usbdev, pipe, NULL, buf, size, interval, function, context)
/** AC\]pUCBݒAPI */
#define Usbh_FixupIsoUcb(ucb, usbdev, pipe, buf, size, function, context)   \
            Usbh_Api_FixupUsbCtrlBlock(ucb, usbdev, pipe, NULL, buf, size, 0, function, context)


#endif	//	__USBH_API_H__
