/** 
 * @brief          GPIO Assembler Function
 * @author         AXELL CORPORATION
 * @description    Assembler Function  for ExeGCC.
 * @note           none
 * @history        2017_02_22  
 * @history        2017_10_26  Ver2.0
 * @history        2021_01_29  [SDK3.2] GPIO|[g̔rLɂƂ̃AZu[`C (#2844)
*/

/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2021 AXELL CORPORATION, all rights reserved.
 */

        .code 32
        .text
        .align  2

/*
 * fn			void GPIOPrm_ModifyBit(uint32_t *r0, uint32_t r1, uint32_t r2)
 * brief		GPIOo͂̔rIȕύX
 * param		r0 [in] GPIOnDTOUTWX^̃AhX
 * param		r1 [in] o̓f[^orrbg
 * param		r2 [in] o̓f[^andrbg
 * description	rIGPIO|[go͂XV܂B
 *				XV̏o͂͌ݏo͂Ăf[^r1orĂr2andlɂȂ܂B
 * return		void
 */
        .globl  GPIOPrm_ModifyBit
        .type   GPIOPrm_ModifyBit, %function
GPIOPrm_ModifyBit:

		/* CPUXe[^XۑIɊ荞݋֎~Ԃɂ */
		mrs		r3, cpsr
		cpsid	i

		ldr		r12, [r0]	/* reg = *GPIOnDTOUT */
		orr		r1, r12, r1	/* reg |= set */
		and		r1, r1, r2	/* reg &= clr */
		str		r1, [r0]	/* *GPIOnDTOUT = reg */

		/* 荞ݏԂCPUXe[^Xۑɖ߂ */
		tst		r3, #(1<<7)
		bxne	lr
		cpsie	i
		bx		lr
