#include <stdint.h>
#include "kernel.h"
#include <sample_common.h>
#include "com.h"
#include "mps_common.h"

#include "board.h"

extern void mps_single(void);
extern void mps_multi(void);
extern void mps_trick(void);
static void mps_help(void);

static void (*func[])() = {
	mps_help,
	mps_single,
	mps_multi,
	mps_trick,
};

/**
 * @brief		C
 * @param[in]	param	p[^
 * @return		Ȃ
 * @note		Ȃ
 */
void MPS_main(uint8_t param)
{
	((void)param);
	uint8_t		mode = 0;
	char		input[2+2];

	if(sys_meminit(AG903_SAMPLE_VRAM_ALLOC_SIZE,
				   (void *)AG903_SAMPLE_VRAM_ADDR,
				   SYSMEM_NORMAL_CACHE_OFF)) {
		COM_PutStr("MEMORY INIT FAILED.\r\n");
		sys_dlytsk(AG903_SAMPLE_DLY_ERROUT);
		return;
	}

	func[0]();

	while (mode != 0xFF) {
		COM_PutStr(" -- Choose sample number (00h<HELP> to FFh): ");
		COM_GetNum_Wait(input, sizeof(input));
		mode = (ASCtoBIN(input[0]) << 4)
				 | (ASCtoBIN(input[1]) << 0);
		if(0xFF == mode) {
			break;
		}
		if(mode >= (sizeof(func)/sizeof(void*))) {
			mode = 0;
		}

	   	Board_SelectDviTX();	/* DVIo͗L */
		func[mode]();	/* Sample funcs */

		/* N[Abv */
		sys_memfinal();
		if(sys_meminit(AG903_SAMPLE_VRAM_ALLOC_SIZE,
					   (void *)AG903_SAMPLE_VRAM_ADDR,
					   SYSMEM_NORMAL_CACHE_OFF)) {
			COM_PutStr("MEMORY INIT FAILED.\r\n");
			sys_dlytsk(AG903_SAMPLE_DLY_ERROUT);
			return;
		}
	}
	sys_memfinal();

	return;
}

/**
 * @brief		wv\
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void mps_help(void)
{
	MPS_Printf("\t# 00 ... Help\r\n");
	MPS_Printf("\t# 01 ... MP4 movie play : Single stream\r\n");
	MPS_Printf("\t# 02 ... MP4 movie play : Multi stream\r\n");
	MPS_Printf("\t# 03 ... MP4 movie play : Trick play\r\n");
	MPS_Printf("\t# FF ... Exit Sample\r\n");

	return;
}

