/*
 * @history     2020_07_22  [SDK3.1] UARTTvPIO]ł̓삪肵ĂȂsC (#2781)
 * @history     2025_03_06  [SDK3.7] DMAv񓯊̂Ƃ̑΍􂪂ĂȂsC (#5786)
 */
/*
 * This program was created by Axell Corporation.
 * Copyright (C) 2017-2025 Axell Corporation, all rights reserved.
 */
#include "sample_common.h"
#include "com.h"
#include "uart/uartmgr.h"
#include "register/AG903_uartreg.h"
#include "dmac/dmacmgr.h"
#include "timr/timrmgr.h"

/* vg^Cv */
static int32_t Uart_init_module(void);
static int32_t Uart_term_module(void);
static void Uart_SampleHelp(void);
static void Uart_EchoBackPio(void);
static void Uart_EchoBackDma(void);
static void Uart_LoopSendDma(void);
static void Uart_EchoBackPioRs485(void);
static void Uart_EchoBackDmaRs485(void);
static void Uart_LoopSendDmaRs485(void);
static void Uart_EchoBack_pio(_Bool rs485en);
static void Uart_EchoBack_dma(_Bool rs485en);
static void Uart_LoopSend_dma(_Bool rs485en);
static void Uart_InitHw(uint8_t ch, uint8_t initype);
static int32_t Uart_WaitSend(uint32_t timout);
static int32_t Uart_WaitDmaTerm(uint32_t timout);
static int32_t Uart_WaitDmaLoop(AG903_DMACMgrHandle* handle, uint32_t timout);
static void Uart_CallbackPio(AG903_UARTMgrHandle* handle, uint32_t event);
static void Uart_CallbackDma(AG903_UARTMgrHandle* handle, uint32_t event);
static void Uart_CallbackDmaTerm(AG903_DMACMgrHandle* handle, AG903_DMACMgrDesc** desc, uint8_t* end);
static void Uart_CallbackDmaAbort(AG903_DMACMgrHandle* handle);
static void Uart_CallbackDmaErr(AG903_DMACMgrHandle* handle);
static void Uart_SFifoInit(void);
static int Uart_SFifoIsEmpty(void);
static int Uart_SFifoIsFull(void);
static int Uart_SFifoWrite(const uint8_t *dat, int size);
static int Uart_SFifoRead(uint8_t *dat, int size);


/* Param */
#define UART_SMP_BUFSIZE		(256)			/* obt@TCY */
#define UART_SMP_BAUDRATE		(115200)		/* Uart {[E[g [bps] */
#define UART_SMP_CH				(3)				/* Uart CH [FCH0uC3gp] */
#define UART_SMP_DMACH			(0)				/* DMAC CH */
#define UART_SMP_DMACSEL		(4)				/* DMAC Handshake Select */
#define UART_SMP_LOOP_NUM		(10)			/* Loop Send  */
#define UART_SMP_DMASEL_BASE	(0x10)			/* dma_reqIl(UART0) */
#define UART_SMP_DMASEL_TIMR	(0x08)			/* dma_reqIl(TIMR0) */
#define UART_SMP_REG_INTERVAL	(0x00100000)	/* UART Register Interval */
#define UART_SMP_SFIFOSIZE		(512)			/* \tgFIFOTCY */

enum {
	UART_SMP_HW_NORMAL=0,
	UART_SMP_HW_RS485,
};

/* Macro */
#define	EPRINT(FMT, ...)		sys_print(0, FMT,##__VA_ARGS__)
#define	PRINT(FMT, ...)			sys_print(0, FMT"\r\n",##__VA_ARGS__)
#define UART_ERROR(str)			sys_print(1, " ERROR:%s[%d] *%s*\r\n",__FUNCTION__, __LINE__, str)

static void (*func[])() = {
	Uart_SampleHelp,
	Uart_EchoBackPio,
	Uart_EchoBackDma,
	Uart_LoopSendDma,
	Uart_EchoBackPioRs485,
	Uart_EchoBackDmaRs485,
	Uart_LoopSendDmaRs485,
};

static volatile int32_t	UartRcvSize=0;
static uint32_t	UartLoopCnt=0;
static _Bool	UartSendEnd=false;
static _Bool	UartDmaTerm=false;
static uint8_t	UartBuf[UART_SMP_BUFSIZE];
static const uint8_t	UartSampleStr1[]={" Uart DMA Loop Send : Sample String 1 \r\n"};
static const uint8_t	UartSampleStr2[]={" Uart DMA Loop Send : Sample String 2 \r\n"};
static const uint8_t	UartTimingParam[]={0,0,2,3};
static struct uart_sfifo {
	uint8_t buf[UART_SMP_SFIFOSIZE];
	volatile int iw;	/* CgCfbNX 荞ݒ̍XV */
	volatile int ir;	/* [hCfbNX 荞ݒ̍XV */
} UartSFifo;

/**
 * @brief		C
 * @param[in]	param	p[^
 * @return		Ȃ
 * @note		Ȃ
 */
void UART_main(uint8_t param)
{
	uint8_t		mode = 0;
	char		input[2+2];

	((void)param);

	Uart_SampleHelp();	/* Help\ */

	Uart_init_module();

	while (mode != 0xFF) {
		EPRINT(" -- Choose sample number (00h<HELP> to FFh): ");
		COM_GetNum_Wait(input, sizeof(input));
		mode = (ASCtoBIN(input[0]) << 4)
			 | (ASCtoBIN(input[1]) << 0);
		if(0xFF == mode) {
			break;
		}
		if(mode >= (sizeof(func)/sizeof(void*))) {
			func[0](); /* Help */
		}
		else {
			func[mode]();	/* Sample funcs */
		}
	}

	Uart_term_module();

	return;
}

/**
 * @brief		Tu
 * @param[in]	param	p[^
 * @return		Ȃ
 * @note		Ȃ
 */
void UART_sub(uint32_t param)
{
	((void)param);
	/* Ȃ */
	return;
}

/**
 * @brief		W[
 * @param[in]	Ȃ
 * @retval		AG903_ENONE		I
 * @note		Ȃ
 */
static int32_t Uart_init_module(void)
{
	static _Bool	UartInit=false;
	int32_t 		result;

	if(false == UartInit) {
		result = AG903_UARTMgrInit(UART_SMP_CH); /* Managaer  */
		if(AG903_ENONE != result) {
			UART_ERROR("Init");
		}
		else {
			UartInit = true;
		}
	}

	return AG903_ENONE;
}

/**
 * @brief		W[I
 * @param[in]	Ȃ
 * @retval		AG903_ENONE		I
 * @note		Ȃ
 */
static int32_t Uart_term_module(void)
{
	/* Ȃ */
	return AG903_ENONE;
}

/**
 * @brief		wv\
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Uart_SampleHelp(void)
{
	PRINT("\t# 00 ... Help");
	PRINT("\t# 01 ... Echo Back PIO");
	PRINT("\t# 02 ... Echo Back DMA");
	PRINT("\t# 03 ... Loop Send DMA");
	PRINT("\t# 04 ... Echo Back PIO RS485");
	PRINT("\t# 05 ... Echo Back DMA RS485");
	PRINT("\t# 06 ... Loop Send DMA RS485");
	PRINT("\t# FF ... Exit Sample");

	return;
}

/**
 * @brief		GR[obN [PIO]
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Uart_EchoBackPio(void)
{
	Uart_InitHw(UART_SMP_CH, UART_SMP_HW_NORMAL);
	Uart_EchoBack_pio(false);

	return;
}

/**
 * @brief		GR[obN(RS485) [PIO]
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Uart_EchoBackPioRs485(void)
{
	Uart_InitHw(UART_SMP_CH, UART_SMP_HW_RS485);
	Uart_EchoBack_pio(true);

	return;
}

/**
 * @brief		GR[obN [DMA]
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Uart_EchoBackDma(void)
{
	Uart_InitHw(UART_SMP_CH, UART_SMP_HW_NORMAL);
	Uart_EchoBack_dma(false);

	return;
}

/**
 * @brief		GR[obN(RS485) [DMA]
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Uart_EchoBackDmaRs485(void)
{
	Uart_InitHw(UART_SMP_CH, UART_SMP_HW_RS485);
	Uart_EchoBack_dma(true);

	return;
}

/**
 * @brief		[vM [DMA]
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Uart_LoopSendDma(void)
{
	Uart_InitHw(UART_SMP_CH, UART_SMP_HW_NORMAL);
	Uart_LoopSend_dma(false);

	return;
}

/**
 * @brief		[vM(RS485) [DMA]
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Uart_LoopSendDmaRs485(void)
{
	Uart_InitHw(UART_SMP_CH, UART_SMP_HW_RS485);
	Uart_LoopSend_dma(true);

	return;
}

/**
 * @brief		PIOGR[obN
 * @param[in]	rs485en  RS485L/ [true:L]
 * @return		Ȃ
 * @note		͕GR[obN܂B"end\r\n"̓͂ŏI܂B
 * @note		VÃp[^ݒ͊֐ōsĂ܂B
 */
static void Uart_EchoBack_pio(_Bool rs485en)
{
	AG903_UARTMgrHandle*	handle;
	AG903_UARTMgrParam		com;
	AG903_UARTMgrRs485Param rs485;
	int32_t 	result;
	int32_t 	loop;
	_Bool		end;
	uint8_t 	chara[5]={0};
	uint8_t		buf[16];	/* MP UARTFIFOƓTCYŏ\ */
	int32_t		buf_size = sizeof(buf)/sizeof(buf[0]);
	int32_t		rsize;

	if(true == rs485en) { /* RS485I */
		PRINT(" Echo back the RS485 Port. [use PIO]");
	}
	else {
		PRINT(" Echo Back the COM2 Port. [use PIO]");
	}

	UartRcvSize=0;
	UartSendEnd=false;
	Uart_SFifoInit();

	/* UARTݒ */
	result = AG903_UARTMgrGetHandle(UART_SMP_CH, &handle); 								/* nh擾 */
	if(AG903_ENONE != result) {
		UART_ERROR("GetHandle");
	}
	result = AG903_UARTMgrSetCallback(handle, (AG903_UARTMgrClbk)Uart_CallbackPio);		/* R[obNo^ */
	if(AG903_ENONE != result) {
		UART_ERROR("SetCallback");
	}
	com.baud	= UART_SMP_BAUDRATE;
	com.parity  = AG903_UART_PARITY_NON;
	com.stopbit = AG903_UART_STOPBIT_1;
	com.databit = AG903_UART_DATBIT_8;
	if(true == rs485en) { /* RS485I */
		com.flow = AG903_UART_FLOW_CTS;
	}
	else {
		com.flow = AG903_UART_FLOW_NON;
	}
	result = AG903_UARTMgrSetParam(handle, &com); 										/* UARTʐMp[^ݒ */
	if(AG903_ENONE != result) {
		UART_ERROR("SetParam");
	}
	if(true == rs485en) { /* RS485I */
		rs485.setuptime = 1;
		rs485.holdtime  = 1;
		rs485.rcvtime	= 10000;
		rs485.interval	= 10000;
		rs485.timeout	= 10000;
		rs485.event		= 0x00;
		result = AG903_UARTMgrSetRs485Param(handle, &rs485);							/* RS485p[^ݒ */
		if(AG903_ENONE != result) {
			UART_ERROR("Set485Param");
		}
	}
	result = AG903_UARTMgrReceive(handle, false);										/* MJn */
	if(AG903_ENONE != result) {
		UART_ERROR("Receive");
	}

	/* GR[obN */
	PRINT(" Echo Back is terminated When you enter the 'end+CRLF'.");
	end = false;
	while(1) {
		if (!Uart_SFifoIsEmpty()) {
			rsize = Uart_SFifoRead(buf, buf_size); /* Aobt@փRs[ */
			if(true == rs485en) { /* RS485I */
				result = AG903_UARTMgrStopReceive(handle); 								/* M~ */
				if(AG903_ENONE != result) {
					UART_ERROR("StopReceive");
				}
			}
			result = AG903_UARTMgrSend(handle, buf, rsize, false); 			/* MJn */
			if(AG903_ENONE != result) {
				UART_ERROR("Send");
			}
			result = Uart_WaitSend(500);												/* M҂ */
			if(AG903_ENONE != result) {
				UART_ERROR("WaitSend");
			}
			for(loop=0; loop<rsize; loop++) { /* I */			
				chara[4] = chara[3];
				chara[3] = chara[2];
				chara[2] = chara[1];
				chara[1] = chara[0];
				chara[0] = buf[loop];
				if(('e'==chara[4])&&('n'==chara[3])&&('d'==chara[2])&&(0x0d==chara[1])&&(0x0a==chara[0])) {
					end = true;
					break;
				}
			}
			if(true == end) {
				break; /* I */
			}
			UartRcvSize=0;
			if(true == rs485en) { /* RS485I */
				result = AG903_UARTMgrReceive(handle, false);							/* MJn */
				if(AG903_ENONE != result) {
					UART_ERROR("Receive");
				}
			}
		}
	}

	/* UART~ */
	result = AG903_UARTMgrStopReceive(handle); 											/* M~ */
	if(AG903_ENONE != result) {
		UART_ERROR("StopReceive");
	}

	result = AG903_UARTMgrStopSend(handle); 											/* M~ */
	if(AG903_ENONE != result) {
		UART_ERROR("StopSend");
	}

	result = AG903_UARTMgrReleaseHandle(handle); 										/* nh */
	if(AG903_ENONE != result) {
		UART_ERROR("ReleaseHandle");
	}

	Uart_SFifoInit();																	/* cf[^Δj */

	return;
}

/**
 * @brief		DMAGR[obN
 * @param[in]	rs485en  RS485L/ [true:L]
 * @return		Ȃ
 * @note		UART_SMP_BUFSIZE̕DMAMADMAMŃGR[obN܂B
 * @note		VÃp[^ݒ͊֐ōsĂ܂B
 */
static void Uart_EchoBack_dma(_Bool rs485en)
{
	AG903_DMACMgrHandle*	hdl_dmac;
	AG903_UARTMgrHandle*	hdl_uart;
	AG903_UARTMgrParam		com;
	AG903_UARTMgrRs485Param rs485;
    AG903_DMACMgrConfig     config;
	AG903_DMACMgrDesc		desc;
	int32_t 	result;

	if(true == rs485en) { /* RS485I */
		PRINT(" Echo back the RS485 Port. [use DMA]");
	}
	else {
		PRINT(" Echo Back the COM2 Port. [use DMA]");
	}

	UartDmaTerm=false;
	UartSendEnd=false;

	/* UARTݒ */
	result = AG903_UARTMgrGetHandle(UART_SMP_CH, &hdl_uart); 							/* UARTnh擾 */
	if(AG903_ENONE != result) {
		UART_ERROR("GetUartHandle");
	}
	result = AG903_UARTMgrSetCallback(hdl_uart, (AG903_UARTMgrClbk)Uart_CallbackDma); 	/* UARTR[obNo^ */
	if(AG903_ENONE != result) {
		UART_ERROR("SetUartCallback");
	}
	com.baud	= UART_SMP_BAUDRATE;
	com.parity  = AG903_UART_PARITY_NON;
	com.stopbit = AG903_UART_STOPBIT_1;
	com.databit = AG903_UART_DATBIT_8;
	com.flow	= AG903_UART_FLOW_CTS;
	result = AG903_UARTMgrSetParam(hdl_uart, &com); 									/* UARTʐMp[^ݒ */
	if(AG903_ENONE != result) {
		UART_ERROR("SetParam");
	}
	if(true == rs485en) { /* RS485I */
		rs485.setuptime = 1;
		rs485.holdtime  = 1;
		rs485.rcvtime	= 10000;
		rs485.interval	= 10000;
		rs485.timeout	= 10000;
		rs485.event		= 0x00;
		result = AG903_UARTMgrSetRs485Param(hdl_uart, &rs485);							/* RS485p[^ݒ */
		if(AG903_ENONE != result) {
			UART_ERROR("Set485Param");
		}
	}

	/* DMACݒ [UARTMemory] */
	Sys_SetDmaInterface(UART_SMP_DMACSEL, (UART_SMP_DMASEL_BASE+(0x02*UART_SMP_CH)));	/* dma_req I(Mbuf) */
	AG903_DMACMgrSetSyncPeripheral(UART_SMP_DMACH, 1);
	result = AG903_DMACMgrGetHandle(UART_SMP_DMACH, &hdl_dmac); 						/* DMACnh擾 */
	if(AG903_ENONE != result) {
		UART_ERROR("GetDmacHandle");
	}
	result = AG903_DMACMgrSetIntCallback(hdl_dmac, Uart_CallbackDmaTerm,
										Uart_CallbackDmaAbort, Uart_CallbackDmaErr);	/* DMACR[obNo^ */
	if(AG903_ENONE != result) {
		UART_ERROR("SetDmacCallback");
	}
	config.val = 0;
	config.st.SrcHEn = 1;
	config.st.SrcRS  = UART_SMP_DMACSEL;
	desc.Ctrl.val = 0;
	desc.Ctrl.st.SrcCtrl = 2; /* Fixed */
	desc.SrcAddr  = (uint32_t)(&AG903_UARTn(UART_SMP_CH)->RBR);
	desc.DstAddr  = (uint32_t)UartBuf;
	desc.Trns.val = UART_SMP_BUFSIZE;
	desc.Stride.val = 0;
	desc.next = 0;
	AG903_DMACMgrSetDescList(hdl_dmac, &config, &desc, 1); 								/* fBXNv^ݒ */

	/* MJn`M҂ */
	PRINT(" * Wait receive data %d[Byte]", UART_SMP_BUFSIZE);
	result = AG903_UARTMgrReceive(hdl_uart, true); 										/* UARTMJn(݋) */
	if(AG903_ENONE != result) {
		UART_ERROR("Receive");
	}
	result = AG903_DMACMgrEnable(hdl_dmac); 											/* DMAs */
	if(AG903_ENONE != result) {
		UART_ERROR("Enable");
	}
	result = Uart_WaitDmaTerm(60000); 													/* DMA]҂ */
	if(AG903_ENONE != result) {
		UART_ERROR("WaitDmaTerm");
	}
	result = AG903_UARTMgrStopReceive(hdl_uart); 										/* M~(݋֎~) */
	if(AG903_ENONE != result) {
		UART_ERROR("StopReceive");
	}

	/* DMACݒ [MemoryUART] */
	Sys_SetDmaInterface(UART_SMP_DMACSEL, (UART_SMP_DMASEL_BASE+(0x02*UART_SMP_CH)+1));	/* dma_req I(Mbuf) */
	AG903_DMACMgrSetSyncPeripheral(UART_SMP_DMACH, 1);
	config.val = 0;
	config.st.DstHEn = 1;
	config.st.DstRS  = UART_SMP_DMACSEL;
	desc.Ctrl.val = 0;
	desc.Ctrl.st.DstCtrl = 2; /* Fixed */
	desc.SrcAddr  = (uint32_t)UartBuf;
	desc.DstAddr  = (uint32_t)(&AG903_UARTn(UART_SMP_CH)->THR);
	desc.Trns.val = UART_SMP_BUFSIZE;
	desc.Stride.val = 0;
	desc.next = 0;
	AG903_DMACMgrSetDescList(hdl_dmac, &config, &desc, 1); 								/* fBXNv^ݒ */

	/* MJn`҂ */
	PRINT(" * Echo Back %d[Byte]", UART_SMP_BUFSIZE);
	result = AG903_DMACMgrEnable(hdl_dmac); 											/* DMAs */
	if(AG903_ENONE != result) {
		UART_ERROR("Enable");
	}
	result = AG903_UARTMgrSend(hdl_uart, NULL, 0, true); 								/* UARTMJn(݋) */
	if(AG903_ENONE != result) {
		UART_ERROR("Send");
	}
	result = Uart_WaitDmaTerm(10000); 													/* DMA]҂ */
	if(AG903_ENONE != result) {
		UART_ERROR("WaitDmaTerm");
	}
	result = Uart_WaitSend(100); 														/* UARTM҂ */
	if(AG903_ENONE != result) {
		UART_ERROR("WaitSend");
	}
	result = AG903_UARTMgrStopSend(hdl_uart); 											/* M~ */
	if(AG903_ENONE != result) {
		UART_ERROR("StopSend");
	}

	/* DMAC */
	result = AG903_DMACMgrReleaseHandle(hdl_dmac);										/* nh */
	if(AG903_ENONE != result) {
		UART_ERROR("ReleaseDmacHandle");
	}

	/* UART */
	result = AG903_UARTMgrReleaseHandle(hdl_uart);										/* nh */
	if(AG903_ENONE != result) {
		UART_ERROR("ReleaseUartHandle");
	}

	return;
}

/**
 * @brief		DMA[vM
 * @param[in]	rs485en  RS485L/ [true:L]
 * @return		Ȃ
 * @note		DMAC̏z]gpTvłB
 * @note		TimerDMANGXg@\gpTvłB
 */
static void Uart_LoopSend_dma(_Bool rs485en)
{
	AG903_DMACMgrHandle*		hdl_dmac;
	AG903_UARTMgrHandle*		hdl_uart;
	AG903_TIMRMgrHandle*		hdl_timr;
	AG903_UARTMgrParam			com;
	AG903_UARTMgrRs485Param 	rs485;
	AG903_TIMRMgrTickCntParam 	tick;
    AG903_DMACMgrConfig     	config;
	AG903_DMACMgrDesc			desc[2];
	int32_t 	result;
	char		chara[4];
	int8_t		timsel;
	uint8_t		timch;

	UartDmaTerm=false;
	UartSendEnd=false;
	UartLoopCnt=0;

	if(true == rs485en) { /* RS485I */
		PRINT(" Loop send any string. [RS485 Port]");
	}
	else {
		PRINT(" Loop send any string. [COM2 Port]");
	}

	while(1) { /* ^C~OI */
		PRINT(" Select the transfer timing");
		PRINT(" 0 : no wait");
		PRINT(" 1 : 200ms wait / 1chara");
		PRINT(" 2 : 200ms wait / 4chara");
		PRINT(" 3 : 200ms wait / 8chara");
		EPRINT(" ");
		COM_GetNum_Wait(chara, 3); /* 3 = 1(Select No.)+CRLF */
		timsel = ASCtoBIN(chara[0]);
		if(3 < timsel) {
			PRINT(" Invalid number");
			continue;
		}
		break;
	}

	/* UARTݒ */
	result = AG903_UARTMgrGetHandle(UART_SMP_CH, &hdl_uart); 							/* UARTnh擾 */
	if(AG903_ENONE != result) {
		UART_ERROR("GetUartHandle");
	}
	result = AG903_UARTMgrSetCallback(hdl_uart, (AG903_UARTMgrClbk)Uart_CallbackDma); 	/* UARTR[obNo^ */
	if(AG903_ENONE != result) {
		UART_ERROR("SetUartCallback");
	}
	com.baud	= UART_SMP_BAUDRATE;
	com.parity  = AG903_UART_PARITY_NON;
	com.stopbit = AG903_UART_STOPBIT_1;
	com.databit = AG903_UART_DATBIT_8;
	com.flow	= AG903_UART_FLOW_CTS;
	result = AG903_UARTMgrSetParam(hdl_uart, &com); 									/* UARTʐMp[^ݒ */
	if(AG903_ENONE != result) {
		UART_ERROR("SetParam");
	}
	if(true == rs485en) { /* RS485I */
		rs485.setuptime = 1;
		rs485.holdtime  = 1;
		rs485.rcvtime	= 10000;
		rs485.interval	= 10000;
		rs485.timeout	= 10000;
		rs485.event		= 0x00;
		result = AG903_UARTMgrSetRs485Param(hdl_uart, &rs485);							/* RS485p[^ݒ */
		if(AG903_ENONE != result) {
			UART_ERROR("Set485Param");
		}
	}

	/* TIMRݒ */
	if(0 < timsel) {
		result = AG903_TIMRMgrGetHandle(&hdl_timr);
		if(AG903_ENONE != result) {
			UART_ERROR("GetTimrHandle");
		}
		result = AG903_TIMRMgrGetChannel(hdl_timr, &timch);
		if(AG903_ENONE != result) {
			UART_ERROR("GetTimrCH");
		}
		tick.period  = 40000000;  /* 200[ms] (clk 200M[Hz]) */
		tick.match   = 0;
		tick.resolution = AG903_TIMR_CNT_SYSCLK;
		tick.oneshot = false;
		tick.output  = NULL;
		result = AG903_TIMRMgrSetTickCountMode(hdl_timr, &tick);
		if(AG903_ENONE != result) {
			UART_ERROR("SetTimr");
		}
		result = AG903_TIMRMgrEnableDmaRequest(hdl_timr, 0x01);
		if(AG903_ENONE != result) {
			UART_ERROR("EnableTimrDrq");
		}
	}

	/* DMACݒ [MemoryUART] */
	result = AG903_DMACMgrGetHandle(UART_SMP_DMACH, &hdl_dmac);
	if(AG903_ENONE != result) {
		UART_ERROR("GetDmacHandle");
	}
	result = AG903_DMACMgrSetIntCallback(hdl_dmac, Uart_CallbackDmaTerm,
										Uart_CallbackDmaAbort, Uart_CallbackDmaErr);
	if(AG903_ENONE != result) {
		UART_ERROR("SetDmacCallback");
	}
	config.val = 0;
	config.st.DstHEn = 1;
	config.st.DstRS  = UART_SMP_DMACSEL;
	desc[0].Ctrl.val = 0;
	desc[0].Ctrl.st.DstCtrl = 2; /* Fixed */
	desc[0].SrcAddr  = (uint32_t)UartSampleStr1;
	desc[0].DstAddr  = (uint32_t)(&AG903_UARTn(UART_SMP_CH)->THR);
	desc[0].Trns.val = sizeof(UartSampleStr1);
	desc[0].Stride.val = 0;
	desc[0].next = (void*)&desc[1]; /* desc[1] */
	desc[1].Ctrl.val = 0;
	desc[1].Ctrl.st.DstCtrl = 2; /* Fixed */
	desc[1].SrcAddr  = (uint32_t)UartSampleStr2;
	desc[1].DstAddr  = (uint32_t)(&AG903_UARTn(UART_SMP_CH)->THR);
	desc[1].Trns.val = sizeof(UartSampleStr2);
	desc[1].Stride.val = 0;
	desc[1].next = (void*)&desc[0]; /* desc[0] */
	if(0 < timsel) {
		Sys_SetDmaInterface(UART_SMP_DMACSEL, (UART_SMP_DMASEL_TIMR+timch)); /* dma_req I(Timer) */
		AG903_DMACMgrSetSyncPeripheral(UART_SMP_DMACH, 1);
		desc[0].Ctrl.st.SrcTcnt = UartTimingParam[timsel];
		desc[1].Ctrl.st.SrcTcnt = UartTimingParam[timsel];
	}
	else {
		Sys_SetDmaInterface(UART_SMP_DMACSEL, (UART_SMP_DMASEL_BASE+(0x02*UART_SMP_CH)+1));
		AG903_DMACMgrSetSyncPeripheral(UART_SMP_DMACH, 1);
	}

	AG903_DMACMgrSetDescList(hdl_dmac, &config, desc, 2); /* fBXNv^ݒ */

	/* MJn */
	PRINT(" * Transfer Start");
	result = AG903_DMACMgrEnable(hdl_dmac);
	if(AG903_ENONE != result) {
		UART_ERROR("Enable");
	}
	result = AG903_UARTMgrSend(hdl_uart, NULL, 0, true); 								/* UARTMJn(݋) */
	if(AG903_ENONE != result) {
		UART_ERROR("Send");
	}
	if(0 < timsel) {
		result = AG903_TIMRMgrStart(hdl_timr);
		if(AG903_ENONE != result) {
			UART_ERROR("Timer Start");
		}
	}

	/* ҂ */
	result = Uart_WaitDmaLoop(hdl_dmac, 100000);
	if(AG903_ENONE != result) {
		UART_ERROR("WaitDmaLoop");
	}
	else {
		PRINT(" * Transfer End");
	}

	/* UART */
	result = AG903_UARTMgrStopSend(hdl_uart); 											/* M~ */
	if(AG903_ENONE != result) {
		UART_ERROR("StopSend");
	}
	result = AG903_UARTMgrReleaseHandle(hdl_uart);										/* nh */
	if(AG903_ENONE != result) {
		UART_ERROR("ReleaseUartHandle");
	}

	/* DMAC */
	result = AG903_DMACMgrReleaseHandle(hdl_dmac);
	if(AG903_ENONE != result) {
		UART_ERROR("ReleaseDmacHandle");
	}

	/* TIMR */
	if(0 < timsel) {
		result = AG903_TIMRMgrStop(hdl_timr);
		if(AG903_ENONE != result) {
			UART_ERROR("Stop");
		}
		result = AG903_TIMRMgrReleaseHandle(hdl_timr);
		if(AG903_ENONE != result) {
			UART_ERROR("ReleaseHandle");
		}
	}

	return;
}

/**
 * @brief		HWݒ
 * @param		ch [in] UART`l
 * @param		initype [in] ݒ
 * @return		Ȃ
 * @note		UART3̏ꍇ131pin-134pingp܂B
 */
static void Uart_InitHw(uint8_t ch, uint8_t initype)
{
	/* [qݒhw_init()Ŏ{ς */

	if(3 == ch) {
		ch++;		/* UART3̏ꍇ131pin-134pingp [DB51903M] */
	}

	switch(initype) {
		case UART_SMP_HW_NORMAL:
			Board_SelectUartConnection(ch, AG903_UART_CONNECT_COM2);	/* COM2I */
			break;
		case UART_SMP_HW_RS485:
			Board_SelectUartConnection(ch, AG903_UART_CONNECT_RS485);	/* RS485I */
		default:
			/* Ȃ */
			break;
	}

	return;
}

/**
 * @brief		M҂
 * @param[in]	timout	^CAEg[ms]
 * @return		Ȃ
 * @note		Ȃ
 */
static int32_t Uart_WaitSend(uint32_t timout)
{
	int32_t		retval = AG903_ENONE;
	uint32_t	cnt;
	uint32_t	loop;

	cnt = timout/10;
	if(timout%10) {
		cnt++;
	}
	for(loop=0; loop<cnt; loop++) {
		if(true == UartSendEnd) {
			UartSendEnd = false;
			break;
		}
		sys_dlytsk(10);
	}
	if(cnt<=loop) {
		retval = -AG903_ETIMEDOUT;
	}

	return retval;
}

/**
 * @brief		DMA҂
 * @param[in]	timout	^CAEg[ms]
 * @return		Ȃ
 * @note		Ȃ
 */
static int32_t Uart_WaitDmaTerm(uint32_t timout)
{
	int32_t		retval = AG903_ENONE;
	uint32_t	cnt;
	uint32_t	loop;

	cnt = timout/10;
	if(timout%10) {
		cnt++;
	}
	for(loop=0; loop<cnt; loop++) {
		if(true == UartDmaTerm) {
			UartDmaTerm = false;
			break;
		}
		sys_dlytsk(10);
	}
	if(cnt<=loop) {
		retval = -AG903_ETIMEDOUT;
	}

	return retval;
}

/**
 * @brief		DMAzQƊ҂
 * @param[in]	handle	DMACnh
 * @param[in]	timout	^CAEg[ms]
 * @return		Ȃ
 * @note		Ȃ
 */

static int32_t Uart_WaitDmaLoop(AG903_DMACMgrHandle* handle, uint32_t timout)
{
	AG903_DMACMgrStatus  status;
	int32_t		retval = AG903_ENONE;
	uint32_t	cnt;
	uint32_t	loop;

	cnt = timout/10;
	if(timout%10) {
		cnt++;
	}
	for(loop=0; loop<cnt; loop++) {
		AG903_DMACMgrGetStatus(handle, &status);
		if(true != status.enable) {
			break;
		}
		sys_dlytsk(10);
	}
	if(cnt<=loop) {
		retval = -AG903_ETIMEDOUT;
	}

	return retval;
}

/**
 * @brief	R[obN (PIO]).
 * @param[in]	handle  UARTnh.
 * @param[in]	event	R[obNCxg.
 * @return	Ȃ.
 * @note	Ȃ.
 */
static void Uart_CallbackPio(AG903_UARTMgrHandle* handle, uint32_t event)
{
	if(AG903_UART_EVENT_SNDEND & event) {
		UartSendEnd = true;
	}

	if((AG903_UART_EVENT_DATARDY|AG903_UART_EVENT_RCVTIMEOUT) & event) {
		UartRcvSize = AG903_UARTMgrGetReceiveData(handle, UartBuf, UART_SMP_BUFSIZE);
		Uart_SFifoWrite(UartBuf, UartRcvSize);
	}

	if((AG903_UART_EVENT_OVERRUN|AG903_UART_EVENT_PARITYERR|AG903_UART_EVENT_FRAMINGERR|
		AG903_UART_EVENT_FIFOERR) & event) {
		/* Ȃ */
	}

	return;
}

/**
 * @brief	R[obN (DMA]).
 * @param[in]	handle  UARTnh.
 * @param[in]	event	R[obNCxg.
 * @return	Ȃ.
 * @note	Ȃ.
 */
static void Uart_CallbackDma(AG903_UARTMgrHandle* handle, uint32_t event)
{
	((void)handle);

	if(AG903_UART_EVENT_SNDEMPTY & event) {
		UartSendEnd = true;
	}

	if((AG903_UART_EVENT_DATARDY|AG903_UART_EVENT_RCVTIMEOUT) & event) {
		/* Ȃ */
	}

	if((AG903_UART_EVENT_OVERRUN|AG903_UART_EVENT_PARITYERR|AG903_UART_EVENT_FRAMINGERR|
		AG903_UART_EVENT_FIFOERR) & event) {
		/* Ȃ */
	}

	return;
}

/**
 * @brief		]I
 * @param[in]	handle	nh
 * @param[out]	desc	fBXNv^i[
 * @param[out]	end		zItO
 * @return		Ȃ
 * @note		Ȃ
 */
static void Uart_CallbackDmaTerm(AG903_DMACMgrHandle* handle, AG903_DMACMgrDesc** desc, uint8_t* end)
{
	((void)handle);

	if(NULL == desc) {
		UartDmaTerm = true;
	}
	else {
		(*desc) = NULL;
		if((UART_SMP_LOOP_NUM-2) <= ++UartLoopCnt) {
			(*end) = true;
		}
	}

	return;
}

/**
 * @brief		A{[g
 * @param[in]	handle	nh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Uart_CallbackDmaAbort(AG903_DMACMgrHandle* handle)
{
	((void)handle);
	return;
}

/**
 * @brief		G[
 * @param[in]	handle	nh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Uart_CallbackDmaErr(AG903_DMACMgrHandle* handle)
{
	((void)handle);
	return;
}


static void Uart_SFifoInit(void)
{
	struct uart_sfifo *self = &UartSFifo;
	self->iw = 0;
	self->ir = 0;
}

static int Uart_SFifoIsEmpty(void)
{
	struct uart_sfifo *self = &UartSFifo;

	int iw = self->iw;
	int ir = self->ir;
	return (iw == ir) ? 1 : 0;
}

static int Uart_SFifoIsFull(void)
{
	struct uart_sfifo *self = &UartSFifo;

	int ir = self->ir;
	int iw = self->iw;
	return ((iw + 1)%UART_SMP_SFIFOSIZE == ir) ? 1 : 0;
}


static int Uart_SFifoWrite(const uint8_t *dat, int size)
{
	struct uart_sfifo *self = &UartSFifo;
	int ii;

	for (ii = 0; ii < size; ii++) {
		if (!Uart_SFifoIsFull()) {
			self->buf[self->iw] = dat[ii];
			self->iw = (self->iw + 1) % UART_SMP_SFIFOSIZE;
		} else {
			break;
		}
	}

	return ii;
}

static int Uart_SFifoRead(uint8_t *dat, int size)
{
	struct uart_sfifo *self = &UartSFifo;
	int ii;

	for (ii = 0; ii < size; ii++) {
		if (!Uart_SFifoIsEmpty()) {
			dat[ii] = self->buf[self->ir];
			self->ir = (self->ir + 1) % UART_SMP_SFIFOSIZE;
		} else {
			break;
		}
	}

	return ii;
}
