/** 
 * @brief           Communication Device Class Driver API Header
 * @author          AXELL CORPORATION
 * @description     Communication Device Class Driver񋟃wb_<p>
 *                  AvP[ViData Class InterfaceȊOj
 * @note            none
 * @history         2017_02_22 
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
#ifndef __USB_CDC_COMMIF_API_H__
#define __USB_CDC_COMMIF_API_H__
/* DOM-IGNORE-END */

#include "usb_cdc_type.h"
#include "usb_cdc_log.h"

/** CDC hCoFW[o[W */
#define	CDC_MAJOR_VERSION		(0x01)

/** CDC hCoF}Ci[o[W */
#define	CDC_MINOR_VERSION		(0x00)


/** R~jP[VNXLʒmR[h */
typedef enum {
	COMM_FEATURE_SELECTOR_ABSTRACT_STATE = 1,	/** Abstruct Control Model ʐM@\ */
	COMM_FEATURE_SELECTOR_COUNTRY_SETTING		/** R[h@\ */
} COMM_FEATURE_SELECTOR;

/** 񓯊VAʐMݒ Xgbvrbg */
typedef enum {
	LINE_CODING_STOPBIT_1,						/** 1 Stop Bit */
	LINE_CODING_STOPBIT_15,						/** 1.5 Stop Bit */
	LINE_CODING_STOPBIT_2						/** 2 Stop Bit */
} LINE_CODING_STOPBIT;

/** 񓯊VAʐMݒ peB */
typedef enum {
	LINE_CODING_PARITY_NONE,					/** peBȂ */
	LINE_CODING_PARITY_ODD,						/**  */
	LINE_CODING_PARITY_EVEN,					/**  */
	LINE_CODING_PARITY_MARK,					/** }[N */
	LINE_CODING_PARITY_SPACE					/** Xy[X */
} LINE_CODING_PARITY;

/** 񓯊VAʐMݒ f[^rbg */
typedef enum {
	LINE_CODING_DATABIT_5 = 5,					/** 5 Data Bit */
	LINE_CODING_DATABIT_6,						/** 6 Data Bit */
	LINE_CODING_DATABIT_7,						/** 7 Data Bit */
	LINE_CODING_DATABIT_8,						/** 8 Data Bit */
	LINE_CODING_DATABIT_16 = 16					/** 16 Data Bit */
} LINE_CODING_DATABIT;


typedef struct CdcCommFeature* PCDC_COMM_FEATURE;	/** ʐM@\ւ̃|C^ */
typedef struct CdcLineCoding* PCDC_LINE_CODING;		/** 񓯊VAʐMݒւ̃|C^ */
typedef struct CdcControlLineState* PCDC_CONTROL_LINE_STATE;	/** RS232 Mݒւ̃|C^ */
typedef struct CdcSendBreak* PCDC_SEND_BREAK;		/** u[NMoւ̃|C^ */

/** ʐM@\<p>
    ݒ܂͎擾f[^̏ڍׂɂẮAuUniversal Serial Bus Communications Class Subclass 
    Specification for PSTN DevicesvQƂĉB<p>
    ^C~O F ʐM@\̐ݒ肨ю擾O<p>
    폜^C~O F ʐM@\̐ݒ肨ю擾 */
typedef struct CdcCommFeature {
	COMM_FEATURE_SELECTOR	FeatureSelector;	/** @\I */
	uhs_ubit16_t			u16Data;			/** ʐM@\f[^ */
} CDC_COMM_FEATURE;

/** 񓯊VAʐMݒ<p>
    ^C~O F 񓯊VAʐM̐ݒ肨ю擾O<p>
    폜^C~O F 񓯊VAʐM̐ݒ肨ю擾 */
typedef struct CdcLineCoding {
    uhs_ubit32_t			u32BaudRate;		/** ʐMx */
    LINE_CODING_STOPBIT		StopBit;			/** Xgbvrbg */
    LINE_CODING_PARITY		Parity;				/** peB */
    LINE_CODING_DATABIT		DataBit;			/** f[^rbg */
} CDC_LINE_CODING;

/** RS232 Mݒ<p>
    ݒ肷f[^̏ڍׂɂẮAuUniversal Serial Bus Communications Class Subclass 
    Specification for PSTN DevicesvQƂĉB<p>
    ^C~O F RS232 MݒO<p>
    폜^C~O F RS232 Mݒ */
typedef struct CdcControlLineState {
	uhs_ubit16_t	u16Data;					/** RS232 Mݒf[^ */
} CDC_CONTROL_LINE_STATE;

/** u[NMo^<p>
    ݒ肷f[^̏ڍׂɂẮAuUniversal Serial Bus Communications Class Subclass 
    Specification for PSTN DevicesvQƂĉB<p>
    ^C~O F u[NMoO<p>
    폜^C~O F u[NMo */
typedef struct CdcSendBreak {
	uhs_ubit16_t	u16Data;					/** u[NMof[^ */
} CDC_SEND_BREAK;


extern uhs_status_t Usbh_Cdc_GetVersion(uhs_ubit8_t*  pu8MajorVersion, uhs_ubit8_t*  pu8MinorVersion);
extern uhs_status_t Usbh_Cdc_RegistCallBack(void* pContext, cdc_callback_t pUserNotifyCallback, uhs_ubit8_t u8TotalBuffSize);
extern uhs_status_t Usbh_Cdc_SendEncapsulatedCommand(void* pContext, PCDC_BUFF_INFO pstData);
extern uhs_status_t Usbh_Cdc_GetEncapsulatedResponse(void* pContext, PCDC_BUFF_INFO pstData);
extern uhs_status_t Usbh_Cdc_SetCommFeature(void* pContext, PCDC_COMM_FEATURE pstData);
extern uhs_status_t Usbh_Cdc_GetCommFeature(void* pContext, PCDC_COMM_FEATURE pstData);
extern uhs_status_t Usbh_Cdc_ClearCommFeature(void* pContext, PCDC_COMM_FEATURE pstData);
extern uhs_status_t Usbh_Cdc_SetLineCoding(void* pContext, PCDC_LINE_CODING pstData);
extern uhs_status_t Usbh_Cdc_GetLineCoding(void* pContext, PCDC_LINE_CODING pstData);
extern uhs_status_t Usbh_Cdc_SetControlLineState(void* pContext, PCDC_CONTROL_LINE_STATE pstData);
extern uhs_status_t Usbh_Cdc_SendBreak(void* pContext, PCDC_SEND_BREAK pstData);

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/
#ifdef USBH_STACK_DEBUG_BUILD
#define CIAPI_CDC_REPORT_SUMMARY(err) Usbh_Cdc_Log_ReportError( g_filename, __LINE__, (err), (uhs_ubit8_t*)"1", 0 )
#define CIAPI_CDC_REPORT_DETAIL(err, mesg, len) Usbh_Cdc_Log_ReportError( g_filename, __LINE__, (err), (mesg), (len) )
#define CIAPI_CDC_REPORT_MILESTONE(num) Usbh_Cdc_Log_ReportMilestone((num))
#else
#define CIAPI_CDC_REPORT_SUMMARY(err) Usbh_Cdc_Log_ReportDummy(err)
#define CIAPI_CDC_REPORT_DETAIL(err, mesg, len) Usbh_Cdc_Log_ReportDummy(err)
#define CIAPI_CDC_REPORT_MILESTONE(num) Usbh_Cdc_Log_ReportMilestone((num))
#endif

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/

#endif /* __USB_CDC_COMMIF_API_H__ */
