/**
 * @brief           EQS Primitive Header
 * @author          AXELL CORPORATION
 * @description     EQS Primitive񋟃wb_B<p>EQS PrimitivegpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __EQSPRM_H__
#define __EQSPRM_H__
/* DOM-IGNORE-END */

#ifdef __cplusplus
extern "C" {
#endif

#define	AG903_EQS_DIVIDE_MIN	(2)					/** 䉺 */
#define	AG903_EQS_AREA_MAX		(4)					/** EQSGA */
#define AG903_EQS_AREA_BASE		(0x60000000UL)		/** EQSGAx[XAhX */
#define	AG903_EQS_AREA_SIZ		(16 * 1024 * 1024)	/** EQSGATCY */

/** EQSݒp[^ */
typedef struct _AG903_EQSPrmFormat {
	uint8_t	command;		/** R}h */
	uint8_t	wait;			/** EFCgTCN */
	uint8_t	data_len;		/** f[^ (Write) */
	uint8_t	addr_len;		/** AhX */
	uint8_t	flow;			/** t[L */
	uint8_t	reserve;		/** \ */
} AG903_EQSPrmFormat;

/*************************************************************************************
 * vg^Cv`
 ************************************************************************************/
void AG903_EQSPrmSetMOD(uint8_t mode);
void AG903_EQSPrmGetMOD(uint8_t* mode);
void AG903_EQSPrmSetDivide(uint16_t div);
void AG903_EQSPrmGetDivide(uint16_t* div);
void AG903_EQSPrmSetWaitCycle(uint16_t count);
void AG903_EQSPrmGetWaitCycle(uint16_t* count);
void AG903_EQSPrmGetAddress(uint8_t area, uint32_t* addr);
void AG903_EQSPrmSetRdFORMAT(uint8_t ch, AG903_EQSPrmFormat* format);
void AG903_EQSPrmSetWrFORMAT(uint8_t ch, AG903_EQSPrmFormat* format);


#ifdef __cplusplus
}
#endif

#endif/* __EQSPRM_H__ */
