/**
 * @brief           JPG Manager Header
 * @author          AXELL CORPORATION
 * @description     JPG Manager񋟃wb_B<p>JPG ManagergpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_05_01  [#1303]JPGCu̕ύX
 * @history         2017_10_26  Ver2.0
 * @history         2018_01_24  Ver2.1
 *                  [#1781] iݒAPI "AG903_JPGSetQScale" ǉ
 * @history         2021_06_30  [SDK3.3] ُJPEGf[^̃fR[hIȂȂsC (#3255)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2021 AXELL CORPORATION, all rights reserved.
 */

#ifndef __JPGMGR_H__
#define __JPGMGR_H__
/* DOM-IGNORE-END */

#ifdef __cplusplus
extern "C" {
#endif

/** R[fbN[h */
enum AG903_JPG_ENDEC_ENUM{
	AG903_JPG_ENDEC_DECODE					= 0	,	/** Decode operation */
	AG903_JPG_ENDEC_ENCODE						,	/** Encode operation */
};

/** J[R|[lg */
enum AG903_JPG_CCOMP_ENUM{
	AG903_JPG_CCOMP_YUV420					= 0	,	/** YUV420 mode */
	AG903_JPG_CCOMP_YUV422						,	/** YUV422 mode */
};

/** tbNv */
enum AG903_JPG_HOOK_ENUM{
	AG903_JPG_HOOK_CMP						= 0	,	/** oX] */
	AG903_JPG_HOOK_STRE							,	/** Xg[f[^]G[ */
	AG903_JPG_HOOK_IMGE							,	/** 摜f[^]G[ */
	AG903_JPG_HOOK_CAPE							,	/** Lv`[I[o[t[ */
	AG903_JPG_HOOK_ESTE							,	/** GR[hJnG[ */
	AG903_JPG_HOOK_EOI							,	/** EOIo */
	AG903_JPG_HOOK_SOI							,	/** SOI/Picturewb_o */
	AG903_JPG_HOOK_EOP							,	/** CODEC */
	AG903_JPG_HOOK_SOP							,	/** CODECJn */
	AG903_JPG_HOOK_NG							,	/** R[fbNG[ */
	AG903_JPG_HOOK_SOS							,	/** SOSo */
	AG903_JPG_HOOK_DCTRI						,	/** DCTǂݍ */
	AG903_JPG_HOOK_INITF						,	/** CODEC */
	AG903_JPG_HOOK_SRSTF						,	/** CODEC\tgZbg	*/

	AG903_JPG_HOOK_MAX								/** tbNv */
};

/** JPGnh */
typedef uint32_t	AG903_JPGHandle;

/** R[fbNp[^<p>
    interval Restart}[J[̃C^[o̐ݒłB<p>
	operation ͉Ew肵܂B AG903_JPG_ENDEC_DECODE , AG903_JPG_ENDEC_ENCODE<p>
    color_cmpnt ͉Ew肵܂B AG903_JPG_CCOMP_YUV420 , AG903_JPG_CCOMP_YUV422<p>
    EOImarker  true=}[J[ONAfalse=}[J[OFF łB<p>
    RSTmarker  true=}[J[ONAfalse=}[J[OFF łB<p>
    SOImarker  true=}[J[ONAfalse=}[J[OFF łB<p>
    marker  true=}[J[ONAfalse=}[J[OFF łB<p>
    SOSstop  true=fR[h~Afalse=ʏ퓮 łB*/
typedef struct _AG903_JPGCtrlParam {
	uint16_t	interval;		/** Restart}[J[ C^[o */
	uint8_t		operation;		/** Codec Operation Decode/Encode */
	uint8_t		color_cmpnt;	/** Color Component YUV420/YUV422 (Encodê) */
	uint8_t		EOImarker;		/** EOI}[J[ On/Off (Encodê) */
	uint8_t		RSTmarker;		/** RST}[J[ On/Off (Encodê) */
	uint8_t		SOImarker;		/** SOI}[J[ On/Off (Encodê) */
	uint8_t		marker;			/** DQT/SOF/DHT/SOS}[J[ On/Off (Encodê) */
	uint8_t		SOSstop;		/** SOSoStop (Decodê) */
	uint8_t		reserve[3];		/** \ */
}	AG903_JPGCtrlParam;

/** R[fbNݒp[^<p>
    in_buf 4oCgACꂽAhXw肵ĉB
    ܂fR[h̓f[^̖0xXX4oCgȏ]ɕtĉB<p>
    out_buf 4oCgACꂽAhXw肵ĉB
    ܂GR[h̓TCYς܂̂ŏ\ȃTCYmۂĉB<p>
    strm_size  in_buf ɗ]ɕtf[^܂߂TCYݒ肵ĉB<p>
    stride  XgCh̃oCgTCYݒ肵ĉB
	܂ݒl8sNZ̔{i16oCgjPʂɂKv܂B<p>
	capture  true=Lv`H荞݁Afalse=VRAM荞 łB<p>
    buf_flow  true=LAfalse= łBiBMUgptruew肵ĉj<p>
    flame_skip  true=SOI}[J[܂Ńt[XLbvAfalse=XLbvȂ łB*/
typedef struct _AG903_JPGCodecParam {
	void*		in_buf;		/** ̓obt@ (capture OFF̂) */
	void*		out_buf;	/** o̓obt@ */
	uint32_t	h_size;		/** TCY[pixel] (Encodê) */
	uint32_t	v_size;		/** TCY[pixel] (Encodê) */
	uint32_t	strm_size;	/** Xg[TCY (Decodê)  */
	uint16_t	stride;		/** XgChTCY (capture OFF̂)  */
	uint8_t		capture;	/** capture ON/OFF */
	uint8_t		buf_flow;	/** obt@Ǘt[ ON/OFF */
	uint8_t		flame_skip;	/** Search next SOI automatically ON/OFF */
	uint8_t		reserve[3];	/** \ */
}	AG903_JPGCodecParam;

/** R[obN֐^<p>
    handle JPGnhAparam  AG903_JPGSetHooks Őݒ肵p[^łB*/
typedef void (*AG903_JPGClbk)(AG903_JPGHandle *handle, uint32_t param);

/** tbNXg\<p>
    R[obNsvȏꍇ clbk NULLݒ肵ĉB<p>
    param ̓R[obN֐ɈƂēn܂B*/
typedef struct _AG903_JPGHooks {
	AG903_JPGClbk	clbk;	/** R[obN֐|C^ */
	uint32_t			param;	/** Cӂ̃p[^ */
}	AG903_JPGHooks;

/*************************************************************************************
 * vg^Cv`
 ************************************************************************************/

/**
 * @brief           JPGW[
 * @param           none
 * @return          
 * @retval          AG903_ENONE  I
 * @description     Ԃ̏s܂BVXeNCALLĉB
*/
int32_t AG903_JPGInit(void);

/**
 * @brief           JPGnh擾
 * @param           handle [out] JPGnh
 * @return          nh擾
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EBUSY   nhgp
 * @retval          -AG903_EFAULT  si݃nho^sj
 * @description     JPG̃nh擾܂B
 * @note            Ԃ́A擾ɏ܂B
 * @note	        ȉINTManager APIgp܂B
 * @note              EAG903_INTMgrSetHandler
 * @note              EAG903_INTMgrEnableInt
*/
int32_t AG903_JPGGetHandle(AG903_JPGHandle **handle);

/**
 * @brief           JPGnh
 * @param           handle [in] JPGnh
 * @return          nh
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EBUSY   nhgp
 * @description     nh܂B<p>쒆Ƀnhꂽꍇ̓G[Ԃ܂B 
 * @note            ́Anh͍̉sȂłB
*/
int32_t AG903_JPGReleaseHandle(AG903_JPGHandle *handle);

/**
 * @brief           Xg[TCY擾
 * @param           handle [in] JPGnh
 * @param           size [out] Xg[TCY [oCg]
 * @return          Xg[TCY擾
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     Xg[TCY擾܂BiGR[hɃf[^TCY擾邱Ƃł܂Bj
*/
int32_t AG903_JPGGetStreamSize(AG903_JPGHandle *handle, uint32_t *size);

/**
 * @brief           C[WTCY擾
 * @param           handle [in] JPGnh
 * @param           xlen [out]  [pixel]
 * @param           ylen [out] c [pixel]
 * @return          C[WTCY擾
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     C[WTCY擾܂BifR[hɃfR[h摜̃TCY擾邱Ƃł܂Bj
*/
int32_t AG903_JPGGetImageSize(AG903_JPGHandle *handle, uint32_t *xlen, uint32_t *ylen);

/**
 * @brief           J[R|[lg擾
 * @param           handle [in] JPGnh
 * @param           ccomp [out] J[R|[lg [0:YUV420,1:YUV422]
 * @return          J[R|[lg擾
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     J[R|[lg擾܂BifR[hJPEGt[wb_J[R|[lg擾邱Ƃł܂Bj
*/
int32_t AG903_JPGGetColorComponent(AG903_JPGHandle *handle, uint8_t *ccomp);

/**
 * @brief           R[fbN
 * @param           handle [in] JPGnh
 * @param           param [out] p[^
 * @return          R[fbN
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EBUSY   nhgpij
 * @description     R[fbN܂B 
 * @note            fR[hGR[hւ̐؂ւA܂͂̋t̐؂ւsꍇAR[fbNI(AG903_JPGEndCodec)<p>
 *                  Ō݂̏IA֐R[ĂB<p>
 *                  ꏈsꍇ́AR[fbNI͕svłB
 * @note            ɔG[AG903_JPGSetHooksŃR[obNo^ČoĂB
*/
int32_t AG903_JPGInitCodec(AG903_JPGHandle *handle, AG903_JPGCtrlParam *param);

/**
 * @brief           R[fbNJn
 * @param           handle [in] JPG nh
 * @param           param [in] R[fbNp[^
 * @return          R[fbNJn
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EILSEQ  Ԉُi/j
 * @description     R[fbN̓Jn܂B
 * @note            fR[h́A4Byteȏ̃_~[f[^tĂB<p>
 *                  _~[f[^tȂꍇAf[^]IȂꂪ܂B<p>
 *                  GR[h́AGR[hf[^o͐obt@̐擪4ByteɁAGR[hf[^̃TCYi[܂BGR[hf[^́A擪4Byteォi[܂B
 * @note            ɔG[AG903_JPGSetHooksŃR[obNo^ČoĂB
*/
int32_t AG903_JPGStartCodec(AG903_JPGHandle *handle, AG903_JPGCodecParam *param);

/**
 * @brief           R[fbNI
 * @param           handle [in] JPGnh
 * @return          R[fbNI
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     R[fbN̏I܂B
*/
int32_t AG903_JPGEndCodec(AG903_JPGHandle *handle);

/**
 * @brief           R[obNo^
 * @param           handle [in] JPGnh
 * @param           hook [in] tbNXg
 * @return          R[obNo^
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     R[obNo^܂B<p>
 *                  hookɂ͈ȉzƂAKvȃR[obNo^ĉB<p>
 *                  <table>
 *                  <tr><th>hook</th><th>R[obN</th></tr>
 *                  <tr><td>AG903_JPG_HOOK_CMP</td><td>oX]</td></tr>
 *                  <tr><td>AG903_JPG_HOOK_STRE</td><td>Xg[f[^]G[</td></tr>
 *                  <tr><td>AG903_JPG_HOOK_IMGE</td><td>摜f[^]G[</td></tr>
 *                  <tr><td>AG903_JPG_HOOK_CAPE</td><td>Lv`[I[o[t[</td></tr>
 *                  <tr><td>AG903_JPG_HOOK_ESTE</td><td>GR[hJnG[</td></tr>
 *                  <tr><td>AG903_JPG_HOOK_EOI</td><td>EOIo</td></tr>
 *                  <tr><td>AG903_JPG_HOOK_SOI</td><td>SOI/Picturewb_o</td></tr>
 *                  <tr><td>AG903_JPG_HOOK_EOP</td><td>CODEC</td></tr>
 *                  <tr><td>AG903_JPG_HOOK_SOP</td><td>CODECJn</td></tr>
 *                  <tr><td>AG903_JPG_HOOK_NG</td><td>R[fbNG[</td></tr>
 *                  <tr><td>AG903_JPG_HOOK_SOS</td><td>SOSo</td></tr>
 *                  <tr><td>AG903_JPG_HOOK_DCTRI</td><td>DCTǂݍ</td></tr>
 *                  <tr><td>AG903_JPG_HOOK_INITF</td><td>CODEC</td></tr>
 *                  <tr><td>AG903_JPG_HOOK_SRSTF</td><td>CODEC\tgZbg</td></tr>
 *                  </table>
 * @note            R[obNsvȏꍇ clbk  NULL ݒ肵ĉB
 * @note            R[fbN̏́uAG903_JPG_HOOK_EOPvł͂ȂuAG903_JPG_HOOK_CMPvŔfĉB
 * @note            AG903_JPG_HOOK_NĜƂ͂Ăf[^sł\܂B
 * @note            AG903_JPG_HOOK_NĜƂ̓R[obN𔲂AG903_JPGEndCodecŏIA
 *                  AG903_JPGInitŏĉB
*/
int32_t AG903_JPGSetHooks(AG903_JPGHandle *handle, AG903_JPGHooks *hook);

/**
 * @brief           ilݒ
 * @param           scale [in] il
 * @return          ilݒ茋
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     摜̕ilw肵܂Bw͈͂́A0Fiikj100Fiiሳkj̊ԂŎw肵ĂB<p>
 *                  ܂A{֐Őݒ肵iĺAJPGW[֐uAG903_JPGInitvs鎖œKp܂B<p>
 *                  ftHgl75łB
*/
int32_t AG903_JPGSetQScale(uint8_t scale);


#ifdef __cplusplus
}
#endif

#endif/* __JPGMGR_H__ */
