/**
 * @brief           PGP Primitive Header
 * @author          AXELL CORPORATION
 * @description     PGP Primitive Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef PGPPRM_H
#define PGPPRM_H
/* DOM-IGNORE-END */

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/** pCvC̍ő吔 */
#define AG903_PGP_PRM_MAX_PIPELINE        (6)

/** VRAM̓|[g̍ő吔 */
#define AG903_PGP_PRM_MAX_VRAMI           (4)

/** Zxϊe[u̍ő吔 */
#define AG903_PGP_PRM_MAX_DGCLUT          (2)

/** PGPnSTATEWX^p[^ */
typedef struct _PGPPrmParamPGPnSTATE {
	uint32_t blank;                     /** BLANKtB[hl  */
	uint32_t vrmacc;                    /** VRMACCtB[hl */
	uint32_t queue;                     /** QUEUEtB[hl  */
	uint32_t sst;                       /** SSTtB[hl    */
	uint32_t st;                        /** STtB[hl     */
}PGPPrmParamPGPnSTATE;

/** PGPnINTENWX^p[^ */
typedef struct _PGPPrmParamPGPnINTEN {
	uint32_t nd;                        /** NDtB[hl      */
	uint32_t voicpl;                    /** VOICPLtB[hl  */
	uint32_t vooflw;                    /** VOOFLWtB[hl  */
	uint32_t ifcofs;                    /** IFCOFStB[hl  */
	uint32_t ifcofm;                    /** IFCOFMtB[hl  */
	uint32_t lblcrpt;                   /** LBLCRPTtB[hl */
	uint32_t lblcpl;                    /** LBLCPLtB[hl  */
	uint32_t hgmicpl;                   /** HGMICPLtB[hl */
	uint32_t hgmcpl;                    /** HGMCPLtB[hl  */
	uint32_t vsynco;                    /** VSYNCOtB[hl  */
	uint32_t vlineo;                    /** VLINEOtB[hl  */
	uint32_t vsynci;                    /** VSYNCItB[hl  */
	uint32_t vlinei;                    /** VLINEItB[hl  */
}PGPPrmParamPGPnINTEN;

/** PGPnINTSTATWX^p[^ */
typedef struct _PGPPrmParamPGPnINTSTAT {
	uint32_t nd;                        /** NDtB[hl      */
	uint32_t voicpl;                    /** VOICPLtB[hl  */
	uint32_t vooflw;                    /** VOOFLWtB[hl  */
	uint32_t ifcofs;                    /** IFCOFStB[hl  */
	uint32_t ifcofm;                    /** IFCOFMtB[hl  */
	uint32_t lblcrpt;                   /** LBLCRPTtB[hl */
	uint32_t lblcpl;                    /** LBLCPLtB[hl  */
	uint32_t hgmicpl;                   /** HGMICPLtB[hl */
	uint32_t hgmcpl;                    /** HGMCPLtB[hl  */
	uint32_t vsynco;                    /** VSYNCOtB[hl  */
	uint32_t vlineo;                    /** VLINEOtB[hl  */
	uint32_t vsynci;                    /** VSYNCItB[hl  */
	uint32_t vlinei;                    /** VLINEItB[hl  */
}PGPPrmParamPGPnINTSTAT;

/** PGPnINTCLRWX^p[^ */
typedef struct _PGPPrmParamPGPnINTCLR {
	uint32_t nd;                        /** NDtB[hl      */
	uint32_t voicpl;                    /** VOICPLtB[hl  */
	uint32_t vooflw;                    /** VOOFLWtB[hl  */
	uint32_t ifcofs;                    /** IFCOFStB[hl  */
	uint32_t ifcofm;                    /** IFCOFMtB[hl  */
	uint32_t lblcrpt;                   /** LBLCRPTtB[hl */
	uint32_t lblcpl;                    /** LBLCPLtB[hl  */
	uint32_t hgmicpl;                   /** HGMICPLtB[hl */
	uint32_t hgmcpl;                    /** HGMCPLtB[hl  */
	uint32_t vsynco;                    /** VSYNCOtB[hl  */
	uint32_t vlineo;                    /** VLINEOtB[hl  */
	uint32_t vsynci;                    /** VSYNCItB[hl  */
	uint32_t vlinei;                    /** VLINEItB[hl  */
}PGPPrmParamPGPnINTCLR;

/** PGPnTRGENWX^p[^ */
typedef struct _PGPPrmParamPGPnTRGEN {
	uint32_t vsynco;                    /** VSYNCOtB[hl */
	uint32_t vlineo;                    /** VLINEOtB[hl */
	uint32_t vsynci;                    /** VSYNCItB[hl */
	uint32_t vlinei;                    /** VLINEItB[hl */
}PGPPrmParamPGPnTRGEN;

/** PGPnINCTRLWX^p[^ */
typedef struct _PGPPrmParamPGPnINCTRL {
	uint32_t hdly;                      /** HDLYtB[h   */
	uint32_t md;                        /** MDtB[hl   */
	uint32_t tick;                      /** TICKtB[hl */
	uint32_t trg;                       /** TRGtB[hl  */
	uint32_t sel;                       /** SELtB[hl  */
	uint32_t fmt;                       /** FMTtB[hl  */
}PGPPrmParamPGPnINCTRL;

/** PGPnFUNCCTRLWX^p[^ */
typedef struct _PGPPrmParamPGPnFUNCCTRL {
	uint32_t out;                       /** OUTtB[hl    */
	uint32_t ifcodr;                    /** IFCODRtB[hl */
	uint32_t ifc;                       /** IFCtB[hl    */
	uint32_t thr;                       /** THRtB[hl    */
	uint32_t dgc;                       /** DGCtB[hl    */
	uint32_t hsv1;                      /** HSV1tB[hl   */
	uint32_t spf;                       /** SPFtB[hl    */
	uint32_t scale;                     /** SCALEtB[hl  */
	uint32_t csc1;                      /** CSC1tB[hl   */
	uint32_t nrf;                       /** NRFtB[hl    */
}PGPPrmParamPGPnFUNCCTRL;
/** PGPnPOSWX^p[^ */
typedef struct _PGPPrmParamPGPnPOS {
	uint32_t epos;                      /** EPOStB[hl */
	uint32_t opos;                      /** OPOStB[hl */
	uint32_t scan;                      /** SCANtB[hl */
	uint32_t vpos;                      /** VPOStB[hl */
	uint32_t hpos;                      /** HPOStB[hl */
}PGPPrmParamPGPnPOS;

/** PGPnOUTCTRL0WX^p[^ */
typedef struct _PGPPrmParamPGPnOUTCTRL0 {
	uint32_t pad;                       /** PADtB[hl   */
	uint32_t limit;                     /** LIMITtB[hl */
	uint32_t fai;                       /** FAItB[hl   */
	uint32_t dth;                       /** DTHtB[hl   */
	uint32_t bmu;                       /** BMUtB[hl   */
	uint32_t scan;                      /** SCANtB[hl  */
	uint32_t dim;                       /** DIMtB[hl   */
	uint32_t swapw;                     /** SWAPWtB[hl */
	uint32_t swaph;                     /** SWAPHtB[hl */
	uint32_t swap4;                     /** SWAP4tB[hl */
	uint32_t swap1;                     /** SWAP1tB[hl */
	uint32_t md;                        /** MDtB[hl    */
	uint32_t fmt;                       /** FMTtB[hl   */
}PGPPrmParamPGPnOUTCTRL0;

/** PGPnSCCTRLWX^p[^ */
typedef struct _PGPPrmParamPGPnSCCTRL {
	uint32_t limit;                     /** LIMITtB[hl */
	uint32_t mtd;                       /** MTDtB[hl   */
	uint32_t nmrv;                      /** NMRVtB[hl  */
	uint32_t dnmv;                      /** DNMVtB[hl  */
	uint32_t nmrh;                      /** NMRHtB[hl  */
	uint32_t dnmh;                      /** DNMHtB[hl  */
}PGPPrmParamPGPnSCCTRL;

/** PGPnSPFCTRLWX^p[^ */
typedef struct _PGPPrmParamPGPnSPFCTRL {
	uint32_t sft;                       /** SFTtB[hl */
	uint32_t bc;                        /** BCtB[hl  */
	uint32_t r;                         /** RtB[hl   */
	uint32_t g;                         /** GtB[hl   */
	uint32_t b;                         /** BtB[hl   */
}PGPPrmParamPGPnSPFCTRL;

/** PGPnHGMCTRLWX^p[^ */
typedef struct _PGPPrmParamPGPnHGMCTRL {
	uint32_t inv;                       /** INVtB[hl  */
	uint32_t bmu;                       /** BMUtB[hl  */
	uint32_t exc;                       /** EXCtB[hl  */
	uint32_t thr;                       /** THRtB[hl  */
	uint32_t sft;                       /** SFTtB[hl  */
	uint32_t vinc;                      /** VINCtB[hl */
	uint32_t hinc;                      /** HINCtB[hl */
}PGPPrmParamPGPnHGMCTRL;

/** PGPnHGMSTATWX^p[^ */
typedef struct _PGPPrmParamPGPnHGMSTAT {
	uint32_t init;                      /** INITtB[hl   */
	uint32_t vrmacc;                    /** VRMACCtB[hl */
	uint32_t act;                       /** ACTtB[hl    */
	uint32_t queue;                     /** QUEUEtB[hl  */
	uint32_t cmd;                       /** CMDtB[hl    */
}PGPPrmParamPGPnHGMSTAT;

/** PGPnTHRCTRLWX^p[^ */
typedef struct _PGPPrmParamPGPnTHRCTRL {
	uint32_t limit;                     /** LIMITtB[hl  */
	uint32_t spf1;                      /** SPF1tB[hl   */
	uint32_t msk;                       /** MSKtB[hl    */
	uint32_t csc2;                      /** CSC2tB[hl   */
	uint32_t hsv2;                      /** HSV2tB[hl   */
	uint32_t thr8;                      /** THR8tB[hl   */
	uint32_t outsel;                    /** OUTSELtB[hl */
	uint32_t c8sel;                     /** C8SELtB[hl  */
}PGPPrmParamPGPnTHRCTRL;

/** PGPnMSK0PRM1WX^p[^ */
typedef struct _PGPPrmParamPGPnMSK0PRM1 {
	uint32_t hmax;                      /** HMAXtB[hl */
	uint32_t hmin;                      /** HMINtB[hl */
	uint32_t lmax;                      /** LMAXtB[hl */
	uint32_t lmin;                      /** LMINtB[hl */
}PGPPrmParamPGPnMSK0PRM1;

/** PGPnMSK1PRM1WX^p[^ */
typedef struct _PGPPrmParamPGPnMSK1PRM1 {
	uint32_t hmax;                      /** HMAXtB[hl */
	uint32_t hmin;                      /** HMINtB[hl */
	uint32_t lmax;                      /** LMAXtB[hl */
	uint32_t lmin;                      /** LMINtB[hl */
}PGPPrmParamPGPnMSK1PRM1;

/** PGPnMSK2PRM1WX^p[^ */
typedef struct _PGPPrmParamPGPnMSK2PRM1 {
	uint32_t hmax;                      /** HMAXtB[hl */
	uint32_t hmin;                      /** HMINtB[hl */
	uint32_t lmax;                      /** LMAXtB[hl */
	uint32_t lmin;                      /** LMINtB[hl */
}PGPPrmParamPGPnMSK2PRM1;

/** PGPnTHR8PRM0WX^p[^ */
typedef struct _PGPPrmParamPGPnTHR8PRM0 {
	uint32_t type;                      /** TYPEtB[hl   */
	uint32_t maxval;                    /** MAXVALtB[hl */
	uint32_t maxthr;                    /** MAXTHRtB[hl */
	uint32_t minthr;                    /** MINTHRtB[hl */
}PGPPrmParamPGPnTHR8PRM0;

/** PGPnTHR8PRM1WX^p[^ */
typedef struct _PGPPrmParamPGPnTHR8PRM1 {
	uint32_t type;                      /** TYPEtB[hl   */
	uint32_t maxval;                    /** MAXVALtB[hl */
	uint32_t maxthr;                    /** MAXTHRtB[hl */
	uint32_t minthr;                    /** MINTHRtB[hl */
}PGPPrmParamPGPnTHR8PRM1;

/** PGPnTHR8PRM2WX^p[^ */
typedef struct _PGPPrmParamPGPnTHR8PRM2 {
	uint32_t type;                      /** TYPEtB[hl   */
	uint32_t maxval;                    /** MAXVALtB[hl */
	uint32_t maxthr;                    /** MAXTHRtB[hl */
	uint32_t minthr;                    /** MINTHRtB[hl */
}PGPPrmParamPGPnTHR8PRM2;

/** PGPnTHR1PRM1WX^p[^ */
typedef struct _PGPPrmParamPGPnTHR1PRM1 {
	uint32_t hmax;                      /** HMAXtB[hl */
	uint32_t hmin;                      /** HMINtB[hl */
	uint32_t lmax;                      /** LMAXtB[hl */
	uint32_t lmin;                      /** LMINtB[hl */
}PGPPrmParamPGPnTHR1PRM1;

/** PGPnSPF1PRM0WX^p[^ */
typedef struct _PGPPrmParamPGPnSPF1PRM0 {
	uint32_t h10;                       /** H10tB[hl */
	uint32_t h00;                       /** H00tB[hl */
	uint32_t hm0;                       /** HM0tB[hl */
	uint32_t h1m;                       /** H1MtB[hl */
	uint32_t h0m;                       /** H0MtB[hl */
	uint32_t hmm;                       /** HMMtB[hl */
}PGPPrmParamPGPnSPF1PRM0;

/** PGPnSPF1PRM1WX^p[^ */
typedef struct _PGPPrmParamPGPnSPF1PRM1 {
	uint32_t thr;                       /** THRtB[hl */
	uint32_t h11;                       /** H11tB[hl */
	uint32_t h01;                       /** H01tB[hl */
	uint32_t hm1;                       /** HM1tB[hl */
}PGPPrmParamPGPnSPF1PRM1;

/** PGPnLBLCTRLWX^p[^ */
typedef struct _PGPPrmParamPGPnLBLCTRL {
	uint32_t vld;                       /** VLDtB[hl   */
	uint32_t inv;                       /** INVtB[hl   */
	uint32_t cnct;                      /** CNCTtB[hl  */
	uint32_t bmu;                       /** BMUtB[hl   */
	uint32_t flthr;                     /** FLTHRtB[hl */
	uint32_t maxid;                     /** MAXIDtB[hl */
}PGPPrmParamPGPnLBLCTRL;

/** PGPnLBLSTATWX^p[^ */
typedef struct _PGPPrmParamPGPnLBLSTAT {
	uint32_t l_id;                      /** IDtB[hl     */
	uint32_t vrmacc;                    /** VRMACCtB[hl */
	uint32_t act;                       /** ACTtB[hl    */
	uint32_t queue;                     /** QUEUEtB[hl  */
	uint32_t cmd;                       /** CMDtB[hl    */
}PGPPrmParamPGPnLBLSTAT;

/** PGPnIFCCTRLWX^p[^ */
typedef struct _PGPPrmParamPGPnIFCCTRL {
	uint32_t scan;                      /** SCANtB[hl  */
	uint32_t limit;                     /** LIMITtB[hl */
	uint32_t src;                       /** SRCtB[hl   */
	uint32_t op;                        /** OPtB[hl    */
	uint32_t sft1;                      /** SFT1tB[hl  */
	uint32_t sft0;                      /** SFT0tB[hl  */
}PGPPrmParamPGPnIFCCTRL;

/** PGPVInCTRL0WX^p[^ */
typedef struct _PGPPrmParamPGPVInCTRL0 {
	uint32_t fai;                       /** FAItB[hl   */
	uint32_t bmu;                       /** BMUtB[hl   */
	uint32_t scan;                      /** SCANtB[hl  */
	uint32_t dim;                       /** DIMtB[hl   */
	uint32_t swapw;                     /** SWAPWtB[hl */
	uint32_t swaph;                     /** SWAPHtB[hl */
	uint32_t swap4;                     /** SWAP4tB[hl */
	uint32_t swap1;                     /** SWAP1tB[hl */
	uint32_t md;                        /** MDtB[hl    */
	uint32_t fmt;                       /** FMTtB[hl   */
}PGPPrmParamPGPVInCTRL0;

/** PGPVInVPRM0WX^p[^ */
typedef struct _PGPPrmParamPGPVInVPRM0 {
	uint32_t ebp;                       /** EBPtB[hl */
	uint32_t efp;                       /** EFPtB[hl */
	uint32_t obp;                       /** OBPtB[hl */
	uint32_t ofp;                       /** OFPtB[hl */
	uint32_t vpw;                       /** VPWtB[hl */
}PGPPrmParamPGPVInVPRM0;


void AG903_PgpPrmSetPGPnCMD(uint32_t id, uint32_t cmd);
void AG903_PgpPrmGetPGPnSTATE(uint32_t id, PGPPrmParamPGPnSTATE *state);
void AG903_PgpPrmSetPGPnINTCTRLI(uint32_t id, uint32_t field, uint32_t fcnt, uint32_t line);
void AG903_PgpPrmGetPGPnINTCTRLI(uint32_t id, uint32_t *field, uint32_t *fcnt, uint32_t *line);
void AG903_PgpPrmSetPGPnINTCTRLO(uint32_t id, uint32_t field, uint32_t fcnt, uint32_t line);
void AG903_PgpPrmGetPGPnINTCTRLO(uint32_t id, uint32_t *field, uint32_t *fcnt, uint32_t *line);
void AG903_PgpPrmSetPGPnINTEN(uint32_t id, PGPPrmParamPGPnINTEN *inten);
void AG903_PgpPrmGetPGPnINTEN(uint32_t id, PGPPrmParamPGPnINTEN *inten);
void AG903_PgpPrmGetPGPnINTSTAT(uint32_t id, PGPPrmParamPGPnINTSTAT *stat);
void AG903_PgpPrmSetPGPnINTCLR(uint32_t id, PGPPrmParamPGPnINTCLR *clr);
void AG903_PgpPrmSetPGPnTRGCTRLI(uint32_t id, uint32_t field, uint32_t fcnt, uint32_t line);
void AG903_PgpPrmGetPGPnTRGCTRLI(uint32_t id, uint32_t *field, uint32_t *fcnt, uint32_t *line);
void AG903_PgpPrmSetPGPnTRGCTRLO(uint32_t id, uint32_t field, uint32_t fcnt, uint32_t line);
void AG903_PgpPrmGetPGPnTRGCTRLO(uint32_t id, uint32_t *field, uint32_t *fcnt, uint32_t *line);
void AG903_PgpPrmSetPGPnTRGEN(uint32_t id, PGPPrmParamPGPnTRGEN *trgen);
void AG903_PgpPrmGetPGPnTRGEN(uint32_t id, PGPPrmParamPGPnTRGEN *trgen);
void AG903_PgpPrmSetPGPnINCTRL(uint32_t id, PGPPrmParamPGPnINCTRL *inctrl);
void AG903_PgpPrmGetPGPnINCTRL(uint32_t id, PGPPrmParamPGPnINCTRL *inctrl);
void AG903_PgpPrmSetPGPnFUNCCTRL(uint32_t id, PGPPrmParamPGPnFUNCCTRL *funcctrl);
void AG903_PgpPrmGetPGPnFUNCCTRL(uint32_t id, PGPPrmParamPGPnFUNCCTRL *funcctrl);
void AG903_PgpPrmSetPGPnSIZE(uint32_t id, uint32_t vsize, uint32_t hsize);
void AG903_PgpPrmGetPGPnSIZE(uint32_t id, uint32_t *vsize, uint32_t *hsize);
void AG903_PgpPrmSetPGPnPOS(uint32_t id, PGPPrmParamPGPnPOS *pos);
void AG903_PgpPrmGetPGPnPOS(uint32_t id, PGPPrmParamPGPnPOS *pos);
void AG903_PgpPrmSetPGPnOUTCTRL0(uint32_t id, PGPPrmParamPGPnOUTCTRL0 *outctrl0);
void AG903_PgpPrmGetPGPnOUTCTRL0(uint32_t id, PGPPrmParamPGPnOUTCTRL0 *outctrl0);
void AG903_PgpPrmSetPGPnOUTCTRL1(uint32_t id, uint32_t re, uint32_t ge, uint32_t be);
void AG903_PgpPrmGetPGPnOUTCTRL1(uint32_t id, uint32_t *re, uint32_t *ge, uint32_t *be);
void AG903_PgpPrmSetPGPnOUTBASE(uint32_t id, uint32_t adr);
void AG903_PgpPrmGetPGPnOUTBASE(uint32_t id, uint32_t *adr);
void AG903_PgpPrmSetPGPnOUTHSIZE(uint32_t id, uint32_t hsize);
void AG903_PgpPrmGetPGPnOUTHSIZE(uint32_t id, uint32_t *hsize);
void AG903_PgpPrmGetPGPnFAIVAL0(uint32_t id, uint32_t *tmstamp);
void AG903_PgpPrmGetPGPnFAIVAL1(uint32_t id, uint32_t *field, uint32_t *port, uint32_t *fnum);
void AG903_PgpPrmSetPGPnIPCPRM(uint32_t id, uint32_t limit, uint32_t blky, uint32_t blkc);
void AG903_PgpPrmGetPGPnIPCPRM(uint32_t id, uint32_t *limit, uint32_t *blky, uint32_t *blkc);
void AG903_PgpPrmSetPGPnCSC1CTRL(uint32_t id, uint32_t limit, uint32_t sft);
void AG903_PgpPrmGetPGPnCSC1CTRL(uint32_t id, uint32_t *limit, uint32_t *sft);
void AG903_PgpPrmSetPGPnCSC1PRM0(uint32_t id, uint32_t m12, uint32_t m11);
void AG903_PgpPrmGetPGPnCSC1PRM0(uint32_t id, uint32_t *m12, uint32_t *m11);
void AG903_PgpPrmSetPGPnCSC1PRM1(uint32_t id, uint32_t m13);
void AG903_PgpPrmGetPGPnCSC1PRM1(uint32_t id, uint32_t *m13);
void AG903_PgpPrmSetPGPnCSC1PRM2(uint32_t id, uint32_t m14);
void AG903_PgpPrmGetPGPnCSC1PRM2(uint32_t id, uint32_t *m14);
void AG903_PgpPrmSetPGPnCSC1PRM3(uint32_t id, uint32_t m22, uint32_t m21);
void AG903_PgpPrmGetPGPnCSC1PRM3(uint32_t id, uint32_t *m22, uint32_t *m21);
void AG903_PgpPrmSetPGPnCSC1PRM4(uint32_t id, uint32_t m23);
void AG903_PgpPrmGetPGPnCSC1PRM4(uint32_t id, uint32_t *m23);
void AG903_PgpPrmSetPGPnCSC1PRM5(uint32_t id, uint32_t m24);
void AG903_PgpPrmGetPGPnCSC1PRM5(uint32_t id, uint32_t *m24);
void AG903_PgpPrmSetPGPnCSC1PRM6(uint32_t id, uint32_t m32, uint32_t m31);
void AG903_PgpPrmGetPGPnCSC1PRM6(uint32_t id, uint32_t *m32, uint32_t *m31);
void AG903_PgpPrmSetPGPnCSC1PRM7(uint32_t id, uint32_t m33);
void AG903_PgpPrmGetPGPnCSC1PRM7(uint32_t id, uint32_t *m33);
void AG903_PgpPrmSetPGPnCSC1PRM8(uint32_t id, uint32_t m34);
void AG903_PgpPrmGetPGPnCSC1PRM8(uint32_t id, uint32_t *m34);
void AG903_PgpPrmSetPGPnSCCTRL(uint32_t id, PGPPrmParamPGPnSCCTRL *scctrl);
void AG903_PgpPrmGetPGPnSCCTRL(uint32_t id, PGPPrmParamPGPnSCCTRL *scctrl);
void AG903_PgpPrmSetPGPnSPFCTRL(uint32_t id, PGPPrmParamPGPnSPFCTRL *spfctrl);
void AG903_PgpPrmGetPGPnSPFCTRL(uint32_t id, PGPPrmParamPGPnSPFCTRL *spfctrl);
void AG903_PgpPrmSetPGPnSPFPRM0(uint32_t id, uint32_t h1m, uint32_t h0m, uint32_t hmm);
void AG903_PgpPrmGetPGPnSPFPRM0(uint32_t id, uint32_t *h1m, uint32_t *h0m, uint32_t *hmm);
void AG903_PgpPrmSetPGPnSPFPRM1(uint32_t id, uint32_t h10, uint32_t h00, uint32_t hm0);
void AG903_PgpPrmGetPGPnSPFPRM1(uint32_t id, uint32_t *h10, uint32_t *h00, uint32_t *hm0);
void AG903_PgpPrmSetPGPnSPFPRM2(uint32_t id, uint32_t h11, uint32_t h01, uint32_t hm1);
void AG903_PgpPrmGetPGPnSPFPRM2(uint32_t id, uint32_t *h11, uint32_t *h01, uint32_t *hm1);
void AG903_PgpPrmSetPGPnSPFPRM3(uint32_t id, uint32_t ofs);
void AG903_PgpPrmGetPGPnSPFPRM3(uint32_t id, uint32_t *ofs);
void AG903_PgpPrmSetPGPnHSV1CTRL(uint32_t id, uint32_t fmt);
void AG903_PgpPrmGetPGPnHSV1CTRL(uint32_t id, uint32_t *fmt);
void AG903_PgpPrmGetPGPnDGCSTAT(uint32_t id, uint32_t *queue);
void AG903_PgpPrmSetPGPnHGMCMD(uint32_t id, uint32_t cmd);
void AG903_PgpPrmSetPGPnHGMCTRL(uint32_t id, PGPPrmParamPGPnHGMCTRL *hgmctrl);
void AG903_PgpPrmGetPGPnHGMCTRL(uint32_t id, PGPPrmParamPGPnHGMCTRL *hgmctrl);
void AG903_PgpPrmSetPGPnHGMSIZE(uint32_t id, uint32_t vsize, uint32_t hsize);
void AG903_PgpPrmGetPGPnHGMSIZE(uint32_t id, uint32_t *vsize, uint32_t *hsize);
void AG903_PgpPrmSetPGPnHGMPOS(uint32_t id, uint32_t vpos, uint32_t hpos);
void AG903_PgpPrmGetPGPnHGMPOS(uint32_t id, uint32_t *vpos, uint32_t *hpos);
void AG903_PgpPrmSetPGPnHGMDST(uint32_t id, uint32_t adr);
void AG903_PgpPrmGetPGPnHGMDST(uint32_t id, uint32_t *adr);
void AG903_PgpPrmGetPGPnHGMMOD0(uint32_t id, uint32_t *bw, uint32_t *val, uint32_t *cnt);
void AG903_PgpPrmGetPGPnHGMRNG0(uint32_t id, uint32_t *maxval, uint32_t *minval);
void AG903_PgpPrmGetPGPnHGMMOD1(uint32_t id, uint32_t *bw, uint32_t *val, uint32_t *cnt);
void AG903_PgpPrmGetPGPnHGMRNG1(uint32_t id, uint32_t *maxval, uint32_t *minval);
void AG903_PgpPrmGetPGPnHGMMOD2(uint32_t id, uint32_t *bw, uint32_t *val, uint32_t *cnt);
void AG903_PgpPrmGetPGPnHGMRNG2(uint32_t id, uint32_t *maxval, uint32_t *minval);
void AG903_PgpPrmGetPGPnHGMSTAT(uint32_t id, PGPPrmParamPGPnHGMSTAT *stat);
void AG903_PgpPrmSetPGPnTHRCTRL(uint32_t id, PGPPrmParamPGPnTHRCTRL *thrctrl);
void AG903_PgpPrmGetPGPnTHRCTRL(uint32_t id, PGPPrmParamPGPnTHRCTRL *thrctrl);
void AG903_PgpPrmSetPGPnHSV2CTRL(uint32_t id, uint32_t fmt);
void AG903_PgpPrmGetPGPnHSV2CTRL(uint32_t id, uint32_t *fmt);
void AG903_PgpPrmSetPGPnCSC2CTRL(uint32_t id, uint32_t limit, uint32_t sft);
void AG903_PgpPrmGetPGPnCSC2CTRL(uint32_t id, uint32_t *limit, uint32_t *sft);
void AG903_PgpPrmSetPGPnCSC2PRM0(uint32_t id, uint32_t m12, uint32_t m11);
void AG903_PgpPrmGetPGPnCSC2PRM0(uint32_t id, uint32_t *m12, uint32_t *m11);
void AG903_PgpPrmSetPGPnCSC2PRM1(uint32_t id, uint32_t m13);
void AG903_PgpPrmGetPGPnCSC2PRM1(uint32_t id, uint32_t *m13);
void AG903_PgpPrmSetPGPnCSC2PRM2(uint32_t id, uint32_t m14);
void AG903_PgpPrmGetPGPnCSC2PRM2(uint32_t id, uint32_t *m14);
void AG903_PgpPrmSetPGPnCSC2PRM3(uint32_t id, uint32_t m22, uint32_t m21);
void AG903_PgpPrmGetPGPnCSC2PRM3(uint32_t id, uint32_t *m22, uint32_t *m21);
void AG903_PgpPrmSetPGPnCSC2PRM4(uint32_t id, uint32_t m23);
void AG903_PgpPrmGetPGPnCSC2PRM4(uint32_t id, uint32_t *m23);
void AG903_PgpPrmSetPGPnCSC2PRM5(uint32_t id, uint32_t m24);
void AG903_PgpPrmGetPGPnCSC2PRM5(uint32_t id, uint32_t *m24);
void AG903_PgpPrmSetPGPnCSC2PRM6(uint32_t id, uint32_t m32, uint32_t m31);
void AG903_PgpPrmGetPGPnCSC2PRM6(uint32_t id, uint32_t *m32, uint32_t *m31);
void AG903_PgpPrmSetPGPnCSC2PRM7(uint32_t id, uint32_t m33);
void AG903_PgpPrmGetPGPnCSC2PRM7(uint32_t id, uint32_t *m33);
void AG903_PgpPrmSetPGPnCSC2PRM8(uint32_t id, uint32_t m34);
void AG903_PgpPrmGetPGPnCSC2PRM8(uint32_t id, uint32_t *m34);
void AG903_PgpPrmSetPGPnMSK0PRM0(uint32_t id, uint32_t h, uint32_t l, uint32_t x);
void AG903_PgpPrmGetPGPnMSK0PRM0(uint32_t id, uint32_t *h, uint32_t *l, uint32_t *x);
void AG903_PgpPrmSetPGPnMSK0PRM1(uint32_t id, PGPPrmParamPGPnMSK0PRM1 *msk0prm1);
void AG903_PgpPrmGetPGPnMSK0PRM1(uint32_t id, PGPPrmParamPGPnMSK0PRM1 *msk0prm1);
void AG903_PgpPrmSetPGPnMSK1PRM0(uint32_t id, uint32_t h, uint32_t l, uint32_t x);
void AG903_PgpPrmGetPGPnMSK1PRM0(uint32_t id, uint32_t *h, uint32_t *l, uint32_t *x);
void AG903_PgpPrmSetPGPnMSK1PRM1(uint32_t id, PGPPrmParamPGPnMSK1PRM1 *msk1prm1);
void AG903_PgpPrmGetPGPnMSK1PRM1(uint32_t id, PGPPrmParamPGPnMSK1PRM1 *msk1prm1);
void AG903_PgpPrmSetPGPnMSK2PRM0(uint32_t id, uint32_t h, uint32_t l, uint32_t x);
void AG903_PgpPrmGetPGPnMSK2PRM0(uint32_t id, uint32_t *h, uint32_t *l, uint32_t *x);
void AG903_PgpPrmSetPGPnMSK2PRM1(uint32_t id, PGPPrmParamPGPnMSK2PRM1 *msk2prm1);
void AG903_PgpPrmGetPGPnMSK2PRM1(uint32_t id, PGPPrmParamPGPnMSK2PRM1 *msk2prm1);
void AG903_PgpPrmSetPGPnTHR8PRM0(uint32_t id, PGPPrmParamPGPnTHR8PRM0 *thr8prm0);
void AG903_PgpPrmGetPGPnTHR8PRM0(uint32_t id, PGPPrmParamPGPnTHR8PRM0 *thr8prm0);
void AG903_PgpPrmSetPGPnTHR8PRM1(uint32_t id, PGPPrmParamPGPnTHR8PRM1 *thr8prm1);
void AG903_PgpPrmGetPGPnTHR8PRM1(uint32_t id, PGPPrmParamPGPnTHR8PRM1 *thr8prm1);
void AG903_PgpPrmSetPGPnTHR8PRM2(uint32_t id, PGPPrmParamPGPnTHR8PRM2 *thr8prm2);
void AG903_PgpPrmGetPGPnTHR8PRM2(uint32_t id, PGPPrmParamPGPnTHR8PRM2 *thr8prm2);
void AG903_PgpPrmSetPGPnTHR1PRM0(uint32_t id, uint32_t h, uint32_t l, uint32_t x);
void AG903_PgpPrmGetPGPnTHR1PRM0(uint32_t id, uint32_t *h, uint32_t *l, uint32_t *x);
void AG903_PgpPrmSetPGPnTHR1PRM1(uint32_t id, PGPPrmParamPGPnTHR1PRM1 *thr1prm);
void AG903_PgpPrmGetPGPnTHR1PRM1(uint32_t id, PGPPrmParamPGPnTHR1PRM1 *thr1prm);
void AG903_PgpPrmSetPGPnSPF1PRM0(uint32_t id, PGPPrmParamPGPnSPF1PRM0 *spf1prm0);
void AG903_PgpPrmGetPGPnSPF1PRM0(uint32_t id, PGPPrmParamPGPnSPF1PRM0 *spf1prm0);
void AG903_PgpPrmSetPGPnSPF1PRM1(uint32_t id, PGPPrmParamPGPnSPF1PRM1 *spf1prm1);
void AG903_PgpPrmGetPGPnSPF1PRM1(uint32_t id, PGPPrmParamPGPnSPF1PRM1 *spf1prm1);
void AG903_PgpPrmGetPGPnTHR1CNT(uint32_t id, uint32_t *cnt);
void AG903_PgpPrmSetPGPnLBLCMD(uint32_t id, uint32_t cmd);
void AG903_PgpPrmSetPGPnLBLCTRL(uint32_t id, PGPPrmParamPGPnLBLCTRL *lblctrl);
void AG903_PgpPrmGetPGPnLBLCTRL(uint32_t id, PGPPrmParamPGPnLBLCTRL *lblctrl);
void AG903_PgpPrmSetPGPnLBLSIZE(uint32_t id, uint32_t vsize, uint32_t hsize);
void AG903_PgpPrmGetPGPnLBLSIZE(uint32_t id, uint32_t *vsize, uint32_t *hsize);
void AG903_PgpPrmSetPGPnLBLPOS(uint32_t id, uint32_t vpos, uint32_t hpos);
void AG903_PgpPrmGetPGPnLBLPOS(uint32_t id, uint32_t *vpos, uint32_t *hpos);
void AG903_PgpPrmSetPGPnLBLDST(uint32_t id, uint32_t adr);
void AG903_PgpPrmGetPGPnLBLDST(uint32_t id, uint32_t *adr);
void AG903_PgpPrmGetPGPnLBLSTAT(uint32_t id, PGPPrmParamPGPnLBLSTAT *lblstat);
void AG903_PgpPrmSetPGPnIFCCMD(uint32_t id, uint32_t cmd);
void AG903_PgpPrmSetPGPnIFCCTRL(uint32_t id, PGPPrmParamPGPnIFCCTRL *ifcctrl);
void AG903_PgpPrmGetPGPnIFCCTRL(uint32_t id, PGPPrmParamPGPnIFCCTRL *ifcctrl);
void AG903_PgpPrmSetPGPnIFCPRM(uint32_t id, uint32_t gain1, uint32_t gain0);
void AG903_PgpPrmGetPGPnIFCPRM(uint32_t id, uint32_t *gain1, uint32_t *gain0);
void AG903_PgpPrmSetPGPVInCMD(uint32_t id, uint32_t cmd);
void AG903_PgpPrmGetPGPVInSTATE(uint32_t id, uint32_t *vrmacc, uint32_t *queue, uint32_t *st);
void AG903_PgpPrmSetPGPVInCTRL0(uint32_t id, PGPPrmParamPGPVInCTRL0 *ctrl0);
void AG903_PgpPrmGetPGPVInCTRL0(uint32_t id, PGPPrmParamPGPVInCTRL0 *ctrl0);
void AG903_PgpPrmSetPGPVInCTRL1(uint32_t id, uint32_t div, uint32_t vld, uint32_t inv);
void AG903_PgpPrmGetPGPVInCTRL1(uint32_t id, uint32_t *div, uint32_t *vld, uint32_t *inv);
void AG903_PgpPrmSetPGPVInBASE(uint32_t id, uint32_t adr);
void AG903_PgpPrmGetPGPVInBASE(uint32_t id, uint32_t *adr);
void AG903_PgpPrmSetPGPVInHSIZE(uint32_t id, uint32_t hsize);
void AG903_PgpPrmGetPGPVInHSIZE(uint32_t id, uint32_t *hsize);
void AG903_PgpPrmSetPGPVInHPRM0(uint32_t id, uint32_t hpw);
void AG903_PgpPrmGetPGPVInHPRM0(uint32_t id, uint32_t *hpw);
void AG903_PgpPrmSetPGPVInHPRM1(uint32_t id, uint32_t hfp, uint32_t hbp);
void AG903_PgpPrmGetPGPVInHPRM1(uint32_t id, uint32_t *hfp, uint32_t *hbp);
void AG903_PgpPrmSetPGPVInVPRM0(uint32_t id, PGPPrmParamPGPVInVPRM0 *vprm0);
void AG903_PgpPrmGetPGPVInVPRM0(uint32_t id, PGPPrmParamPGPVInVPRM0 *vprm0);
void AG903_PgpPrmSetPGPVInVPRM1(uint32_t id, uint32_t vfp, uint32_t vbp);
void AG903_PgpPrmGetPGPVInVPRM1(uint32_t id, uint32_t *vfp, uint32_t *vbp);
void AG903_PgpPrmSetPGPVInSIZE(uint32_t id, uint32_t ovsize, uint32_t vsize, uint32_t hsize);
void AG903_PgpPrmGetPGPVInSIZE(uint32_t id, uint32_t *ovsize, uint32_t *vsize, uint32_t *hsize);
void AG903_PgpPrmSetPGPJPGOUTSEL(uint32_t en, uint32_t sel);
void AG903_PgpPrmGetPGPJPGOUTSEL(uint32_t *en, uint32_t *sel);
void AG903_PgpPrmSetPGPnDGCLUTB(uint32_t id, uint8_t blue[256]);
void AG903_PgpPrmGetPGPnDGCLUTB(uint32_t id, uint8_t *blue);
void AG903_PgpPrmSetPGPnDGCFLUTB(uint32_t id, uint8_t blue[256]);
void AG903_PgpPrmSetPGPnDGCLUTG(uint32_t id, uint8_t green[256]);
void AG903_PgpPrmGetPGPnDGCLUTG(uint32_t id, uint8_t *green);
void AG903_PgpPrmSetPGPnDGCFLUTG(uint32_t id, uint8_t green[256]);
void AG903_PgpPrmSetPGPnDGCLUTR(uint32_t id, uint8_t red[256]);
void AG903_PgpPrmGetPGPnDGCLUTR(uint32_t id, uint8_t *red);
void AG903_PgpPrmSetPGPnDGCFLUTR(uint32_t id, uint8_t red[256]);


#ifdef __cplusplus
}
#endif

#endif
