/**
 * @brief           BSC Register Definition
 * @author          AXELL CORPORATION
 * @description     BSC Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_BSC_REGMAP_H_
#define _AG903_BSC_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** BSC Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __I  uint32_t  PBSTAT;

        struct {
            __I  uint32_t  MDSRM32                        :  1;
            __I  uint32_t  MDDV                           :  1;
            __I  uint32_t  BSGRT                          :  1;
            __I  uint32_t  BSRQ                           :  1;
            __I  uint32_t  PCC                            :  1;
            __I  uint32_t  IDE                            :  1;
        } PBSTAT_bits;
    };

    union {
        __IO uint32_t  PBINTMASK;

        struct {
            __IO uint32_t  INT0                           :  1;
            __IO uint32_t  INT1                           :  1;
            __IO uint32_t  INT2                           :  1;
            __IO uint32_t  INT3                           :  1;
        } PBINTMASK_bits;
    };

    union {
        __IO uint32_t  PBINTMODE;

        struct {
            __IO uint32_t  INT0                           :  1;
            __IO uint32_t  INT1                           :  1;
            __IO uint32_t  INT2                           :  1;
            __IO uint32_t  INT3                           :  1;
        } PBINTMODE_bits;
    };

    union {
        __IO uint32_t  PBINTPOL;

        struct {
            __IO uint32_t  INT0                           :  1;
            __IO uint32_t  INT1                           :  1;
            __IO uint32_t  INT2                           :  1;
            __IO uint32_t  INT3                           :  1;
        } PBINTPOL_bits;
    };

    union {
        __O  uint32_t  PBINTCLR;

        struct {
            __O  uint32_t  INT0                           :  1;
            __O  uint32_t  INT1                           :  1;
            __O  uint32_t  INT2                           :  1;
            __O  uint32_t  INT3                           :  1;
        } PBINTCLR_bits;
    };

    __I  uint32_t  RESERVED1[4];

    union {
        __IO uint32_t  CFMODE;

        struct {
            __IO uint32_t  MDCF                           :  2;
        } CFMODE_bits;
    };

    __I  uint32_t  RESERVED2[2];

    union {
        __IO uint32_t  PBDMAPOL;

        struct {
            __IO uint32_t  DCK                            :  1;
            __IO uint32_t  DRQ                            :  1;
        } PBDMAPOL_bits;
    };

    union {
        __IO uint32_t  CFPMCMD;

        struct {
            __IO uint32_t  CMD                            :  3;
                 uint32_t                                 :  5;
            __IO uint32_t  ACT                            :  1;
            __IO uint32_t  SLP                            :  1;
        } CFPMCMD_bits;
    };

    __I  uint32_t  RESERVED3[1];

    union {
        __I  uint32_t  CFPMSTAT;

        struct {
            __I  uint32_t  STAT                           :  3;
                 uint32_t                                 :  5;
            __I  uint32_t  CD                             :  1;
        } CFPMSTAT_bits;
    };

    union {
        __IO uint32_t  CFPMTON;
    };

    union {
        __IO uint32_t  CFPMTR0;
    };

    union {
        __IO uint32_t  CFPMTR1;
    };

    union {
        __IO uint32_t  CFPMTR2;
    };

    union {
        __IO uint32_t  CFPMTPR;
    };

/* DOM-IGNORE-END */
}AG903_BSC_Type;

#define AG903_BSC                                ((volatile AG903_BSC_Type *) AG903_BSC_BASE)                            /** BSC Base Address */


#define AG903_BSC_PBSTAT_MDSRM32_POS                       0                                                             /** BSCPBSTAT MDSRM32-bit position */
#define AG903_BSC_PBSTAT_MDSRM32_MSK                       (0x1UL << AG903_BSC_PBSTAT_MDSRM32_POS)                       /** BSCPBSTAT MDSRM32-bit mask */
#define AG903_BSC_PBSTAT_MDDV_POS                          1                                                             /** BSCPBSTAT MDDV-bit position */
#define AG903_BSC_PBSTAT_MDDV_MSK                          (0x1UL << AG903_BSC_PBSTAT_MDDV_POS)                          /** BSCPBSTAT MDDV-bit mask */
#define AG903_BSC_PBSTAT_BSGRT_POS                         2                                                             /** BSCPBSTAT BSGRT-bit position */
#define AG903_BSC_PBSTAT_BSGRT_MSK                         (0x1UL << AG903_BSC_PBSTAT_BSGRT_POS)                         /** BSCPBSTAT BSGRT-bit mask */
#define AG903_BSC_PBSTAT_BSRQ_POS                          3                                                             /** BSCPBSTAT BSRQ-bit position */
#define AG903_BSC_PBSTAT_BSRQ_MSK                          (0x1UL << AG903_BSC_PBSTAT_BSRQ_POS)                          /** BSCPBSTAT BSRQ-bit mask */
#define AG903_BSC_PBSTAT_PCC_POS                           4                                                             /** BSCPBSTAT PCC-bit position */
#define AG903_BSC_PBSTAT_PCC_MSK                           (0x1UL << AG903_BSC_PBSTAT_PCC_POS)                           /** BSCPBSTAT PCC-bit mask */
#define AG903_BSC_PBSTAT_IDE_POS                           5                                                             /** BSCPBSTAT IDE-bit position */
#define AG903_BSC_PBSTAT_IDE_MSK                           (0x1UL << AG903_BSC_PBSTAT_IDE_POS)                           /** BSCPBSTAT IDE-bit mask */

#define AG903_BSC_PBINTMASK_INT0_POS                       0                                                             /** BSCPBINTMASK INT0-bit position */
#define AG903_BSC_PBINTMASK_INT0_MSK                       (0x1UL << AG903_BSC_PBINTMASK_INT0_POS)                       /** BSCPBINTMASK INT0-bit mask */
#define AG903_BSC_PBINTMASK_INT1_POS                       1                                                             /** BSCPBINTMASK INT1-bit position */
#define AG903_BSC_PBINTMASK_INT1_MSK                       (0x1UL << AG903_BSC_PBINTMASK_INT1_POS)                       /** BSCPBINTMASK INT1-bit mask */
#define AG903_BSC_PBINTMASK_INT2_POS                       2                                                             /** BSCPBINTMASK INT2-bit position */
#define AG903_BSC_PBINTMASK_INT2_MSK                       (0x1UL << AG903_BSC_PBINTMASK_INT2_POS)                       /** BSCPBINTMASK INT2-bit mask */
#define AG903_BSC_PBINTMASK_INT3_POS                       3                                                             /** BSCPBINTMASK INT3-bit position */
#define AG903_BSC_PBINTMASK_INT3_MSK                       (0x1UL << AG903_BSC_PBINTMASK_INT3_POS)                       /** BSCPBINTMASK INT3-bit mask */

#define AG903_BSC_PBINTMODE_INT0_POS                       0                                                             /** BSCPBINTMODE INT0-bit position */
#define AG903_BSC_PBINTMODE_INT0_MSK                       (0x1UL << AG903_BSC_PBINTMODE_INT0_POS)                       /** BSCPBINTMODE INT0-bit mask */
#define AG903_BSC_PBINTMODE_INT1_POS                       1                                                             /** BSCPBINTMODE INT1-bit position */
#define AG903_BSC_PBINTMODE_INT1_MSK                       (0x1UL << AG903_BSC_PBINTMODE_INT1_POS)                       /** BSCPBINTMODE INT1-bit mask */
#define AG903_BSC_PBINTMODE_INT2_POS                       2                                                             /** BSCPBINTMODE INT2-bit position */
#define AG903_BSC_PBINTMODE_INT2_MSK                       (0x1UL << AG903_BSC_PBINTMODE_INT2_POS)                       /** BSCPBINTMODE INT2-bit mask */
#define AG903_BSC_PBINTMODE_INT3_POS                       3                                                             /** BSCPBINTMODE INT3-bit position */
#define AG903_BSC_PBINTMODE_INT3_MSK                       (0x1UL << AG903_BSC_PBINTMODE_INT3_POS)                       /** BSCPBINTMODE INT3-bit mask */

#define AG903_BSC_PBINTPOL_INT0_POS                        0                                                             /** BSCPBINTPOL INT0-bit position */
#define AG903_BSC_PBINTPOL_INT0_MSK                        (0x1UL << AG903_BSC_PBINTPOL_INT0_POS)                        /** BSCPBINTPOL INT0-bit mask */
#define AG903_BSC_PBINTPOL_INT1_POS                        1                                                             /** BSCPBINTPOL INT1-bit position */
#define AG903_BSC_PBINTPOL_INT1_MSK                        (0x1UL << AG903_BSC_PBINTPOL_INT1_POS)                        /** BSCPBINTPOL INT1-bit mask */
#define AG903_BSC_PBINTPOL_INT2_POS                        2                                                             /** BSCPBINTPOL INT2-bit position */
#define AG903_BSC_PBINTPOL_INT2_MSK                        (0x1UL << AG903_BSC_PBINTPOL_INT2_POS)                        /** BSCPBINTPOL INT2-bit mask */
#define AG903_BSC_PBINTPOL_INT3_POS                        3                                                             /** BSCPBINTPOL INT3-bit position */
#define AG903_BSC_PBINTPOL_INT3_MSK                        (0x1UL << AG903_BSC_PBINTPOL_INT3_POS)                        /** BSCPBINTPOL INT3-bit mask */

#define AG903_BSC_PBINTCLR_INT0_POS                        0                                                             /** BSCPBINTCLR INT0-bit position */
#define AG903_BSC_PBINTCLR_INT0_MSK                        (0x1UL << AG903_BSC_PBINTCLR_INT0_POS)                        /** BSCPBINTCLR INT0-bit mask */
#define AG903_BSC_PBINTCLR_INT1_POS                        1                                                             /** BSCPBINTCLR INT1-bit position */
#define AG903_BSC_PBINTCLR_INT1_MSK                        (0x1UL << AG903_BSC_PBINTCLR_INT1_POS)                        /** BSCPBINTCLR INT1-bit mask */
#define AG903_BSC_PBINTCLR_INT2_POS                        2                                                             /** BSCPBINTCLR INT2-bit position */
#define AG903_BSC_PBINTCLR_INT2_MSK                        (0x1UL << AG903_BSC_PBINTCLR_INT2_POS)                        /** BSCPBINTCLR INT2-bit mask */
#define AG903_BSC_PBINTCLR_INT3_POS                        3                                                             /** BSCPBINTCLR INT3-bit position */
#define AG903_BSC_PBINTCLR_INT3_MSK                        (0x1UL << AG903_BSC_PBINTCLR_INT3_POS)                        /** BSCPBINTCLR INT3-bit mask */

#define AG903_BSC_CFMODE_MDCF_POS                          0                                                             /** BSCCFMODE MDCF-bit position */
#define AG903_BSC_CFMODE_MDCF_MSK                          (0x3UL << AG903_BSC_CFMODE_MDCF_POS)                          /** BSCCFMODE MDCF-bit mask */

#define AG903_BSC_PBDMAPOL_DCK_POS                         0                                                             /** BSCPBDMAPOL DCK-bit position */
#define AG903_BSC_PBDMAPOL_DCK_MSK                         (0x1UL << AG903_BSC_PBDMAPOL_DCK_POS)                         /** BSCPBDMAPOL DCK-bit mask */
#define AG903_BSC_PBDMAPOL_DRQ_POS                         1                                                             /** BSCPBDMAPOL DRQ-bit position */
#define AG903_BSC_PBDMAPOL_DRQ_MSK                         (0x1UL << AG903_BSC_PBDMAPOL_DRQ_POS)                         /** BSCPBDMAPOL DRQ-bit mask */

#define AG903_BSC_CFPMCMD_CMD_POS                          0                                                             /** BSCCFPMCMD CMD-bit position */
#define AG903_BSC_CFPMCMD_CMD_MSK                          (0x7UL << AG903_BSC_CFPMCMD_CMD_POS)                          /** BSCCFPMCMD CMD-bit mask */
#define AG903_BSC_CFPMCMD_ACT_POS                          8                                                             /** BSCCFPMCMD ACT-bit position */
#define AG903_BSC_CFPMCMD_ACT_MSK                          (0x1UL << AG903_BSC_CFPMCMD_ACT_POS)                          /** BSCCFPMCMD ACT-bit mask */
#define AG903_BSC_CFPMCMD_SLP_POS                          9                                                             /** BSCCFPMCMD SLP-bit position */
#define AG903_BSC_CFPMCMD_SLP_MSK                          (0x1UL << AG903_BSC_CFPMCMD_SLP_POS)                          /** BSCCFPMCMD SLP-bit mask */

#define AG903_BSC_CFPMSTAT_STAT_POS                        0                                                             /** BSCCFPMSTAT STAT-bit position */
#define AG903_BSC_CFPMSTAT_STAT_MSK                        (0x7UL << AG903_BSC_CFPMSTAT_STAT_POS)                        /** BSCCFPMSTAT STAT-bit mask */
#define AG903_BSC_CFPMSTAT_CD_POS                          8                                                             /** BSCCFPMSTAT CD-bit position */
#define AG903_BSC_CFPMSTAT_CD_MSK                          (0x1UL << AG903_BSC_CFPMSTAT_CD_POS)                          /** BSCCFPMSTAT CD-bit mask */

#define AG903_BSC_CFPMTON_CYCLE_POS                        0                                                             /** BSCCFPMTON CYCLE-bit position */
#define AG903_BSC_CFPMTON_CYCLE_MSK                        (0xffffffffUL << AG903_BSC_CFPMTON_CYCLE_POS)                 /** BSCCFPMTON CYCLE-bit mask */

#define AG903_BSC_CFPMTR0_CYCLE_POS                        0                                                             /** BSCCFPMTR0 CYCLE-bit position */
#define AG903_BSC_CFPMTR0_CYCLE_MSK                        (0xffffffffUL << AG903_BSC_CFPMTR0_CYCLE_POS)                 /** BSCCFPMTR0 CYCLE-bit mask */

#define AG903_BSC_CFPMTR1_CYCLE_POS                        0                                                             /** BSCCFPMTR1 CYCLE-bit position */
#define AG903_BSC_CFPMTR1_CYCLE_MSK                        (0xffffffffUL << AG903_BSC_CFPMTR1_CYCLE_POS)                 /** BSCCFPMTR1 CYCLE-bit mask */

#define AG903_BSC_CFPMTR2_CYCLE_POS                        0                                                             /** BSCCFPMTR2 CYCLE-bit position */
#define AG903_BSC_CFPMTR2_CYCLE_MSK                        (0xffffffffUL << AG903_BSC_CFPMTR2_CYCLE_POS)                 /** BSCCFPMTR2 CYCLE-bit mask */

#define AG903_BSC_CFPMTPR_CYCLE_POS                        0                                                             /** BSCCFPMTPR CYCLE-bit position */
#define AG903_BSC_CFPMTPR_CYCLE_MSK                        (0xffffffffUL << AG903_BSC_CFPMTPR_CYCLE_POS)                 /** BSCCFPMTPR CYCLE-bit mask */

#endif /* _AG903_BSC_REGMAP_H_ */

