/**
 * @brief           DSP Register Definition
 * @author          AXELL CORPORATION
 * @description     DSP Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_DSP_REGMAP_H_
#define _AG903_DSP_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** DSPn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  CTRL;

        struct {
            __IO uint32_t  DON                            :  1;
        } CTRL_bits;
    };

    union {
        __IO uint32_t  MOD;

        struct {
            __IO uint32_t  DE                             :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  IP                             :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  UPD                            :  2;
            __IO uint32_t  BMR                            :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  LUT                            :  1;
            __IO uint32_t  DITH                           :  1;
        } MOD_bits;
    };

    union {
        __IO uint32_t  SYNC;

        struct {
            __IO uint32_t  SEL                            :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  DLY                            :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  IP                             :  1;
            __IO uint32_t  VP                             :  1;
            __IO uint32_t  FP                             :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  MSK                            :  1;
        } SYNC_bits;
    };

    union {
        __IO uint32_t  BGCOL;

        struct {
            __IO uint32_t  B                              :  8;
            __IO uint32_t  G                              :  8;
            __IO uint32_t  R                              :  8;
            __IO uint32_t  A                              :  8;
        } BGCOL_bits;
    };

    union {
        __IO uint32_t  WINNUM;

        struct {
            __IO uint32_t  CONF                           :  5;
                 uint32_t                                 : 11;
            __IO uint32_t  ACT                            :  5;
        } WINNUM_bits;
    };

    union {
        __IO uint32_t  WATNUM;

        struct {
            __IO uint32_t  NUM                            :  8;
        } WATNUM_bits;
    };

    union {
        __IO uint32_t  WATBASE;

        struct {
                 uint32_t                                 :  3;
            __IO uint32_t  ADDR                           : 29;
        } WATBASE_bits;
    };

    union {
        __IO uint32_t  LSTCTRL;

        struct {
            __IO uint32_t  WAT                            :  1;
                 uint32_t                                 : 15;
            __IO uint32_t  PAL                            :  1;
        } LSTCTRL_bits;
    };

    union {
        __IO uint32_t  HRZPRM0;

        struct {
            __IO uint32_t  HPW                            : 11;
        } HRZPRM0_bits;
    };

    union {
        __IO uint32_t  HRZPRM1;

        struct {
            __IO uint32_t  HBP                            : 11;
                 uint32_t                                 :  5;
            __IO uint32_t  HFP                            : 11;
        } HRZPRM1_bits;
    };

    union {
        __IO uint32_t  VTPRM0;

        struct {
            __IO uint32_t  VPW                            : 11;
                 uint32_t                                 :  5;
            __IO uint32_t  OFP                            :  1;
            __IO uint32_t  OBP                            :  1;
            __IO uint32_t  EFP                            :  1;
            __IO uint32_t  EBP                            :  1;
        } VTPRM0_bits;
    };

    union {
        __IO uint32_t  VTPRM1;

        struct {
            __IO uint32_t  VBP                            : 11;
                 uint32_t                                 :  5;
            __IO uint32_t  VFP                            : 11;
        } VTPRM1_bits;
    };

    union {
        __IO uint32_t  FRMSIZE;

        struct {
            __IO uint32_t  HFS                            : 11;
                 uint32_t                                 :  5;
            __IO uint32_t  VFS                            : 11;
        } FRMSIZE_bits;
    };

    __I  uint32_t  RESERVED1[1];

    union {
        __IO uint32_t  CDCTRL;

        struct {
            __IO uint32_t  BE                             :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  GE                             :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  RE                             :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  AE                             :  1;
        } CDCTRL_bits;
    };

    union {
        __IO uint32_t  COLDET;

        struct {
            __IO uint32_t  B                              :  8;
            __IO uint32_t  G                              :  8;
            __IO uint32_t  R                              :  8;
            __IO uint32_t  A                              :  8;
        } COLDET_bits;
    };

    union {
        __IO uint32_t  DITHAREA0A;

        struct {
            __IO uint32_t  X0                             : 11;
                 uint32_t                                 :  5;
            __IO uint32_t  Y0                             : 11;
        } DITHAREA0A_bits;
    };

    union {
        __IO uint32_t  DITHAREA0B;

        struct {
            __IO uint32_t  X1                             : 11;
                 uint32_t                                 :  5;
            __IO uint32_t  Y1                             : 11;
        } DITHAREA0B_bits;
    };

    union {
        __IO uint32_t  DITHAREA1A;

        struct {
            __IO uint32_t  X0                             : 11;
                 uint32_t                                 :  5;
            __IO uint32_t  Y0                             : 11;
        } DITHAREA1A_bits;
    };

    union {
        __IO uint32_t  DITHAREA1B;

        struct {
            __IO uint32_t  X1                             : 11;
                 uint32_t                                 :  5;
            __IO uint32_t  Y1                             : 11;
        } DITHAREA1B_bits;
    };

    union {
        __IO uint32_t  DITHAREA2A;

        struct {
            __IO uint32_t  X0                             : 11;
                 uint32_t                                 :  5;
            __IO uint32_t  Y0                             : 11;
        } DITHAREA2A_bits;
    };

    union {
        __IO uint32_t  DITHAREA2B;

        struct {
            __IO uint32_t  X1                             : 11;
                 uint32_t                                 :  5;
            __IO uint32_t  Y1                             : 11;
        } DITHAREA2B_bits;
    };

    union {
        __IO uint32_t  DITHAREA3A;

        struct {
            __IO uint32_t  X0                             : 11;
                 uint32_t                                 :  5;
            __IO uint32_t  Y0                             : 11;
        } DITHAREA3A_bits;
    };

    union {
        __IO uint32_t  DITHAREA3B;

        struct {
            __IO uint32_t  X1                             : 11;
                 uint32_t                                 :  5;
            __IO uint32_t  Y1                             : 11;
        } DITHAREA3B_bits;
    };

    union {
        __I  uint32_t  ERRSTAT;

        struct {
            __I  uint32_t  LINE                           : 11;
                 uint32_t                                 :  5;
            __I  uint32_t  UE                             :  1;
                 uint32_t                                 :  7;
            __I  uint32_t  LE                             :  1;
            __I  uint32_t  PE                             :  1;
        } ERRSTAT_bits;
    };

    union {
        __O  uint32_t  ERRCLR;

        struct {
            __O  uint32_t  LINE                           :  1;
                 uint32_t                                 : 15;
            __O  uint32_t  UE                             :  1;
                 uint32_t                                 :  7;
            __O  uint32_t  LE                             :  1;
            __O  uint32_t  PE                             :  1;
        } ERRCLR_bits;
    };

    union {
        __IO uint32_t  INT;

        struct {
            __IO uint32_t  LINE                           : 11;
                 uint32_t                                 :  5;
            __IO uint32_t  FCNT                           :  4;
                 uint32_t                                 :  4;
            __IO uint32_t  HLINE                          :  1;
            __IO uint32_t  VBLK                           :  1;
        } INT_bits;
    };

    union {
        __IO uint32_t  TRIGGER;

        struct {
            __IO uint32_t  OUT                            :  1;
                 uint32_t                                 : 15;
            __IO uint32_t  HRZ                            :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  VT                             :  2;
        } TRIGGER_bits;
    };

    union {
        __I  uint32_t  INTSTAT;

        struct {
            __I  uint32_t  VBLK                           :  1;
                 uint32_t                                 :  7;
            __I  uint32_t  HLINE                          :  1;
                 uint32_t                                 :  7;
            __I  uint32_t  DOFF                           :  1;
                 uint32_t                                 :  7;
            __I  uint32_t  DREQ                           :  1;
        } INTSTAT_bits;
    };

    union {
        __O  uint32_t  INTCLR;

        struct {
            __O  uint32_t  VBLK                           :  1;
                 uint32_t                                 :  7;
            __O  uint32_t  HLINE                          :  1;
                 uint32_t                                 :  7;
            __O  uint32_t  DOFF                           :  1;
        } INTCLR_bits;
    };

    union {
        __IO uint32_t  INTMASK;

        struct {
            __IO uint32_t  VBLK                           :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  HLINE                          :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  DOFF                           :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  ERR                            :  1;
        } INTMASK_bits;
    };

    union {
        __IO uint32_t  DMAREQ;

        struct {
            __IO uint32_t  REQ                            :  3;
        } DMAREQ_bits;
    };

    union {
        __I  uint32_t  HRZSTAT;

        struct {
            __I  uint32_t  PIX                            : 11;
                 uint32_t                                 :  5;
            __I  uint32_t  STAT                           :  1;
        } HRZSTAT_bits;
    };

    union {
        __I  uint32_t  VTSTAT;

        struct {
            __I  uint32_t  LINE                           : 11;
                 uint32_t                                 :  5;
            __I  uint32_t  STAT                           :  1;
                 uint32_t                                 :  7;
            __I  uint32_t  FCNT                           :  4;
        } VTSTAT_bits;
    };

    __I  uint32_t  RESERVED2[30];

    union {
        __IO uint32_t  LUTR[64];

        struct {
            __IO uint32_t  R0                             :  8;
            __IO uint32_t  R1                             :  8;
            __IO uint32_t  R2                             :  8;
            __IO uint32_t  R3                             :  8;
        } LUTR_bits[64];
    };

    union {
        __IO uint32_t  LUTG[64];

        struct {
            __IO uint32_t  G0                             :  8;
            __IO uint32_t  G1                             :  8;
            __IO uint32_t  G2                             :  8;
            __IO uint32_t  G3                             :  8;
        } LUTG_bits[64];
    };

    union {
        __IO uint32_t  LUTB[64];

        struct {
            __IO uint32_t  B0                             :  8;
            __IO uint32_t  B1                             :  8;
            __IO uint32_t  B2                             :  8;
            __IO uint32_t  B3                             :  8;
        } LUTB_bits[64];
    };

/* DOM-IGNORE-END */
}AG903_DSPn_Type;

#define AG903_DSPn(ch)                           ((volatile AG903_DSPn_Type *)(AG903_DSP0_BASE + 0x400 * ch))            /** DSPn Base Address (n=0..1) */
#define AG903_DSPn_CTRL(ch)                      AG903_DSPn(ch)->CTRL                                                    /** DSPnCTRL Address (n=0..1) */
#define AG903_DSPn_MOD(ch)                       AG903_DSPn(ch)->MOD                                                     /** DSPnMOD Address (n=0..1) */
#define AG903_DSPn_SYNC(ch)                      AG903_DSPn(ch)->SYNC                                                    /** DSPnSYNC Address (n=0..1) */
#define AG903_DSPn_BGCOL(ch)                     AG903_DSPn(ch)->BGCOL                                                   /** DSPnBGCOL Address (n=0..1) */
#define AG903_DSPn_WINNUM(ch)                    AG903_DSPn(ch)->WINNUM                                                  /** DSPnWINNUM Address (n=0..1) */
#define AG903_DSPn_WATNUM(ch)                    AG903_DSPn(ch)->WATNUM                                                  /** DSPnWATNUM Address (n=0..1) */
#define AG903_DSPn_WATBASE(ch)                   AG903_DSPn(ch)->WATBASE                                                 /** DSPnWATBASE Address (n=0..1) */
#define AG903_DSPn_LSTCTRL(ch)                   AG903_DSPn(ch)->LSTCTRL                                                 /** DSPnLSTCTRL Address (n=0..1) */
#define AG903_DSPn_HRZPRM0(ch)                   AG903_DSPn(ch)->HRZPRM0                                                 /** DSPnHRZPRM0 Address (n=0..1) */
#define AG903_DSPn_HRZPRM1(ch)                   AG903_DSPn(ch)->HRZPRM1                                                 /** DSPnHRZPRM1 Address (n=0..1) */
#define AG903_DSPn_VTPRM0(ch)                    AG903_DSPn(ch)->VTPRM0                                                  /** DSPnVTPRM0 Address (n=0..1) */
#define AG903_DSPn_VTPRM1(ch)                    AG903_DSPn(ch)->VTPRM1                                                  /** DSPnVTPRM1 Address (n=0..1) */
#define AG903_DSPn_FRMSIZE(ch)                   AG903_DSPn(ch)->FRMSIZE                                                 /** DSPnFRMSIZE Address (n=0..1) */
#define AG903_DSPn_CDCTRL(ch)                    AG903_DSPn(ch)->CDCTRL                                                  /** DSPnCDCTRL Address (n=0..1) */
#define AG903_DSPn_COLDET(ch)                    AG903_DSPn(ch)->COLDET                                                  /** DSPnCOLDET Address (n=0..1) */
#define AG903_DSPn_DITHAREA0A(ch)                AG903_DSPn(ch)->DITHAREA0A                                              /** DSPnDITHAREA0A Address (n=0..1) */
#define AG903_DSPn_DITHAREA0B(ch)                AG903_DSPn(ch)->DITHAREA0B                                              /** DSPnDITHAREA0B Address (n=0..1) */
#define AG903_DSPn_DITHAREA1A(ch)                AG903_DSPn(ch)->DITHAREA1A                                              /** DSPnDITHAREA1A Address (n=0..1) */
#define AG903_DSPn_DITHAREA1B(ch)                AG903_DSPn(ch)->DITHAREA1B                                              /** DSPnDITHAREA1B Address (n=0..1) */
#define AG903_DSPn_DITHAREA2A(ch)                AG903_DSPn(ch)->DITHAREA2A                                              /** DSPnDITHAREA2A Address (n=0..1) */
#define AG903_DSPn_DITHAREA2B(ch)                AG903_DSPn(ch)->DITHAREA2B                                              /** DSPnDITHAREA2B Address (n=0..1) */
#define AG903_DSPn_DITHAREA3A(ch)                AG903_DSPn(ch)->DITHAREA3A                                              /** DSPnDITHAREA3A Address (n=0..1) */
#define AG903_DSPn_DITHAREA3B(ch)                AG903_DSPn(ch)->DITHAREA3B                                              /** DSPnDITHAREA3B Address (n=0..1) */
#define AG903_DSPn_ERRSTAT(ch)                   AG903_DSPn(ch)->ERRSTAT                                                 /** DSPnERRSTAT Address (n=0..1) */
#define AG903_DSPn_ERRCLR(ch)                    AG903_DSPn(ch)->ERRCLR                                                  /** DSPnERRCLR Address (n=0..1) */
#define AG903_DSPn_INT(ch)                       AG903_DSPn(ch)->INT                                                     /** DSPnINT Address (n=0..1) */
#define AG903_DSPn_TRIGGER(ch)                   AG903_DSPn(ch)->TRIGGER                                                 /** DSPnTRIGGER Address (n=0..1) */
#define AG903_DSPn_INTSTAT(ch)                   AG903_DSPn(ch)->INTSTAT                                                 /** DSPnINTSTAT Address (n=0..1) */
#define AG903_DSPn_INTCLR(ch)                    AG903_DSPn(ch)->INTCLR                                                  /** DSPnINTCLR Address (n=0..1) */
#define AG903_DSPn_INTMASK(ch)                   AG903_DSPn(ch)->INTMASK                                                 /** DSPnINTMASK Address (n=0..1) */
#define AG903_DSPn_DMAREQ(ch)                    AG903_DSPn(ch)->DMAREQ                                                  /** DSPnDMAREQ Address (n=0..1) */
#define AG903_DSPn_HRZSTAT(ch)                   AG903_DSPn(ch)->HRZSTAT                                                 /** DSPnHRZSTAT Address (n=0..1) */
#define AG903_DSPn_VTSTAT(ch)                    AG903_DSPn(ch)->VTSTAT                                                  /** DSPnVTSTAT Address (n=0..1) */
#define AG903_DSPn_LUTR(ch)                      AG903_DSPn(ch)->LUTR                                                    /** DSPnLUTR Address (n=0..1) */
#define AG903_DSPn_LUTG(ch)                      AG903_DSPn(ch)->LUTG                                                    /** DSPnLUTG Address (n=0..1) */
#define AG903_DSPn_LUTB(ch)                      AG903_DSPn(ch)->LUTB                                                    /** DSPnLUTB Address (n=0..1) */

#define AG903_DSP0                               ((volatile AG903_DSPn_Type *) AG903_DSP0_BASE)                          /** DSPn Base Address */
#define AG903_DSP1                               ((volatile AG903_DSPn_Type *) AG903_DSP1_BASE)                          /** DSPn Base Address */


#define AG903_DSPn_CTRL_DON_POS                            0                                                             /** DSPnCTRL DON-bit position */
#define AG903_DSPn_CTRL_DON_MSK                            (0x1UL << AG903_DSPn_CTRL_DON_POS)                            /** DSPnCTRL DON-bit mask */

#define AG903_DSPn_MOD_DE_POS                              0                                                             /** DSPnMOD DE-bit position */
#define AG903_DSPn_MOD_DE_MSK                              (0x1UL << AG903_DSPn_MOD_DE_POS)                              /** DSPnMOD DE-bit mask */
#define AG903_DSPn_MOD_IP_POS                              8                                                             /** DSPnMOD IP-bit position */
#define AG903_DSPn_MOD_IP_MSK                              (0x1UL << AG903_DSPn_MOD_IP_POS)                              /** DSPnMOD IP-bit mask */
#define AG903_DSPn_MOD_UPD_POS                             16                                                            /** DSPnMOD UPD-bit position */
#define AG903_DSPn_MOD_UPD_MSK                             (0x3UL << AG903_DSPn_MOD_UPD_POS)                             /** DSPnMOD UPD-bit mask */
#define AG903_DSPn_MOD_BMR_POS                             18                                                            /** DSPnMOD BMR-bit position */
#define AG903_DSPn_MOD_BMR_MSK                             (0x1UL << AG903_DSPn_MOD_BMR_POS)                             /** DSPnMOD BMR-bit mask */
#define AG903_DSPn_MOD_LUT_POS                             24                                                            /** DSPnMOD LUT-bit position */
#define AG903_DSPn_MOD_LUT_MSK                             (0x1UL << AG903_DSPn_MOD_LUT_POS)                             /** DSPnMOD LUT-bit mask */
#define AG903_DSPn_MOD_DITH_POS                            25                                                            /** DSPnMOD DITH-bit position */
#define AG903_DSPn_MOD_DITH_MSK                            (0x1UL << AG903_DSPn_MOD_DITH_POS)                            /** DSPnMOD DITH-bit mask */

#define AG903_DSPn_SYNC_SEL_POS                            0                                                             /** DSPnSYNC SEL-bit position */
#define AG903_DSPn_SYNC_SEL_MSK                            (0x1fUL << AG903_DSPn_SYNC_SEL_POS)                           /** DSPnSYNC SEL-bit mask */
#define AG903_DSPn_SYNC_DLY_POS                            8                                                             /** DSPnSYNC DLY-bit position */
#define AG903_DSPn_SYNC_DLY_MSK                            (0x1UL << AG903_DSPn_SYNC_DLY_POS)                            /** DSPnSYNC DLY-bit mask */
#define AG903_DSPn_SYNC_IP_POS                             16                                                            /** DSPnSYNC IP-bit position */
#define AG903_DSPn_SYNC_IP_MSK                             (0x1UL << AG903_DSPn_SYNC_IP_POS)                             /** DSPnSYNC IP-bit mask */
#define AG903_DSPn_SYNC_VP_POS                             17                                                            /** DSPnSYNC VP-bit position */
#define AG903_DSPn_SYNC_VP_MSK                             (0x1UL << AG903_DSPn_SYNC_VP_POS)                             /** DSPnSYNC VP-bit mask */
#define AG903_DSPn_SYNC_FP_POS                             18                                                            /** DSPnSYNC FP-bit position */
#define AG903_DSPn_SYNC_FP_MSK                             (0x1UL << AG903_DSPn_SYNC_FP_POS)                             /** DSPnSYNC FP-bit mask */
#define AG903_DSPn_SYNC_MSK_POS                            24                                                            /** DSPnSYNC MSK-bit position */
#define AG903_DSPn_SYNC_MSK_MSK                            (0x1UL << AG903_DSPn_SYNC_MSK_POS)                            /** DSPnSYNC MSK-bit mask */

#define AG903_DSPn_BGCOL_B_POS                             0                                                             /** DSPnBGCOL B-bit position */
#define AG903_DSPn_BGCOL_B_MSK                             (0xffUL << AG903_DSPn_BGCOL_B_POS)                            /** DSPnBGCOL B-bit mask */
#define AG903_DSPn_BGCOL_G_POS                             8                                                             /** DSPnBGCOL G-bit position */
#define AG903_DSPn_BGCOL_G_MSK                             (0xffUL << AG903_DSPn_BGCOL_G_POS)                            /** DSPnBGCOL G-bit mask */
#define AG903_DSPn_BGCOL_R_POS                             16                                                            /** DSPnBGCOL R-bit position */
#define AG903_DSPn_BGCOL_R_MSK                             (0xffUL << AG903_DSPn_BGCOL_R_POS)                            /** DSPnBGCOL R-bit mask */
#define AG903_DSPn_BGCOL_A_POS                             24                                                            /** DSPnBGCOL A-bit position */
#define AG903_DSPn_BGCOL_A_MSK                             (0xffUL << AG903_DSPn_BGCOL_A_POS)                            /** DSPnBGCOL A-bit mask */

#define AG903_DSPn_WINNUM_CONF_POS                         0                                                             /** DSPnWINNUM CONF-bit position */
#define AG903_DSPn_WINNUM_CONF_MSK                         (0x1fUL << AG903_DSPn_WINNUM_CONF_POS)                        /** DSPnWINNUM CONF-bit mask */
#define AG903_DSPn_WINNUM_ACT_POS                          16                                                            /** DSPnWINNUM ACT-bit position */
#define AG903_DSPn_WINNUM_ACT_MSK                          (0x1fUL << AG903_DSPn_WINNUM_ACT_POS)                         /** DSPnWINNUM ACT-bit mask */

#define AG903_DSPn_WATNUM_NUM_POS                          0                                                             /** DSPnWATNUM NUM-bit position */
#define AG903_DSPn_WATNUM_NUM_MSK                          (0xffUL << AG903_DSPn_WATNUM_NUM_POS)                         /** DSPnWATNUM NUM-bit mask */

#define AG903_DSPn_WATBASE_ADDR_POS                        3                                                             /** DSPnWATBASE ADDR-bit position */
#define AG903_DSPn_WATBASE_ADDR_MSK                        (0x1fffffffUL << AG903_DSPn_WATBASE_ADDR_POS)                 /** DSPnWATBASE ADDR-bit mask */

#define AG903_DSPn_LSTCTRL_WAT_POS                         0                                                             /** DSPnLSTCTRL WAT-bit position */
#define AG903_DSPn_LSTCTRL_WAT_MSK                         (0x1UL << AG903_DSPn_LSTCTRL_WAT_POS)                         /** DSPnLSTCTRL WAT-bit mask */
#define AG903_DSPn_LSTCTRL_PAL_POS                         16                                                            /** DSPnLSTCTRL PAL-bit position */
#define AG903_DSPn_LSTCTRL_PAL_MSK                         (0x1UL << AG903_DSPn_LSTCTRL_PAL_POS)                         /** DSPnLSTCTRL PAL-bit mask */

#define AG903_DSPn_HRZPRM0_HPW_POS                         0                                                             /** DSPnHRZPRM0 HPW-bit position */
#define AG903_DSPn_HRZPRM0_HPW_MSK                         (0x7ffUL << AG903_DSPn_HRZPRM0_HPW_POS)                       /** DSPnHRZPRM0 HPW-bit mask */

#define AG903_DSPn_HRZPRM1_HBP_POS                         0                                                             /** DSPnHRZPRM1 HBP-bit position */
#define AG903_DSPn_HRZPRM1_HBP_MSK                         (0x7ffUL << AG903_DSPn_HRZPRM1_HBP_POS)                       /** DSPnHRZPRM1 HBP-bit mask */
#define AG903_DSPn_HRZPRM1_HFP_POS                         16                                                            /** DSPnHRZPRM1 HFP-bit position */
#define AG903_DSPn_HRZPRM1_HFP_MSK                         (0x7ffUL << AG903_DSPn_HRZPRM1_HFP_POS)                       /** DSPnHRZPRM1 HFP-bit mask */

#define AG903_DSPn_VTPRM0_VPW_POS                          0                                                             /** DSPnVTPRM0 VPW-bit position */
#define AG903_DSPn_VTPRM0_VPW_MSK                          (0x7ffUL << AG903_DSPn_VTPRM0_VPW_POS)                        /** DSPnVTPRM0 VPW-bit mask */
#define AG903_DSPn_VTPRM0_OFP_POS                          16                                                            /** DSPnVTPRM0 OFP-bit position */
#define AG903_DSPn_VTPRM0_OFP_MSK                          (0x1UL << AG903_DSPn_VTPRM0_OFP_POS)                          /** DSPnVTPRM0 OFP-bit mask */
#define AG903_DSPn_VTPRM0_OBP_POS                          17                                                            /** DSPnVTPRM0 OBP-bit position */
#define AG903_DSPn_VTPRM0_OBP_MSK                          (0x1UL << AG903_DSPn_VTPRM0_OBP_POS)                          /** DSPnVTPRM0 OBP-bit mask */
#define AG903_DSPn_VTPRM0_EFP_POS                          18                                                            /** DSPnVTPRM0 EFP-bit position */
#define AG903_DSPn_VTPRM0_EFP_MSK                          (0x1UL << AG903_DSPn_VTPRM0_EFP_POS)                          /** DSPnVTPRM0 EFP-bit mask */
#define AG903_DSPn_VTPRM0_EBP_POS                          19                                                            /** DSPnVTPRM0 EBP-bit position */
#define AG903_DSPn_VTPRM0_EBP_MSK                          (0x1UL << AG903_DSPn_VTPRM0_EBP_POS)                          /** DSPnVTPRM0 EBP-bit mask */

#define AG903_DSPn_VTPRM1_VBP_POS                          0                                                             /** DSPnVTPRM1 VBP-bit position */
#define AG903_DSPn_VTPRM1_VBP_MSK                          (0x7ffUL << AG903_DSPn_VTPRM1_VBP_POS)                        /** DSPnVTPRM1 VBP-bit mask */
#define AG903_DSPn_VTPRM1_VFP_POS                          16                                                            /** DSPnVTPRM1 VFP-bit position */
#define AG903_DSPn_VTPRM1_VFP_MSK                          (0x7ffUL << AG903_DSPn_VTPRM1_VFP_POS)                        /** DSPnVTPRM1 VFP-bit mask */

#define AG903_DSPn_FRMSIZE_HFS_POS                         0                                                             /** DSPnFRMSIZE HFS-bit position */
#define AG903_DSPn_FRMSIZE_HFS_MSK                         (0x7ffUL << AG903_DSPn_FRMSIZE_HFS_POS)                       /** DSPnFRMSIZE HFS-bit mask */
#define AG903_DSPn_FRMSIZE_VFS_POS                         16                                                            /** DSPnFRMSIZE VFS-bit position */
#define AG903_DSPn_FRMSIZE_VFS_MSK                         (0x7ffUL << AG903_DSPn_FRMSIZE_VFS_POS)                       /** DSPnFRMSIZE VFS-bit mask */

#define AG903_DSPn_CDCTRL_BE_POS                           0                                                             /** DSPnCDCTRL BE-bit position */
#define AG903_DSPn_CDCTRL_BE_MSK                           (0x1UL << AG903_DSPn_CDCTRL_BE_POS)                           /** DSPnCDCTRL BE-bit mask */
#define AG903_DSPn_CDCTRL_GE_POS                           8                                                             /** DSPnCDCTRL GE-bit position */
#define AG903_DSPn_CDCTRL_GE_MSK                           (0x1UL << AG903_DSPn_CDCTRL_GE_POS)                           /** DSPnCDCTRL GE-bit mask */
#define AG903_DSPn_CDCTRL_RE_POS                           16                                                            /** DSPnCDCTRL RE-bit position */
#define AG903_DSPn_CDCTRL_RE_MSK                           (0x1UL << AG903_DSPn_CDCTRL_RE_POS)                           /** DSPnCDCTRL RE-bit mask */
#define AG903_DSPn_CDCTRL_AE_POS                           24                                                            /** DSPnCDCTRL AE-bit position */
#define AG903_DSPn_CDCTRL_AE_MSK                           (0x1UL << AG903_DSPn_CDCTRL_AE_POS)                           /** DSPnCDCTRL AE-bit mask */

#define AG903_DSPn_COLDET_B_POS                            0                                                             /** DSPnCOLDET B-bit position */
#define AG903_DSPn_COLDET_B_MSK                            (0xffUL << AG903_DSPn_COLDET_B_POS)                           /** DSPnCOLDET B-bit mask */
#define AG903_DSPn_COLDET_G_POS                            8                                                             /** DSPnCOLDET G-bit position */
#define AG903_DSPn_COLDET_G_MSK                            (0xffUL << AG903_DSPn_COLDET_G_POS)                           /** DSPnCOLDET G-bit mask */
#define AG903_DSPn_COLDET_R_POS                            16                                                            /** DSPnCOLDET R-bit position */
#define AG903_DSPn_COLDET_R_MSK                            (0xffUL << AG903_DSPn_COLDET_R_POS)                           /** DSPnCOLDET R-bit mask */
#define AG903_DSPn_COLDET_A_POS                            24                                                            /** DSPnCOLDET A-bit position */
#define AG903_DSPn_COLDET_A_MSK                            (0xffUL << AG903_DSPn_COLDET_A_POS)                           /** DSPnCOLDET A-bit mask */

#define AG903_DSPn_DITHAREA0A_X0_POS                       0                                                             /** DSPnDITHAREA0A X0-bit position */
#define AG903_DSPn_DITHAREA0A_X0_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA0A_X0_POS)                     /** DSPnDITHAREA0A X0-bit mask */
#define AG903_DSPn_DITHAREA0A_Y0_POS                       16                                                            /** DSPnDITHAREA0A Y0-bit position */
#define AG903_DSPn_DITHAREA0A_Y0_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA0A_Y0_POS)                     /** DSPnDITHAREA0A Y0-bit mask */

#define AG903_DSPn_DITHAREA0B_X1_POS                       0                                                             /** DSPnDITHAREA0B X1-bit position */
#define AG903_DSPn_DITHAREA0B_X1_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA0B_X1_POS)                     /** DSPnDITHAREA0B X1-bit mask */
#define AG903_DSPn_DITHAREA0B_Y1_POS                       16                                                            /** DSPnDITHAREA0B Y1-bit position */
#define AG903_DSPn_DITHAREA0B_Y1_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA0B_Y1_POS)                     /** DSPnDITHAREA0B Y1-bit mask */

#define AG903_DSPn_DITHAREA1A_X0_POS                       0                                                             /** DSPnDITHAREA1A X0-bit position */
#define AG903_DSPn_DITHAREA1A_X0_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA1A_X0_POS)                     /** DSPnDITHAREA1A X0-bit mask */
#define AG903_DSPn_DITHAREA1A_Y0_POS                       16                                                            /** DSPnDITHAREA1A Y0-bit position */
#define AG903_DSPn_DITHAREA1A_Y0_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA1A_Y0_POS)                     /** DSPnDITHAREA1A Y0-bit mask */

#define AG903_DSPn_DITHAREA1B_X1_POS                       0                                                             /** DSPnDITHAREA1B X1-bit position */
#define AG903_DSPn_DITHAREA1B_X1_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA1B_X1_POS)                     /** DSPnDITHAREA1B X1-bit mask */
#define AG903_DSPn_DITHAREA1B_Y1_POS                       16                                                            /** DSPnDITHAREA1B Y1-bit position */
#define AG903_DSPn_DITHAREA1B_Y1_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA1B_Y1_POS)                     /** DSPnDITHAREA1B Y1-bit mask */

#define AG903_DSPn_DITHAREA2A_X0_POS                       0                                                             /** DSPnDITHAREA2A X0-bit position */
#define AG903_DSPn_DITHAREA2A_X0_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA2A_X0_POS)                     /** DSPnDITHAREA2A X0-bit mask */
#define AG903_DSPn_DITHAREA2A_Y0_POS                       16                                                            /** DSPnDITHAREA2A Y0-bit position */
#define AG903_DSPn_DITHAREA2A_Y0_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA2A_Y0_POS)                     /** DSPnDITHAREA2A Y0-bit mask */

#define AG903_DSPn_DITHAREA2B_X1_POS                       0                                                             /** DSPnDITHAREA2B X1-bit position */
#define AG903_DSPn_DITHAREA2B_X1_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA2B_X1_POS)                     /** DSPnDITHAREA2B X1-bit mask */
#define AG903_DSPn_DITHAREA2B_Y1_POS                       16                                                            /** DSPnDITHAREA2B Y1-bit position */
#define AG903_DSPn_DITHAREA2B_Y1_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA2B_Y1_POS)                     /** DSPnDITHAREA2B Y1-bit mask */

#define AG903_DSPn_DITHAREA3A_X0_POS                       0                                                             /** DSPnDITHAREA3A X0-bit position */
#define AG903_DSPn_DITHAREA3A_X0_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA3A_X0_POS)                     /** DSPnDITHAREA3A X0-bit mask */
#define AG903_DSPn_DITHAREA3A_Y0_POS                       16                                                            /** DSPnDITHAREA3A Y0-bit position */
#define AG903_DSPn_DITHAREA3A_Y0_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA3A_Y0_POS)                     /** DSPnDITHAREA3A Y0-bit mask */

#define AG903_DSPn_DITHAREA3B_X1_POS                       0                                                             /** DSPnDITHAREA3B X1-bit position */
#define AG903_DSPn_DITHAREA3B_X1_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA3B_X1_POS)                     /** DSPnDITHAREA3B X1-bit mask */
#define AG903_DSPn_DITHAREA3B_Y1_POS                       16                                                            /** DSPnDITHAREA3B Y1-bit position */
#define AG903_DSPn_DITHAREA3B_Y1_MSK                       (0x7ffUL << AG903_DSPn_DITHAREA3B_Y1_POS)                     /** DSPnDITHAREA3B Y1-bit mask */

#define AG903_DSPn_ERRSTAT_LINE_POS                        0                                                             /** DSPnERRSTAT LINE-bit position */
#define AG903_DSPn_ERRSTAT_LINE_MSK                        (0x7ffUL << AG903_DSPn_ERRSTAT_LINE_POS)                      /** DSPnERRSTAT LINE-bit mask */
#define AG903_DSPn_ERRSTAT_UE_POS                          16                                                            /** DSPnERRSTAT UE-bit position */
#define AG903_DSPn_ERRSTAT_UE_MSK                          (0x1UL << AG903_DSPn_ERRSTAT_UE_POS)                          /** DSPnERRSTAT UE-bit mask */
#define AG903_DSPn_ERRSTAT_LE_POS                          24                                                            /** DSPnERRSTAT LE-bit position */
#define AG903_DSPn_ERRSTAT_LE_MSK                          (0x1UL << AG903_DSPn_ERRSTAT_LE_POS)                          /** DSPnERRSTAT LE-bit mask */
#define AG903_DSPn_ERRSTAT_PE_POS                          25                                                            /** DSPnERRSTAT PE-bit position */
#define AG903_DSPn_ERRSTAT_PE_MSK                          (0x1UL << AG903_DSPn_ERRSTAT_PE_POS)                          /** DSPnERRSTAT PE-bit mask */

#define AG903_DSPn_ERRCLR_LINE_POS                         0                                                             /** DSPnERRCLR LINE-bit position */
#define AG903_DSPn_ERRCLR_LINE_MSK                         (0x1UL << AG903_DSPn_ERRCLR_LINE_POS)                         /** DSPnERRCLR LINE-bit mask */
#define AG903_DSPn_ERRCLR_UE_POS                           16                                                            /** DSPnERRCLR UE-bit position */
#define AG903_DSPn_ERRCLR_UE_MSK                           (0x1UL << AG903_DSPn_ERRCLR_UE_POS)                           /** DSPnERRCLR UE-bit mask */
#define AG903_DSPn_ERRCLR_LE_POS                           24                                                            /** DSPnERRCLR LE-bit position */
#define AG903_DSPn_ERRCLR_LE_MSK                           (0x1UL << AG903_DSPn_ERRCLR_LE_POS)                           /** DSPnERRCLR LE-bit mask */
#define AG903_DSPn_ERRCLR_PE_POS                           25                                                            /** DSPnERRCLR PE-bit position */
#define AG903_DSPn_ERRCLR_PE_MSK                           (0x1UL << AG903_DSPn_ERRCLR_PE_POS)                           /** DSPnERRCLR PE-bit mask */

#define AG903_DSPn_INT_LINE_POS                            0                                                             /** DSPnINT LINE-bit position */
#define AG903_DSPn_INT_LINE_MSK                            (0x7ffUL << AG903_DSPn_INT_LINE_POS)                          /** DSPnINT LINE-bit mask */
#define AG903_DSPn_INT_FCNT_POS                            16                                                            /** DSPnINT FCNT-bit position */
#define AG903_DSPn_INT_FCNT_MSK                            (0xfUL << AG903_DSPn_INT_FCNT_POS)                            /** DSPnINT FCNT-bit mask */
#define AG903_DSPn_INT_HLINE_POS                           24                                                            /** DSPnINT HLINE-bit position */
#define AG903_DSPn_INT_HLINE_MSK                           (0x1UL << AG903_DSPn_INT_HLINE_POS)                           /** DSPnINT HLINE-bit mask */
#define AG903_DSPn_INT_VBLK_POS                            25                                                            /** DSPnINT VBLK-bit position */
#define AG903_DSPn_INT_VBLK_MSK                            (0x1UL << AG903_DSPn_INT_VBLK_POS)                            /** DSPnINT VBLK-bit mask */

#define AG903_DSPn_TRIGGER_OUT_POS                         0                                                             /** DSPnTRIGGER OUT-bit position */
#define AG903_DSPn_TRIGGER_OUT_MSK                         (0x1UL << AG903_DSPn_TRIGGER_OUT_POS)                         /** DSPnTRIGGER OUT-bit mask */
#define AG903_DSPn_TRIGGER_HRZ_POS                         16                                                            /** DSPnTRIGGER HRZ-bit position */
#define AG903_DSPn_TRIGGER_HRZ_MSK                         (0x1UL << AG903_DSPn_TRIGGER_HRZ_POS)                         /** DSPnTRIGGER HRZ-bit mask */
#define AG903_DSPn_TRIGGER_VT_POS                          24                                                            /** DSPnTRIGGER VT-bit position */
#define AG903_DSPn_TRIGGER_VT_MSK                          (0x3UL << AG903_DSPn_TRIGGER_VT_POS)                          /** DSPnTRIGGER VT-bit mask */

#define AG903_DSPn_INTSTAT_VBLK_POS                        0                                                             /** DSPnINTSTAT VBLK-bit position */
#define AG903_DSPn_INTSTAT_VBLK_MSK                        (0x1UL << AG903_DSPn_INTSTAT_VBLK_POS)                        /** DSPnINTSTAT VBLK-bit mask */
#define AG903_DSPn_INTSTAT_HLINE_POS                       8                                                             /** DSPnINTSTAT HLINE-bit position */
#define AG903_DSPn_INTSTAT_HLINE_MSK                       (0x1UL << AG903_DSPn_INTSTAT_HLINE_POS)                       /** DSPnINTSTAT HLINE-bit mask */
#define AG903_DSPn_INTSTAT_DOFF_POS                        16                                                            /** DSPnINTSTAT DOFF-bit position */
#define AG903_DSPn_INTSTAT_DOFF_MSK                        (0x1UL << AG903_DSPn_INTSTAT_DOFF_POS)                        /** DSPnINTSTAT DOFF-bit mask */
#define AG903_DSPn_INTSTAT_DREQ_POS                        24                                                            /** DSPnINTSTAT DREQ-bit position */
#define AG903_DSPn_INTSTAT_DREQ_MSK                        (0x1UL << AG903_DSPn_INTSTAT_DREQ_POS)                        /** DSPnINTSTAT DREQ-bit mask */

#define AG903_DSPn_INTCLR_VBLK_POS                         0                                                             /** DSPnINTCLR VBLK-bit position */
#define AG903_DSPn_INTCLR_VBLK_MSK                         (0x1UL << AG903_DSPn_INTCLR_VBLK_POS)                         /** DSPnINTCLR VBLK-bit mask */
#define AG903_DSPn_INTCLR_HLINE_POS                        8                                                             /** DSPnINTCLR HLINE-bit position */
#define AG903_DSPn_INTCLR_HLINE_MSK                        (0x1UL << AG903_DSPn_INTCLR_HLINE_POS)                        /** DSPnINTCLR HLINE-bit mask */
#define AG903_DSPn_INTCLR_DOFF_POS                         16                                                            /** DSPnINTCLR DOFF-bit position */
#define AG903_DSPn_INTCLR_DOFF_MSK                         (0x1UL << AG903_DSPn_INTCLR_DOFF_POS)                         /** DSPnINTCLR DOFF-bit mask */

#define AG903_DSPn_INTMASK_VBLK_POS                        0                                                             /** DSPnINTMASK VBLK-bit position */
#define AG903_DSPn_INTMASK_VBLK_MSK                        (0x1UL << AG903_DSPn_INTMASK_VBLK_POS)                        /** DSPnINTMASK VBLK-bit mask */
#define AG903_DSPn_INTMASK_HLINE_POS                       8                                                             /** DSPnINTMASK HLINE-bit position */
#define AG903_DSPn_INTMASK_HLINE_MSK                       (0x1UL << AG903_DSPn_INTMASK_HLINE_POS)                       /** DSPnINTMASK HLINE-bit mask */
#define AG903_DSPn_INTMASK_DOFF_POS                        16                                                            /** DSPnINTMASK DOFF-bit position */
#define AG903_DSPn_INTMASK_DOFF_MSK                        (0x1UL << AG903_DSPn_INTMASK_DOFF_POS)                        /** DSPnINTMASK DOFF-bit mask */
#define AG903_DSPn_INTMASK_ERR_POS                         24                                                            /** DSPnINTMASK ERR-bit position */
#define AG903_DSPn_INTMASK_ERR_MSK                         (0x1UL << AG903_DSPn_INTMASK_ERR_POS)                         /** DSPnINTMASK ERR-bit mask */

#define AG903_DSPn_DMAREQ_REQ_POS                          0                                                             /** DSPnDMAREQ REQ-bit position */
#define AG903_DSPn_DMAREQ_REQ_MSK                          (0x7UL << AG903_DSPn_DMAREQ_REQ_POS)                          /** DSPnDMAREQ REQ-bit mask */

#define AG903_DSPn_HRZSTAT_PIX_POS                         0                                                             /** DSPnHRZSTAT PIX-bit position */
#define AG903_DSPn_HRZSTAT_PIX_MSK                         (0x7ffUL << AG903_DSPn_HRZSTAT_PIX_POS)                       /** DSPnHRZSTAT PIX-bit mask */
#define AG903_DSPn_HRZSTAT_STAT_POS                        16                                                            /** DSPnHRZSTAT STAT-bit position */
#define AG903_DSPn_HRZSTAT_STAT_MSK                        (0x1UL << AG903_DSPn_HRZSTAT_STAT_POS)                        /** DSPnHRZSTAT STAT-bit mask */

#define AG903_DSPn_VTSTAT_LINE_POS                         0                                                             /** DSPnVTSTAT LINE-bit position */
#define AG903_DSPn_VTSTAT_LINE_MSK                         (0x7ffUL << AG903_DSPn_VTSTAT_LINE_POS)                       /** DSPnVTSTAT LINE-bit mask */
#define AG903_DSPn_VTSTAT_STAT_POS                         16                                                            /** DSPnVTSTAT STAT-bit position */
#define AG903_DSPn_VTSTAT_STAT_MSK                         (0x1UL << AG903_DSPn_VTSTAT_STAT_POS)                         /** DSPnVTSTAT STAT-bit mask */
#define AG903_DSPn_VTSTAT_FCNT_POS                         24                                                            /** DSPnVTSTAT FCNT-bit position */
#define AG903_DSPn_VTSTAT_FCNT_MSK                         (0xfUL << AG903_DSPn_VTSTAT_FCNT_POS)                         /** DSPnVTSTAT FCNT-bit mask */

#define AG903_DSPn_LUTR_R0_POS                             0                                                             /** DSPnLUTR R0-bit position */
#define AG903_DSPn_LUTR_R0_MSK                             (0xffUL << AG903_DSPn_LUTR_R0_POS)                            /** DSPnLUTR R0-bit mask */
#define AG903_DSPn_LUTR_R1_POS                             8                                                             /** DSPnLUTR R1-bit position */
#define AG903_DSPn_LUTR_R1_MSK                             (0xffUL << AG903_DSPn_LUTR_R1_POS)                            /** DSPnLUTR R1-bit mask */
#define AG903_DSPn_LUTR_R2_POS                             16                                                            /** DSPnLUTR R2-bit position */
#define AG903_DSPn_LUTR_R2_MSK                             (0xffUL << AG903_DSPn_LUTR_R2_POS)                            /** DSPnLUTR R2-bit mask */
#define AG903_DSPn_LUTR_R3_POS                             24                                                            /** DSPnLUTR R3-bit position */
#define AG903_DSPn_LUTR_R3_MSK                             (0xffUL << AG903_DSPn_LUTR_R3_POS)                            /** DSPnLUTR R3-bit mask */

#define AG903_DSPn_LUTG_G0_POS                             0                                                             /** DSPnLUTG G0-bit position */
#define AG903_DSPn_LUTG_G0_MSK                             (0xffUL << AG903_DSPn_LUTG_G0_POS)                            /** DSPnLUTG G0-bit mask */
#define AG903_DSPn_LUTG_G1_POS                             8                                                             /** DSPnLUTG G1-bit position */
#define AG903_DSPn_LUTG_G1_MSK                             (0xffUL << AG903_DSPn_LUTG_G1_POS)                            /** DSPnLUTG G1-bit mask */
#define AG903_DSPn_LUTG_G2_POS                             16                                                            /** DSPnLUTG G2-bit position */
#define AG903_DSPn_LUTG_G2_MSK                             (0xffUL << AG903_DSPn_LUTG_G2_POS)                            /** DSPnLUTG G2-bit mask */
#define AG903_DSPn_LUTG_G3_POS                             24                                                            /** DSPnLUTG G3-bit position */
#define AG903_DSPn_LUTG_G3_MSK                             (0xffUL << AG903_DSPn_LUTG_G3_POS)                            /** DSPnLUTG G3-bit mask */

#define AG903_DSPn_LUTB_B0_POS                             0                                                             /** DSPnLUTB B0-bit position */
#define AG903_DSPn_LUTB_B0_MSK                             (0xffUL << AG903_DSPn_LUTB_B0_POS)                            /** DSPnLUTB B0-bit mask */
#define AG903_DSPn_LUTB_B1_POS                             8                                                             /** DSPnLUTB B1-bit position */
#define AG903_DSPn_LUTB_B1_MSK                             (0xffUL << AG903_DSPn_LUTB_B1_POS)                            /** DSPnLUTB B1-bit mask */
#define AG903_DSPn_LUTB_B2_POS                             16                                                            /** DSPnLUTB B2-bit position */
#define AG903_DSPn_LUTB_B2_MSK                             (0xffUL << AG903_DSPn_LUTB_B2_POS)                            /** DSPnLUTB B2-bit mask */
#define AG903_DSPn_LUTB_B3_POS                             24                                                            /** DSPnLUTB B3-bit position */
#define AG903_DSPn_LUTB_B3_MSK                             (0xffUL << AG903_DSPn_LUTB_B3_POS)                            /** DSPnLUTB B3-bit mask */

#endif /* _AG903_DSP_REGMAP_H_ */

