/**
 * @brief           SDC Register Definition
 * @author          AXELL CORPORATION
 * @description     SDC Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_SDC_REGMAP_H_
#define _AG903_SDC_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** SDC Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  SDMA_System_Address;
        __IO uint32_t  Argument_2;
    };

    union {
        __IO uint16_t  Block_Size;

        struct {
            __IO uint16_t  Transfer_Block_Size            : 12;
            __IO uint16_t  Host_SDMA_Buffer_Boundary      :  3;
        } Block_Size_bits;
    };

    union {
        __IO uint16_t  Block_Count;
    };

    union {
        __IO uint32_t  Argument_1;
    };

    union {
        __IO uint16_t  Transfer_Mode;

        struct {
            __IO uint16_t  DMA_Enable                     :  1;
            __IO uint16_t  Block_Count_Enable             :  1;
            __IO uint16_t  Auto_CMD_Enable                :  2;
            __IO uint16_t  Data_Transfer_Direction_Select :  1;
            __IO uint16_t  Multi_Single_Block_Select      :  1;
        } Transfer_Mode_bits;
    };

    union {
        __IO uint16_t  Command;

        struct {
            __IO uint16_t  Response_Type_Select           :  2;
                 uint16_t                                 :  1;
            __IO uint16_t  Command_CRC_Check_Enable       :  1;
            __IO uint16_t  Command_Index_Check_Enable     :  1;
            __IO uint16_t  Data_Present_Select            :  1;
            __IO uint16_t  Command_Type                   :  2;
            __IO uint16_t  Command_Index                  :  6;
        } Command_bits;
    };

    union {
        __I  uint32_t  Response[4];
    };

    union {
        __IO uint32_t  Buffer_Data_Port;
    };

    union {
        __I  uint32_t  Present_State;

        struct {
            __I  uint32_t  Command_Inhibit_CMD            :  1;
            __I  uint32_t  Command_Inhibit_LINE           :  1;
            __I  uint32_t  DAT_Line_Active                :  1;
                 uint32_t                                 :  5;
            __I  uint32_t  Write_Transfer_Active          :  1;
            __I  uint32_t  Read_Transfer_Active           :  1;
            __I  uint32_t  Buffer_Write_Enable            :  1;
            __I  uint32_t  Buffer_Read_Enable             :  1;
                 uint32_t                                 :  4;
            __I  uint32_t  Card_Inserted                  :  1;
            __I  uint32_t  Card_State_Stable              :  1;
            __I  uint32_t  Card_Detect_Pin_Level          :  1;
            __I  uint32_t  Write_Protect_Switch_Pin_Level :  1;
            __I  uint32_t  DAT_Line_Signal_Level          :  4;
            __I  uint32_t  CMD_Line_Signal_Level          :  1;
        } Present_State_bits;
    };

    union {
        __IO uint8_t   Host_Control_1;

        struct {
            __IO uint8_t   LED_Control                    :  1;
            __IO uint8_t   Data_Transfer_Width            :  1;
            __IO uint8_t   High_Speed_Enable              :  1;
            __IO uint8_t   DMA_Select                     :  2;
            __IO uint8_t   Extended_Sata_Transfer_Width   :  1;
            __IO uint8_t   Card_Detect_Test_Level         :  1;
            __IO uint8_t   Card_Detect_Signal_Selection   :  1;
        } Host_Control_1_bits;
    };

    union {
        __IO uint8_t   Power_Control_Register;

        struct {
            __IO uint8_t   SD_Bus_Power                   :  1;
            __IO uint8_t   SD_Bus_Voltage_Select          :  3;
        } Power_Control_Register_bits;
    };

    union {
        __IO uint8_t   Block_Gap_Control;

        struct {
            __IO uint8_t   Stop_At_Block_Gap_Request      :  1;
            __IO uint8_t   Continue_Request               :  1;
            __IO uint8_t   Read_Wait_Control              :  1;
            __IO uint8_t   Interrupt_At_Block_Gap         :  1;
        } Block_Gap_Control_bits;
    };

    __I  uint8_t   RESERVED1[1];

    union {
        __IO uint16_t  Clock_control;

        struct {
            __IO uint16_t  Internal_Clock_Enable          :  1;
            __I  uint16_t  Internal_Clock_Stable          :  1;
            __IO uint16_t  SD_Clock_Enable                :  1;
                 uint16_t                                 :  2;
            __I  uint16_t  Clock_Generator_Select         :  1;
            __IO uint16_t  Upper_Bits_of_SDCLK_Frequency_Select :  2;
            __IO uint16_t  SDCLK_Frequency_Select         :  8;
        } Clock_control_bits;
    };

    union {
        __IO uint8_t   Timeout_Control;

        struct {
            __IO uint8_t   Data_Timeout_Counter_Value     :  4;
        } Timeout_Control_bits;
    };

    union {
        __IO uint8_t   Software_Reset;

        struct {
            __IO uint8_t   Software_Reset_For_All         :  1;
            __IO uint8_t   Software_Reset_For_CMD_Line    :  1;
            __IO uint8_t   Software_Reset_For_DAT_Line    :  1;
        } Software_Reset_bits;
    };

    union {
        __IO uint16_t  Normal_Interrupt_Status;

        struct {
            __IO uint16_t  Command_Complete               :  1;
            __IO uint16_t  Transfer_Complete              :  1;
            __IO uint16_t  Block_Gap_Event                :  1;
            __IO uint16_t  DMA_Interrupt                  :  1;
            __IO uint16_t  Butter_Write_Ready             :  1;
            __IO uint16_t  Buffer_Read_Ready              :  1;
            __IO uint16_t  Card_Insertion                 :  1;
            __IO uint16_t  Card_Removal                   :  1;
            __I  uint16_t  Card_Interrupt                 :  1;
            __I  uint16_t  INT_A                          :  1;
            __I  uint16_t  INT_B                          :  1;
            __I  uint16_t  INT_C                          :  1;
            __I  uint16_t  ReTuning_Event                 :  1;
                 uint16_t                                 :  2;
            __I  uint16_t  Error_Interrupt                :  1;
        } Normal_Interrupt_Status_bits;
    };

    union {
        __IO uint16_t  Error_Interrupt_Status;

        struct {
            __IO uint16_t  Command_Timeout_Error          :  1;
            __IO uint16_t  Command_CRC_Error              :  1;
            __IO uint16_t  Command_End_Bit_Error          :  1;
            __IO uint16_t  Command_Index_Error            :  1;
            __IO uint16_t  Data_Timeout_Error             :  1;
            __IO uint16_t  Data_CRC_Error                 :  1;
            __IO uint16_t  Data_End_Bit_Error             :  1;
            __IO uint16_t  Current_Limit_Error            :  1;
            __IO uint16_t  Auto_CMD_Error                 :  1;
            __IO uint16_t  ADMA_Error                     :  1;
            __IO uint16_t  Tuning_Error                   :  1;
        } Error_Interrupt_Status_bits;
    };

    union {
        __IO uint16_t  Normal_Interrupt_Status_Enable;

        struct {
            __IO uint16_t  Command_Complete_Status_Enable :  1;
            __IO uint16_t  Transfer_Complete_Status_Enable :  1;
            __IO uint16_t  Block_Gap_Event_Status_Enable  :  1;
            __IO uint16_t  DMA_Interrupt_Status_Enable    :  1;
            __IO uint16_t  Buffer_Write_Ready_Status_Enable :  1;
            __IO uint16_t  Buffer_Read_Ready_Status_Enable :  1;
            __IO uint16_t  Card_Insertion_Status_Enable   :  1;
            __IO uint16_t  Card_Removal_Status_Enable     :  1;
            __IO uint16_t  Card_Interrupt_Status_Enable   :  1;
            __IO uint16_t  INT_A_Status_Enable            :  1;
            __IO uint16_t  INT_B_Status_Enable            :  1;
            __IO uint16_t  INT_C_Status_Enable            :  1;
            __IO uint16_t  ReTuning_Event_Status_Enable   :  1;
        } Normal_Interrupt_Status_Enable_bits;
    };

    union {
        __IO uint16_t  Error_Interrupt_Status_Enable;

        struct {
            __IO uint16_t  Command_Timeout_Error_Status_Enable :  1;
            __IO uint16_t  Command_CRC_Error_Status_Enable :  1;
            __IO uint16_t  Command_End_Bit_Error_Status_Enable :  1;
            __IO uint16_t  Command_Index_Error_Status_Enable :  1;
            __IO uint16_t  Data_Timeout_Error_Status_Enable :  1;
            __IO uint16_t  Data_CRC_Error_Status_Enable   :  1;
            __IO uint16_t  Data_End_Bit_Error_Status_Enable :  1;
            __IO uint16_t  Current_Limit_Error_Status_Enable :  1;
            __IO uint16_t  Auto_CMD_Error_Status_Enable   :  1;
            __IO uint16_t  ADMA_Error_Status_Enable       :  1;
            __IO uint16_t  Tuning_Error_Status_Enable     :  1;
        } Error_Interrupt_Status_Enable_bits;
    };

    union {
        __IO uint16_t  Normal_Interrupt_Signal_Enable;

        struct {
            __IO uint16_t  Command_Complete_Signal_Enable :  1;
            __IO uint16_t  Transfer_Complete_Signal_Enable :  1;
            __IO uint16_t  Block_Gap_Event_Signal_Enable  :  1;
            __IO uint16_t  DMA_Interrupt_Signal_Enable    :  1;
            __IO uint16_t  Buffer_Write_Ready_Signal_Enable :  1;
            __IO uint16_t  Buffer_Read_Ready_Signal_Enable :  1;
            __IO uint16_t  Card_Insertion_Signal_Enable   :  1;
            __IO uint16_t  Card_Removal_Signal_Enable     :  1;
            __IO uint16_t  Card_Interrupt_Signal_Enable   :  1;
            __IO uint16_t  INT_A_Signal_Enable            :  1;
            __IO uint16_t  INT_B_Signal_Enable            :  1;
            __IO uint16_t  INT_C_Signal_Enable            :  1;
            __IO uint16_t  ReTuning_Event_Signal_Enable   :  1;
        } Normal_Interrupt_Signal_Enable_bits;
    };

    union {
        __IO uint16_t  Error_Interrupt_Signal_Enable;

        struct {
            __IO uint16_t  Command_Timeout_Error_Signal_Enable :  1;
            __IO uint16_t  Command_CRC_Error_Signal_Enable :  1;
            __IO uint16_t  Command_End_Bit_Error_Signal_Enable :  1;
            __IO uint16_t  Command_Index_Error_Signal_Enable :  1;
            __IO uint16_t  Data_Timeout_Error_Signal_Enable :  1;
            __IO uint16_t  Data_CRC_Error_Signal_Enable   :  1;
            __IO uint16_t  Data_End_Bit_Error_Signal_Enable :  1;
            __IO uint16_t  Current_Limit_Error_Signal_Enable :  1;
            __IO uint16_t  Auto_CMD_Error_Signal_Enable   :  1;
            __IO uint16_t  ADMA_Error_Signal_Enable       :  1;
            __IO uint16_t  Tuning_Error_Signal_Enable     :  1;
        } Error_Interrupt_Signal_Enable_bits;
    };

    union {
        __I  uint16_t  Auto_CMD_Error_Status;

        struct {
            __I  uint16_t  Auto_CMD12_Npt_Executed        :  1;
            __I  uint16_t  Auto_CMD_Timeout_Error         :  1;
            __I  uint16_t  Auto_CMD_CRC_Error             :  1;
            __I  uint16_t  Auto_CMD_End_Bit_Error         :  1;
            __I  uint16_t  Auto_CMD_Index_Error           :  1;
                 uint16_t                                 :  2;
            __I  uint16_t  Command_Not_Issued_By_Auto_CMD12_Error :  1;
        } Auto_CMD_Error_Status_bits;
    };

    union {
        __IO uint16_t  Host_Control_2;

        struct {
            __IO uint16_t  UHS_Mode_Select                :  3;
            __IO uint16_t  V1p8_Signaling_Enable          :  1;
            __IO uint16_t  Driver_Strength_Select         :  2;
            __IO uint16_t  Execute_Tuning                 :  1;
            __IO uint16_t  Sampling_Clock_Select          :  1;
                 uint16_t                                 :  6;
            __IO uint16_t  Asynchronous_Interrupt_Enable  :  1;
            __IO uint16_t  Preset_Value_Enable            :  1;
        } Host_Control_2_bits;
    };

    union {
        __I  uint64_t  Capabilities;

        struct {
            __I  uint64_t  Timeout_Clock_Frequency        :  6;
                 uint64_t                                 :  1;
            __I  uint64_t  Timeout_Clock_Count            :  1;
            __I  uint64_t  Base_Clock_Frequency_For_SD_Clock :  8;
            __I  uint64_t  Max_Block_Length               :  2;
            __I  uint64_t  B8_Support_for_Embedded_Device :  1;
            __I  uint64_t  ADMA2_Support                  :  1;
            __I  uint64_t  ADMA1_Support                  :  1;
            __I  uint64_t  High_Speed_Support             :  1;
            __I  uint64_t  SDMA_Support                   :  1;
            __I  uint64_t  Suspend_Resume_Support         :  1;
            __I  uint64_t  Voltage_Support_3p3V           :  1;
            __I  uint64_t  Voltage_Support_3p0V           :  1;
            __I  uint64_t  Voltage_Support_1p8V           :  1;
                 uint64_t                                 :  1;
            __I  uint64_t  B64_System_Bus_Support         :  1;
            __I  uint64_t  Asynchronous_Interrupt_Support :  1;
            __I  uint64_t  Slot_Type                      :  2;
            __I  uint64_t  SDR50_Support                  :  1;
            __I  uint64_t  SDR104_Support                 :  1;
            __I  uint64_t  DDR50_Support                  :  1;
                 uint64_t                                 :  1;
            __I  uint64_t  Driver_Type_A_Support          :  1;
            __I  uint64_t  Driver_Type_C_Support          :  1;
            __I  uint64_t  Driver_Type_D_Support          :  1;
                 uint64_t                                 :  1;
            __I  uint64_t  Timer_Count_for_ReTuning       :  4;
                 uint64_t                                 :  1;
            __I  uint64_t  User_Tuning_for_SDR50          :  1;
            __I  uint64_t  ReTuning_Modes                 :  2;
            __I  uint64_t  Clock_Multiplier               :  8;
        } Capabilities_bits;
    };

    union {
        __I  uint64_t  Maximum_Current_Capabilities;

        struct {
            __I  uint64_t  Maximum_Current_for_3p3V       :  8;
            __I  uint64_t  Maximum_Current_for_3p0V       :  8;
            __I  uint64_t  Maximum_Current_for_1p8V       :  8;
        } Maximum_Current_Capabilities_bits;
    };

    union {
        __O  uint16_t  Force_Event_for_Auto_CMD_Error_Status;

        struct {
            __O  uint16_t  Force_Event_for_Auto_CMD12_Not_Executed :  1;
            __O  uint16_t  Force_Event_for_Auto_CMD_Timeout_Error :  1;
            __O  uint16_t  Force_Event_for_Auto_CMD_CRC_Error :  1;
            __O  uint16_t  Force_Event_for_Auto_CMD_End_Bit_Error :  1;
            __O  uint16_t  Force_Event_for_Auto_CMD_Index_Error :  1;
                 uint16_t                                 :  2;
            __O  uint16_t  Force_Event_for_Command_Not_Issued_By_Auto_CMD12_Error :  1;
        } Force_Event_for_Auto_CMD_Error_Status_bits;
    };

    union {
        __O  uint16_t  Force_Event_for_Error_Interrupt_Status;

        struct {
            __O  uint16_t  Force_Event_for_Command_Timeout_Error :  1;
            __O  uint16_t  Force_Event_for_Command_CRC_Error :  1;
            __O  uint16_t  Force_Event_for_Command_End_Bit_Error :  1;
            __O  uint16_t  Force_Event_for_Command_Index_Error :  1;
            __O  uint16_t  Force_Event_for_Data_Timeout_Error :  1;
            __O  uint16_t  Force_Event_for_Data_CRC_Error :  1;
            __O  uint16_t  Force_Event_for_Data_End_Bit_Error :  1;
            __O  uint16_t  Force_Event_for_Current_Limit_Error :  1;
            __O  uint16_t  Force_Event_for_Auto_CMD_Error :  1;
            __O  uint16_t  Force_Event_for_ADMA_Error     :  1;
                 uint16_t                                 :  2;
            __O  uint16_t  Force_Event_for_AHB_Response_Error :  1;
        } Force_Event_for_Error_Interrupt_Status_bits;
    };

    union {
        __I  uint8_t   ADMA_Error_Status;

        struct {
            __I  uint8_t   ADMA_Error_State               :  2;
            __I  uint8_t   ADMA_Length_Mismatch_Error     :  1;
        } ADMA_Error_Status_bits;
    };

    __I  uint8_t   RESERVED2[3];

    union {
        __IO uint64_t  ADMA_System_Address;

        struct {
            __IO uint64_t  ADMA_System_Address            : 32;
        } ADMA_System_Address_bits;
    };

    union {
        __I  uint16_t  Preset_Value_INIT;

        struct {
            __I  uint16_t  SDCLK_Frequency_Select_Value   : 10;
            __I  uint16_t  Clock_Generator_Select_Value   :  1;
                 uint16_t                                 :  3;
            __I  uint16_t  Driver_Strength_Select_Value   :  2;
        } Preset_Value_INIT_bits;
    };

    union {
        __I  uint16_t  Preset_Value_DS;

        struct {
            __I  uint16_t  SDCLK_Frequency_Select_Value   : 10;
            __I  uint16_t  Clock_Generator_Select_Value   :  1;
                 uint16_t                                 :  3;
            __I  uint16_t  Driver_Strength_Select_Value   :  2;
        } Preset_Value_DS_bits;
    };

    union {
        __I  uint16_t  Preset_Value_HS;

        struct {
            __I  uint16_t  SDCLK_Frequency_Select_Value   : 10;
            __I  uint16_t  Clock_Generator_Select_Value   :  1;
                 uint16_t                                 :  3;
            __I  uint16_t  Driver_Strength_Select_Value   :  2;
        } Preset_Value_HS_bits;
    };

    union {
        __I  uint16_t  Preset_Value_SDR12;

        struct {
            __I  uint16_t  SDCLK_Frequency_Select_Value   : 10;
            __I  uint16_t  Clock_Generator_Select_Value   :  1;
                 uint16_t                                 :  3;
            __I  uint16_t  Driver_Strength_Select_Value   :  2;
        } Preset_Value_SDR12_bits;
    };

    union {
        __I  uint16_t  Preset_Value_SDR25;

        struct {
            __I  uint16_t  SDCLK_Frequency_Select_Value   : 10;
            __I  uint16_t  Clock_Generator_Select_Value   :  1;
                 uint16_t                                 :  3;
            __I  uint16_t  Driver_Strength_Select_Value   :  2;
        } Preset_Value_SDR25_bits;
    };

    union {
        __I  uint16_t  Preset_Value_SDR50;

        struct {
            __I  uint16_t  SDCLK_Frequency_Select_Value   : 10;
            __I  uint16_t  Clock_Generator_Select_Value   :  1;
                 uint16_t                                 :  3;
            __I  uint16_t  Driver_Strength_Select_Value   :  2;
        } Preset_Value_SDR50_bits;
    };

    union {
        __I  uint16_t  Preset_Value_SDR104;

        struct {
            __I  uint16_t  SDCLK_Frequency_Select_Value   : 10;
            __I  uint16_t  Clock_Generator_Select_Value   :  1;
                 uint16_t                                 :  3;
            __I  uint16_t  Driver_Strength_Select_Value   :  2;
        } Preset_Value_SDR104_bits;
    };

    union {
        __I  uint16_t  Preset_Value_DDR50;

        struct {
            __I  uint16_t  SDCLK_Frequency_Select_Value   : 10;
            __I  uint16_t  Clock_Generator_Select_Value   :  1;
                 uint16_t                                 :  3;
            __I  uint16_t  Driver_Strength_Select_Value   :  2;
        } Preset_Value_DDR50_bits;
    };

    __I  uint32_t  RESERVED3[35];
    __I  uint8_t   RESERVED4[2];

    union {
        __I  uint16_t  Host_Controller_Version;

        struct {
            __I  uint16_t  Specification_Version_Number   :  8;
            __I  uint16_t  Vendor_Version_Number          :  8;
        } Host_Controller_Version_bits;
    };

    union {
        __IO uint32_t  Vendor_defined_0;

        struct {
            __IO uint32_t  p_lat_en                       :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  p_lat_off                      :  6;
                 uint32_t                                 :  2;
            __IO uint32_t  int_edge_sel                   :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  NCRC                           :  4;
        } Vendor_defined_0_bits;
    };

    union {
        __IO uint32_t  Vendor_defined_1;

        struct {
            __IO uint32_t  mmc_boot                       :  2;
            __IO uint32_t  mmc_boot_ack_en                :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  NCR                            :  4;
                 uint32_t                                 :  4;
            __IO uint32_t  NSB                            :  3;
                 uint32_t                                 :  5;
            __IO uint32_t  cmd_conflict_en                :  1;
        } Vendor_defined_1_bits;
    };

    union {
        __IO uint32_t  Vendor_defined_2;

        struct {
            __IO uint32_t  clk_ctrl_sw_rst                :  1;
        } Vendor_defined_2_bits;
    };

    union {
        __IO uint32_t  Vendor_defined_3;

        struct {
            __IO uint32_t  tuning_success_thres           :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  crc16_error_thres              :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  sd_delay_val                   :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  sd_delay_sel_bound             :  5;
        } Vendor_defined_3_bits;
    };

    union {
        __I  uint32_t  Vendor_defined_4;
    };

    union {
        __IO uint32_t  Vendor_defined_5;

        struct {
            __IO uint32_t  db_timeout                     :  4;
        } Vendor_defined_5_bits;
    };

    union {
        __IO uint32_t  Vendor_defined_6;

        struct {
            __IO uint32_t  hburst_incr                    :  1;
        } Vendor_defined_6_bits;
    };

    union {
        __IO uint32_t  Vendor_defined_7;

        struct {
            __IO uint32_t  ahb_resp_err_sts               :  1;
        } Vendor_defined_7_bits;
    };

    union {
        __IO uint32_t  Vendor_defined_8;

        struct {
            __IO uint32_t  ahb_resp_err_sts_en            :  1;
        } Vendor_defined_8_bits;
    };

    union {
        __IO uint32_t  Vendor_defined_9;

        struct {
            __IO uint32_t  ahb_resp_err_sts               :  1;
        } Vendor_defined_9_bits;
    };

    union {
        __IO uint32_t  DMA_handshake_enable;

        struct {
            __IO uint32_t  dma_hsk_en                     :  1;
        } DMA_handshake_enable_bits;
    };

    __I  uint32_t  RESERVED5[19];

    union {
        __I  uint32_t  Hardware_attributes;

        struct {
            __I  uint32_t  hw_config                      :  9;
        } Hardware_attributes_bits;
    };

    union {
        __I  uint32_t  IP_revision;
    };

/* DOM-IGNORE-END */
}AG903_SDC_Type;

#define AG903_SDC                                ((volatile AG903_SDC_Type *) AG903_SDC_BASE)                            /** SDC Base Address */


#define AG903_SDC_SDMA_System_Address_SDMA_System_Address_POS 0                                                          /** SDCSDMA_System_Address SDMA_System_Address-bit position */
#define AG903_SDC_SDMA_System_Address_SDMA_System_Address_MSK (0xffffffffUL << AG903_SDC_SDMA_System_Address_SDMA_System_Address_POS) /** SDCSDMA_System_Address SDMA_System_Address-bit mask */

#define AG903_SDC_Argument_2_Argument_2_POS                0                                                             /** SDCArgument_2 Argument_2-bit position */
#define AG903_SDC_Argument_2_Argument_2_MSK                (0xffffffffUL << AG903_SDC_Argument_2_Argument_2_POS)         /** SDCArgument_2 Argument_2-bit mask */

#define AG903_SDC_Block_Size_Transfer_Block_Size_POS       0                                                             /** SDCBlock_Size Transfer_Block_Size-bit position */
#define AG903_SDC_Block_Size_Transfer_Block_Size_MSK       (0xfffU << AG903_SDC_Block_Size_Transfer_Block_Size_POS)      /** SDCBlock_Size Transfer_Block_Size-bit mask */
#define AG903_SDC_Block_Size_Host_SDMA_Buffer_Boundary_POS 12                                                            /** SDCBlock_Size Host_SDMA_Buffer_Boundary-bit position */
#define AG903_SDC_Block_Size_Host_SDMA_Buffer_Boundary_MSK (0x7U << AG903_SDC_Block_Size_Host_SDMA_Buffer_Boundary_POS)  /** SDCBlock_Size Host_SDMA_Buffer_Boundary-bit mask */

#define AG903_SDC_Block_Count_Blocks_Count_For_Current_Transfer_POS 0                                                    /** SDCBlock_Count Blocks_Count_For_Current_Transfer-bit position */
#define AG903_SDC_Block_Count_Blocks_Count_For_Current_Transfer_MSK (0xffffU << AG903_SDC_Block_Count_Blocks_Count_For_Current_Transfer_POS) /** SDCBlock_Count Blocks_Count_For_Current_Transfer-bit mask */

#define AG903_SDC_Argument_1_Command_Argument_1_POS        0                                                             /** SDCArgument_1 Command_Argument_1-bit position */
#define AG903_SDC_Argument_1_Command_Argument_1_MSK        (0xffffffffUL << AG903_SDC_Argument_1_Command_Argument_1_POS) /** SDCArgument_1 Command_Argument_1-bit mask */

#define AG903_SDC_Transfer_Mode_DMA_Enable_POS             0                                                             /** SDCTransfer_Mode DMA_Enable-bit position */
#define AG903_SDC_Transfer_Mode_DMA_Enable_MSK             (0x1U << AG903_SDC_Transfer_Mode_DMA_Enable_POS)              /** SDCTransfer_Mode DMA_Enable-bit mask */
#define AG903_SDC_Transfer_Mode_Block_Count_Enable_POS     1                                                             /** SDCTransfer_Mode Block_Count_Enable-bit position */
#define AG903_SDC_Transfer_Mode_Block_Count_Enable_MSK     (0x1U << AG903_SDC_Transfer_Mode_Block_Count_Enable_POS)      /** SDCTransfer_Mode Block_Count_Enable-bit mask */
#define AG903_SDC_Transfer_Mode_Auto_CMD_Enable_POS        2                                                             /** SDCTransfer_Mode Auto_CMD_Enable-bit position */
#define AG903_SDC_Transfer_Mode_Auto_CMD_Enable_MSK        (0x3U << AG903_SDC_Transfer_Mode_Auto_CMD_Enable_POS)         /** SDCTransfer_Mode Auto_CMD_Enable-bit mask */
#define AG903_SDC_Transfer_Mode_Data_Transfer_Direction_Select_POS 4                                                     /** SDCTransfer_Mode Data_Transfer_Direction_Select-bit position */
#define AG903_SDC_Transfer_Mode_Data_Transfer_Direction_Select_MSK (0x1U << AG903_SDC_Transfer_Mode_Data_Transfer_Direction_Select_POS) /** SDCTransfer_Mode Data_Transfer_Direction_Select-bit mask */
#define AG903_SDC_Transfer_Mode_Multi_Single_Block_Select_POS 5                                                          /** SDCTransfer_Mode Multi_Single_Block_Select-bit position */
#define AG903_SDC_Transfer_Mode_Multi_Single_Block_Select_MSK (0x1U << AG903_SDC_Transfer_Mode_Multi_Single_Block_Select_POS) /** SDCTransfer_Mode Multi_Single_Block_Select-bit mask */

#define AG903_SDC_Command_Response_Type_Select_POS         0                                                             /** SDCCommand Response_Type_Select-bit position */
#define AG903_SDC_Command_Response_Type_Select_MSK         (0x3U << AG903_SDC_Command_Response_Type_Select_POS)          /** SDCCommand Response_Type_Select-bit mask */
#define AG903_SDC_Command_Command_CRC_Check_Enable_POS     3                                                             /** SDCCommand Command_CRC_Check_Enable-bit position */
#define AG903_SDC_Command_Command_CRC_Check_Enable_MSK     (0x1U << AG903_SDC_Command_Command_CRC_Check_Enable_POS)      /** SDCCommand Command_CRC_Check_Enable-bit mask */
#define AG903_SDC_Command_Command_Index_Check_Enable_POS   4                                                             /** SDCCommand Command_Index_Check_Enable-bit position */
#define AG903_SDC_Command_Command_Index_Check_Enable_MSK   (0x1U << AG903_SDC_Command_Command_Index_Check_Enable_POS)    /** SDCCommand Command_Index_Check_Enable-bit mask */
#define AG903_SDC_Command_Data_Present_Select_POS          5                                                             /** SDCCommand Data_Present_Select-bit position */
#define AG903_SDC_Command_Data_Present_Select_MSK          (0x1U << AG903_SDC_Command_Data_Present_Select_POS)           /** SDCCommand Data_Present_Select-bit mask */
#define AG903_SDC_Command_Command_Type_POS                 6                                                             /** SDCCommand Command_Type-bit position */
#define AG903_SDC_Command_Command_Type_MSK                 (0x3U << AG903_SDC_Command_Command_Type_POS)                  /** SDCCommand Command_Type-bit mask */
#define AG903_SDC_Command_Command_Index_POS                8                                                             /** SDCCommand Command_Index-bit position */
#define AG903_SDC_Command_Command_Index_MSK                (0x3fU << AG903_SDC_Command_Command_Index_POS)                /** SDCCommand Command_Index-bit mask */

#define AG903_SDC_Response_Command_Response_POS            0                                                             /** SDCResponse Command_Response-bit position */
#define AG903_SDC_Response_Command_Response_MSK            (0xffffffffUL << AG903_SDC_Response_Command_Response_POS)     /** SDCResponse Command_Response-bit mask */

#define AG903_SDC_Buffer_Data_Port_Buffer_Data_POS         0                                                             /** SDCBuffer_Data_Port Buffer_Data-bit position */
#define AG903_SDC_Buffer_Data_Port_Buffer_Data_MSK         (0xffffffffUL << AG903_SDC_Buffer_Data_Port_Buffer_Data_POS)  /** SDCBuffer_Data_Port Buffer_Data-bit mask */

#define AG903_SDC_Present_State_Command_Inhibit_CMD_POS    0                                                             /** SDCPresent_State Command_Inhibit_CMD-bit position */
#define AG903_SDC_Present_State_Command_Inhibit_CMD_MSK    (0x1UL << AG903_SDC_Present_State_Command_Inhibit_CMD_POS)    /** SDCPresent_State Command_Inhibit_CMD-bit mask */
#define AG903_SDC_Present_State_Command_Inhibit_LINE_POS   1                                                             /** SDCPresent_State Command_Inhibit_LINE-bit position */
#define AG903_SDC_Present_State_Command_Inhibit_LINE_MSK   (0x1UL << AG903_SDC_Present_State_Command_Inhibit_LINE_POS)   /** SDCPresent_State Command_Inhibit_LINE-bit mask */
#define AG903_SDC_Present_State_DAT_Line_Active_POS        2                                                             /** SDCPresent_State DAT_Line_Active-bit position */
#define AG903_SDC_Present_State_DAT_Line_Active_MSK        (0x1UL << AG903_SDC_Present_State_DAT_Line_Active_POS)        /** SDCPresent_State DAT_Line_Active-bit mask */
#define AG903_SDC_Present_State_Write_Transfer_Active_POS  8                                                             /** SDCPresent_State Write_Transfer_Active-bit position */
#define AG903_SDC_Present_State_Write_Transfer_Active_MSK  (0x1UL << AG903_SDC_Present_State_Write_Transfer_Active_POS)  /** SDCPresent_State Write_Transfer_Active-bit mask */
#define AG903_SDC_Present_State_Read_Transfer_Active_POS   9                                                             /** SDCPresent_State Read_Transfer_Active-bit position */
#define AG903_SDC_Present_State_Read_Transfer_Active_MSK   (0x1UL << AG903_SDC_Present_State_Read_Transfer_Active_POS)   /** SDCPresent_State Read_Transfer_Active-bit mask */
#define AG903_SDC_Present_State_Buffer_Write_Enable_POS    10                                                            /** SDCPresent_State Buffer_Write_Enable-bit position */
#define AG903_SDC_Present_State_Buffer_Write_Enable_MSK    (0x1UL << AG903_SDC_Present_State_Buffer_Write_Enable_POS)    /** SDCPresent_State Buffer_Write_Enable-bit mask */
#define AG903_SDC_Present_State_Buffer_Read_Enable_POS     11                                                            /** SDCPresent_State Buffer_Read_Enable-bit position */
#define AG903_SDC_Present_State_Buffer_Read_Enable_MSK     (0x1UL << AG903_SDC_Present_State_Buffer_Read_Enable_POS)     /** SDCPresent_State Buffer_Read_Enable-bit mask */
#define AG903_SDC_Present_State_Card_Inserted_POS          16                                                            /** SDCPresent_State Card_Inserted-bit position */
#define AG903_SDC_Present_State_Card_Inserted_MSK          (0x1UL << AG903_SDC_Present_State_Card_Inserted_POS)          /** SDCPresent_State Card_Inserted-bit mask */
#define AG903_SDC_Present_State_Card_State_Stable_POS      17                                                            /** SDCPresent_State Card_State_Stable-bit position */
#define AG903_SDC_Present_State_Card_State_Stable_MSK      (0x1UL << AG903_SDC_Present_State_Card_State_Stable_POS)      /** SDCPresent_State Card_State_Stable-bit mask */
#define AG903_SDC_Present_State_Card_Detect_Pin_Level_POS  18                                                            /** SDCPresent_State Card_Detect_Pin_Level-bit position */
#define AG903_SDC_Present_State_Card_Detect_Pin_Level_MSK  (0x1UL << AG903_SDC_Present_State_Card_Detect_Pin_Level_POS)  /** SDCPresent_State Card_Detect_Pin_Level-bit mask */
#define AG903_SDC_Present_State_Write_Protect_Switch_Pin_Level_POS 19                                                    /** SDCPresent_State Write_Protect_Switch_Pin_Level-bit position */
#define AG903_SDC_Present_State_Write_Protect_Switch_Pin_Level_MSK (0x1UL << AG903_SDC_Present_State_Write_Protect_Switch_Pin_Level_POS) /** SDCPresent_State Write_Protect_Switch_Pin_Level-bit mask */
#define AG903_SDC_Present_State_DAT_Line_Signal_Level_POS  20                                                            /** SDCPresent_State DAT_Line_Signal_Level-bit position */
#define AG903_SDC_Present_State_DAT_Line_Signal_Level_MSK  (0xfUL << AG903_SDC_Present_State_DAT_Line_Signal_Level_POS)  /** SDCPresent_State DAT_Line_Signal_Level-bit mask */
#define AG903_SDC_Present_State_CMD_Line_Signal_Level_POS  24                                                            /** SDCPresent_State CMD_Line_Signal_Level-bit position */
#define AG903_SDC_Present_State_CMD_Line_Signal_Level_MSK  (0x1UL << AG903_SDC_Present_State_CMD_Line_Signal_Level_POS)  /** SDCPresent_State CMD_Line_Signal_Level-bit mask */

#define AG903_SDC_Host_Control_1_LED_Control_POS           0                                                             /** SDCHost_Control_1 LED_Control-bit position */
#define AG903_SDC_Host_Control_1_LED_Control_MSK           (0x1U << AG903_SDC_Host_Control_1_LED_Control_POS)            /** SDCHost_Control_1 LED_Control-bit mask */
#define AG903_SDC_Host_Control_1_Data_Transfer_Width_POS   1                                                             /** SDCHost_Control_1 Data_Transfer_Width-bit position */
#define AG903_SDC_Host_Control_1_Data_Transfer_Width_MSK   (0x1U << AG903_SDC_Host_Control_1_Data_Transfer_Width_POS)    /** SDCHost_Control_1 Data_Transfer_Width-bit mask */
#define AG903_SDC_Host_Control_1_High_Speed_Enable_POS     2                                                             /** SDCHost_Control_1 High_Speed_Enable-bit position */
#define AG903_SDC_Host_Control_1_High_Speed_Enable_MSK     (0x1U << AG903_SDC_Host_Control_1_High_Speed_Enable_POS)      /** SDCHost_Control_1 High_Speed_Enable-bit mask */
#define AG903_SDC_Host_Control_1_DMA_Select_POS            3                                                             /** SDCHost_Control_1 DMA_Select-bit position */
#define AG903_SDC_Host_Control_1_DMA_Select_MSK            (0x3U << AG903_SDC_Host_Control_1_DMA_Select_POS)             /** SDCHost_Control_1 DMA_Select-bit mask */
#define AG903_SDC_Host_Control_1_Extended_Sata_Transfer_Width_POS 5                                                      /** SDCHost_Control_1 Extended_Sata_Transfer_Width-bit position */
#define AG903_SDC_Host_Control_1_Extended_Sata_Transfer_Width_MSK (0x1U << AG903_SDC_Host_Control_1_Extended_Sata_Transfer_Width_POS) /** SDCHost_Control_1 Extended_Sata_Transfer_Width-bit mask */
#define AG903_SDC_Host_Control_1_Card_Detect_Test_Level_POS 6                                                            /** SDCHost_Control_1 Card_Detect_Test_Level-bit position */
#define AG903_SDC_Host_Control_1_Card_Detect_Test_Level_MSK (0x1U << AG903_SDC_Host_Control_1_Card_Detect_Test_Level_POS) /** SDCHost_Control_1 Card_Detect_Test_Level-bit mask */
#define AG903_SDC_Host_Control_1_Card_Detect_Signal_Selection_POS 7                                                      /** SDCHost_Control_1 Card_Detect_Signal_Selection-bit position */
#define AG903_SDC_Host_Control_1_Card_Detect_Signal_Selection_MSK (0x1U << AG903_SDC_Host_Control_1_Card_Detect_Signal_Selection_POS) /** SDCHost_Control_1 Card_Detect_Signal_Selection-bit mask */

#define AG903_SDC_Power_Control_Register_SD_Bus_Power_POS  0                                                             /** SDCPower_Control_Register SD_Bus_Power-bit position */
#define AG903_SDC_Power_Control_Register_SD_Bus_Power_MSK  (0x1U << AG903_SDC_Power_Control_Register_SD_Bus_Power_POS)   /** SDCPower_Control_Register SD_Bus_Power-bit mask */
#define AG903_SDC_Power_Control_Register_SD_Bus_Voltage_Select_POS 1                                                     /** SDCPower_Control_Register SD_Bus_Voltage_Select-bit position */
#define AG903_SDC_Power_Control_Register_SD_Bus_Voltage_Select_MSK (0x7U << AG903_SDC_Power_Control_Register_SD_Bus_Voltage_Select_POS) /** SDCPower_Control_Register SD_Bus_Voltage_Select-bit mask */

#define AG903_SDC_Block_Gap_Control_Stop_At_Block_Gap_Request_POS 0                                                      /** SDCBlock_Gap_Control Stop_At_Block_Gap_Request-bit position */
#define AG903_SDC_Block_Gap_Control_Stop_At_Block_Gap_Request_MSK (0x1U << AG903_SDC_Block_Gap_Control_Stop_At_Block_Gap_Request_POS) /** SDCBlock_Gap_Control Stop_At_Block_Gap_Request-bit mask */
#define AG903_SDC_Block_Gap_Control_Continue_Request_POS   1                                                             /** SDCBlock_Gap_Control Continue_Request-bit position */
#define AG903_SDC_Block_Gap_Control_Continue_Request_MSK   (0x1U << AG903_SDC_Block_Gap_Control_Continue_Request_POS)    /** SDCBlock_Gap_Control Continue_Request-bit mask */
#define AG903_SDC_Block_Gap_Control_Read_Wait_Control_POS  2                                                             /** SDCBlock_Gap_Control Read_Wait_Control-bit position */
#define AG903_SDC_Block_Gap_Control_Read_Wait_Control_MSK  (0x1U << AG903_SDC_Block_Gap_Control_Read_Wait_Control_POS)   /** SDCBlock_Gap_Control Read_Wait_Control-bit mask */
#define AG903_SDC_Block_Gap_Control_Interrupt_At_Block_Gap_POS 3                                                         /** SDCBlock_Gap_Control Interrupt_At_Block_Gap-bit position */
#define AG903_SDC_Block_Gap_Control_Interrupt_At_Block_Gap_MSK (0x1U << AG903_SDC_Block_Gap_Control_Interrupt_At_Block_Gap_POS) /** SDCBlock_Gap_Control Interrupt_At_Block_Gap-bit mask */

#define AG903_SDC_Clock_control_Internal_Clock_Enable_POS  0                                                             /** SDCClock_control Internal_Clock_Enable-bit position */
#define AG903_SDC_Clock_control_Internal_Clock_Enable_MSK  (0x1U << AG903_SDC_Clock_control_Internal_Clock_Enable_POS)   /** SDCClock_control Internal_Clock_Enable-bit mask */
#define AG903_SDC_Clock_control_Internal_Clock_Stable_POS  1                                                             /** SDCClock_control Internal_Clock_Stable-bit position */
#define AG903_SDC_Clock_control_Internal_Clock_Stable_MSK  (0x1U << AG903_SDC_Clock_control_Internal_Clock_Stable_POS)   /** SDCClock_control Internal_Clock_Stable-bit mask */
#define AG903_SDC_Clock_control_SD_Clock_Enable_POS        2                                                             /** SDCClock_control SD_Clock_Enable-bit position */
#define AG903_SDC_Clock_control_SD_Clock_Enable_MSK        (0x1U << AG903_SDC_Clock_control_SD_Clock_Enable_POS)         /** SDCClock_control SD_Clock_Enable-bit mask */
#define AG903_SDC_Clock_control_Clock_Generator_Select_POS 5                                                             /** SDCClock_control Clock_Generator_Select-bit position */
#define AG903_SDC_Clock_control_Clock_Generator_Select_MSK (0x1U << AG903_SDC_Clock_control_Clock_Generator_Select_POS)  /** SDCClock_control Clock_Generator_Select-bit mask */
#define AG903_SDC_Clock_control_Upper_Bits_of_SDCLK_Frequency_Select_POS 6                                               /** SDCClock_control Upper_Bits_of_SDCLK_Frequency_Select-bit position */
#define AG903_SDC_Clock_control_Upper_Bits_of_SDCLK_Frequency_Select_MSK (0x3U << AG903_SDC_Clock_control_Upper_Bits_of_SDCLK_Frequency_Select_POS) /** SDCClock_control Upper_Bits_of_SDCLK_Frequency_Select-bit mask */
#define AG903_SDC_Clock_control_SDCLK_Frequency_Select_POS 8                                                             /** SDCClock_control SDCLK_Frequency_Select-bit position */
#define AG903_SDC_Clock_control_SDCLK_Frequency_Select_MSK (0xffU << AG903_SDC_Clock_control_SDCLK_Frequency_Select_POS) /** SDCClock_control SDCLK_Frequency_Select-bit mask */

#define AG903_SDC_Timeout_Control_Data_Timeout_Counter_Value_POS 0                                                       /** SDCTimeout_Control Data_Timeout_Counter_Value-bit position */
#define AG903_SDC_Timeout_Control_Data_Timeout_Counter_Value_MSK (0xfU << AG903_SDC_Timeout_Control_Data_Timeout_Counter_Value_POS) /** SDCTimeout_Control Data_Timeout_Counter_Value-bit mask */

#define AG903_SDC_Software_Reset_Software_Reset_For_All_POS 0                                                            /** SDCSoftware_Reset Software_Reset_For_All-bit position */
#define AG903_SDC_Software_Reset_Software_Reset_For_All_MSK (0x1U << AG903_SDC_Software_Reset_Software_Reset_For_All_POS) /** SDCSoftware_Reset Software_Reset_For_All-bit mask */
#define AG903_SDC_Software_Reset_Software_Reset_For_CMD_Line_POS 1                                                       /** SDCSoftware_Reset Software_Reset_For_CMD_Line-bit position */
#define AG903_SDC_Software_Reset_Software_Reset_For_CMD_Line_MSK (0x1U << AG903_SDC_Software_Reset_Software_Reset_For_CMD_Line_POS) /** SDCSoftware_Reset Software_Reset_For_CMD_Line-bit mask */
#define AG903_SDC_Software_Reset_Software_Reset_For_DAT_Line_POS 2                                                       /** SDCSoftware_Reset Software_Reset_For_DAT_Line-bit position */
#define AG903_SDC_Software_Reset_Software_Reset_For_DAT_Line_MSK (0x1U << AG903_SDC_Software_Reset_Software_Reset_For_DAT_Line_POS) /** SDCSoftware_Reset Software_Reset_For_DAT_Line-bit mask */

#define AG903_SDC_Normal_Interrupt_Status_Command_Complete_POS 0                                                         /** SDCNormal_Interrupt_Status Command_Complete-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Command_Complete_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Command_Complete_POS) /** SDCNormal_Interrupt_Status Command_Complete-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Transfer_Complete_POS 1                                                        /** SDCNormal_Interrupt_Status Transfer_Complete-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Transfer_Complete_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Transfer_Complete_POS) /** SDCNormal_Interrupt_Status Transfer_Complete-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Block_Gap_Event_POS 2                                                          /** SDCNormal_Interrupt_Status Block_Gap_Event-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Block_Gap_Event_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Block_Gap_Event_POS) /** SDCNormal_Interrupt_Status Block_Gap_Event-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_DMA_Interrupt_POS 3                                                            /** SDCNormal_Interrupt_Status DMA_Interrupt-bit position */
#define AG903_SDC_Normal_Interrupt_Status_DMA_Interrupt_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_DMA_Interrupt_POS) /** SDCNormal_Interrupt_Status DMA_Interrupt-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Butter_Write_Ready_POS 4                                                       /** SDCNormal_Interrupt_Status Butter_Write_Ready-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Butter_Write_Ready_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Butter_Write_Ready_POS) /** SDCNormal_Interrupt_Status Butter_Write_Ready-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Buffer_Read_Ready_POS 5                                                        /** SDCNormal_Interrupt_Status Buffer_Read_Ready-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Buffer_Read_Ready_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Buffer_Read_Ready_POS) /** SDCNormal_Interrupt_Status Buffer_Read_Ready-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Card_Insertion_POS 6                                                           /** SDCNormal_Interrupt_Status Card_Insertion-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Card_Insertion_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Card_Insertion_POS) /** SDCNormal_Interrupt_Status Card_Insertion-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Card_Removal_POS 7                                                             /** SDCNormal_Interrupt_Status Card_Removal-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Card_Removal_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Card_Removal_POS)  /** SDCNormal_Interrupt_Status Card_Removal-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Card_Interrupt_POS 8                                                           /** SDCNormal_Interrupt_Status Card_Interrupt-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Card_Interrupt_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Card_Interrupt_POS) /** SDCNormal_Interrupt_Status Card_Interrupt-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_INT_A_POS        9                                                             /** SDCNormal_Interrupt_Status INT_A-bit position */
#define AG903_SDC_Normal_Interrupt_Status_INT_A_MSK        (0x1U << AG903_SDC_Normal_Interrupt_Status_INT_A_POS)         /** SDCNormal_Interrupt_Status INT_A-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_INT_B_POS        10                                                            /** SDCNormal_Interrupt_Status INT_B-bit position */
#define AG903_SDC_Normal_Interrupt_Status_INT_B_MSK        (0x1U << AG903_SDC_Normal_Interrupt_Status_INT_B_POS)         /** SDCNormal_Interrupt_Status INT_B-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_INT_C_POS        11                                                            /** SDCNormal_Interrupt_Status INT_C-bit position */
#define AG903_SDC_Normal_Interrupt_Status_INT_C_MSK        (0x1U << AG903_SDC_Normal_Interrupt_Status_INT_C_POS)         /** SDCNormal_Interrupt_Status INT_C-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_ReTuning_Event_POS 12                                                          /** SDCNormal_Interrupt_Status ReTuning_Event-bit position */
#define AG903_SDC_Normal_Interrupt_Status_ReTuning_Event_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_ReTuning_Event_POS) /** SDCNormal_Interrupt_Status ReTuning_Event-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Error_Interrupt_POS 15                                                         /** SDCNormal_Interrupt_Status Error_Interrupt-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Error_Interrupt_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Error_Interrupt_POS) /** SDCNormal_Interrupt_Status Error_Interrupt-bit mask */

#define AG903_SDC_Error_Interrupt_Status_Command_Timeout_Error_POS 0                                                     /** SDCError_Interrupt_Status Command_Timeout_Error-bit position */
#define AG903_SDC_Error_Interrupt_Status_Command_Timeout_Error_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Command_Timeout_Error_POS) /** SDCError_Interrupt_Status Command_Timeout_Error-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Command_CRC_Error_POS 1                                                         /** SDCError_Interrupt_Status Command_CRC_Error-bit position */
#define AG903_SDC_Error_Interrupt_Status_Command_CRC_Error_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Command_CRC_Error_POS) /** SDCError_Interrupt_Status Command_CRC_Error-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Command_End_Bit_Error_POS 2                                                     /** SDCError_Interrupt_Status Command_End_Bit_Error-bit position */
#define AG903_SDC_Error_Interrupt_Status_Command_End_Bit_Error_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Command_End_Bit_Error_POS) /** SDCError_Interrupt_Status Command_End_Bit_Error-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Command_Index_Error_POS 3                                                       /** SDCError_Interrupt_Status Command_Index_Error-bit position */
#define AG903_SDC_Error_Interrupt_Status_Command_Index_Error_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Command_Index_Error_POS) /** SDCError_Interrupt_Status Command_Index_Error-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Data_Timeout_Error_POS 4                                                        /** SDCError_Interrupt_Status Data_Timeout_Error-bit position */
#define AG903_SDC_Error_Interrupt_Status_Data_Timeout_Error_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Data_Timeout_Error_POS) /** SDCError_Interrupt_Status Data_Timeout_Error-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Data_CRC_Error_POS 5                                                            /** SDCError_Interrupt_Status Data_CRC_Error-bit position */
#define AG903_SDC_Error_Interrupt_Status_Data_CRC_Error_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Data_CRC_Error_POS) /** SDCError_Interrupt_Status Data_CRC_Error-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Data_End_Bit_Error_POS 6                                                        /** SDCError_Interrupt_Status Data_End_Bit_Error-bit position */
#define AG903_SDC_Error_Interrupt_Status_Data_End_Bit_Error_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Data_End_Bit_Error_POS) /** SDCError_Interrupt_Status Data_End_Bit_Error-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Current_Limit_Error_POS 7                                                       /** SDCError_Interrupt_Status Current_Limit_Error-bit position */
#define AG903_SDC_Error_Interrupt_Status_Current_Limit_Error_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Current_Limit_Error_POS) /** SDCError_Interrupt_Status Current_Limit_Error-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Auto_CMD_Error_POS 8                                                            /** SDCError_Interrupt_Status Auto_CMD_Error-bit position */
#define AG903_SDC_Error_Interrupt_Status_Auto_CMD_Error_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Auto_CMD_Error_POS) /** SDCError_Interrupt_Status Auto_CMD_Error-bit mask */
#define AG903_SDC_Error_Interrupt_Status_ADMA_Error_POS    9                                                             /** SDCError_Interrupt_Status ADMA_Error-bit position */
#define AG903_SDC_Error_Interrupt_Status_ADMA_Error_MSK    (0x1U << AG903_SDC_Error_Interrupt_Status_ADMA_Error_POS)     /** SDCError_Interrupt_Status ADMA_Error-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Tuning_Error_POS  10                                                            /** SDCError_Interrupt_Status Tuning_Error-bit position */
#define AG903_SDC_Error_Interrupt_Status_Tuning_Error_MSK  (0x1U << AG903_SDC_Error_Interrupt_Status_Tuning_Error_POS)   /** SDCError_Interrupt_Status Tuning_Error-bit mask */

#define AG903_SDC_Normal_Interrupt_Status_Enable_Command_Complete_Status_Enable_POS 0                                    /** SDCNormal_Interrupt_Status_Enable Command_Complete_Status_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Command_Complete_Status_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Enable_Command_Complete_Status_Enable_POS) /** SDCNormal_Interrupt_Status_Enable Command_Complete_Status_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Transfer_Complete_Status_Enable_POS 1                                   /** SDCNormal_Interrupt_Status_Enable Transfer_Complete_Status_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Transfer_Complete_Status_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Enable_Transfer_Complete_Status_Enable_POS) /** SDCNormal_Interrupt_Status_Enable Transfer_Complete_Status_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Block_Gap_Event_Status_Enable_POS 2                                     /** SDCNormal_Interrupt_Status_Enable Block_Gap_Event_Status_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Block_Gap_Event_Status_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Enable_Block_Gap_Event_Status_Enable_POS) /** SDCNormal_Interrupt_Status_Enable Block_Gap_Event_Status_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Enable_DMA_Interrupt_Status_Enable_POS 3                                       /** SDCNormal_Interrupt_Status_Enable DMA_Interrupt_Status_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Enable_DMA_Interrupt_Status_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Enable_DMA_Interrupt_Status_Enable_POS) /** SDCNormal_Interrupt_Status_Enable DMA_Interrupt_Status_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Buffer_Write_Ready_Status_Enable_POS 4                                  /** SDCNormal_Interrupt_Status_Enable Buffer_Write_Ready_Status_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Buffer_Write_Ready_Status_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Enable_Buffer_Write_Ready_Status_Enable_POS) /** SDCNormal_Interrupt_Status_Enable Buffer_Write_Ready_Status_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Buffer_Read_Ready_Status_Enable_POS 5                                   /** SDCNormal_Interrupt_Status_Enable Buffer_Read_Ready_Status_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Buffer_Read_Ready_Status_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Enable_Buffer_Read_Ready_Status_Enable_POS) /** SDCNormal_Interrupt_Status_Enable Buffer_Read_Ready_Status_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Card_Insertion_Status_Enable_POS 6                                      /** SDCNormal_Interrupt_Status_Enable Card_Insertion_Status_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Card_Insertion_Status_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Enable_Card_Insertion_Status_Enable_POS) /** SDCNormal_Interrupt_Status_Enable Card_Insertion_Status_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Card_Removal_Status_Enable_POS 7                                        /** SDCNormal_Interrupt_Status_Enable Card_Removal_Status_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Card_Removal_Status_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Enable_Card_Removal_Status_Enable_POS) /** SDCNormal_Interrupt_Status_Enable Card_Removal_Status_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Card_Interrupt_Status_Enable_POS 8                                      /** SDCNormal_Interrupt_Status_Enable Card_Interrupt_Status_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Enable_Card_Interrupt_Status_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Enable_Card_Interrupt_Status_Enable_POS) /** SDCNormal_Interrupt_Status_Enable Card_Interrupt_Status_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Enable_INT_A_Status_Enable_POS 9                                               /** SDCNormal_Interrupt_Status_Enable INT_A_Status_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Enable_INT_A_Status_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Enable_INT_A_Status_Enable_POS) /** SDCNormal_Interrupt_Status_Enable INT_A_Status_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Enable_INT_B_Status_Enable_POS 10                                              /** SDCNormal_Interrupt_Status_Enable INT_B_Status_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Enable_INT_B_Status_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Enable_INT_B_Status_Enable_POS) /** SDCNormal_Interrupt_Status_Enable INT_B_Status_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Enable_INT_C_Status_Enable_POS 11                                              /** SDCNormal_Interrupt_Status_Enable INT_C_Status_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Enable_INT_C_Status_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Enable_INT_C_Status_Enable_POS) /** SDCNormal_Interrupt_Status_Enable INT_C_Status_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Status_Enable_ReTuning_Event_Status_Enable_POS 12                                     /** SDCNormal_Interrupt_Status_Enable ReTuning_Event_Status_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Status_Enable_ReTuning_Event_Status_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Status_Enable_ReTuning_Event_Status_Enable_POS) /** SDCNormal_Interrupt_Status_Enable ReTuning_Event_Status_Enable-bit mask */

#define AG903_SDC_Error_Interrupt_Status_Enable_Command_Timeout_Error_Status_Enable_POS 0                                /** SDCError_Interrupt_Status_Enable Command_Timeout_Error_Status_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Status_Enable_Command_Timeout_Error_Status_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Enable_Command_Timeout_Error_Status_Enable_POS) /** SDCError_Interrupt_Status_Enable Command_Timeout_Error_Status_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Enable_Command_CRC_Error_Status_Enable_POS 1                                    /** SDCError_Interrupt_Status_Enable Command_CRC_Error_Status_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Status_Enable_Command_CRC_Error_Status_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Enable_Command_CRC_Error_Status_Enable_POS) /** SDCError_Interrupt_Status_Enable Command_CRC_Error_Status_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Enable_Command_End_Bit_Error_Status_Enable_POS 2                                /** SDCError_Interrupt_Status_Enable Command_End_Bit_Error_Status_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Status_Enable_Command_End_Bit_Error_Status_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Enable_Command_End_Bit_Error_Status_Enable_POS) /** SDCError_Interrupt_Status_Enable Command_End_Bit_Error_Status_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Enable_Command_Index_Error_Status_Enable_POS 3                                  /** SDCError_Interrupt_Status_Enable Command_Index_Error_Status_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Status_Enable_Command_Index_Error_Status_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Enable_Command_Index_Error_Status_Enable_POS) /** SDCError_Interrupt_Status_Enable Command_Index_Error_Status_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Enable_Data_Timeout_Error_Status_Enable_POS 4                                   /** SDCError_Interrupt_Status_Enable Data_Timeout_Error_Status_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Status_Enable_Data_Timeout_Error_Status_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Enable_Data_Timeout_Error_Status_Enable_POS) /** SDCError_Interrupt_Status_Enable Data_Timeout_Error_Status_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Enable_Data_CRC_Error_Status_Enable_POS 5                                       /** SDCError_Interrupt_Status_Enable Data_CRC_Error_Status_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Status_Enable_Data_CRC_Error_Status_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Enable_Data_CRC_Error_Status_Enable_POS) /** SDCError_Interrupt_Status_Enable Data_CRC_Error_Status_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Enable_Data_End_Bit_Error_Status_Enable_POS 6                                   /** SDCError_Interrupt_Status_Enable Data_End_Bit_Error_Status_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Status_Enable_Data_End_Bit_Error_Status_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Enable_Data_End_Bit_Error_Status_Enable_POS) /** SDCError_Interrupt_Status_Enable Data_End_Bit_Error_Status_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Enable_Current_Limit_Error_Status_Enable_POS 7                                  /** SDCError_Interrupt_Status_Enable Current_Limit_Error_Status_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Status_Enable_Current_Limit_Error_Status_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Enable_Current_Limit_Error_Status_Enable_POS) /** SDCError_Interrupt_Status_Enable Current_Limit_Error_Status_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Enable_Auto_CMD_Error_Status_Enable_POS 8                                       /** SDCError_Interrupt_Status_Enable Auto_CMD_Error_Status_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Status_Enable_Auto_CMD_Error_Status_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Enable_Auto_CMD_Error_Status_Enable_POS) /** SDCError_Interrupt_Status_Enable Auto_CMD_Error_Status_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Enable_ADMA_Error_Status_Enable_POS 9                                           /** SDCError_Interrupt_Status_Enable ADMA_Error_Status_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Status_Enable_ADMA_Error_Status_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Enable_ADMA_Error_Status_Enable_POS) /** SDCError_Interrupt_Status_Enable ADMA_Error_Status_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Status_Enable_Tuning_Error_Status_Enable_POS 10                                        /** SDCError_Interrupt_Status_Enable Tuning_Error_Status_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Status_Enable_Tuning_Error_Status_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Status_Enable_Tuning_Error_Status_Enable_POS) /** SDCError_Interrupt_Status_Enable Tuning_Error_Status_Enable-bit mask */

#define AG903_SDC_Normal_Interrupt_Signal_Enable_Command_Complete_Signal_Enable_POS 0                                    /** SDCNormal_Interrupt_Signal_Enable Command_Complete_Signal_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Command_Complete_Signal_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Signal_Enable_Command_Complete_Signal_Enable_POS) /** SDCNormal_Interrupt_Signal_Enable Command_Complete_Signal_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Transfer_Complete_Signal_Enable_POS 1                                   /** SDCNormal_Interrupt_Signal_Enable Transfer_Complete_Signal_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Transfer_Complete_Signal_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Signal_Enable_Transfer_Complete_Signal_Enable_POS) /** SDCNormal_Interrupt_Signal_Enable Transfer_Complete_Signal_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Block_Gap_Event_Signal_Enable_POS 2                                     /** SDCNormal_Interrupt_Signal_Enable Block_Gap_Event_Signal_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Block_Gap_Event_Signal_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Signal_Enable_Block_Gap_Event_Signal_Enable_POS) /** SDCNormal_Interrupt_Signal_Enable Block_Gap_Event_Signal_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_DMA_Interrupt_Signal_Enable_POS 3                                       /** SDCNormal_Interrupt_Signal_Enable DMA_Interrupt_Signal_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_DMA_Interrupt_Signal_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Signal_Enable_DMA_Interrupt_Signal_Enable_POS) /** SDCNormal_Interrupt_Signal_Enable DMA_Interrupt_Signal_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Buffer_Write_Ready_Signal_Enable_POS 4                                  /** SDCNormal_Interrupt_Signal_Enable Buffer_Write_Ready_Signal_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Buffer_Write_Ready_Signal_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Signal_Enable_Buffer_Write_Ready_Signal_Enable_POS) /** SDCNormal_Interrupt_Signal_Enable Buffer_Write_Ready_Signal_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Buffer_Read_Ready_Signal_Enable_POS 5                                   /** SDCNormal_Interrupt_Signal_Enable Buffer_Read_Ready_Signal_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Buffer_Read_Ready_Signal_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Signal_Enable_Buffer_Read_Ready_Signal_Enable_POS) /** SDCNormal_Interrupt_Signal_Enable Buffer_Read_Ready_Signal_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Card_Insertion_Signal_Enable_POS 6                                      /** SDCNormal_Interrupt_Signal_Enable Card_Insertion_Signal_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Card_Insertion_Signal_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Signal_Enable_Card_Insertion_Signal_Enable_POS) /** SDCNormal_Interrupt_Signal_Enable Card_Insertion_Signal_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Card_Removal_Signal_Enable_POS 7                                        /** SDCNormal_Interrupt_Signal_Enable Card_Removal_Signal_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Card_Removal_Signal_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Signal_Enable_Card_Removal_Signal_Enable_POS) /** SDCNormal_Interrupt_Signal_Enable Card_Removal_Signal_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Card_Interrupt_Signal_Enable_POS 8                                      /** SDCNormal_Interrupt_Signal_Enable Card_Interrupt_Signal_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_Card_Interrupt_Signal_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Signal_Enable_Card_Interrupt_Signal_Enable_POS) /** SDCNormal_Interrupt_Signal_Enable Card_Interrupt_Signal_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_INT_A_Signal_Enable_POS 9                                               /** SDCNormal_Interrupt_Signal_Enable INT_A_Signal_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_INT_A_Signal_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Signal_Enable_INT_A_Signal_Enable_POS) /** SDCNormal_Interrupt_Signal_Enable INT_A_Signal_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_INT_B_Signal_Enable_POS 10                                              /** SDCNormal_Interrupt_Signal_Enable INT_B_Signal_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_INT_B_Signal_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Signal_Enable_INT_B_Signal_Enable_POS) /** SDCNormal_Interrupt_Signal_Enable INT_B_Signal_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_INT_C_Signal_Enable_POS 11                                              /** SDCNormal_Interrupt_Signal_Enable INT_C_Signal_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_INT_C_Signal_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Signal_Enable_INT_C_Signal_Enable_POS) /** SDCNormal_Interrupt_Signal_Enable INT_C_Signal_Enable-bit mask */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_ReTuning_Event_Signal_Enable_POS 12                                     /** SDCNormal_Interrupt_Signal_Enable ReTuning_Event_Signal_Enable-bit position */
#define AG903_SDC_Normal_Interrupt_Signal_Enable_ReTuning_Event_Signal_Enable_MSK (0x1U << AG903_SDC_Normal_Interrupt_Signal_Enable_ReTuning_Event_Signal_Enable_POS) /** SDCNormal_Interrupt_Signal_Enable ReTuning_Event_Signal_Enable-bit mask */

#define AG903_SDC_Error_Interrupt_Signal_Enable_Command_Timeout_Error_Signal_Enable_POS 0                                /** SDCError_Interrupt_Signal_Enable Command_Timeout_Error_Signal_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Command_Timeout_Error_Signal_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Signal_Enable_Command_Timeout_Error_Signal_Enable_POS) /** SDCError_Interrupt_Signal_Enable Command_Timeout_Error_Signal_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Command_CRC_Error_Signal_Enable_POS 1                                    /** SDCError_Interrupt_Signal_Enable Command_CRC_Error_Signal_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Command_CRC_Error_Signal_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Signal_Enable_Command_CRC_Error_Signal_Enable_POS) /** SDCError_Interrupt_Signal_Enable Command_CRC_Error_Signal_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Command_End_Bit_Error_Signal_Enable_POS 2                                /** SDCError_Interrupt_Signal_Enable Command_End_Bit_Error_Signal_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Command_End_Bit_Error_Signal_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Signal_Enable_Command_End_Bit_Error_Signal_Enable_POS) /** SDCError_Interrupt_Signal_Enable Command_End_Bit_Error_Signal_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Command_Index_Error_Signal_Enable_POS 3                                  /** SDCError_Interrupt_Signal_Enable Command_Index_Error_Signal_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Command_Index_Error_Signal_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Signal_Enable_Command_Index_Error_Signal_Enable_POS) /** SDCError_Interrupt_Signal_Enable Command_Index_Error_Signal_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Data_Timeout_Error_Signal_Enable_POS 4                                   /** SDCError_Interrupt_Signal_Enable Data_Timeout_Error_Signal_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Data_Timeout_Error_Signal_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Signal_Enable_Data_Timeout_Error_Signal_Enable_POS) /** SDCError_Interrupt_Signal_Enable Data_Timeout_Error_Signal_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Data_CRC_Error_Signal_Enable_POS 5                                       /** SDCError_Interrupt_Signal_Enable Data_CRC_Error_Signal_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Data_CRC_Error_Signal_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Signal_Enable_Data_CRC_Error_Signal_Enable_POS) /** SDCError_Interrupt_Signal_Enable Data_CRC_Error_Signal_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Data_End_Bit_Error_Signal_Enable_POS 6                                   /** SDCError_Interrupt_Signal_Enable Data_End_Bit_Error_Signal_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Data_End_Bit_Error_Signal_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Signal_Enable_Data_End_Bit_Error_Signal_Enable_POS) /** SDCError_Interrupt_Signal_Enable Data_End_Bit_Error_Signal_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Current_Limit_Error_Signal_Enable_POS 7                                  /** SDCError_Interrupt_Signal_Enable Current_Limit_Error_Signal_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Current_Limit_Error_Signal_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Signal_Enable_Current_Limit_Error_Signal_Enable_POS) /** SDCError_Interrupt_Signal_Enable Current_Limit_Error_Signal_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Auto_CMD_Error_Signal_Enable_POS 8                                       /** SDCError_Interrupt_Signal_Enable Auto_CMD_Error_Signal_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Auto_CMD_Error_Signal_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Signal_Enable_Auto_CMD_Error_Signal_Enable_POS) /** SDCError_Interrupt_Signal_Enable Auto_CMD_Error_Signal_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Signal_Enable_ADMA_Error_Signal_Enable_POS 9                                           /** SDCError_Interrupt_Signal_Enable ADMA_Error_Signal_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Signal_Enable_ADMA_Error_Signal_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Signal_Enable_ADMA_Error_Signal_Enable_POS) /** SDCError_Interrupt_Signal_Enable ADMA_Error_Signal_Enable-bit mask */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Tuning_Error_Signal_Enable_POS 10                                        /** SDCError_Interrupt_Signal_Enable Tuning_Error_Signal_Enable-bit position */
#define AG903_SDC_Error_Interrupt_Signal_Enable_Tuning_Error_Signal_Enable_MSK (0x1U << AG903_SDC_Error_Interrupt_Signal_Enable_Tuning_Error_Signal_Enable_POS) /** SDCError_Interrupt_Signal_Enable Tuning_Error_Signal_Enable-bit mask */

#define AG903_SDC_Auto_CMD_Error_Status_Auto_CMD12_Npt_Executed_POS 0                                                    /** SDCAuto_CMD_Error_Status Auto_CMD12_Npt_Executed-bit position */
#define AG903_SDC_Auto_CMD_Error_Status_Auto_CMD12_Npt_Executed_MSK (0x1U << AG903_SDC_Auto_CMD_Error_Status_Auto_CMD12_Npt_Executed_POS) /** SDCAuto_CMD_Error_Status Auto_CMD12_Npt_Executed-bit mask */
#define AG903_SDC_Auto_CMD_Error_Status_Auto_CMD_Timeout_Error_POS 1                                                     /** SDCAuto_CMD_Error_Status Auto_CMD_Timeout_Error-bit position */
#define AG903_SDC_Auto_CMD_Error_Status_Auto_CMD_Timeout_Error_MSK (0x1U << AG903_SDC_Auto_CMD_Error_Status_Auto_CMD_Timeout_Error_POS) /** SDCAuto_CMD_Error_Status Auto_CMD_Timeout_Error-bit mask */
#define AG903_SDC_Auto_CMD_Error_Status_Auto_CMD_CRC_Error_POS 2                                                         /** SDCAuto_CMD_Error_Status Auto_CMD_CRC_Error-bit position */
#define AG903_SDC_Auto_CMD_Error_Status_Auto_CMD_CRC_Error_MSK (0x1U << AG903_SDC_Auto_CMD_Error_Status_Auto_CMD_CRC_Error_POS) /** SDCAuto_CMD_Error_Status Auto_CMD_CRC_Error-bit mask */
#define AG903_SDC_Auto_CMD_Error_Status_Auto_CMD_End_Bit_Error_POS 3                                                     /** SDCAuto_CMD_Error_Status Auto_CMD_End_Bit_Error-bit position */
#define AG903_SDC_Auto_CMD_Error_Status_Auto_CMD_End_Bit_Error_MSK (0x1U << AG903_SDC_Auto_CMD_Error_Status_Auto_CMD_End_Bit_Error_POS) /** SDCAuto_CMD_Error_Status Auto_CMD_End_Bit_Error-bit mask */
#define AG903_SDC_Auto_CMD_Error_Status_Auto_CMD_Index_Error_POS 4                                                       /** SDCAuto_CMD_Error_Status Auto_CMD_Index_Error-bit position */
#define AG903_SDC_Auto_CMD_Error_Status_Auto_CMD_Index_Error_MSK (0x1U << AG903_SDC_Auto_CMD_Error_Status_Auto_CMD_Index_Error_POS) /** SDCAuto_CMD_Error_Status Auto_CMD_Index_Error-bit mask */
#define AG903_SDC_Auto_CMD_Error_Status_Command_Not_Issued_By_Auto_CMD12_Error_POS 7                                     /** SDCAuto_CMD_Error_Status Command_Not_Issued_By_Auto_CMD12_Error-bit position */
#define AG903_SDC_Auto_CMD_Error_Status_Command_Not_Issued_By_Auto_CMD12_Error_MSK (0x1U << AG903_SDC_Auto_CMD_Error_Status_Command_Not_Issued_By_Auto_CMD12_Error_POS) /** SDCAuto_CMD_Error_Status Command_Not_Issued_By_Auto_CMD12_Error-bit mask */

#define AG903_SDC_Host_Control_2_UHS_Mode_Select_POS       0                                                             /** SDCHost_Control_2 UHS_Mode_Select-bit position */
#define AG903_SDC_Host_Control_2_UHS_Mode_Select_MSK       (0x7U << AG903_SDC_Host_Control_2_UHS_Mode_Select_POS)        /** SDCHost_Control_2 UHS_Mode_Select-bit mask */
#define AG903_SDC_Host_Control_2_V1p8_Signaling_Enable_POS 3                                                             /** SDCHost_Control_2 V1p8_Signaling_Enable-bit position */
#define AG903_SDC_Host_Control_2_V1p8_Signaling_Enable_MSK (0x1U << AG903_SDC_Host_Control_2_V1p8_Signaling_Enable_POS)  /** SDCHost_Control_2 V1p8_Signaling_Enable-bit mask */
#define AG903_SDC_Host_Control_2_Driver_Strength_Select_POS 4                                                            /** SDCHost_Control_2 Driver_Strength_Select-bit position */
#define AG903_SDC_Host_Control_2_Driver_Strength_Select_MSK (0x3U << AG903_SDC_Host_Control_2_Driver_Strength_Select_POS) /** SDCHost_Control_2 Driver_Strength_Select-bit mask */
#define AG903_SDC_Host_Control_2_Execute_Tuning_POS        6                                                             /** SDCHost_Control_2 Execute_Tuning-bit position */
#define AG903_SDC_Host_Control_2_Execute_Tuning_MSK        (0x1U << AG903_SDC_Host_Control_2_Execute_Tuning_POS)         /** SDCHost_Control_2 Execute_Tuning-bit mask */
#define AG903_SDC_Host_Control_2_Sampling_Clock_Select_POS 7                                                             /** SDCHost_Control_2 Sampling_Clock_Select-bit position */
#define AG903_SDC_Host_Control_2_Sampling_Clock_Select_MSK (0x1U << AG903_SDC_Host_Control_2_Sampling_Clock_Select_POS)  /** SDCHost_Control_2 Sampling_Clock_Select-bit mask */
#define AG903_SDC_Host_Control_2_Asynchronous_Interrupt_Enable_POS 14                                                    /** SDCHost_Control_2 Asynchronous_Interrupt_Enable-bit position */
#define AG903_SDC_Host_Control_2_Asynchronous_Interrupt_Enable_MSK (0x1U << AG903_SDC_Host_Control_2_Asynchronous_Interrupt_Enable_POS) /** SDCHost_Control_2 Asynchronous_Interrupt_Enable-bit mask */
#define AG903_SDC_Host_Control_2_Preset_Value_Enable_POS   15                                                            /** SDCHost_Control_2 Preset_Value_Enable-bit position */
#define AG903_SDC_Host_Control_2_Preset_Value_Enable_MSK   (0x1U << AG903_SDC_Host_Control_2_Preset_Value_Enable_POS)    /** SDCHost_Control_2 Preset_Value_Enable-bit mask */

#define AG903_SDC_Capabilities_Timeout_Clock_Frequency_POS 0                                                             /** SDCCapabilities Timeout_Clock_Frequency-bit position */
#define AG903_SDC_Capabilities_Timeout_Clock_Frequency_MSK (0x3fULL << AG903_SDC_Capabilities_Timeout_Clock_Frequency_POS) /** SDCCapabilities Timeout_Clock_Frequency-bit mask */
#define AG903_SDC_Capabilities_Timeout_Clock_Count_POS     7                                                             /** SDCCapabilities Timeout_Clock_Count-bit position */
#define AG903_SDC_Capabilities_Timeout_Clock_Count_MSK     (0x1ULL << AG903_SDC_Capabilities_Timeout_Clock_Count_POS)    /** SDCCapabilities Timeout_Clock_Count-bit mask */
#define AG903_SDC_Capabilities_Base_Clock_Frequency_For_SD_Clock_POS 8                                                   /** SDCCapabilities Base_Clock_Frequency_For_SD_Clock-bit position */
#define AG903_SDC_Capabilities_Base_Clock_Frequency_For_SD_Clock_MSK (0xffULL << AG903_SDC_Capabilities_Base_Clock_Frequency_For_SD_Clock_POS) /** SDCCapabilities Base_Clock_Frequency_For_SD_Clock-bit mask */
#define AG903_SDC_Capabilities_Max_Block_Length_POS        16                                                            /** SDCCapabilities Max_Block_Length-bit position */
#define AG903_SDC_Capabilities_Max_Block_Length_MSK        (0x3ULL << AG903_SDC_Capabilities_Max_Block_Length_POS)       /** SDCCapabilities Max_Block_Length-bit mask */
#define AG903_SDC_Capabilities_B8_Support_for_Embedded_Device_POS 18                                                     /** SDCCapabilities B8_Support_for_Embedded_Device-bit position */
#define AG903_SDC_Capabilities_B8_Support_for_Embedded_Device_MSK (0x1ULL << AG903_SDC_Capabilities_B8_Support_for_Embedded_Device_POS) /** SDCCapabilities B8_Support_for_Embedded_Device-bit mask */
#define AG903_SDC_Capabilities_ADMA2_Support_POS           19                                                            /** SDCCapabilities ADMA2_Support-bit position */
#define AG903_SDC_Capabilities_ADMA2_Support_MSK           (0x1ULL << AG903_SDC_Capabilities_ADMA2_Support_POS)          /** SDCCapabilities ADMA2_Support-bit mask */
#define AG903_SDC_Capabilities_ADMA1_Support_POS           20                                                            /** SDCCapabilities ADMA1_Support-bit position */
#define AG903_SDC_Capabilities_ADMA1_Support_MSK           (0x1ULL << AG903_SDC_Capabilities_ADMA1_Support_POS)          /** SDCCapabilities ADMA1_Support-bit mask */
#define AG903_SDC_Capabilities_High_Speed_Support_POS      21                                                            /** SDCCapabilities High_Speed_Support-bit position */
#define AG903_SDC_Capabilities_High_Speed_Support_MSK      (0x1ULL << AG903_SDC_Capabilities_High_Speed_Support_POS)     /** SDCCapabilities High_Speed_Support-bit mask */
#define AG903_SDC_Capabilities_SDMA_Support_POS            22                                                            /** SDCCapabilities SDMA_Support-bit position */
#define AG903_SDC_Capabilities_SDMA_Support_MSK            (0x1ULL << AG903_SDC_Capabilities_SDMA_Support_POS)           /** SDCCapabilities SDMA_Support-bit mask */
#define AG903_SDC_Capabilities_Suspend_Resume_Support_POS  23                                                            /** SDCCapabilities Suspend_Resume_Support-bit position */
#define AG903_SDC_Capabilities_Suspend_Resume_Support_MSK  (0x1ULL << AG903_SDC_Capabilities_Suspend_Resume_Support_POS) /** SDCCapabilities Suspend_Resume_Support-bit mask */
#define AG903_SDC_Capabilities_Voltage_Support_3p3V_POS    24                                                            /** SDCCapabilities Voltage_Support_3p3V-bit position */
#define AG903_SDC_Capabilities_Voltage_Support_3p3V_MSK    (0x1ULL << AG903_SDC_Capabilities_Voltage_Support_3p3V_POS)   /** SDCCapabilities Voltage_Support_3p3V-bit mask */
#define AG903_SDC_Capabilities_Voltage_Support_3p0V_POS    25                                                            /** SDCCapabilities Voltage_Support_3p0V-bit position */
#define AG903_SDC_Capabilities_Voltage_Support_3p0V_MSK    (0x1ULL << AG903_SDC_Capabilities_Voltage_Support_3p0V_POS)   /** SDCCapabilities Voltage_Support_3p0V-bit mask */
#define AG903_SDC_Capabilities_Voltage_Support_1p8V_POS    26                                                            /** SDCCapabilities Voltage_Support_1p8V-bit position */
#define AG903_SDC_Capabilities_Voltage_Support_1p8V_MSK    (0x1ULL << AG903_SDC_Capabilities_Voltage_Support_1p8V_POS)   /** SDCCapabilities Voltage_Support_1p8V-bit mask */
#define AG903_SDC_Capabilities_B64_System_Bus_Support_POS  28                                                            /** SDCCapabilities B64_System_Bus_Support-bit position */
#define AG903_SDC_Capabilities_B64_System_Bus_Support_MSK  (0x1ULL << AG903_SDC_Capabilities_B64_System_Bus_Support_POS) /** SDCCapabilities B64_System_Bus_Support-bit mask */
#define AG903_SDC_Capabilities_Asynchronous_Interrupt_Support_POS 29                                                     /** SDCCapabilities Asynchronous_Interrupt_Support-bit position */
#define AG903_SDC_Capabilities_Asynchronous_Interrupt_Support_MSK (0x1ULL << AG903_SDC_Capabilities_Asynchronous_Interrupt_Support_POS) /** SDCCapabilities Asynchronous_Interrupt_Support-bit mask */
#define AG903_SDC_Capabilities_Slot_Type_POS               30                                                            /** SDCCapabilities Slot_Type-bit position */
#define AG903_SDC_Capabilities_Slot_Type_MSK               (0x3ULL << AG903_SDC_Capabilities_Slot_Type_POS)              /** SDCCapabilities Slot_Type-bit mask */
#define AG903_SDC_Capabilities_SDR50_Support_POS           32                                                            /** SDCCapabilities SDR50_Support-bit position */
#define AG903_SDC_Capabilities_SDR50_Support_MSK           (0x1ULL << AG903_SDC_Capabilities_SDR50_Support_POS)          /** SDCCapabilities SDR50_Support-bit mask */
#define AG903_SDC_Capabilities_SDR104_Support_POS          33                                                            /** SDCCapabilities SDR104_Support-bit position */
#define AG903_SDC_Capabilities_SDR104_Support_MSK          (0x1ULL << AG903_SDC_Capabilities_SDR104_Support_POS)         /** SDCCapabilities SDR104_Support-bit mask */
#define AG903_SDC_Capabilities_DDR50_Support_POS           34                                                            /** SDCCapabilities DDR50_Support-bit position */
#define AG903_SDC_Capabilities_DDR50_Support_MSK           (0x1ULL << AG903_SDC_Capabilities_DDR50_Support_POS)          /** SDCCapabilities DDR50_Support-bit mask */
#define AG903_SDC_Capabilities_Driver_Type_A_Support_POS   36                                                            /** SDCCapabilities Driver_Type_A_Support-bit position */
#define AG903_SDC_Capabilities_Driver_Type_A_Support_MSK   (0x1ULL << AG903_SDC_Capabilities_Driver_Type_A_Support_POS)  /** SDCCapabilities Driver_Type_A_Support-bit mask */
#define AG903_SDC_Capabilities_Driver_Type_C_Support_POS   37                                                            /** SDCCapabilities Driver_Type_C_Support-bit position */
#define AG903_SDC_Capabilities_Driver_Type_C_Support_MSK   (0x1ULL << AG903_SDC_Capabilities_Driver_Type_C_Support_POS)  /** SDCCapabilities Driver_Type_C_Support-bit mask */
#define AG903_SDC_Capabilities_Driver_Type_D_Support_POS   38                                                            /** SDCCapabilities Driver_Type_D_Support-bit position */
#define AG903_SDC_Capabilities_Driver_Type_D_Support_MSK   (0x1ULL << AG903_SDC_Capabilities_Driver_Type_D_Support_POS)  /** SDCCapabilities Driver_Type_D_Support-bit mask */
#define AG903_SDC_Capabilities_Timer_Count_for_ReTuning_POS 40                                                           /** SDCCapabilities Timer_Count_for_ReTuning-bit position */
#define AG903_SDC_Capabilities_Timer_Count_for_ReTuning_MSK (0xfULL << AG903_SDC_Capabilities_Timer_Count_for_ReTuning_POS) /** SDCCapabilities Timer_Count_for_ReTuning-bit mask */
#define AG903_SDC_Capabilities_User_Tuning_for_SDR50_POS   45                                                            /** SDCCapabilities User_Tuning_for_SDR50-bit position */
#define AG903_SDC_Capabilities_User_Tuning_for_SDR50_MSK   (0x1ULL << AG903_SDC_Capabilities_User_Tuning_for_SDR50_POS)  /** SDCCapabilities User_Tuning_for_SDR50-bit mask */
#define AG903_SDC_Capabilities_ReTuning_Modes_POS          46                                                            /** SDCCapabilities ReTuning_Modes-bit position */
#define AG903_SDC_Capabilities_ReTuning_Modes_MSK          (0x3ULL << AG903_SDC_Capabilities_ReTuning_Modes_POS)         /** SDCCapabilities ReTuning_Modes-bit mask */
#define AG903_SDC_Capabilities_Clock_Multiplier_POS        48                                                            /** SDCCapabilities Clock_Multiplier-bit position */
#define AG903_SDC_Capabilities_Clock_Multiplier_MSK        (0xffULL << AG903_SDC_Capabilities_Clock_Multiplier_POS)      /** SDCCapabilities Clock_Multiplier-bit mask */

#define AG903_SDC_Maximum_Current_Capabilities_Maximum_Current_for_3p3V_POS 0                                            /** SDCMaximum_Current_Capabilities Maximum_Current_for_3p3V-bit position */
#define AG903_SDC_Maximum_Current_Capabilities_Maximum_Current_for_3p3V_MSK (0xffULL << AG903_SDC_Maximum_Current_Capabilities_Maximum_Current_for_3p3V_POS) /** SDCMaximum_Current_Capabilities Maximum_Current_for_3p3V-bit mask */
#define AG903_SDC_Maximum_Current_Capabilities_Maximum_Current_for_3p0V_POS 8                                            /** SDCMaximum_Current_Capabilities Maximum_Current_for_3p0V-bit position */
#define AG903_SDC_Maximum_Current_Capabilities_Maximum_Current_for_3p0V_MSK (0xffULL << AG903_SDC_Maximum_Current_Capabilities_Maximum_Current_for_3p0V_POS) /** SDCMaximum_Current_Capabilities Maximum_Current_for_3p0V-bit mask */
#define AG903_SDC_Maximum_Current_Capabilities_Maximum_Current_for_1p8V_POS 16                                           /** SDCMaximum_Current_Capabilities Maximum_Current_for_1p8V-bit position */
#define AG903_SDC_Maximum_Current_Capabilities_Maximum_Current_for_1p8V_MSK (0xffULL << AG903_SDC_Maximum_Current_Capabilities_Maximum_Current_for_1p8V_POS) /** SDCMaximum_Current_Capabilities Maximum_Current_for_1p8V-bit mask */

#define AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD12_Not_Executed_POS 0                    /** SDCForce_Event_for_Auto_CMD_Error_Status Force_Event_for_Auto_CMD12_Not_Executed-bit position */
#define AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD12_Not_Executed_MSK (0x1U << AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD12_Not_Executed_POS) /** SDCForce_Event_for_Auto_CMD_Error_Status Force_Event_for_Auto_CMD12_Not_Executed-bit mask */
#define AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD_Timeout_Error_POS 1                     /** SDCForce_Event_for_Auto_CMD_Error_Status Force_Event_for_Auto_CMD_Timeout_Error-bit position */
#define AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD_Timeout_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD_Timeout_Error_POS) /** SDCForce_Event_for_Auto_CMD_Error_Status Force_Event_for_Auto_CMD_Timeout_Error-bit mask */
#define AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD_CRC_Error_POS 2                         /** SDCForce_Event_for_Auto_CMD_Error_Status Force_Event_for_Auto_CMD_CRC_Error-bit position */
#define AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD_CRC_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD_CRC_Error_POS) /** SDCForce_Event_for_Auto_CMD_Error_Status Force_Event_for_Auto_CMD_CRC_Error-bit mask */
#define AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD_End_Bit_Error_POS 3                     /** SDCForce_Event_for_Auto_CMD_Error_Status Force_Event_for_Auto_CMD_End_Bit_Error-bit position */
#define AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD_End_Bit_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD_End_Bit_Error_POS) /** SDCForce_Event_for_Auto_CMD_Error_Status Force_Event_for_Auto_CMD_End_Bit_Error-bit mask */
#define AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD_Index_Error_POS 4                       /** SDCForce_Event_for_Auto_CMD_Error_Status Force_Event_for_Auto_CMD_Index_Error-bit position */
#define AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD_Index_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Auto_CMD_Index_Error_POS) /** SDCForce_Event_for_Auto_CMD_Error_Status Force_Event_for_Auto_CMD_Index_Error-bit mask */
#define AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Command_Not_Issued_By_Auto_CMD12_Error_POS 7     /** SDCForce_Event_for_Auto_CMD_Error_Status Force_Event_for_Command_Not_Issued_By_Auto_CMD12_Error-bit position */
#define AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Command_Not_Issued_By_Auto_CMD12_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Auto_CMD_Error_Status_Force_Event_for_Command_Not_Issued_By_Auto_CMD12_Error_POS) /** SDCForce_Event_for_Auto_CMD_Error_Status Force_Event_for_Command_Not_Issued_By_Auto_CMD12_Error-bit mask */

#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Command_Timeout_Error_POS 0                     /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Command_Timeout_Error-bit position */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Command_Timeout_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Command_Timeout_Error_POS) /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Command_Timeout_Error-bit mask */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Command_CRC_Error_POS 1                         /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Command_CRC_Error-bit position */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Command_CRC_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Command_CRC_Error_POS) /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Command_CRC_Error-bit mask */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Command_End_Bit_Error_POS 2                     /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Command_End_Bit_Error-bit position */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Command_End_Bit_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Command_End_Bit_Error_POS) /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Command_End_Bit_Error-bit mask */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Command_Index_Error_POS 3                       /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Command_Index_Error-bit position */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Command_Index_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Command_Index_Error_POS) /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Command_Index_Error-bit mask */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Data_Timeout_Error_POS 4                        /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Data_Timeout_Error-bit position */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Data_Timeout_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Data_Timeout_Error_POS) /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Data_Timeout_Error-bit mask */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Data_CRC_Error_POS 5                            /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Data_CRC_Error-bit position */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Data_CRC_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Data_CRC_Error_POS) /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Data_CRC_Error-bit mask */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Data_End_Bit_Error_POS 6                        /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Data_End_Bit_Error-bit position */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Data_End_Bit_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Data_End_Bit_Error_POS) /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Data_End_Bit_Error-bit mask */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Current_Limit_Error_POS 7                       /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Current_Limit_Error-bit position */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Current_Limit_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Current_Limit_Error_POS) /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Current_Limit_Error-bit mask */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Auto_CMD_Error_POS 8                            /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Auto_CMD_Error-bit position */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Auto_CMD_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_Auto_CMD_Error_POS) /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_Auto_CMD_Error-bit mask */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_ADMA_Error_POS 9                                /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_ADMA_Error-bit position */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_ADMA_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_ADMA_Error_POS) /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_ADMA_Error-bit mask */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_AHB_Response_Error_POS 12                       /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_AHB_Response_Error-bit position */
#define AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_AHB_Response_Error_MSK (0x1U << AG903_SDC_Force_Event_for_Error_Interrupt_Status_Force_Event_for_AHB_Response_Error_POS) /** SDCForce_Event_for_Error_Interrupt_Status Force_Event_for_AHB_Response_Error-bit mask */

#define AG903_SDC_ADMA_Error_Status_ADMA_Error_State_POS   0                                                             /** SDCADMA_Error_Status ADMA_Error_State-bit position */
#define AG903_SDC_ADMA_Error_Status_ADMA_Error_State_MSK   (0x3U << AG903_SDC_ADMA_Error_Status_ADMA_Error_State_POS)    /** SDCADMA_Error_Status ADMA_Error_State-bit mask */
#define AG903_SDC_ADMA_Error_Status_ADMA_Length_Mismatch_Error_POS 2                                                     /** SDCADMA_Error_Status ADMA_Length_Mismatch_Error-bit position */
#define AG903_SDC_ADMA_Error_Status_ADMA_Length_Mismatch_Error_MSK (0x1U << AG903_SDC_ADMA_Error_Status_ADMA_Length_Mismatch_Error_POS) /** SDCADMA_Error_Status ADMA_Length_Mismatch_Error-bit mask */

#define AG903_SDC_ADMA_System_Address_ADMA_System_Address_POS 0                                                          /** SDCADMA_System_Address ADMA_System_Address-bit position */
#define AG903_SDC_ADMA_System_Address_ADMA_System_Address_MSK (0xffffffffULL << AG903_SDC_ADMA_System_Address_ADMA_System_Address_POS) /** SDCADMA_System_Address ADMA_System_Address-bit mask */

#define AG903_SDC_Preset_Value_INIT_SDCLK_Frequency_Select_Value_POS 0                                                   /** SDCPreset_Value_INIT SDCLK_Frequency_Select_Value-bit position */
#define AG903_SDC_Preset_Value_INIT_SDCLK_Frequency_Select_Value_MSK (0x3ffU << AG903_SDC_Preset_Value_INIT_SDCLK_Frequency_Select_Value_POS) /** SDCPreset_Value_INIT SDCLK_Frequency_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_INIT_Clock_Generator_Select_Value_POS 10                                                  /** SDCPreset_Value_INIT Clock_Generator_Select_Value-bit position */
#define AG903_SDC_Preset_Value_INIT_Clock_Generator_Select_Value_MSK (0x1U << AG903_SDC_Preset_Value_INIT_Clock_Generator_Select_Value_POS) /** SDCPreset_Value_INIT Clock_Generator_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_INIT_Driver_Strength_Select_Value_POS 14                                                  /** SDCPreset_Value_INIT Driver_Strength_Select_Value-bit position */
#define AG903_SDC_Preset_Value_INIT_Driver_Strength_Select_Value_MSK (0x3U << AG903_SDC_Preset_Value_INIT_Driver_Strength_Select_Value_POS) /** SDCPreset_Value_INIT Driver_Strength_Select_Value-bit mask */

#define AG903_SDC_Preset_Value_DS_SDCLK_Frequency_Select_Value_POS 0                                                     /** SDCPreset_Value_DS SDCLK_Frequency_Select_Value-bit position */
#define AG903_SDC_Preset_Value_DS_SDCLK_Frequency_Select_Value_MSK (0x3ffU << AG903_SDC_Preset_Value_DS_SDCLK_Frequency_Select_Value_POS) /** SDCPreset_Value_DS SDCLK_Frequency_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_DS_Clock_Generator_Select_Value_POS 10                                                    /** SDCPreset_Value_DS Clock_Generator_Select_Value-bit position */
#define AG903_SDC_Preset_Value_DS_Clock_Generator_Select_Value_MSK (0x1U << AG903_SDC_Preset_Value_DS_Clock_Generator_Select_Value_POS) /** SDCPreset_Value_DS Clock_Generator_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_DS_Driver_Strength_Select_Value_POS 14                                                    /** SDCPreset_Value_DS Driver_Strength_Select_Value-bit position */
#define AG903_SDC_Preset_Value_DS_Driver_Strength_Select_Value_MSK (0x3U << AG903_SDC_Preset_Value_DS_Driver_Strength_Select_Value_POS) /** SDCPreset_Value_DS Driver_Strength_Select_Value-bit mask */

#define AG903_SDC_Preset_Value_HS_SDCLK_Frequency_Select_Value_POS 0                                                     /** SDCPreset_Value_HS SDCLK_Frequency_Select_Value-bit position */
#define AG903_SDC_Preset_Value_HS_SDCLK_Frequency_Select_Value_MSK (0x3ffU << AG903_SDC_Preset_Value_HS_SDCLK_Frequency_Select_Value_POS) /** SDCPreset_Value_HS SDCLK_Frequency_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_HS_Clock_Generator_Select_Value_POS 10                                                    /** SDCPreset_Value_HS Clock_Generator_Select_Value-bit position */
#define AG903_SDC_Preset_Value_HS_Clock_Generator_Select_Value_MSK (0x1U << AG903_SDC_Preset_Value_HS_Clock_Generator_Select_Value_POS) /** SDCPreset_Value_HS Clock_Generator_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_HS_Driver_Strength_Select_Value_POS 14                                                    /** SDCPreset_Value_HS Driver_Strength_Select_Value-bit position */
#define AG903_SDC_Preset_Value_HS_Driver_Strength_Select_Value_MSK (0x3U << AG903_SDC_Preset_Value_HS_Driver_Strength_Select_Value_POS) /** SDCPreset_Value_HS Driver_Strength_Select_Value-bit mask */

#define AG903_SDC_Preset_Value_SDR12_SDCLK_Frequency_Select_Value_POS 0                                                  /** SDCPreset_Value_SDR12 SDCLK_Frequency_Select_Value-bit position */
#define AG903_SDC_Preset_Value_SDR12_SDCLK_Frequency_Select_Value_MSK (0x3ffU << AG903_SDC_Preset_Value_SDR12_SDCLK_Frequency_Select_Value_POS) /** SDCPreset_Value_SDR12 SDCLK_Frequency_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_SDR12_Clock_Generator_Select_Value_POS 10                                                 /** SDCPreset_Value_SDR12 Clock_Generator_Select_Value-bit position */
#define AG903_SDC_Preset_Value_SDR12_Clock_Generator_Select_Value_MSK (0x1U << AG903_SDC_Preset_Value_SDR12_Clock_Generator_Select_Value_POS) /** SDCPreset_Value_SDR12 Clock_Generator_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_SDR12_Driver_Strength_Select_Value_POS 14                                                 /** SDCPreset_Value_SDR12 Driver_Strength_Select_Value-bit position */
#define AG903_SDC_Preset_Value_SDR12_Driver_Strength_Select_Value_MSK (0x3U << AG903_SDC_Preset_Value_SDR12_Driver_Strength_Select_Value_POS) /** SDCPreset_Value_SDR12 Driver_Strength_Select_Value-bit mask */

#define AG903_SDC_Preset_Value_SDR25_SDCLK_Frequency_Select_Value_POS 0                                                  /** SDCPreset_Value_SDR25 SDCLK_Frequency_Select_Value-bit position */
#define AG903_SDC_Preset_Value_SDR25_SDCLK_Frequency_Select_Value_MSK (0x3ffU << AG903_SDC_Preset_Value_SDR25_SDCLK_Frequency_Select_Value_POS) /** SDCPreset_Value_SDR25 SDCLK_Frequency_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_SDR25_Clock_Generator_Select_Value_POS 10                                                 /** SDCPreset_Value_SDR25 Clock_Generator_Select_Value-bit position */
#define AG903_SDC_Preset_Value_SDR25_Clock_Generator_Select_Value_MSK (0x1U << AG903_SDC_Preset_Value_SDR25_Clock_Generator_Select_Value_POS) /** SDCPreset_Value_SDR25 Clock_Generator_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_SDR25_Driver_Strength_Select_Value_POS 14                                                 /** SDCPreset_Value_SDR25 Driver_Strength_Select_Value-bit position */
#define AG903_SDC_Preset_Value_SDR25_Driver_Strength_Select_Value_MSK (0x3U << AG903_SDC_Preset_Value_SDR25_Driver_Strength_Select_Value_POS) /** SDCPreset_Value_SDR25 Driver_Strength_Select_Value-bit mask */

#define AG903_SDC_Preset_Value_SDR50_SDCLK_Frequency_Select_Value_POS 0                                                  /** SDCPreset_Value_SDR50 SDCLK_Frequency_Select_Value-bit position */
#define AG903_SDC_Preset_Value_SDR50_SDCLK_Frequency_Select_Value_MSK (0x3ffU << AG903_SDC_Preset_Value_SDR50_SDCLK_Frequency_Select_Value_POS) /** SDCPreset_Value_SDR50 SDCLK_Frequency_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_SDR50_Clock_Generator_Select_Value_POS 10                                                 /** SDCPreset_Value_SDR50 Clock_Generator_Select_Value-bit position */
#define AG903_SDC_Preset_Value_SDR50_Clock_Generator_Select_Value_MSK (0x1U << AG903_SDC_Preset_Value_SDR50_Clock_Generator_Select_Value_POS) /** SDCPreset_Value_SDR50 Clock_Generator_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_SDR50_Driver_Strength_Select_Value_POS 14                                                 /** SDCPreset_Value_SDR50 Driver_Strength_Select_Value-bit position */
#define AG903_SDC_Preset_Value_SDR50_Driver_Strength_Select_Value_MSK (0x3U << AG903_SDC_Preset_Value_SDR50_Driver_Strength_Select_Value_POS) /** SDCPreset_Value_SDR50 Driver_Strength_Select_Value-bit mask */

#define AG903_SDC_Preset_Value_SDR104_SDCLK_Frequency_Select_Value_POS 0                                                 /** SDCPreset_Value_SDR104 SDCLK_Frequency_Select_Value-bit position */
#define AG903_SDC_Preset_Value_SDR104_SDCLK_Frequency_Select_Value_MSK (0x3ffU << AG903_SDC_Preset_Value_SDR104_SDCLK_Frequency_Select_Value_POS) /** SDCPreset_Value_SDR104 SDCLK_Frequency_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_SDR104_Clock_Generator_Select_Value_POS 10                                                /** SDCPreset_Value_SDR104 Clock_Generator_Select_Value-bit position */
#define AG903_SDC_Preset_Value_SDR104_Clock_Generator_Select_Value_MSK (0x1U << AG903_SDC_Preset_Value_SDR104_Clock_Generator_Select_Value_POS) /** SDCPreset_Value_SDR104 Clock_Generator_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_SDR104_Driver_Strength_Select_Value_POS 14                                                /** SDCPreset_Value_SDR104 Driver_Strength_Select_Value-bit position */
#define AG903_SDC_Preset_Value_SDR104_Driver_Strength_Select_Value_MSK (0x3U << AG903_SDC_Preset_Value_SDR104_Driver_Strength_Select_Value_POS) /** SDCPreset_Value_SDR104 Driver_Strength_Select_Value-bit mask */

#define AG903_SDC_Preset_Value_DDR50_SDCLK_Frequency_Select_Value_POS 0                                                  /** SDCPreset_Value_DDR50 SDCLK_Frequency_Select_Value-bit position */
#define AG903_SDC_Preset_Value_DDR50_SDCLK_Frequency_Select_Value_MSK (0x3ffU << AG903_SDC_Preset_Value_DDR50_SDCLK_Frequency_Select_Value_POS) /** SDCPreset_Value_DDR50 SDCLK_Frequency_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_DDR50_Clock_Generator_Select_Value_POS 10                                                 /** SDCPreset_Value_DDR50 Clock_Generator_Select_Value-bit position */
#define AG903_SDC_Preset_Value_DDR50_Clock_Generator_Select_Value_MSK (0x1U << AG903_SDC_Preset_Value_DDR50_Clock_Generator_Select_Value_POS) /** SDCPreset_Value_DDR50 Clock_Generator_Select_Value-bit mask */
#define AG903_SDC_Preset_Value_DDR50_Driver_Strength_Select_Value_POS 14                                                 /** SDCPreset_Value_DDR50 Driver_Strength_Select_Value-bit position */
#define AG903_SDC_Preset_Value_DDR50_Driver_Strength_Select_Value_MSK (0x3U << AG903_SDC_Preset_Value_DDR50_Driver_Strength_Select_Value_POS) /** SDCPreset_Value_DDR50 Driver_Strength_Select_Value-bit mask */

#define AG903_SDC_Host_Controller_Version_Specification_Version_Number_POS 0                                             /** SDCHost_Controller_Version Specification_Version_Number-bit position */
#define AG903_SDC_Host_Controller_Version_Specification_Version_Number_MSK (0xffU << AG903_SDC_Host_Controller_Version_Specification_Version_Number_POS) /** SDCHost_Controller_Version Specification_Version_Number-bit mask */
#define AG903_SDC_Host_Controller_Version_Vendor_Version_Number_POS 8                                                    /** SDCHost_Controller_Version Vendor_Version_Number-bit position */
#define AG903_SDC_Host_Controller_Version_Vendor_Version_Number_MSK (0xffU << AG903_SDC_Host_Controller_Version_Vendor_Version_Number_POS) /** SDCHost_Controller_Version Vendor_Version_Number-bit mask */

#define AG903_SDC_Vendor_defined_0_p_lat_en_POS            0                                                             /** SDCVendor_defined_0 p_lat_en-bit position */
#define AG903_SDC_Vendor_defined_0_p_lat_en_MSK            (0x1UL << AG903_SDC_Vendor_defined_0_p_lat_en_POS)            /** SDCVendor_defined_0 p_lat_en-bit mask */
#define AG903_SDC_Vendor_defined_0_p_lat_off_POS           8                                                             /** SDCVendor_defined_0 p_lat_off-bit position */
#define AG903_SDC_Vendor_defined_0_p_lat_off_MSK           (0x3fUL << AG903_SDC_Vendor_defined_0_p_lat_off_POS)          /** SDCVendor_defined_0 p_lat_off-bit mask */
#define AG903_SDC_Vendor_defined_0_int_edge_sel_POS        16                                                            /** SDCVendor_defined_0 int_edge_sel-bit position */
#define AG903_SDC_Vendor_defined_0_int_edge_sel_MSK        (0x1UL << AG903_SDC_Vendor_defined_0_int_edge_sel_POS)        /** SDCVendor_defined_0 int_edge_sel-bit mask */
#define AG903_SDC_Vendor_defined_0_NCRC_POS                24                                                            /** SDCVendor_defined_0 NCRC-bit position */
#define AG903_SDC_Vendor_defined_0_NCRC_MSK                (0xfUL << AG903_SDC_Vendor_defined_0_NCRC_POS)                /** SDCVendor_defined_0 NCRC-bit mask */

#define AG903_SDC_Vendor_defined_1_mmc_boot_POS            0                                                             /** SDCVendor_defined_1 mmc_boot-bit position */
#define AG903_SDC_Vendor_defined_1_mmc_boot_MSK            (0x3UL << AG903_SDC_Vendor_defined_1_mmc_boot_POS)            /** SDCVendor_defined_1 mmc_boot-bit mask */
#define AG903_SDC_Vendor_defined_1_mmc_boot_ack_en_POS     2                                                             /** SDCVendor_defined_1 mmc_boot_ack_en-bit position */
#define AG903_SDC_Vendor_defined_1_mmc_boot_ack_en_MSK     (0x1UL << AG903_SDC_Vendor_defined_1_mmc_boot_ack_en_POS)     /** SDCVendor_defined_1 mmc_boot_ack_en-bit mask */
#define AG903_SDC_Vendor_defined_1_NCR_POS                 8                                                             /** SDCVendor_defined_1 NCR-bit position */
#define AG903_SDC_Vendor_defined_1_NCR_MSK                 (0xfUL << AG903_SDC_Vendor_defined_1_NCR_POS)                 /** SDCVendor_defined_1 NCR-bit mask */
#define AG903_SDC_Vendor_defined_1_NSB_POS                 16                                                            /** SDCVendor_defined_1 NSB-bit position */
#define AG903_SDC_Vendor_defined_1_NSB_MSK                 (0x7UL << AG903_SDC_Vendor_defined_1_NSB_POS)                 /** SDCVendor_defined_1 NSB-bit mask */
#define AG903_SDC_Vendor_defined_1_cmd_conflict_en_POS     24                                                            /** SDCVendor_defined_1 cmd_conflict_en-bit position */
#define AG903_SDC_Vendor_defined_1_cmd_conflict_en_MSK     (0x1UL << AG903_SDC_Vendor_defined_1_cmd_conflict_en_POS)     /** SDCVendor_defined_1 cmd_conflict_en-bit mask */

#define AG903_SDC_Vendor_defined_2_clk_ctrl_sw_rst_POS     0                                                             /** SDCVendor_defined_2 clk_ctrl_sw_rst-bit position */
#define AG903_SDC_Vendor_defined_2_clk_ctrl_sw_rst_MSK     (0x1UL << AG903_SDC_Vendor_defined_2_clk_ctrl_sw_rst_POS)     /** SDCVendor_defined_2 clk_ctrl_sw_rst-bit mask */

#define AG903_SDC_Vendor_defined_3_tuning_success_thres_POS 0                                                            /** SDCVendor_defined_3 tuning_success_thres-bit position */
#define AG903_SDC_Vendor_defined_3_tuning_success_thres_MSK (0x1fUL << AG903_SDC_Vendor_defined_3_tuning_success_thres_POS) /** SDCVendor_defined_3 tuning_success_thres-bit mask */
#define AG903_SDC_Vendor_defined_3_crc16_error_thres_POS   8                                                             /** SDCVendor_defined_3 crc16_error_thres-bit position */
#define AG903_SDC_Vendor_defined_3_crc16_error_thres_MSK   (0x1fUL << AG903_SDC_Vendor_defined_3_crc16_error_thres_POS)  /** SDCVendor_defined_3 crc16_error_thres-bit mask */
#define AG903_SDC_Vendor_defined_3_sd_delay_val_POS        16                                                            /** SDCVendor_defined_3 sd_delay_val-bit position */
#define AG903_SDC_Vendor_defined_3_sd_delay_val_MSK        (0x1fUL << AG903_SDC_Vendor_defined_3_sd_delay_val_POS)       /** SDCVendor_defined_3 sd_delay_val-bit mask */
#define AG903_SDC_Vendor_defined_3_sd_delay_sel_bound_POS  24                                                            /** SDCVendor_defined_3 sd_delay_sel_bound-bit position */
#define AG903_SDC_Vendor_defined_3_sd_delay_sel_bound_MSK  (0x1fUL << AG903_SDC_Vendor_defined_3_sd_delay_sel_bound_POS) /** SDCVendor_defined_3 sd_delay_sel_bound-bit mask */

#define AG903_SDC_Vendor_defined_4_tuning_record_POS       0                                                             /** SDCVendor_defined_4 tuning_record-bit position */
#define AG903_SDC_Vendor_defined_4_tuning_record_MSK       (0xffffffffUL << AG903_SDC_Vendor_defined_4_tuning_record_POS) /** SDCVendor_defined_4 tuning_record-bit mask */

#define AG903_SDC_Vendor_defined_5_db_timeout_POS          0                                                             /** SDCVendor_defined_5 db_timeout-bit position */
#define AG903_SDC_Vendor_defined_5_db_timeout_MSK          (0xfUL << AG903_SDC_Vendor_defined_5_db_timeout_POS)          /** SDCVendor_defined_5 db_timeout-bit mask */

#define AG903_SDC_Vendor_defined_6_hburst_incr_POS         0                                                             /** SDCVendor_defined_6 hburst_incr-bit position */
#define AG903_SDC_Vendor_defined_6_hburst_incr_MSK         (0x1UL << AG903_SDC_Vendor_defined_6_hburst_incr_POS)         /** SDCVendor_defined_6 hburst_incr-bit mask */

#define AG903_SDC_Vendor_defined_7_ahb_resp_err_sts_POS    0                                                             /** SDCVendor_defined_7 ahb_resp_err_sts-bit position */
#define AG903_SDC_Vendor_defined_7_ahb_resp_err_sts_MSK    (0x1UL << AG903_SDC_Vendor_defined_7_ahb_resp_err_sts_POS)    /** SDCVendor_defined_7 ahb_resp_err_sts-bit mask */

#define AG903_SDC_Vendor_defined_8_ahb_resp_err_sts_en_POS 0                                                             /** SDCVendor_defined_8 ahb_resp_err_sts_en-bit position */
#define AG903_SDC_Vendor_defined_8_ahb_resp_err_sts_en_MSK (0x1UL << AG903_SDC_Vendor_defined_8_ahb_resp_err_sts_en_POS) /** SDCVendor_defined_8 ahb_resp_err_sts_en-bit mask */

#define AG903_SDC_Vendor_defined_9_ahb_resp_err_sts_POS    0                                                             /** SDCVendor_defined_9 ahb_resp_err_sts-bit position */
#define AG903_SDC_Vendor_defined_9_ahb_resp_err_sts_MSK    (0x1UL << AG903_SDC_Vendor_defined_9_ahb_resp_err_sts_POS)    /** SDCVendor_defined_9 ahb_resp_err_sts-bit mask */

#define AG903_SDC_DMA_handshake_enable_dma_hsk_en_POS      0                                                             /** SDCDMA_handshake_enable dma_hsk_en-bit position */
#define AG903_SDC_DMA_handshake_enable_dma_hsk_en_MSK      (0x1UL << AG903_SDC_DMA_handshake_enable_dma_hsk_en_POS)      /** SDCDMA_handshake_enable dma_hsk_en-bit mask */

#define AG903_SDC_Hardware_attributes_hw_config_POS        0                                                             /** SDCHardware_attributes hw_config-bit position */
#define AG903_SDC_Hardware_attributes_hw_config_MSK        (0x1ffUL << AG903_SDC_Hardware_attributes_hw_config_POS)      /** SDCHardware_attributes hw_config-bit mask */

#define AG903_SDC_IP_revision_Rev_num_POS                  0                                                             /** SDCIP_revision Rev_num-bit position */
#define AG903_SDC_IP_revision_Rev_num_MSK                  (0xffffffffUL << AG903_SDC_IP_revision_Rev_num_POS)           /** SDCIP_revision Rev_num-bit mask */


#endif /* _AG903_SDC_REGMAP_H_ */

