/**
 * @brief           SDMC Register Definition
 * @author          AXELL CORPORATION
 * @description     SDMC Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_SDMC_REGMAP_H_
#define _AG903_SDMC_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** SDMC Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  SDRAM_Timing_1;

        struct {
            __IO uint32_t  TCL                            :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  TWR                            :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  TRF                            :  4;
            __IO uint32_t  TRCD                           :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  TRP                            :  4;
            __IO uint32_t  TRAS                           :  4;
        } SDRAM_Timing_1_bits;
    };

    union {
        __IO uint32_t  SDRAM_Timing_2;

        struct {
            __IO uint32_t  REF_INTV                       : 16;
            __IO uint32_t  INI_REFT                       :  4;
            __IO uint32_t  INI_PREC                       :  4;
        } SDRAM_Timing_2_bits;
    };

    union {
        __IO uint32_t  SDRAM_Configuration_1;

        struct {
            __IO uint32_t  BNKSIZE                        :  4;
            __IO uint32_t  MBW                            :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  DSZ                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  DDW                            :  2;
        } SDRAM_Configuration_1_bits;
    };

    union {
        __IO uint32_t  SDRAM_Configuration_2;

        struct {
            __IO uint32_t  SREF                           :  1;
            __I  uint32_t  PWDN                           :  1;
            __IO uint32_t  ISMR                           :  1;
            __IO uint32_t  IREF                           :  1;
            __IO uint32_t  IPREC                          :  1;
            __IO uint32_t  AMTSEL                         :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  T_PDSR                         : 10;
                 uint32_t                                 :  2;
            __I  uint32_t  SREF_MODE                      :  1;
        } SDRAM_Configuration_2_bits;
    };

    union {
        __IO uint32_t  External_Bank;

        struct {
            __IO uint32_t  BASE                           : 12;
            __IO uint32_t  EN                             :  1;
        } External_Bank_bits;
    };

    __I  uint32_t  RESERVED1[7];

    union {
        __IO uint32_t  Read_Arbitration;

        struct {
            __IO uint32_t  CH1GW                          :  4;
            __IO uint32_t  CH2GW                          :  4;
            __IO uint32_t  CH3GW                          :  4;
            __IO uint32_t  CH4GW                          :  4;
            __IO uint32_t  CH5GW                          :  4;
            __IO uint32_t  CH6GW                          :  4;
            __IO uint32_t  CH7GW                          :  4;
            __IO uint32_t  CH8GW                          :  4;
        } Read_Arbitration_bits;
    };

    union {
        __IO uint32_t  Flush_Request;

        struct {
            __IO uint32_t  FLUSHCHN                       :  3;
            __IO uint32_t  FLUSHCMPLT                     :  1;
        } Flush_Request_bits;
    };

    __I  uint32_t  RESERVED2[1];

    union {
        __IO uint32_t  Mobile_SDRAM_Support;

        struct {
            __IO uint32_t  DS                             :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  PASR                           :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  MOBILE                         :  1;
        } Mobile_SDRAM_Support_bits;
    };

    __I  uint32_t  RESERVED3[48];

    union {
        __I  uint32_t  Controller_Revision;

        struct {
            __I  uint32_t  REV_VER                        :  8;
            __I  uint32_t  MINOR_VER                      :  8;
            __I  uint32_t  MAJOR_VER                      :  8;
        } Controller_Revision_bits;
    };

    union {
        __I  uint32_t  Controller_Feature;

        struct {
            __I  uint32_t  EBNK                           :  8;
            __I  uint32_t  CHN                            :  8;
            __I  uint32_t  EBI                            :  1;
                 uint32_t                                 :  7;
            __I  uint32_t  CH1_FDEPTH                     :  1;
            __I  uint32_t  CH2_FDEPTH                     :  1;
            __I  uint32_t  CH3_FDEPTH                     :  1;
            __I  uint32_t  CH4_FDEPTH                     :  1;
            __I  uint32_t  CH5_FDEPTH                     :  1;
            __I  uint32_t  CH6_FDEPTH                     :  1;
            __I  uint32_t  CH7_FDEPTH                     :  1;
            __I  uint32_t  CH8_FDEPTH                     :  1;
        } Controller_Feature_bits;
    };

/* DOM-IGNORE-END */
}AG903_SDMC_Type;

#define AG903_SDMC                               ((volatile AG903_SDMC_Type *) AG903_SDMC_BASE)                          /** SDMC Base Address */


#define AG903_SDMC_SDRAM_Timing_1_TCL_POS                  0                                                             /** SDMCSDRAM_Timing_1 TCL-bit position */
#define AG903_SDMC_SDRAM_Timing_1_TCL_MSK                  (0x3UL << AG903_SDMC_SDRAM_Timing_1_TCL_POS)                  /** SDMCSDRAM_Timing_1 TCL-bit mask */
#define AG903_SDMC_SDRAM_Timing_1_TWR_POS                  4                                                             /** SDMCSDRAM_Timing_1 TWR-bit position */
#define AG903_SDMC_SDRAM_Timing_1_TWR_MSK                  (0x3UL << AG903_SDMC_SDRAM_Timing_1_TWR_POS)                  /** SDMCSDRAM_Timing_1 TWR-bit mask */
#define AG903_SDMC_SDRAM_Timing_1_TRF_POS                  8                                                             /** SDMCSDRAM_Timing_1 TRF-bit position */
#define AG903_SDMC_SDRAM_Timing_1_TRF_MSK                  (0xfUL << AG903_SDMC_SDRAM_Timing_1_TRF_POS)                  /** SDMCSDRAM_Timing_1 TRF-bit mask */
#define AG903_SDMC_SDRAM_Timing_1_TRCD_POS                 12                                                            /** SDMCSDRAM_Timing_1 TRCD-bit position */
#define AG903_SDMC_SDRAM_Timing_1_TRCD_MSK                 (0x7UL << AG903_SDMC_SDRAM_Timing_1_TRCD_POS)                 /** SDMCSDRAM_Timing_1 TRCD-bit mask */
#define AG903_SDMC_SDRAM_Timing_1_TRP_POS                  16                                                            /** SDMCSDRAM_Timing_1 TRP-bit position */
#define AG903_SDMC_SDRAM_Timing_1_TRP_MSK                  (0xfUL << AG903_SDMC_SDRAM_Timing_1_TRP_POS)                  /** SDMCSDRAM_Timing_1 TRP-bit mask */
#define AG903_SDMC_SDRAM_Timing_1_TRAS_POS                 20                                                            /** SDMCSDRAM_Timing_1 TRAS-bit position */
#define AG903_SDMC_SDRAM_Timing_1_TRAS_MSK                 (0xfUL << AG903_SDMC_SDRAM_Timing_1_TRAS_POS)                 /** SDMCSDRAM_Timing_1 TRAS-bit mask */

#define AG903_SDMC_SDRAM_Timing_2_REF_INTV_POS             0                                                             /** SDMCSDRAM_Timing_2 REF_INTV-bit position */
#define AG903_SDMC_SDRAM_Timing_2_REF_INTV_MSK             (0xffffUL << AG903_SDMC_SDRAM_Timing_2_REF_INTV_POS)          /** SDMCSDRAM_Timing_2 REF_INTV-bit mask */
#define AG903_SDMC_SDRAM_Timing_2_INI_REFT_POS             16                                                            /** SDMCSDRAM_Timing_2 INI_REFT-bit position */
#define AG903_SDMC_SDRAM_Timing_2_INI_REFT_MSK             (0xfUL << AG903_SDMC_SDRAM_Timing_2_INI_REFT_POS)             /** SDMCSDRAM_Timing_2 INI_REFT-bit mask */
#define AG903_SDMC_SDRAM_Timing_2_INI_PREC_POS             20                                                            /** SDMCSDRAM_Timing_2 INI_PREC-bit position */
#define AG903_SDMC_SDRAM_Timing_2_INI_PREC_MSK             (0xfUL << AG903_SDMC_SDRAM_Timing_2_INI_PREC_POS)             /** SDMCSDRAM_Timing_2 INI_PREC-bit mask */

#define AG903_SDMC_SDRAM_Configuration_1_BNKSIZE_POS       0                                                             /** SDMCSDRAM_Configuration_1 BNKSIZE-bit position */
#define AG903_SDMC_SDRAM_Configuration_1_BNKSIZE_MSK       (0xfUL << AG903_SDMC_SDRAM_Configuration_1_BNKSIZE_POS)       /** SDMCSDRAM_Configuration_1 BNKSIZE-bit mask */
#define AG903_SDMC_SDRAM_Configuration_1_MBW_POS           4                                                             /** SDMCSDRAM_Configuration_1 MBW-bit position */
#define AG903_SDMC_SDRAM_Configuration_1_MBW_MSK           (0x3UL << AG903_SDMC_SDRAM_Configuration_1_MBW_POS)           /** SDMCSDRAM_Configuration_1 MBW-bit mask */
#define AG903_SDMC_SDRAM_Configuration_1_DSZ_POS           8                                                             /** SDMCSDRAM_Configuration_1 DSZ-bit position */
#define AG903_SDMC_SDRAM_Configuration_1_DSZ_MSK           (0x7UL << AG903_SDMC_SDRAM_Configuration_1_DSZ_POS)           /** SDMCSDRAM_Configuration_1 DSZ-bit mask */
#define AG903_SDMC_SDRAM_Configuration_1_DDW_POS           12                                                            /** SDMCSDRAM_Configuration_1 DDW-bit position */
#define AG903_SDMC_SDRAM_Configuration_1_DDW_MSK           (0x3UL << AG903_SDMC_SDRAM_Configuration_1_DDW_POS)           /** SDMCSDRAM_Configuration_1 DDW-bit mask */

#define AG903_SDMC_SDRAM_Configuration_2_SREF_POS          0                                                             /** SDMCSDRAM_Configuration_2 SREF-bit position */
#define AG903_SDMC_SDRAM_Configuration_2_SREF_MSK          (0x1UL << AG903_SDMC_SDRAM_Configuration_2_SREF_POS)          /** SDMCSDRAM_Configuration_2 SREF-bit mask */
#define AG903_SDMC_SDRAM_Configuration_2_PWDN_POS          1                                                             /** SDMCSDRAM_Configuration_2 PWDN-bit position */
#define AG903_SDMC_SDRAM_Configuration_2_PWDN_MSK          (0x1UL << AG903_SDMC_SDRAM_Configuration_2_PWDN_POS)          /** SDMCSDRAM_Configuration_2 PWDN-bit mask */
#define AG903_SDMC_SDRAM_Configuration_2_ISMR_POS          2                                                             /** SDMCSDRAM_Configuration_2 ISMR-bit position */
#define AG903_SDMC_SDRAM_Configuration_2_ISMR_MSK          (0x1UL << AG903_SDMC_SDRAM_Configuration_2_ISMR_POS)          /** SDMCSDRAM_Configuration_2 ISMR-bit mask */
#define AG903_SDMC_SDRAM_Configuration_2_IREF_POS          3                                                             /** SDMCSDRAM_Configuration_2 IREF-bit position */
#define AG903_SDMC_SDRAM_Configuration_2_IREF_MSK          (0x1UL << AG903_SDMC_SDRAM_Configuration_2_IREF_POS)          /** SDMCSDRAM_Configuration_2 IREF-bit mask */
#define AG903_SDMC_SDRAM_Configuration_2_IPREC_POS         4                                                             /** SDMCSDRAM_Configuration_2 IPREC-bit position */
#define AG903_SDMC_SDRAM_Configuration_2_IPREC_MSK         (0x1UL << AG903_SDMC_SDRAM_Configuration_2_IPREC_POS)         /** SDMCSDRAM_Configuration_2 IPREC-bit mask */
#define AG903_SDMC_SDRAM_Configuration_2_AMTSEL_POS        5                                                             /** SDMCSDRAM_Configuration_2 AMTSEL-bit position */
#define AG903_SDMC_SDRAM_Configuration_2_AMTSEL_MSK        (0x1UL << AG903_SDMC_SDRAM_Configuration_2_AMTSEL_POS)        /** SDMCSDRAM_Configuration_2 AMTSEL-bit mask */
#define AG903_SDMC_SDRAM_Configuration_2_T_PDSR_POS        8                                                             /** SDMCSDRAM_Configuration_2 T_PDSR-bit position */
#define AG903_SDMC_SDRAM_Configuration_2_T_PDSR_MSK        (0x3ffUL << AG903_SDMC_SDRAM_Configuration_2_T_PDSR_POS)      /** SDMCSDRAM_Configuration_2 T_PDSR-bit mask */
#define AG903_SDMC_SDRAM_Configuration_2_SREF_MODE_POS     20                                                            /** SDMCSDRAM_Configuration_2 SREF_MODE-bit position */
#define AG903_SDMC_SDRAM_Configuration_2_SREF_MODE_MSK     (0x1UL << AG903_SDMC_SDRAM_Configuration_2_SREF_MODE_POS)     /** SDMCSDRAM_Configuration_2 SREF_MODE-bit mask */

#define AG903_SDMC_External_Bank_BASE_POS                  0                                                             /** SDMCExternal_Bank BASE-bit position */
#define AG903_SDMC_External_Bank_BASE_MSK                  (0xfffUL << AG903_SDMC_External_Bank_BASE_POS)                /** SDMCExternal_Bank BASE-bit mask */
#define AG903_SDMC_External_Bank_EN_POS                    12                                                            /** SDMCExternal_Bank EN-bit position */
#define AG903_SDMC_External_Bank_EN_MSK                    (0x1UL << AG903_SDMC_External_Bank_EN_POS)                    /** SDMCExternal_Bank EN-bit mask */

#define AG903_SDMC_Read_Arbitration_CH1GW_POS              0                                                             /** SDMCRead_Arbitration CH1GW-bit position */
#define AG903_SDMC_Read_Arbitration_CH1GW_MSK              (0xfUL << AG903_SDMC_Read_Arbitration_CH1GW_POS)              /** SDMCRead_Arbitration CH1GW-bit mask */
#define AG903_SDMC_Read_Arbitration_CH2GW_POS              4                                                             /** SDMCRead_Arbitration CH2GW-bit position */
#define AG903_SDMC_Read_Arbitration_CH2GW_MSK              (0xfUL << AG903_SDMC_Read_Arbitration_CH2GW_POS)              /** SDMCRead_Arbitration CH2GW-bit mask */
#define AG903_SDMC_Read_Arbitration_CH3GW_POS              8                                                             /** SDMCRead_Arbitration CH3GW-bit position */
#define AG903_SDMC_Read_Arbitration_CH3GW_MSK              (0xfUL << AG903_SDMC_Read_Arbitration_CH3GW_POS)              /** SDMCRead_Arbitration CH3GW-bit mask */
#define AG903_SDMC_Read_Arbitration_CH4GW_POS              12                                                            /** SDMCRead_Arbitration CH4GW-bit position */
#define AG903_SDMC_Read_Arbitration_CH4GW_MSK              (0xfUL << AG903_SDMC_Read_Arbitration_CH4GW_POS)              /** SDMCRead_Arbitration CH4GW-bit mask */
#define AG903_SDMC_Read_Arbitration_CH5GW_POS              16                                                            /** SDMCRead_Arbitration CH5GW-bit position */
#define AG903_SDMC_Read_Arbitration_CH5GW_MSK              (0xfUL << AG903_SDMC_Read_Arbitration_CH5GW_POS)              /** SDMCRead_Arbitration CH5GW-bit mask */
#define AG903_SDMC_Read_Arbitration_CH6GW_POS              20                                                            /** SDMCRead_Arbitration CH6GW-bit position */
#define AG903_SDMC_Read_Arbitration_CH6GW_MSK              (0xfUL << AG903_SDMC_Read_Arbitration_CH6GW_POS)              /** SDMCRead_Arbitration CH6GW-bit mask */
#define AG903_SDMC_Read_Arbitration_CH7GW_POS              24                                                            /** SDMCRead_Arbitration CH7GW-bit position */
#define AG903_SDMC_Read_Arbitration_CH7GW_MSK              (0xfUL << AG903_SDMC_Read_Arbitration_CH7GW_POS)              /** SDMCRead_Arbitration CH7GW-bit mask */
#define AG903_SDMC_Read_Arbitration_CH8GW_POS              28                                                            /** SDMCRead_Arbitration CH8GW-bit position */
#define AG903_SDMC_Read_Arbitration_CH8GW_MSK              (0xfUL << AG903_SDMC_Read_Arbitration_CH8GW_POS)              /** SDMCRead_Arbitration CH8GW-bit mask */

#define AG903_SDMC_Flush_Request_FLUSHCHN_POS              0                                                             /** SDMCFlush_Request FLUSHCHN-bit position */
#define AG903_SDMC_Flush_Request_FLUSHCHN_MSK              (0x7UL << AG903_SDMC_Flush_Request_FLUSHCHN_POS)              /** SDMCFlush_Request FLUSHCHN-bit mask */
#define AG903_SDMC_Flush_Request_FLUSHCMPLT_POS            3                                                             /** SDMCFlush_Request FLUSHCMPLT-bit position */
#define AG903_SDMC_Flush_Request_FLUSHCMPLT_MSK            (0x1UL << AG903_SDMC_Flush_Request_FLUSHCMPLT_POS)            /** SDMCFlush_Request FLUSHCMPLT-bit mask */

#define AG903_SDMC_Mobile_SDRAM_Support_DS_POS             0                                                             /** SDMCMobile_SDRAM_Support DS-bit position */
#define AG903_SDMC_Mobile_SDRAM_Support_DS_MSK             (0x3UL << AG903_SDMC_Mobile_SDRAM_Support_DS_POS)             /** SDMCMobile_SDRAM_Support DS-bit mask */
#define AG903_SDMC_Mobile_SDRAM_Support_PASR_POS           4                                                             /** SDMCMobile_SDRAM_Support PASR-bit position */
#define AG903_SDMC_Mobile_SDRAM_Support_PASR_MSK           (0x7UL << AG903_SDMC_Mobile_SDRAM_Support_PASR_POS)           /** SDMCMobile_SDRAM_Support PASR-bit mask */
#define AG903_SDMC_Mobile_SDRAM_Support_MOBILE_POS         8                                                             /** SDMCMobile_SDRAM_Support MOBILE-bit position */
#define AG903_SDMC_Mobile_SDRAM_Support_MOBILE_MSK         (0x1UL << AG903_SDMC_Mobile_SDRAM_Support_MOBILE_POS)         /** SDMCMobile_SDRAM_Support MOBILE-bit mask */

#define AG903_SDMC_Controller_Revision_REV_VER_POS         0                                                             /** SDMCController_Revision REV_VER-bit position */
#define AG903_SDMC_Controller_Revision_REV_VER_MSK         (0xffUL << AG903_SDMC_Controller_Revision_REV_VER_POS)        /** SDMCController_Revision REV_VER-bit mask */
#define AG903_SDMC_Controller_Revision_MINOR_VER_POS       8                                                             /** SDMCController_Revision MINOR_VER-bit position */
#define AG903_SDMC_Controller_Revision_MINOR_VER_MSK       (0xffUL << AG903_SDMC_Controller_Revision_MINOR_VER_POS)      /** SDMCController_Revision MINOR_VER-bit mask */
#define AG903_SDMC_Controller_Revision_MAJOR_VER_POS       16                                                            /** SDMCController_Revision MAJOR_VER-bit position */
#define AG903_SDMC_Controller_Revision_MAJOR_VER_MSK       (0xffUL << AG903_SDMC_Controller_Revision_MAJOR_VER_POS)      /** SDMCController_Revision MAJOR_VER-bit mask */

#define AG903_SDMC_Controller_Feature_EBNK_POS             0                                                             /** SDMCController_Feature EBNK-bit position */
#define AG903_SDMC_Controller_Feature_EBNK_MSK             (0xffUL << AG903_SDMC_Controller_Feature_EBNK_POS)            /** SDMCController_Feature EBNK-bit mask */
#define AG903_SDMC_Controller_Feature_CHN_POS              8                                                             /** SDMCController_Feature CHN-bit position */
#define AG903_SDMC_Controller_Feature_CHN_MSK              (0xffUL << AG903_SDMC_Controller_Feature_CHN_POS)             /** SDMCController_Feature CHN-bit mask */
#define AG903_SDMC_Controller_Feature_EBI_POS              16                                                            /** SDMCController_Feature EBI-bit position */
#define AG903_SDMC_Controller_Feature_EBI_MSK              (0x1UL << AG903_SDMC_Controller_Feature_EBI_POS)              /** SDMCController_Feature EBI-bit mask */
#define AG903_SDMC_Controller_Feature_CH1_FDEPTH_POS       24                                                            /** SDMCController_Feature CH1_FDEPTH-bit position */
#define AG903_SDMC_Controller_Feature_CH1_FDEPTH_MSK       (0x1UL << AG903_SDMC_Controller_Feature_CH1_FDEPTH_POS)       /** SDMCController_Feature CH1_FDEPTH-bit mask */
#define AG903_SDMC_Controller_Feature_CH2_FDEPTH_POS       25                                                            /** SDMCController_Feature CH2_FDEPTH-bit position */
#define AG903_SDMC_Controller_Feature_CH2_FDEPTH_MSK       (0x1UL << AG903_SDMC_Controller_Feature_CH2_FDEPTH_POS)       /** SDMCController_Feature CH2_FDEPTH-bit mask */
#define AG903_SDMC_Controller_Feature_CH3_FDEPTH_POS       26                                                            /** SDMCController_Feature CH3_FDEPTH-bit position */
#define AG903_SDMC_Controller_Feature_CH3_FDEPTH_MSK       (0x1UL << AG903_SDMC_Controller_Feature_CH3_FDEPTH_POS)       /** SDMCController_Feature CH3_FDEPTH-bit mask */
#define AG903_SDMC_Controller_Feature_CH4_FDEPTH_POS       27                                                            /** SDMCController_Feature CH4_FDEPTH-bit position */
#define AG903_SDMC_Controller_Feature_CH4_FDEPTH_MSK       (0x1UL << AG903_SDMC_Controller_Feature_CH4_FDEPTH_POS)       /** SDMCController_Feature CH4_FDEPTH-bit mask */
#define AG903_SDMC_Controller_Feature_CH5_FDEPTH_POS       28                                                            /** SDMCController_Feature CH5_FDEPTH-bit position */
#define AG903_SDMC_Controller_Feature_CH5_FDEPTH_MSK       (0x1UL << AG903_SDMC_Controller_Feature_CH5_FDEPTH_POS)       /** SDMCController_Feature CH5_FDEPTH-bit mask */
#define AG903_SDMC_Controller_Feature_CH6_FDEPTH_POS       29                                                            /** SDMCController_Feature CH6_FDEPTH-bit position */
#define AG903_SDMC_Controller_Feature_CH6_FDEPTH_MSK       (0x1UL << AG903_SDMC_Controller_Feature_CH6_FDEPTH_POS)       /** SDMCController_Feature CH6_FDEPTH-bit mask */
#define AG903_SDMC_Controller_Feature_CH7_FDEPTH_POS       30                                                            /** SDMCController_Feature CH7_FDEPTH-bit position */
#define AG903_SDMC_Controller_Feature_CH7_FDEPTH_MSK       (0x1UL << AG903_SDMC_Controller_Feature_CH7_FDEPTH_POS)       /** SDMCController_Feature CH7_FDEPTH-bit mask */
#define AG903_SDMC_Controller_Feature_CH8_FDEPTH_POS       31                                                            /** SDMCController_Feature CH8_FDEPTH-bit position */
#define AG903_SDMC_Controller_Feature_CH8_FDEPTH_MSK       (0x1UL << AG903_SDMC_Controller_Feature_CH8_FDEPTH_POS)       /** SDMCController_Feature CH8_FDEPTH-bit mask */

#endif /* _AG903_SDMC_REGMAP_H_ */

