/**
 * @brief           TIM Register Definition
 * @author          AXELL CORPORATION
 * @description     TIM Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_TIM_REGMAP_H_
#define _AG903_TIM_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** TIMn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  CTRL;

        struct {
            __IO uint32_t  MOD                            :  3;
            __IO uint32_t  OS                             :  1;
        } CTRL_bits;
    };

    union {
        __IO uint32_t  RSTTRG;

        struct {
            __IO uint32_t  EN                             :  2;
            __IO uint32_t  BOOT                           :  2;
            __IO uint32_t  RES                            :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  POL                            :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  CH                             :  2;
            __IO uint32_t  LO                             :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  EVE                            :  6;
        } RSTTRG_bits;
    };

    union {
        __IO uint32_t  INMOD;

        struct {
            __IO uint32_t  RES                            :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  POL                            :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  CH                             :  2;
            __IO uint32_t  LO                             :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  EVE                            :  6;
        } INMOD_bits;
    };

    union {
        __IO uint32_t  OUTMOD;

        struct {
            __IO uint32_t  MOD                            :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  POL                            :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  CH                             :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  OVF                            :  1;
            __IO uint32_t  CM                             :  1;
        } OUTMOD_bits;
    };

    union {
        __IO uint32_t  CNT;
    };

    union {
        __IO uint32_t  PERIOD;
    };

    union {
        __IO uint32_t  MATCH;
    };

    union {
        __IO uint32_t  PULWID;

        struct {
            __IO uint32_t  VAL                            : 20;
        } PULWID_bits;
    };

    union {
        __I  uint32_t  STAT;

        struct {
            __I  uint32_t  OVF                            :  1;
            __I  uint32_t  CM                             :  1;
                 uint32_t                                 : 14;
            __I  uint32_t  DR                             :  1;
        } STAT_bits;
    };

    union {
        __O  uint32_t  CLR;

        struct {
            __O  uint32_t  OVF                            :  1;
            __O  uint32_t  CM                             :  1;
        } CLR_bits;
    };

    __I  uint32_t  RESERVED1[2];

    union {
        __IO uint32_t  INTMASK;

        struct {
            __IO uint32_t  OVF                            :  1;
            __IO uint32_t  CM                             :  1;
        } INTMASK_bits;
    };

    union {
        __IO uint32_t  DMAREQ;

        struct {
            __IO uint32_t  OVF                            :  1;
            __IO uint32_t  CM                             :  1;
        } DMAREQ_bits;
    };

    union {
        __IO uint32_t  TRIGGER;

        struct {
            __IO uint32_t  OVF                            :  1;
            __IO uint32_t  CM                             :  1;
        } TRIGGER_bits;
    };

/* DOM-IGNORE-END */
}AG903_TIMn_Type;

/** TIM Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __O  uint32_t  BOOTTRG;

        struct {
            __O  uint32_t  CH0                            :  1;
            __O  uint32_t  CH1                            :  1;
            __O  uint32_t  CH2                            :  1;
            __O  uint32_t  CH3                            :  1;
            __O  uint32_t  CH4                            :  1;
            __O  uint32_t  CH5                            :  1;
            __O  uint32_t  CH6                            :  1;
            __O  uint32_t  CH7                            :  1;
        } BOOTTRG_bits;
    };

/* DOM-IGNORE-END */
}AG903_TIM_Type;

#define AG903_TIMn(ch)                           ((volatile AG903_TIMn_Type *)(AG903_TIM0_BASE + 0x40 * ch))             /** TIMn Base Address (n=0..7) */
#define AG903_TIMn_CTRL(ch)                      AG903_TIMn(ch)->CTRL                                                    /** TIMnCTRL Address (n=0..7) */
#define AG903_TIMn_RSTTRG(ch)                    AG903_TIMn(ch)->RSTTRG                                                  /** TIMnRSTTRG Address (n=0..7) */
#define AG903_TIMn_INMOD(ch)                     AG903_TIMn(ch)->INMOD                                                   /** TIMnINMOD Address (n=0..7) */
#define AG903_TIMn_OUTMOD(ch)                    AG903_TIMn(ch)->OUTMOD                                                  /** TIMnOUTMOD Address (n=0..7) */
#define AG903_TIMn_CNT(ch)                       AG903_TIMn(ch)->CNT                                                     /** TIMnCNT Address (n=0..7) */
#define AG903_TIMn_PERIOD(ch)                    AG903_TIMn(ch)->PERIOD                                                  /** TIMnPERIOD Address (n=0..7) */
#define AG903_TIMn_MATCH(ch)                     AG903_TIMn(ch)->MATCH                                                   /** TIMnMATCH Address (n=0..7) */
#define AG903_TIMn_PULWID(ch)                    AG903_TIMn(ch)->PULWID                                                  /** TIMnPULWID Address (n=0..7) */
#define AG903_TIMn_STAT(ch)                      AG903_TIMn(ch)->STAT                                                    /** TIMnSTAT Address (n=0..7) */
#define AG903_TIMn_CLR(ch)                       AG903_TIMn(ch)->CLR                                                     /** TIMnCLR Address (n=0..7) */
#define AG903_TIMn_INTMASK(ch)                   AG903_TIMn(ch)->INTMASK                                                 /** TIMnINTMASK Address (n=0..7) */
#define AG903_TIMn_DMAREQ(ch)                    AG903_TIMn(ch)->DMAREQ                                                  /** TIMnDMAREQ Address (n=0..7) */
#define AG903_TIMn_TRIGGER(ch)                   AG903_TIMn(ch)->TRIGGER                                                 /** TIMnTRIGGER Address (n=0..7) */

#define AG903_TIM0                               ((volatile AG903_TIMn_Type *) AG903_TIM0_BASE)                          /** TIMn Base Address */
#define AG903_TIM1                               ((volatile AG903_TIMn_Type *) AG903_TIM1_BASE)                          /** TIMn Base Address */
#define AG903_TIM2                               ((volatile AG903_TIMn_Type *) AG903_TIM2_BASE)                          /** TIMn Base Address */
#define AG903_TIM3                               ((volatile AG903_TIMn_Type *) AG903_TIM3_BASE)                          /** TIMn Base Address */
#define AG903_TIM4                               ((volatile AG903_TIMn_Type *) AG903_TIM4_BASE)                          /** TIMn Base Address */
#define AG903_TIM5                               ((volatile AG903_TIMn_Type *) AG903_TIM5_BASE)                          /** TIMn Base Address */
#define AG903_TIM6                               ((volatile AG903_TIMn_Type *) AG903_TIM6_BASE)                          /** TIMn Base Address */
#define AG903_TIM7                               ((volatile AG903_TIMn_Type *) AG903_TIM7_BASE)                          /** TIMn Base Address */
#define AG903_TIM                                ((volatile AG903_TIM_Type *) AG903_TIM_BASE)                            /** TIM Base Address */


#define AG903_TIMn_CTRL_MOD_POS                            0                                                             /** TIMnCTRL MOD-bit position */
#define AG903_TIMn_CTRL_MOD_MSK                            (0x7UL << AG903_TIMn_CTRL_MOD_POS)                            /** TIMnCTRL MOD-bit mask */
#define AG903_TIMn_CTRL_OS_POS                             3                                                             /** TIMnCTRL OS-bit position */
#define AG903_TIMn_CTRL_OS_MSK                             (0x1UL << AG903_TIMn_CTRL_OS_POS)                             /** TIMnCTRL OS-bit mask */

#define AG903_TIMn_RSTTRG_EN_POS                           0                                                             /** TIMnRSTTRG EN-bit position */
#define AG903_TIMn_RSTTRG_EN_MSK                           (0x3UL << AG903_TIMn_RSTTRG_EN_POS)                           /** TIMnRSTTRG EN-bit mask */
#define AG903_TIMn_RSTTRG_BOOT_POS                         2                                                             /** TIMnRSTTRG BOOT-bit position */
#define AG903_TIMn_RSTTRG_BOOT_MSK                         (0x3UL << AG903_TIMn_RSTTRG_BOOT_POS)                         /** TIMnRSTTRG BOOT-bit mask */
#define AG903_TIMn_RSTTRG_RES_POS                          4                                                             /** TIMnRSTTRG RES-bit position */
#define AG903_TIMn_RSTTRG_RES_MSK                          (0x3UL << AG903_TIMn_RSTTRG_RES_POS)                          /** TIMnRSTTRG RES-bit mask */
#define AG903_TIMn_RSTTRG_POL_POS                          8                                                             /** TIMnRSTTRG POL-bit position */
#define AG903_TIMn_RSTTRG_POL_MSK                          (0x1UL << AG903_TIMn_RSTTRG_POL_POS)                          /** TIMnRSTTRG POL-bit mask */
#define AG903_TIMn_RSTTRG_CH_POS                           16                                                            /** TIMnRSTTRG CH-bit position */
#define AG903_TIMn_RSTTRG_CH_MSK                           (0x3UL << AG903_TIMn_RSTTRG_CH_POS)                           /** TIMnRSTTRG CH-bit mask */
#define AG903_TIMn_RSTTRG_LO_POS                           18                                                            /** TIMnRSTTRG LO-bit position */
#define AG903_TIMn_RSTTRG_LO_MSK                           (0x1UL << AG903_TIMn_RSTTRG_LO_POS)                           /** TIMnRSTTRG LO-bit mask */
#define AG903_TIMn_RSTTRG_EVE_POS                          24                                                            /** TIMnRSTTRG EVE-bit position */
#define AG903_TIMn_RSTTRG_EVE_MSK                          (0x3fUL << AG903_TIMn_RSTTRG_EVE_POS)                         /** TIMnRSTTRG EVE-bit mask */

#define AG903_TIMn_INMOD_RES_POS                           0                                                             /** TIMnINMOD RES-bit position */
#define AG903_TIMn_INMOD_RES_MSK                           (0x3UL << AG903_TIMn_INMOD_RES_POS)                           /** TIMnINMOD RES-bit mask */
#define AG903_TIMn_INMOD_POL_POS                           8                                                             /** TIMnINMOD POL-bit position */
#define AG903_TIMn_INMOD_POL_MSK                           (0x1UL << AG903_TIMn_INMOD_POL_POS)                           /** TIMnINMOD POL-bit mask */
#define AG903_TIMn_INMOD_CH_POS                            16                                                            /** TIMnINMOD CH-bit position */
#define AG903_TIMn_INMOD_CH_MSK                            (0x3UL << AG903_TIMn_INMOD_CH_POS)                            /** TIMnINMOD CH-bit mask */
#define AG903_TIMn_INMOD_LO_POS                            18                                                            /** TIMnINMOD LO-bit position */
#define AG903_TIMn_INMOD_LO_MSK                            (0x1UL << AG903_TIMn_INMOD_LO_POS)                            /** TIMnINMOD LO-bit mask */
#define AG903_TIMn_INMOD_EVE_POS                           24                                                            /** TIMnINMOD EVE-bit position */
#define AG903_TIMn_INMOD_EVE_MSK                           (0x3fUL << AG903_TIMn_INMOD_EVE_POS)                          /** TIMnINMOD EVE-bit mask */

#define AG903_TIMn_OUTMOD_MOD_POS                          0                                                             /** TIMnOUTMOD MOD-bit position */
#define AG903_TIMn_OUTMOD_MOD_MSK                          (0x3UL << AG903_TIMn_OUTMOD_MOD_POS)                          /** TIMnOUTMOD MOD-bit mask */
#define AG903_TIMn_OUTMOD_POL_POS                          8                                                             /** TIMnOUTMOD POL-bit position */
#define AG903_TIMn_OUTMOD_POL_MSK                          (0x1UL << AG903_TIMn_OUTMOD_POL_POS)                          /** TIMnOUTMOD POL-bit mask */
#define AG903_TIMn_OUTMOD_CH_POS                           16                                                            /** TIMnOUTMOD CH-bit position */
#define AG903_TIMn_OUTMOD_CH_MSK                           (0x3UL << AG903_TIMn_OUTMOD_CH_POS)                           /** TIMnOUTMOD CH-bit mask */
#define AG903_TIMn_OUTMOD_OVF_POS                          24                                                            /** TIMnOUTMOD OVF-bit position */
#define AG903_TIMn_OUTMOD_OVF_MSK                          (0x1UL << AG903_TIMn_OUTMOD_OVF_POS)                          /** TIMnOUTMOD OVF-bit mask */
#define AG903_TIMn_OUTMOD_CM_POS                           25                                                            /** TIMnOUTMOD CM-bit position */
#define AG903_TIMn_OUTMOD_CM_MSK                           (0x1UL << AG903_TIMn_OUTMOD_CM_POS)                           /** TIMnOUTMOD CM-bit mask */

#define AG903_TIMn_CNT_VAL_POS                             0                                                             /** TIMnCNT VAL-bit position */
#define AG903_TIMn_CNT_VAL_MSK                             (0xffffffffUL << AG903_TIMn_CNT_VAL_POS)                      /** TIMnCNT VAL-bit mask */

#define AG903_TIMn_PERIOD_VAL_POS                          0                                                             /** TIMnPERIOD VAL-bit position */
#define AG903_TIMn_PERIOD_VAL_MSK                          (0xffffffffUL << AG903_TIMn_PERIOD_VAL_POS)                   /** TIMnPERIOD VAL-bit mask */

#define AG903_TIMn_MATCH_VAL_POS                           0                                                             /** TIMnMATCH VAL-bit position */
#define AG903_TIMn_MATCH_VAL_MSK                           (0xffffffffUL << AG903_TIMn_MATCH_VAL_POS)                    /** TIMnMATCH VAL-bit mask */

#define AG903_TIMn_PULWID_VAL_POS                          0                                                             /** TIMnPULWID VAL-bit position */
#define AG903_TIMn_PULWID_VAL_MSK                          (0xfffffUL << AG903_TIMn_PULWID_VAL_POS)                      /** TIMnPULWID VAL-bit mask */

#define AG903_TIMn_STAT_OVF_POS                            0                                                             /** TIMnSTAT OVF-bit position */
#define AG903_TIMn_STAT_OVF_MSK                            (0x1UL << AG903_TIMn_STAT_OVF_POS)                            /** TIMnSTAT OVF-bit mask */
#define AG903_TIMn_STAT_CM_POS                             1                                                             /** TIMnSTAT CM-bit position */
#define AG903_TIMn_STAT_CM_MSK                             (0x1UL << AG903_TIMn_STAT_CM_POS)                             /** TIMnSTAT CM-bit mask */
#define AG903_TIMn_STAT_DR_POS                             16                                                            /** TIMnSTAT DR-bit position */
#define AG903_TIMn_STAT_DR_MSK                             (0x1UL << AG903_TIMn_STAT_DR_POS)                             /** TIMnSTAT DR-bit mask */

#define AG903_TIMn_CLR_OVF_POS                             0                                                             /** TIMnCLR OVF-bit position */
#define AG903_TIMn_CLR_OVF_MSK                             (0x1UL << AG903_TIMn_CLR_OVF_POS)                             /** TIMnCLR OVF-bit mask */
#define AG903_TIMn_CLR_CM_POS                              1                                                             /** TIMnCLR CM-bit position */
#define AG903_TIMn_CLR_CM_MSK                              (0x1UL << AG903_TIMn_CLR_CM_POS)                              /** TIMnCLR CM-bit mask */

#define AG903_TIMn_INTMASK_OVF_POS                         0                                                             /** TIMnINTMASK OVF-bit position */
#define AG903_TIMn_INTMASK_OVF_MSK                         (0x1UL << AG903_TIMn_INTMASK_OVF_POS)                         /** TIMnINTMASK OVF-bit mask */
#define AG903_TIMn_INTMASK_CM_POS                          1                                                             /** TIMnINTMASK CM-bit position */
#define AG903_TIMn_INTMASK_CM_MSK                          (0x1UL << AG903_TIMn_INTMASK_CM_POS)                          /** TIMnINTMASK CM-bit mask */

#define AG903_TIMn_DMAREQ_OVF_POS                          0                                                             /** TIMnDMAREQ OVF-bit position */
#define AG903_TIMn_DMAREQ_OVF_MSK                          (0x1UL << AG903_TIMn_DMAREQ_OVF_POS)                          /** TIMnDMAREQ OVF-bit mask */
#define AG903_TIMn_DMAREQ_CM_POS                           1                                                             /** TIMnDMAREQ CM-bit position */
#define AG903_TIMn_DMAREQ_CM_MSK                           (0x1UL << AG903_TIMn_DMAREQ_CM_POS)                           /** TIMnDMAREQ CM-bit mask */

#define AG903_TIMn_TRIGGER_OVF_POS                         0                                                             /** TIMnTRIGGER OVF-bit position */
#define AG903_TIMn_TRIGGER_OVF_MSK                         (0x1UL << AG903_TIMn_TRIGGER_OVF_POS)                         /** TIMnTRIGGER OVF-bit mask */
#define AG903_TIMn_TRIGGER_CM_POS                          1                                                             /** TIMnTRIGGER CM-bit position */
#define AG903_TIMn_TRIGGER_CM_MSK                          (0x1UL << AG903_TIMn_TRIGGER_CM_POS)                          /** TIMnTRIGGER CM-bit mask */

#define AG903_TIM_BOOTTRG_CH0_POS                          0                                                             /** TIMBOOTTRG CH0-bit position */
#define AG903_TIM_BOOTTRG_CH0_MSK                          (0x1UL << AG903_TIM_BOOTTRG_CH0_POS)                          /** TIMBOOTTRG CH0-bit mask */
#define AG903_TIM_BOOTTRG_CH1_POS                          1                                                             /** TIMBOOTTRG CH1-bit position */
#define AG903_TIM_BOOTTRG_CH1_MSK                          (0x1UL << AG903_TIM_BOOTTRG_CH1_POS)                          /** TIMBOOTTRG CH1-bit mask */
#define AG903_TIM_BOOTTRG_CH2_POS                          2                                                             /** TIMBOOTTRG CH2-bit position */
#define AG903_TIM_BOOTTRG_CH2_MSK                          (0x1UL << AG903_TIM_BOOTTRG_CH2_POS)                          /** TIMBOOTTRG CH2-bit mask */
#define AG903_TIM_BOOTTRG_CH3_POS                          3                                                             /** TIMBOOTTRG CH3-bit position */
#define AG903_TIM_BOOTTRG_CH3_MSK                          (0x1UL << AG903_TIM_BOOTTRG_CH3_POS)                          /** TIMBOOTTRG CH3-bit mask */
#define AG903_TIM_BOOTTRG_CH4_POS                          4                                                             /** TIMBOOTTRG CH4-bit position */
#define AG903_TIM_BOOTTRG_CH4_MSK                          (0x1UL << AG903_TIM_BOOTTRG_CH4_POS)                          /** TIMBOOTTRG CH4-bit mask */
#define AG903_TIM_BOOTTRG_CH5_POS                          5                                                             /** TIMBOOTTRG CH5-bit position */
#define AG903_TIM_BOOTTRG_CH5_MSK                          (0x1UL << AG903_TIM_BOOTTRG_CH5_POS)                          /** TIMBOOTTRG CH5-bit mask */
#define AG903_TIM_BOOTTRG_CH6_POS                          6                                                             /** TIMBOOTTRG CH6-bit position */
#define AG903_TIM_BOOTTRG_CH6_MSK                          (0x1UL << AG903_TIM_BOOTTRG_CH6_POS)                          /** TIMBOOTTRG CH6-bit mask */
#define AG903_TIM_BOOTTRG_CH7_POS                          7                                                             /** TIMBOOTTRG CH7-bit position */
#define AG903_TIM_BOOTTRG_CH7_MSK                          (0x1UL << AG903_TIM_BOOTTRG_CH7_POS)                          /** TIMBOOTTRG CH7-bit mask */

#endif /* _AG903_TIM_REGMAP_H_ */

