/**
 * @brief           SSP Primitive Header
 * @author          AXELL CORPORATION
 * @description     SSP Primitive񋟃wb_B<p>SSP PrimitivegpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2025_03_06  [SDK3.7] SSP1[h̑MłȂsC (#5633)
 * @history         2025_03_06  [SDK3.7] SSPCuSPI[hł̑MANZX@\ǉ (#5662)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by Axell Corporation.
 * Copyright (C) 2017-2025 Axell Corporation, all rights reserved.
 */

#ifndef _SSPPRM_H_
#define _SSPPRM_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include "lib_common/AG903_common.h"

#ifdef __cplusplus
extern "C" {
#endif

/** SSP`l */
#define AG903_SSP_CH_NUM			(4)

/** f[^ MAXl [rbg] */
#define AG903_SSP_SDL_MAX			(128)

/** NbN MINl iSSPj*/
#define AG903_SSP_SSPDIV_MIN		(4)

/** NbN MINl iSPIj*/
#define AG903_SSP_SPIDIV_MIN		(2)

/** S/PDIF UrbgWX^ */
#define AG903_SSP_USERBIT_REGMAX	(12)

/** FIFOi */
#define AG903_SSP_FIFO_DEPTH		(16)

/** FIFOTCY */
#define AG903_SSP_FIFO_BITSIZE		(32)

/** tH[}bg */
enum _AG903_SspFormatType {
	AG903_SSP_FORMAT_SSP = 0,		/** Texas Instruments Synchronous Serial Port */
	AG903_SSP_FORMAT_SPI,			/** Motorola Serial Peripheral Interface */
	AG903_SSP_FORMAT_MICROWIRE,		/** National Semiconductor MICROWIRE */
	AG903_SSP_FORMAT_I2S,			/** Philips I2S */
	AG903_SSP_FORMAT_RESERVE,		/** reserve */
	AG903_SSP_FORMAT_SPDIF,			/** Sony/Philips Digital Interface Format */
	AG903_SSP_FORMAT_TYPENUM,		/** tH[}bgʐ */
};

/**  */
enum _AG903_SspOperationType {
	AG903_SSP_OPM_SLAVE = 0,		/** X[u m[h */
	AG903_SSP_OPM_SLAVE_STEREO,		/** X[u XeI[h */
	AG903_SSP_OPM_MASTER,			/** }X^ m[h */
	AG903_SSP_OPM_MASTER_STEREO,	/** }X^ XeI[h */
	AG903_SSP_OPM_NUM,				/** ʐ */
};

#define AG903_SSP_INTSTS_TFTHIBIT	(1<<3)	/** SSPnIntrStatus TFTHI-bit */
#define AG903_SSP_INTSTS_RFTHIBIT   (1<<2)	/** SSPnIntrStatus RFTHI-bit */
#define AG903_SSP_INTSTS_TFURIBIT   (1<<1)	/** SSPnIntrStatus TFURI-bit */
#define AG903_SSP_INTSTS_RFORIBIT   (1<<0)	/** SSPnIntrStatus RFORI-bit */

/** p[^ */
typedef struct _AG903_SSPPrmCtrl{
	uint16_t	sclk_div;		/** SCLK divider */
	uint8_t		pdl;			/** Padding data length */
	uint8_t		sdl;			/** Serial data length */
 //	uint8_t		fs_fdbk;		/** FS internal feedback */
 //	uint8_t		sclk_fdbk;		/** SCLK internal feedback */
	uint8_t		spi_fspo;		/** Frame/Sync polarity (SPI) */
	uint8_t		format;			/** Frame format */
	uint8_t		spi_flash;		/** SPI FLASH indicate (SPI)  */
	uint8_t		validity;		/** SPDIF validity (SPDIF)  */
	uint8_t		fsdist;			/** Frame/Sync and data distance (I2S) */
 //	uint8_t		lbm;			/** loopback mode */
	uint8_t		lsb;			/** Bit Sequence indicator (I2S/SPI) */
	uint8_t		fspo;			/** Frame/Sync polarity (I2S) */
	uint8_t		fsjstfy;		/** Data justify (I2S) */
	uint8_t		opm;			/** Operation Mode */
	uint8_t		sclkpo;			/** SCLK polarity (SPI) */
	uint8_t		sclkph;			/** SCLK phase (SPI) */
	uint8_t		reserve;		/** \ */
} AG903_SSPPrmCtrl;

/** p[^2 */
typedef struct _AG903_SSPPrmCtrl2 {
	uint8_t     fsos;			/** SPIt[M̏o̓|[g (SPI) */
	uint8_t     fs;				/** SPIt[M̏o̓x (SPI) */
	uint8_t     txen;			/** M@\̃Cl[u */
	uint8_t     rxen;			/** M@\̃Cl[u */
	uint8_t     ssprst;			/** SSP̃Xe[g}Ṽ\tgZbg */
 //	uint8_t     accrst;
 //	uint8_t     acwrst;
	uint8_t     txfclr;			/** MFIFÕNA */
	uint8_t     rxfclr;			/** MFIFÕNA */
	uint8_t     txdoe;			/** Mf[^̏o̓Cl[u */
	uint8_t     sspen;			/** SSP̃Cl[u */
} AG903_SSPPrmCtrl2;

/** Xe[^X */
typedef struct _AG903_SSPPrmStatus{
	uint8_t		txfifo_num;		/** MFIFOGg */
	uint8_t		rxfifo_num;		/** MFIFOGg */
	uint8_t		busy;			/** Busy [true=Busy] */
	uint8_t		txfifo_notfull; /** MFIFO Not Full [true=Not Full] */
	uint8_t		rxfifo_full;	/** MFIFO Full [true=Full] */
	uint8_t		reserve[3];		/** \ */
} AG903_SSPPrmStatus;

	/** 荞ݐ */
typedef struct _AG903_SSPPrmIntCtrl{
	uint8_t		tfthod;			/** MFIFÔl */
	uint8_t		rfthod;			/** MFIFÔl */
	uint8_t		tfdmaen;		/** MDMAṽCl[u */
	uint8_t		rfdmaen;		/** MDMAṽCl[u */
	uint8_t		tfthien;		/** MFIFOl荞݂̃Cl[u */
	uint8_t		rfthien;		/** MFIFOl荞݂̃Cl[u */
	uint8_t		tfurien;		/** MFIFOA_[荞݂̃Cl[u */ 
	uint8_t		rforien;		/** MFIFOI[o[荞݂̃Cl[u */
} AG903_SSPPrmIntCtrl;

void AG903_SSPPrmSetControl(uint8_t ch, AG903_SSPPrmCtrl* param);
void AG903_SSPPrmGetControl2(uint8_t ch, AG903_SSPPrmCtrl2* param);
void AG903_SSPPrmSetControl2(uint8_t ch, AG903_SSPPrmCtrl2* param);
void AG903_SSPPrmEnableOutput(uint8_t ch);
void AG903_SSPPrmDisableOutput(uint8_t ch);
void AG903_SSPPrmEnableTransfer(uint8_t ch);
void AG903_SSPPrmDisableTransfer(uint8_t ch);
void AG903_SSPPrmCheckEnable(uint8_t ch, uint8_t* enable);
void AG903_SSPPrmEnableTxFunc(uint8_t ch);
void AG903_SSPPrmDisbleTxFunc(uint8_t ch);
void AG903_SSPPrmEnableRxFunc(uint8_t ch);
void AG903_SSPPrmDisbleRxFunc(uint8_t ch);
void AG903_SSPPrmGetTxFifoEntry(uint8_t ch, uint8_t* entry);
void AG903_SSPPrmGetRxFifoEntry(uint8_t ch, uint8_t* entry);
void AG903_SSPPrmSetTxFifoThreshold(uint8_t ch, uint8_t val);
void AG903_SSPPrmSetRxFifoThreshold(uint8_t ch, uint8_t val);
void AG903_SSPPrmClearTxFifo(uint8_t ch);
void AG903_SSPPrmClearRxFifo(uint8_t ch);
void AG903_SSPPrmReset(uint8_t ch);
void AG903_SSPPrmSetStatusBit(uint8_t ch, uint32_t status_0, uint32_t status_1);
void AG903_SSPPrmSetUserBit(uint8_t ch, uint8_t offset, uint32_t val);
void AG903_SSPPrmEnableTxInt(uint8_t ch);
void AG903_SSPPrmDisbleTxInt(uint8_t ch);
void AG903_SSPPrmEnableRxInt(uint8_t ch);
void AG903_SSPPrmDisbleRxInt(uint8_t ch);
void AG903_SSPPrmEnableTxDmareq(uint8_t ch);
void AG903_SSPPrmDisableTxDmareq(uint8_t ch);
void AG903_SSPPrmEnableRxDmareq(uint8_t ch);
void AG903_SSPPrmDisableRxDmareq(uint8_t ch);
void AG903_SSPPrmSetData(uint8_t ch, uint32_t val);
void AG903_SSPPrmGetData(uint8_t ch, uint32_t* val);
void AG903_SSPPrmGetStatus(uint8_t ch, AG903_SSPPrmStatus* status);
void AG903_SSPPrmSetIntControl(uint8_t ch, AG903_SSPPrmIntCtrl* param);
void AG903_SSPPrmGetIntControl(uint8_t ch, AG903_SSPPrmIntCtrl* param);
void AG903_SSPPrmGetIntStatus(uint8_t ch, uint32_t* status);


#ifdef __cplusplus
}
#endif
#endif /* _SSPPRM_H_ */
