/**
 * @brief           TIMR Manager Header
 * @author          AXELL CORPORATION
 * @description     TIMR Manager񋟃wb_B<p>TIMR ManagergpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef _TIMRMGR_H_
#define _TIMRMGR_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include "lib_common/AG903_common.h"

#ifdef __cplusplus
extern "C" {
#endif

/** ch̊݃nh(ő吔AG903_OSWprCreIsrAuto̎Ɉˑ܂) */
#define AG903_TIMR_INTHDR_NUM		(2)

/** ^C}͒[q */
enum _AG903_TimrInputType {
	AG903_TIMR_INPUT_EXTIN0 = 0,	/** EXTIN[0]  */
	AG903_TIMR_INPUT_EXTIN1,		/** EXTIN[1]  */
	AG903_TIMR_INPUT_EXTIN2,		/** EXTIN[2]  */
	AG903_TIMR_INPUT_EXTIN3,		/** EXTIN[3]  */
	AG903_TIMR_INPUT_EXTOUT0,		/** EXTOUT[0] */
	AG903_TIMR_INPUT_EXTOUT1,		/** EXTOUT[1] */
	AG903_TIMR_INPUT_EXTOUT2,		/** EXTOUT[2] */
	AG903_TIMR_INPUT_EXTOUT3,		/** EXTOUT[3] */
	AG903_TIMR_INPUT_TYPENUM,		/** ^C}͒[qʐ */
};

/** [^GR[_͒[q */
enum _AG903_TimrInputTypeRotaryEncoder {
	AG903_TIMR_INPUT_REIN01 = 0,	/** A EXTIN[0], B EXTIN[1] */
	AG903_TIMR_INPUT_REIN23,		/** A EXTIN[2], B EXTIN[3] */
	AG903_TIMR_INPUT_REOUT01,		/** A EXTOUT[0], B EXTOUT[1] */
	AG903_TIMR_INPUT_REOUT23,		/** A EXTOUT[2], B EXTOUT[3] */
	AG903_TIMR_INPUT_RETYPENUM,		/** [^GR[_͒[qʐ */
};

/** TvONbN */
enum _AG903_TimrCntClkType {
	AG903_TIMR_CNT_SYSCLK = 0,		/** VXeNbN */
	AG903_TIMR_CNT_TICK0,			/** Tick0 */
	AG903_TIMR_CNT_TICK1,			/** Tick1 */
	AG903_TIMR_CNT_TYPENUM,			/** TvONbNʐ */
};

/** ^C}o͎ */
enum _AG903_TimrOutMode {
	AG903_TIMR_OUT_PLUSE = 0,		/** pXo */
	AG903_TIMR_OUT_LEVEL,			/** xo */
	AG903_TIMR_OUT_PWM,				/** PWMo */
	AG903_TIMR_OUT_MODENUM,			/** ^C}o͎ʐ */
};

/** ɐ */
enum _AG903_TimrPolarityType {
	AG903_TIMR_POL_POSITIVE = 0,	/** _ */
	AG903_TIMR_POL_NEGATIVE,		/** _ */
	AG903_TIMR_POL_TYPENUM,			/** ɐʐ */
};

/** ZbggK */
enum _AG903_TimrResetTriggerType {
	AG903_TIMR_RSTTRG_EXTPORT = 0,	/** O[q */
	AG903_TIMR_RSTTRG_EVENT,		/** Cxg */
	AG903_TIMR_RSTTRG_TYPENUM,		/** ZbggKʐ */
};

/** ݌orbgiRyAE}b`j*/
#define AG903_TIMR_COMPARE_BIT		(1<<1)

/** ݌orbgiI[o[t[j*/
#define AG903_TIMR_OVERFLOW_BIT		(1<<0)

/** TIMRnh */
typedef uint32_t	AG903_TIMRMgrHandle;

/** NbNETickv[hOutputp[^<p>
    mode ͉Ew肵܂B _AG903_TimrOutMode<p>
    portch 0`3Ń^C}o͒[qiTIO[3:0]jI܂B<p>
    polarity ͉Ew肵܂B _AG903_TimrPolarityType<p>
    mask ̓pXAxõ͎RyAE}b`oAI[o[t[õ}XNbitPʂŐݒ肵܂B<p>
    Bit1:RyAE}b`o<p>
    Bit0:I[o[t[o<p>
    0bFo}XN܂B 1bFo}XN܂B*/
typedef struct _AG903_TIMRMgrTickCntOutput{
	uint32_t	plusewidth;		/** pX (pXo͎) */
	uint8_t		mode;			/** o̓[h */
	uint8_t		portch;			/** o͒[q */
	uint8_t		polarity;		/** ɐ */
	uint8_t		mask;			/** }XN */
} AG903_TIMRMgrTickCntOutput;

/** NbNETickv[hݒp[^<p>
    o͒[qsȂꍇ output NULLƂĉB<p>
    resolution ͉Ew肵܂B _AG903_TimrCntClkType<p>
    oneshot  true=VbgAfalse=sIfBbN łB */
typedef struct _AG903_TIMRMgrTickCntParam{
	AG903_TIMRMgrTickCntOutput* output;	/** Outputp[^ */
	uint32_t	period;			/**  */
	uint32_t	match;			/** rl */
	uint8_t		resolution;		/** \w */
	uint8_t		oneshot;		/** Vbgw */
	uint8_t		reserve[2];		/** \ */
} AG903_TIMRMgrTickCntParam;

/** [^[GR[_̓[hOutputp[^<p>
    mode ͉Ew肵܂B _AG903_TimrOutMode<p>
    portch 0`3Ń^C}o͒[qiTIO[3:0]jI܂B<p>
    polarity ͉Ew肵܂B _AG903_TimrPolarityType */
typedef struct _AG903_TIMRMgrRotaryEncOutput{
	uint32_t	plusewidth;		/** pX (pXo͎) */
	uint8_t		mode;			/** o̓[h */
	uint8_t		portch;			/** o͒[q */
	uint8_t		polarity;		/** ɐ */
	uint8_t		reserve;		/** \ */
} AG903_TIMRMgrRotaryEncOutput;

/** [^[GR[_̓[hݒp[^<p>
    o͒[qsȂꍇ output NULLƂĉB<p>
    intype ͉Ew肵܂B  _AG903_TimrInputTypeRotaryEncoder<p>
    sampling ͉Ew肵܂B _AG903_TimrCntClkType */
typedef struct _AG903_TIMRMgrRotaryEncParam{
	AG903_TIMRMgrRotaryEncOutput* output;	/** Outputp[^ */
	uint32_t	range;			/** l */
	uint32_t	match;			/** rl */
	uint8_t		intype;			/** ̓^Cvw */
	uint8_t		sampling;		/** TvOԊu */
	uint8_t		reserve[2];		/** \ */
} AG903_TIMRMgrRotaryEncParam;

/** PWM̓[hOutputp[^<p>
    mode ͉Ew肵܂B _AG903_TimrOutMode<p>
    portch 0`3Ń^C}o͒[qiTIO[3:0]jI܂B<p>
    polarity ͉Ew肵܂B _AG903_TimrPolarityType */
typedef struct _AG903_TIMRMgrPwmInOutput{
	uint32_t	plusewidth;		/** pX (pXo͎) */
	uint8_t		mode;			/** o̓[h */
	uint8_t		portch;			/** o͒[q */
	uint8_t		polarity;		/** ɐ */
	uint8_t		reserve;		/** \ */
} AG903_TIMRMgrPwmInOutput;

/** PWM̓[hݒp[^<p>
    o͒[qsȂꍇ output NULLƂĉB<p>
    intype ͉Ew肵܂B _AG903_TimrInputType<p>
    resolution ͉Ew肵܂B _AG903_TimrCntClkType<p>
    oneshot  true=VbgAfalse=sIfBbN łB */
typedef struct _AG903_TIMRMgrPwmInParam{
	AG903_TIMRMgrPwmInOutput* output;	/** Outputp[^ */
	uint8_t		intype;			/** ̓^Cvw */
	uint8_t		polarity;		/** ͋ɐ */
	uint8_t		resolution;		/** \w */
	uint8_t		oneshot;		/** Vbgw */
} AG903_TIMRMgrPwmInParam;

/** Cxgv[hOutputp[^<p>
    mode ͉Ew肵܂B _AG903_TimrOutMode<p>
    portch 0`3Ń^C}o͒[qiTIO[3:0]jI܂B<p>
    polarity ͉Ew肵܂B _AG903_TimrPolarityType<p>
    mask ̓pXAxõ͎RyAE}b`oAI[o[t[õ}XNbitPʂŐݒ肵܂B<p>
    Bit1:RyAE}b`o<p>
    Bit0:I[o[t[o<p>
    0bFo}XN܂B 1bFo}XN܂B*/
typedef struct _AG903_TIMRMgrEventCntOutput{
	uint32_t	plusewidth;		/** pX (pXo͎) */
	uint8_t		mode;			/** o̓[h */
	uint8_t		portch;			/** o͒[qch */
	uint8_t		polarity;		/** ɐ */
	uint8_t		mask;			/** }XN */
} AG903_TIMRMgrEventCntOutput;

/** Cxgv[hݒp[^<p>
    o͒[qsȂꍇ output NULLƂĉB<p>
    event ͌vΏۂ̃Cxgw肵܂BCxgԍɂẮwAX51903dlxQƂĉB<p>
    oneshot  true=VbgAfalse=sIfBbN łB */
typedef struct _AG903_TIMRMgrEventCntParam{
	AG903_TIMRMgrEventCntOutput* output;	/** Outputp[^ */
	uint32_t	period;			/**  */
	uint32_t	match;			/** rl */
	uint8_t		event;			/** Cxgw */
	uint8_t		oneshot;		/** Vbgw */
	uint8_t		reserve[2];		/** \ */
} AG903_TIMRMgrEventCntParam;

/** ͒[qpXv[hOutputp[^<p>
    mode ͉Ew肵܂B _AG903_TimrOutMode<p>
    portch 0`3Ń^C}o͒[qiTIO[3:0]jI܂B<p>
    polarity ͉Ew肵܂B _AG903_TimrPolarityType<p>
    mask ̓pXAxõ͎RyAE}b`oAI[o[t[õ}XNbitPʂŐݒ肵܂B<p>
    Bit1:RyAE}b`o<p>
    Bit0:I[o[t[o<p>
    0bFo}XN܂B 1bFo}XN܂B*/
typedef struct _AG903_TIMRMgrPulseCntOutput{
	uint32_t	plusewidth;		/** pX (pXo͎) */
	uint8_t		mode;			/** o̓[h */
	uint8_t		portch;			/** o͒[qch */
	uint8_t		polarity;		/** ɐ */
	uint8_t		mask;			/** }XN */
} AG903_TIMRMgrPulseCntOutput;

/** ͒[qpXv[hݒp[^<p>
    o͒[qsȂꍇ output NULLƂĉB<p>
    intype ͉Ew肵܂B _AG903_TimrInputType<p>
    polarity ͉Ew肵܂B _AG903_TimrPolarityType<p>
    sampling ͉Ew肵܂B _AG903_TimrCntClkType<p>
    oneshot  true=VbgAfalse=sIfBbN łB */
typedef struct _AG903_TIMRMgrPulseCntParam{
	AG903_TIMRMgrPulseCntOutput* output;	/** Outputp[^ */
	uint32_t	period;			/**  */
	uint32_t	match;			/** rl */
	uint8_t		intype;			/** ̓^Cvw */
	uint8_t		polarity;		/** ͋ɐ */
	uint8_t		sampling;		/** TvOԊu */
	uint8_t		oneshot;		/** Vbgw */
} AG903_TIMRMgrPulseCntParam;

/** ͒[qxv[hOutputp[^<p>
    mode ͉Ew肵܂B _AG903_TimrOutMode<p>
    portch 0`3Ń^C}o͒[qiTIO[3:0]jI܂B<p>
    polarity ͉Ew肵܂B _AG903_TimrPolarityType<p>
    mask ̓pXAxõ͎RyAE}b`oAI[o[t[õ}XNbitPʂŐݒ肵܂B<p>
    Bit1:RyAE}b`o<p>
    Bit0:I[o[t[o<p>
    0bFo}XN܂B 1bFo}XN܂B*/
typedef struct _AG903_TIMRMgrLevelCntOutput{
	uint32_t	plusewidth;		/** pX (pXo͎) */
	uint8_t		mode;			/** o̓[h */
	uint8_t		portch;			/** o͒[qch */
	uint8_t		polarity;		/** ɐ */
	uint8_t		mask;			/** }XN */
} AG903_TIMRMgrLevelCntOutput;

/** ͒[qxv[hݒp[^<p>
    o͒[qsȂꍇ output NULLƂĉB<p>
    intype ͉Ew肵܂B _AG903_TimrInputType<p>
    polarity ͉Ew肵܂B _AG903_TimrPolarityType<p>
    sampling ͉Ew肵܂B _AG903_TimrCntClkType<p>
    oneshot  true=VbgAfalse=sIfBbN łB */
typedef struct _AG903_TIMRMgrLevelCntParam{
	AG903_TIMRMgrLevelCntOutput* output;	/** Outputp[^ */
	uint32_t	period;			/**  */
	uint32_t	match;			/** rl */
	uint8_t		intype;			/** ̓^Cvw */
	uint8_t		polarity;		/** ͋ɐ */
	uint8_t		sampling;		/** TvOԊu  */
	uint8_t		oneshot;		/** Vbgw */
} AG903_TIMRMgrLevelCntParam;

/** ZbggKݒp[^<p>
    trigger ͉Ew肵܂B _AG903_TimrResetTriggerType<p>
    event ͌vΏۂ̃Cxgw肵܂BCxgԍɂẮwAX51903dlxQƂĉB<p>
    intype ͉Ew肵܂B _AG903_TimrInputType<p>
    polarity ͉Ew肵܂B _AG903_TimrPolarityType<p>
    sampling ͉Ew肵܂B _AG903_TimrCntClkType */
typedef struct _AG903_TIMRMgrResetParam{
	uint8_t		trigger;		/** gK */
	uint8_t		event;			/** Cxgw (CxgTrigger) */
	uint8_t		intype;			/** ͒[qw (O[qTrigger) */
	uint8_t		polarity;		/** ɐ (O[qTrigger) */
	uint8_t		sampling;		/** TvOԊu (O[qTrigger) */
	uint8_t		reserve[3];		/** \ */
} AG903_TIMRMgrResetParam;


int32_t	AG903_TIMRMgrInit(void);
int32_t	AG903_TIMRMgrGetHandle(AG903_TIMRMgrHandle** handle);
int32_t	AG903_TIMRMgrReleaseHandle(AG903_TIMRMgrHandle* handle);
int32_t	AG903_TIMRMgrSetIntHandler(AG903_TIMRMgrHandle* handle, void* func, void* param);
int32_t	AG903_TIMRMgrDeleteIntHandler(AG903_TIMRMgrHandle* handle, void* func);
int32_t	AG903_TIMRMgrSetRotaryEncoderMode(AG903_TIMRMgrHandle* handle, AG903_TIMRMgrRotaryEncParam* param);
int32_t	AG903_TIMRMgrSetPwmInMode(AG903_TIMRMgrHandle* handle, AG903_TIMRMgrPwmInParam* param);
int32_t	AG903_TIMRMgrSetTickCountMode(AG903_TIMRMgrHandle* handle, AG903_TIMRMgrTickCntParam* param);
int32_t	AG903_TIMRMgrSetEventCountMode(AG903_TIMRMgrHandle* handle, AG903_TIMRMgrEventCntParam* param);
int32_t	AG903_TIMRMgrSetPulseCountMode(AG903_TIMRMgrHandle* handle, AG903_TIMRMgrPulseCntParam* param);
int32_t	AG903_TIMRMgrSetLevelCountMode(AG903_TIMRMgrHandle* handle, AG903_TIMRMgrLevelCntParam* param);
int32_t	AG903_TIMRMgrStart(AG903_TIMRMgrHandle* handle);
int32_t	AG903_TIMRMgrStop(AG903_TIMRMgrHandle* handle);
int32_t	AG903_TIMRMgrStartMulti(uint8_t chbit);
int32_t	AG903_TIMRMgrEnableResetTrigger(AG903_TIMRMgrHandle* handle, AG903_TIMRMgrResetParam* param);
int32_t	AG903_TIMRMgrDisableResetTrigger(AG903_TIMRMgrHandle* handle);
int32_t	AG903_TIMRMgrEnableOneShot(AG903_TIMRMgrHandle* handle);
int32_t	AG903_TIMRMgrDisableOneShot(AG903_TIMRMgrHandle* handle);
int32_t	AG903_TIMRMgrEnableIntMask(AG903_TIMRMgrHandle* handle, uint8_t target);
int32_t	AG903_TIMRMgrDisableIntMask(AG903_TIMRMgrHandle* handle, uint8_t target);
int32_t	AG903_TIMRMgrEnableEventTrigger(AG903_TIMRMgrHandle* handle, uint8_t target);
int32_t	AG903_TIMRMgrDisableEventTrigger(AG903_TIMRMgrHandle* handle, uint8_t target);
int32_t	AG903_TIMRMgrEnableDmaRequest(AG903_TIMRMgrHandle* handle, uint8_t target);
int32_t	AG903_TIMRMgrDisableDmaRequest(AG903_TIMRMgrHandle* handle, uint8_t target);
int32_t	AG903_TIMRMgrGetStatus(AG903_TIMRMgrHandle* handle, uint32_t* status);
int32_t	AG903_TIMRMgrClearStatus(AG903_TIMRMgrHandle* handle, uint32_t target);
int32_t	AG903_TIMRMgrGetCount(AG903_TIMRMgrHandle* handle, uint32_t* count);
int32_t	AG903_TIMRMgrSetCount(AG903_TIMRMgrHandle* handle, uint32_t count);
int32_t	AG903_TIMRMgrGetPeriodValue(AG903_TIMRMgrHandle* handle, uint32_t* period);
int32_t	AG903_TIMRMgrSetPeriodValue(AG903_TIMRMgrHandle* handle, uint32_t period);
int32_t	AG903_TIMRMgrGetMatchValue(AG903_TIMRMgrHandle* handle, uint32_t* match);
int32_t	AG903_TIMRMgrSetMatchValue(AG903_TIMRMgrHandle* handle, uint32_t match);
int32_t	AG903_TIMRMgrGetChannel(AG903_TIMRMgrHandle* handle, uint8_t* ch);


#ifdef __cplusplus
}
#endif
#endif /* _TIMRMGR_H_ */
