/**
 * @brief           UART Manager Header
 * @author          AXELL CORPORATION
 * @description     UART Manager񋟃wb_B<p>UART ManagergpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _UARTMGR_H_
#define _UARTMGR_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include "lib_common/AG903_common.h"

#ifdef __cplusplus
extern "C" {
#endif

/** CLK_FTP̎g [Hz] */
#define AG903_UART_CLK			(100000000)

/** Mobt@TCY */
#define AG903_UART_BUFSIZE		(512)

/** peBw iȂj*/
#define AG903_UART_PARITY_NON	(0)
/** peBw ij*/
#define AG903_UART_PARITY_ODD	(1)
/** peBw ij*/
#define AG903_UART_PARITY_EVEN	(2)

/** Xgbvrbgw i1rbgj*/
#define AG903_UART_STOPBIT_1	(1)
/** Xgbvrbgw i2rbgj*/
#define AG903_UART_STOPBIT_2	(2)
/** Xgbvrbgw i1.5rbgj*/
#define AG903_UART_STOPBIT_1_5	(3)

/** f[^rbgw i5rbgj*/
#define AG903_UART_DATBIT_5		(5)
/** f[^rbgw i6rbgj*/
#define AG903_UART_DATBIT_6		(6)
/** f[^rbgw i7rbgj*/
#define AG903_UART_DATBIT_7		(7)
/** f[^rbgw i8rbgj*/
#define AG903_UART_DATBIT_8		(8)

/** t[w iȂj*/
#define AG903_UART_FLOW_NON		(0)
/** t[w iRTS/CTSj*/
#define AG903_UART_FLOW_CTS		(1)

/** ݒl i{[E[gj*/
#define AG903_UART_DFLT_BAUD	(9600)
/** ݒl ipeBj*/
#define AG903_UART_DFLT_PARITY	(AG903_UART_PARITY_NON)
/** ݒl iXgbvrbgj*/
#define AG903_UART_DFLT_STOPBIT	(AG903_UART_STOPBIT_1)
/** ݒl if[^rbgj*/
#define AG903_UART_DFLT_DATBIT	(AG903_UART_DATBIT_8)
/** ݒl it[j*/
#define AG903_UART_DFLT_FLOW	(AG903_UART_FLOW_NON)

/** ZbgFIFOw iRXFIFOj*/
#define AG903_UART_RESET_RXFIFO	(1<<0)
/** ZbgFIFOw iTXFIFOj*/
#define AG903_UART_RESET_TXFIFO	(1<<1)

/** Cxgwrbg iRS485M^CAEgj*/
#define AG903_UART_RCVTIMEOUT_BIT	(1<<0)
/** Cxgwrbg iRS485LN^ԎM^CAEgj*/
#define AG903_UART_CHARATIMEOUT_BIT	(1<<1)

/** Cxgorbg iMj*/
#define AG903_UART_EVENT_SNDEND		(1<<0)
/** Cxgorbg iMf[^Ȃj*/
#define AG903_UART_EVENT_SNDEMPTY	(1<<1)
/** Cxgorbg iMf[^Lj*/
#define AG903_UART_EVENT_DATARDY	(1<<2)
/** Cxgorbg iM^CAEgj*/
#define AG903_UART_EVENT_RCVTIMEOUT	(1<<3)
/** Cxgorbg iBreakMj*/
#define AG903_UART_EVENT_BREAK		(1<<4)
/** Cxgorbg iRS485M^CAEgj*/
#define AG903_UART_EVENT_RS485_RTO	(1<<5)
/** Cxgorbg iRS485LN^ԎM^CAEgj*/
#define AG903_UART_EVENT_RS485_CTO	(1<<6)
/** Cxgorbg iI[o[j*/
#define AG903_UART_EVENT_OVERRUN	(1<<8)
/** Cxgorbg ipeBG[j*/
#define AG903_UART_EVENT_PARITYERR	(1<<9)
/** Cxgorbg it[~OG[j*/
#define AG903_UART_EVENT_FRAMINGERR	(1<<10)
/** Cxgorbg iFIFOf[^G[j*/
#define AG903_UART_EVENT_FIFOERR	(1<<11)

/** UARTnh */
typedef uint32_t	AG903_UARTMgrHandle;

/** R[obN֐̌^B<p>
    handleUARTnhAevent̓CxgorbgłB<p>
    eventBitATC͈ȉ̒ʂłB<p>
    <table>
    <tr><th>bit</th><th>e</th></tr>
    <tr><td>31:12</td><td>reserve</td></tr>
    <tr><td>11</td><td>FIFOf[^G[</td></tr>
    <tr><td>10</td><td>t[~OG[</td></tr>
    <tr><td>9</td><td>peBG[</td></tr>
    <tr><td>8</td><td>I[o[G[</td></tr>
    <tr><td>7</td><td>reserve</td></tr>
    <tr><td>6</td><td>RS485LN^ԎM^CAEg</td></tr>
    <tr><td>5</td><td>RS485M^CAEg</td></tr>
    <tr><td>4</td><td>BreakM</td></tr>
    <tr><td>3</td><td>Mf[^Li^CAEgj</td></tr>
    <tr><td>2</td><td>Mf[^L</td></tr>
    <tr><td>1</td><td>Mf[^Ȃ(DMA)</td></tr>
    <tr><td>0</td><td>M(PIO)</td></tr>
    </table> */
typedef void (*AG903_UARTMgrClbk)(AG903_UARTMgrHandle* handle, uint32_t event);

/** UARTݒp[^<p>
    parity ͉Ew肵܂B AG903_UART_PARITY_NON , AG903_UART_PARITY_EVEN , AG903_UART_PARITY_ODD<p>
    stopbit ͉Ew肵܂B AG903_UART_STOPBIT_1 , AG903_UART_STOPBIT_1_5 , AG903_UART_STOPBIT_2<p>
    databit ͉Ew肵܂B AG903_UART_DATBIT_5 , AG903_UART_DATBIT_6 , AG903_UART_DATBIT_7 , AG903_UART_DATBIT_8<p>
    flow ͉Ew肵܂B AG903_UART_FLOW_NON , AG903_UART_FLOW_CTS */
typedef struct _AG903_UARTMgrParam {
	uint32_t	baud;		/** {[E[g [bps] */
	uint8_t		parity;		/** peB (Ȃ/Even/Odd) */
	uint8_t		stopbit;	/** Xgbvrbg (1/1.5/2) */
	uint8_t		databit;   	/** f[^rbg (5/6/7/8) */
	uint8_t		flow;		/** t[ (Ȃ/CTS,RTS) */
} AG903_UARTMgrParam;

/** RS485ݒp[^<p>
    event ͈ȉ̊ebitɁh1hw肷ƃCxgLɂȂ܂B<p>
    <table>
    <tr><th>bit</th><th>e</th></tr>
    <tr><td>1</td><td>LN^ԎM^CAEg</td></tr>
    <tr><td>0</td><td>M^CAEg</td></tr>
    </table> */
typedef struct _AG903_UARTMgrRs485Param {
	uint32_t	setuptime;	/** ZbgAbv [clk] */
	uint32_t	holdtime;	/** z[h [clk] */
	uint32_t	rcvtime;	/** M [clk] */
	uint32_t	interval;	/** LN^Ԋu [clk] */
	uint32_t	timeout;	/** M^CAEgl [clk] */
	uint32_t	event;	    /** Timeout Eventݒ */
} AG903_UARTMgrRs485Param;


int32_t	AG903_UARTMgrInit(uint8_t ch);
int32_t	AG903_UARTMgrGetHandle(uint8_t ch, AG903_UARTMgrHandle** handle);
int32_t	AG903_UARTMgrReleaseHandle(AG903_UARTMgrHandle* handle);
int32_t	AG903_UARTMgrSetCallback(AG903_UARTMgrHandle* handle, AG903_UARTMgrClbk clbk);
int32_t AG903_UARTMgrSetParam(AG903_UARTMgrHandle*handle, AG903_UARTMgrParam* param);
int32_t AG903_UARTMgrSetRs485Param(AG903_UARTMgrHandle*handle, AG903_UARTMgrRs485Param *param);
int32_t AG903_UARTMgrSend(AG903_UARTMgrHandle* handle, uint8_t* buf, uint32_t size, _Bool dma);
int32_t AG903_UARTMgrReceive(AG903_UARTMgrHandle* handle, _Bool dma);
int32_t AG903_UARTMgrGetReceiveData(AG903_UARTMgrHandle* handle, uint8_t* buf, uint32_t size);
int32_t AG903_UARTMgrStopSend(AG903_UARTMgrHandle* handle);
int32_t AG903_UARTMgrStopReceive(AG903_UARTMgrHandle* handle);
int32_t AG903_UARTMgrResetFifo(AG903_UARTMgrHandle* handle, uint8_t rstbit);
int32_t AG903_UARTMgrSetBreak(AG903_UARTMgrHandle* handle, _Bool enable);

#ifdef __cplusplus
}
#endif
#endif /* _UARTMGR_H_ */
