/**
 * @brief           VID Primitive Header
 * @author          AXELL CORPORATION
 * @description     VID Primitive Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef VIDPRM_H
#define VIDPRM_H
/* DOM-IGNORE-END */

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/** Oo̓`l̍ő吔 */
#define AG903_VID_PRM_MAX_IO_PORTS          (2)

/** Lv`o͂̍ő吔 */
#define AG903_VID_PRM_MAX_CAPTURE_PORTS     (4)

/** VIDIOnMODWX^p[^ */
typedef struct _VIDPrmParamVIDIOnMOD
{
	uint32_t vpol;                          /** VPOLtB[hl */
	uint32_t hpol;                          /** HPOLtB[hl */
	uint32_t dpol;                          /** DPOLtB[hl */
	uint32_t fpol;                          /** FPOLtB[hl */
	uint32_t cpol;                          /** CPOLtB[hl */
} VIDPrmParamVIDIOnMOD;

/** VIDCOnMODWX^p[^ */
typedef struct _VIDPrmParamVIDCOnMOD
{
	uint32_t tdmblk;                        /** TDMBLKtB[hl */
	uint32_t tdmtrs;                        /** TDMTRStB[hl */
	uint32_t delay;                         /** DELAYtB[hl  */
	uint32_t trsdec;                        /** TRSDECtB[hl */
} VIDPrmParamVIDCOnMOD;

/** VIDCOnTRSPRMWX^p[^ */
typedef struct _VIDPrmParamVIDCOnTRSPRM
{
	uint32_t efp;                           /** EFPtB[h  */
	uint32_t ofp;                           /** OFPtB[h  */
	uint32_t vfp;                           /** VFPtB[h  */
	uint32_t href;                          /** HREFtB[h */
	uint32_t hfp;                           /** HFPtB[h  */
} VIDPrmParamVIDCOnTRSPRM;

/** VIDCOnSTATWX^p[^ */
typedef struct _VIDPrmParamVIDCOnSTAT
{
	uint32_t blkval;                        /** BLKVALtB[hl */
	uint32_t trsval;                        /** TRSVALtB[hl */
	uint32_t vblank;                        /** VBLANKtB[hl */
	uint32_t hblank;                        /** HBLANKtB[hl */
	uint32_t tdmch;                         /** TDMCHtB[hl  */
} VIDPrmParamVIDCOnSTAT;

/** VIDCOnVST0WX^p[^ */
typedef struct _VIDPrmParamVIDCOnVST0
{
	uint32_t scan;                          /** SCANtB[hl */
	uint32_t ebp;                           /** EBPtB[hl  */
	uint32_t efp;                           /** EFPtB[hl  */
	uint32_t obp;                           /** OBPtB[hl  */
	uint32_t ofp;                           /** OFPtB[hl  */
	uint32_t vpw;                           /** VPWtB[hl  */
} VIDPrmParamVIDCOnVST0;


void AG903_VidPrmSetVIDCTRL(uint32_t on);
void AG903_VidPrmGetVIDCTRL(uint32_t *on);
void AG903_VidPrmSetVIDFMT(uint32_t fmt);
void AG903_VidPrmGetVIDFMT(uint32_t *fmt);
void AG903_VidPrmSetVIDIOnCTRL(uint32_t id, uint32_t soe);
void AG903_VidPrmGetVIDIOnCTRL(uint32_t id, uint32_t *soe);
void AG903_VidPrmSetVIDIOnMOD(uint32_t id, VIDPrmParamVIDIOnMOD *mod);
void AG903_VidPrmGetVIDIOnMOD(uint32_t id, VIDPrmParamVIDIOnMOD *mod);
void AG903_VidPrmSetVIDIOnOHPRM0(uint32_t id, uint32_t hpw);
void AG903_VidPrmGetVIDIOnOHPRM0(uint32_t id, uint32_t *hpw);
void AG903_VidPrmSetVIDIOnOHPRM1(uint32_t id, uint32_t hfp, uint32_t hbp);
void AG903_VidPrmGetVIDIOnOHPRM1(uint32_t id, uint32_t *hfp, uint32_t *hbp);
void AG903_VidPrmSetVIDIOnOVPRM0(uint32_t id, uint32_t vpw);
void AG903_VidPrmGetVIDIOnOVPRM0(uint32_t id, uint32_t *vpw);
void AG903_VidPrmSetVIDIOnOVPRM1(uint32_t id, uint32_t vfp, uint32_t vbp);
void AG903_VidPrmGetVIDIOnOVPRM1(uint32_t id, uint32_t *vfp, uint32_t *vbp);
void AG903_VidPrmSetVIDIOnOSIZE(uint32_t id, uint32_t vfs, uint32_t hfs);
void AG903_VidPrmGetVIDIOnOSIZE(uint32_t id, uint32_t *vfs, uint32_t *hfs);
void AG903_VidPrmGetVIDIOnSTAT(uint32_t id, uint32_t *cwt);
void AG903_VidPrmSetVIDCOnMOD(uint32_t id, VIDPrmParamVIDCOnMOD *mod);
void AG903_VidPrmGetVIDCOnMOD(uint32_t id, VIDPrmParamVIDCOnMOD *mod);
void AG903_VidPrmSetVIDCOnTRSPRM(uint32_t id, VIDPrmParamVIDCOnTRSPRM *trsprm);
void AG903_VidPrmGetVIDCOnTRSPRM(uint32_t id, VIDPrmParamVIDCOnTRSPRM *trsprm);
void AG903_VidPrmSetVIDCOnSDPRM(uint32_t id, uint32_t vmax, uint32_t hmax);
void AG903_VidPrmGetVIDCOnSDPRM(uint32_t id, uint32_t *vmax, uint32_t *hmax);
void AG903_VidPrmGetVIDCOnSTAT(uint32_t id, VIDPrmParamVIDCOnSTAT *stat);
void AG903_VidPrmGetVIDCOnHST0(uint32_t id, uint32_t *hpw);
void AG903_VidPrmGetVIDCOnHST1(uint32_t id, uint32_t *hfp, uint32_t *hbp);
void AG903_VidPrmGetVIDCOnVST0(uint32_t id, VIDPrmParamVIDCOnVST0 *vst0);
void AG903_VidPrmGetVIDCOnVST1(uint32_t id, uint32_t *vfp, uint32_t *vbp);
void AG903_VidPrmGetVIDCOnFST(uint32_t id, uint32_t *vfs, uint32_t *hfs);


#ifdef __cplusplus
}
#endif

#endif
