/*
 * @history 2019_12_27  [SDK3.0] Lv`[XP[XŃAiOLv`̂ƂCMOSo͂I\ɕύX (#1704)
 */
#ifndef __CAP_COMMON_H__
#define __CAP_COMMON_H__

#include <stdint.h>
#include "via/viamgr.h"
#include "vid/vidmgr.h"
#include "dsp/dspmgr.h"

/* }N */
#define CAP_Printf(FMT, ...)	sys_print(0, FMT,##__VA_ARGS__)
#define CAP_ErrPrintf(FMT, ...)	sys_print(1, FMT,##__VA_ARGS__)
#define RTNCODE					gCAPErrCode
#define ERRCHK(chk,syntax)		do{ RTNCODE=syntax; if (chk!=RTNCODE) CAP_ErrPrintf("ERROR: %s():L%u\r\n",__func__,__LINE__); }while(0)
#define NOERR(syntax)			do{ if (gCAPErrCode==AG903_ENONE){ syntax; } }while(0)
#define NOERRCHK(chk,syntax)	NOERR(ERRCHK(chk,syntax);)

/* Lv` */
enum{
	CAP_MODE_VIA_LVDS = 0,
	CAP_MODE_VID,
	CAP_MODE_VIA_CMOS,	
	CAP_MODE_MAX,
};

typedef struct _CAP_Framebuffer {
	void *buf;
	size_t size;
}CAP_Framebuffer;

/* Lv`Jnʒu */
#define CAP_VIA_HPOS_OFFSET			(80+(720-640)/2)
#define CAP_VIA_VPOS_OFFSET			10
#define CAP_VID_HPOS_OFFSET			118
#define CAP_VID_VPOS_OFFSET			34

/* ͉𑜓x */
#define CAP_ANALOG_IN_WIDTH			640
#define CAP_ANALOG_IN_HEIGHT		480
#define CAP_DIGITAL_IN_WIDTH		720
#define CAP_DIGITAL_IN_HEIGHT		480

/* ͉𑜓x @\ʍől */
#define CAP_HISTOGRAM_MAX_WIDTH		640
#define CAP_HISTOGRAM_MAX_HEIGHT	480
#define CAP_LABELING_MAX_WIDTH		640

/* o͉𑜓x */
#define CAP_DISPLAY_WIDTH			1920
#define CAP_DISPLAY_HEIGHT			1080
#define CAP_WINDOW_WIDTH			640
#define CAP_WINDOW_HEIGHT			480

/* pCvC~^CAEg */
#define CAP_PIPESTOP_TIMEOUT		(5000/10)

/* HSYNCɑ΂Ă̒xw [pixel] */
#define CAP_HSYNC_DELAY				0

void* CAP_GetFramebufferAddr(void);
void CAP_SetFramebufferAddr(void *addr);
AG903_ViaMgrInputHandle* CAP_GetVIAHandle(uint8_t ch);
AG903_VidMgrOutputHandle* CAP_GetVIDOutHandle(void);
AG903_DSPMgrHandle* CAP_GetDSPHandle(uint8_t ch);

int32_t CAP_SetupVIA(void);
int32_t CAP_ReleaseVIA(void);
int32_t CAP_SetupVID(void);
int32_t CAP_ReleaseVID(void);
int32_t CAP_SetupDisplay(int32_t mode);
int32_t CAP_ReleaseDisplay(void);
uint32_t getColorByHue(uint8_t index);

#endif /* __CAP_COMMON_H__ */
