/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

/* VGPathIuWFNg */
static VGPath path;

VGubyte pathcmd[] = {
    0x02, 0x0e, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x06, 0x0a, 0x0a,
    0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x06, 0x0a, 0x00,
};
VGfloat pathdata[] = {
    163.30, 246.10, 149.50, 259.90, 135.70, 273.70, 112.70, 273.70,
    82.80, 273.70, 71.30, 262.20, 57.50, 248.40, 57.50, 232.30,
    57.50, 220.80, 69.00, 209.30, 85.10, 193.20, 138.00, 174.80,
    179.40, 161.00, 197.80, 142.60, 218.50, 121.90, 218.50, 87.40,
    218.50, 55.20, 195.50, 32.20, 163.30, 0.00, 112.70, 0.00,
    57.50, 0.00, 29.90, 27.60, 0.00, 57.50, 2.30, 121.90,
    48.30, 48.30, 71.30, 62.10, 57.50, 78.20, 41.40, 110.40,
    41.40, 142.60, 41.40, 158.70, 57.50, 172.50, 71.30, 172.50,
    89.70, 172.50, 103.50, 158.70, 117.30, 144.90, 131.10, 105.80,
    144.90, 48.30, 165.60, 29.90, 184.00, 9.20, 204.70, 9.20,
    234.60, 9.20, 264.50, 34.50, 289.80, 59.80, 315.10, 112.70,
    315.10, 158.70, 315.10, 186.30, 287.50, 213.90, 259.90, 211.60,
    220.80, 165.60, 163.30, 246.10, 149.50, 259.90,
};

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {1.0F, 1.0F, 1.0F, 1.0F};

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);

    /* VGPathIuWFNg̐ */
    path = vgCreatePath(VG_PATH_FORMAT_STANDARD, VG_PATH_DATATYPE_F, 1.0F, 0.0F, 0, 0, VG_PATH_CAPABILITY_ALL);

    /* VGPathIuWFNgɌ`f[^o^ */
    vgAppendPathData(path, sizeof(pathcmd), pathcmd, pathdata);

    /* Jg}gNXPATH_USER_TO_SURFACEɐݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_PATH_USER_TO_SURFACE);
    vgLoadIdentity();
}

static void DrawFastPath(void)
{
    /* pX`惂[hL */
    vgSetiEXT(VG_EXT_FAST_PATH_OPERATION, VG_TRUE);

    /* Q[h */
    vgSetiEXT(VG_EXT_FILL_BEZIER_TYPE, VG_EXT_BEZIER_TYPE_DIV2);
    vgLoadIdentity(); vgTranslate(20, 2);   vgScale(0.02, 0.02);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(60, 2);   vgScale(0.04, 0.04);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(120, 2);  vgScale(0.1, 0.1);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(200, 2);  vgScale(0.2, 0.2);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(300, 2);  vgScale(0.4, 0.4);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(450, 2);  vgScale(0.5, 0.5);
    vgDrawPath(path, VG_FILL_PATH);

    /* S[h */
    vgSetiEXT(VG_EXT_FILL_BEZIER_TYPE, VG_EXT_BEZIER_TYPE_DIV4);
    vgLoadIdentity(); vgTranslate(20, 160);   vgScale(0.02, 0.02);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(60, 160);   vgScale(0.04, 0.04);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(120, 160);  vgScale(0.1, 0.1);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(200, 160);  vgScale(0.2, 0.2);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(300, 160);  vgScale(0.4, 0.4);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(450, 160);  vgScale(0.5, 0.5);
    vgDrawPath(path, VG_FILL_PATH);

    /* Qׂ̂敪[h i2^3=8j*/
    vgSetiEXT(VG_EXT_FILL_BEZIER_TYPE, VG_EXT_BEZIER_TYPE_POW2);
    vgSetiEXT(VG_EXT_FILL_BEZIER_POW2_NUM, 3);
    vgLoadIdentity(); vgTranslate(20, 318);   vgScale(0.02, 0.02);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(60, 318);   vgScale(0.04, 0.04);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(120, 318);  vgScale(0.1, 0.1);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(200, 318);  vgScale(0.2, 0.2);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(300, 318);  vgScale(0.4, 0.4);
    vgDrawPath(path, VG_FILL_PATH);
    vgLoadIdentity(); vgTranslate(450, 318);  vgScale(0.5, 0.5);
    vgDrawPath(path, VG_FILL_PATH);

    /* pX`惂[h */
    vgSetiEXT(VG_EXT_FAST_PATH_OPERATION, VG_FALSE);
}

static void TestTerm(void)
{
    /* IuWFNg̔j */
    vgDestroyPath(path);
}

void FastPathMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* pX` */
    DrawFastPath();

    /* obt@Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}

