/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

#define POS00_X     40
#define POS00_Y     50
#define POS01_X     330
#define POS01_Y     10
#define POS02_X     600
#define POS02_Y     50
#define POS10_X     40
#define POS10_Y     300
#define POS11_X     330
#define POS11_Y     260
#define POS12_X     600
#define POS12_Y     300
#define ROT_0       0
#define ROT_1       45
#define ROT_2       90

static VGImage image;
static VGPath path;
static void *image_data;

static VGubyte path_cmd[] = {
    VG_MOVE_TO_ABS, VG_LINE_TO_ABS, VG_LINE_TO_ABS, VG_LINE_TO_ABS, VG_CLOSE_PATH,
    VG_MOVE_TO_ABS, VG_LINE_TO_ABS, VG_LINE_TO_ABS, VG_CLOSE_PATH,
};

static VGint path_coord[] = {
    0, 0, 160, 0, 160, 120, 0, 120,
    20, 20, 80, 100, 140, 20,
};

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {1.0F, 1.0F, 1.0F, 1.0F};

    /* 摜Ǎ */
    image_data = GfxGetFreeArea(IMAGE_WIDTH, IMAGE_HEIGHT, IMAGE_BPP<<3);
    GfxFsRead((int8_t*)IMAGE_NAME1, IMAGE_STRIDE * IMAGE_HEIGHT, (void*)image_data);

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);

    /* VGPathIuWFNg̐ */
    path = vgCreatePath(VG_PATH_FORMAT_STANDARD, VG_PATH_DATATYPE_S_32, 1.0F, 0.0F, 0, 0, VG_PATH_CAPABILITY_ALL);

    /* VGPathIuWFNgɌ`f[^o^ */
    vgAppendPathData(path, sizeof(path_cmd), path_cmd, path_coord);

    /* VGImageIuWFNg̐ */
    image = vgCreateImage(VG_sRGBA_8888, IMAGE_WIDTH, IMAGE_HEIGHT, VG_IMAGE_QUALITY_NONANTIALIASED | VG_IMAGE_QUALITY_FASTER | VG_IMAGE_QUALITY_BETTER);

    /* VGImageIuWFNgɃC[Wf[^o^ */
    vgImageSubData(image, image_data, IMAGE_STRIDE, VG_sRGBA_8888, 0, 0, IMAGE_WIDTH, IMAGE_HEIGHT);
}

static void DrawPath(VGPath path, VGfloat x, VGfloat y, VGfloat rotate, VGfloat scale_x, VGfloat scale_y)
{
    /* pX̕ϊ}gNXݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_PATH_USER_TO_SURFACE);

    /* }gNXiPʍsj*/
    vgLoadIdentity();

    /* ړsw */
    vgTranslate(x, y);

    /* ]sw */
    vgRotate(rotate);

     /* g/ksw */
    vgScale(scale_x, scale_y);

   /* ` */
    vgDrawPath(path, VG_FILL_PATH);
}

static void DrawImage(VGImage image, VGfloat x, VGfloat y, VGfloat rotate, VGfloat scale_x, VGfloat scale_y)
{
    /* C[W̕ϊ}gNXݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_IMAGE_USER_TO_SURFACE);

    /* }gNXiPʍsj*/
    vgLoadIdentity();

    /* ړsw */
    vgTranslate(x, y);

    /* ]sw */
    vgRotate(rotate);

    /* g/ksw */
    vgScale(scale_x, scale_y);

    /* ` */
    vgDrawImage(image);
}

static void TestTerm(void)
{
    GfxReleaseFreeArea(image_data);

    vgDestroyPath(path);
    vgDestroyImage(image);
}

void MatrixMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* pX`揈 */
    DrawPath(path, POS00_X, POS00_Y, ROT_0, 1.0F, 1.0F);
    DrawPath(path, POS01_X, POS01_Y, ROT_1, 1.3F, 1.3F);
    DrawPath(path, POS02_X, POS02_Y, ROT_2, 0.5F, 0.5F);

    /* C[W`揈 */
    DrawImage(image, POS10_X, POS10_Y, ROT_0, 1.0F, 1.0F);
    DrawImage(image, POS11_X, POS11_Y, ROT_1, 1.3F, 1.3F);
    DrawImage(image, POS12_X, POS12_Y, ROT_2, 0.5F, 0.5F);

    /* obt@Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}
