/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/

/*****************************************************************************/
/*     include file                                                          */
/*****************************************************************************/
#include "kernel.h"
#include "kernel_itron4.h"
#include "ffsys.h"
#include "ffsysdrv_cfg.h"

#include "vram/vrammgr.h"
#include "uhs_type.h"
#include "uhs_stdlib.h"
#include "usb_msc_api.h"
#include "usb_msc_param.h"

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/
/* v[ID */
int32_t			g_mplid_fs = 0;

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/
/* Sector Size */
#define SEC_LEN         512         /* Sector size for low driver */

/******************************************************************************
   FunctionF  usb_ini
   ArgumentF  dev_id     : foCXID
   Return  F  E_OK       I
   Summary F  USB
   Caution F  
******************************************************************************/
ER usb_ini(ID dev_id)
{
	AG903_VRAMMgrMplPrm		pool_prm;						/* v[p[^		*/


	if(g_mplid_fs == 0) {
		/*------------------*/
		/* v[ */
		/*------------------*/
		/* p[^ݒ */
		pool_prm.mplatr	= AG903_OSW_ATRFIFO;				/* v[҂ FIFO 			*/
		pool_prm.mplsz	= MPL_FS_SIZE;						/* v[̃oCgTCY		*/
		pool_prm.mpl	= (void *)MPL_FS_ADDR;				/* v[̈̐擪Ԓn		*/
		pool_prm.memtype = AG903_VRAM_NORMAL_CACHE_OFF;		/* LbV OFF					*/

		g_mplid_fs = AG903_VRAMMgrCreateMpl(&pool_prm);
	}
    return E_OK;
}

/******************************************************************************
   FunctionF  usb_ext
   ArgumentF  dev_id     : foCXID
   Return  F  E_OK       I
   Summary F  USBI
   Caution F  
******************************************************************************/
ER usb_ext(ID dev_id)
{
    /* Ȃ */
    return E_OK;
}

/******************************************************************************
   FunctionF  usb_mnt
   ArgumentF  dev_id     : foCXID
   Return  F  E_OK       I
   Summary F  USB}Eg
   Caution F  
******************************************************************************/
ER usb_mnt(ID dev_id)
{
    PSTOR_UNIT pNewUnit;
    uhs_sbit32_t retval;


    /* dev_id0̏ꍇ */
    /* mount()R[ꂽꍇ́Adev_id0ƂȂ */
    if(dev_id == 0) {
		/* ڑfoCX */
		if(Usbh_Stor_GetAttachDevNum() > 1) {
			/* G[ */
			return E_PAR;
		}
		/* ڑfoCX1ȉ */
		else {
			/* foCXID0ȊǑŒlƒu */
			dev_id = CFG_DRV_LOW_FIXED_DEV_ID;
			/* Storage Driver֑΂āAUnmount Disk邩mF */
			pNewUnit = Usbh_Stor_GetUnmountUnit();
			if(pNewUnit == NULL){
				/* }Eg̃foCX */
				return  E_NRD;
			}
        }
    }
    /* dev_id0ȊO */
    else {
        /* foCXIDPSTOR_UNITo */
        pNewUnit = (PSTOR_UNIT)dev_id;
    }
	
	/* }Eg */
	retval = Usbh_Stor_Mount(pNewUnit, (PUSER_DRV)dev_id);
	if(retval != USBSTOR_SUCCESS) {
		return E_DRV;
	}
	return E_OK;
}

/******************************************************************************
   FunctionF  usb_umt
   ArgumentF  dev_id     : foCXID
   Return  F  E_OK       I
   Summary F  USBA}Eg
   Caution F  
******************************************************************************/
ER usb_umt(ID dev_id)
{
    uhs_sbit32_t retval;


    /* dev_id0̏ꍇ */
    /* unmount()R[ꂽꍇ́Adev_id0ƂȂ */
    if(dev_id == 0) {
		/* foCXID0ȊǑŒlƒu */
		dev_id = CFG_DRV_LOW_FIXED_DEV_ID;
	}
    retval = Usbh_Stor_Unmount((PUSER_DRV)dev_id);
	if(retval != USBSTOR_SUCCESS) {
		return E_DRV;
	}
	return E_OK;
}

/******************************************************************************
   FunctionF  usb_read
   ArgumentF  dev_id     : foCXID
               buf        : [hf[^i[obt@
               cnt        : ZN^
               tmo        : (gp)
   Return  F  E_OK       I
   Summary F  USBA}Eg
   Caution F  
******************************************************************************/
ER usb_read(ID dev_id, VP buf, UW pos, UH cnt, TMO tmo)
{
    uhs_ubit8_t *pBuff;
    uhs_sbit32_t retval;


    /* LbVobt@擾 */
    pBuff = AG903_VRAMMgrMalloc(g_mplid_fs, cnt * SEC_LEN);
    /* ZN^[h */
    retval = Usbh_Stor_ReadSector((PUSER_DRV)(dev_id), 
                                (uhs_ubit32_t)(pos),
                                (uhs_ubit16_t)(cnt),
                                pBuff);
    if (retval != USBSTOR_SUCCESS) {
        /* LbVobt@ */
		AG903_VRAMMgrFree(g_mplid_fs, pBuff);
        return E_DRV;
    }
    /* obt@Rs[ */
    memcpy(buf, pBuff, cnt * SEC_LEN);
    /* LbVobt@ */
	AG903_VRAMMgrFree(g_mplid_fs, pBuff);

	return E_OK;
}

/******************************************************************************
   FunctionF  usb_write
   ArgumentF  dev_id     : foCXID
               buf        : Cgf[^i[Ăobt@
               cnt        : ZN^
               tmo        : (gp)
   Return  F  E_OK       I
   Summary F  USBA}Eg
   Caution F  
******************************************************************************/
ER usb_write(ID dev_id, VP buf, UW pos, UH cnt, TMO tmo)
{
    uhs_ubit8_t *pBuff;
    uhs_sbit32_t retval;


    /* LbVobt@擾 */
    pBuff = AG903_VRAMMgrMalloc(g_mplid_fs, cnt * SEC_LEN);
    /* obt@Rs[ */
    memcpy(pBuff, buf, cnt * SEC_LEN);
    /* ZN^Cg */
    retval = Usbh_Stor_WriteSector((PUSER_DRV)(dev_id), 
                                 (uhs_ubit32_t)(pos),
                                 (uhs_ubit16_t)(cnt),
                                 pBuff);
    /* LbVobt@ */
 	AG903_VRAMMgrFree(g_mplid_fs, pBuff);
   if (retval != USBSTOR_SUCCESS) {
        return E_DRV;
    }

    return E_OK;
}
