/*
 * @history		2019_12_27  [SDK3.0] ^XNTA_FPUtŋNĂȂsC (uC3) (#2698)
 */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/

/*****************************************************************************/
/*     include file                                                          */
/*****************************************************************************/
#include "kernel.h"
#include "uhs_configtop.h"
#include "cdc/usb_cdc_commif_api.h"
#include "cdc/usb_cdc_dataif_api.h"
#include "cdc/usb_cdc_api.h"
#include <stdint.h>
#include "vram/vrammgr.h"
#include "usb_sample.h"
#include "sample_util.h"
#include "sample_app_cdc.h"

#define TEST_LOOPBAKC_DEVICE	(1)		/* LoopbackfoCXpeXǵu1v */
#if TEST_LOOPBAKC_DEVICE
	static uint8_t			testdata[64] = {0};
#endif
/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/
/* ^XN */
typedef struct CdcTaskInfo {
	ID					tskid;								/* ^XNID							*/
	ID					mbxid;								/* [{bNXID					*/
	uhs_ubit8_t*		pNotifyBuff;						/* Notifypobt@AhX			*/
	uhs_ubit8_t*		pBulkInBuff;						/* oNINobt@AhX			*/
	void*				pContext;							/* ڑĂȂNULL			*/
} CDC_TASK_INFO;

/* ڑ^ؒfbZ[W */
typedef struct CdcConnMsgPkt {
	uhs_ubit32_t		msg;								/* bZ[We					*/
	void*				pContext;							/* ʒmfoCX̃ReLXg		*/
} CDC_CONN_MSG_PKT;

/* AvP[V^XNbZ[W */
typedef struct CdcAppMsgPkt {
	uhs_ubit32_t		msg;								/* bZ[We					*/
	CDC_NOTIFY_INFO		notify;								/* ʒm							*/
	void*				pContext;							/* ʒmfoCX̃ReLXg		*/
} CDC_APP_MSG_PKT;

/*****************************************************************************/
/*     define                                                                */
/*****************************************************************************/
/* obt@TCY */
#define NOTIFY_BUFF_SIZE			(64)

/* obt@TCY */
#define BUFF_SIZE					(100)

/* ControlLineState */
#define LINE_STATE_DTR				(0x0001)
#define LINE_STATE_RTS				(0x0002)

/* NetworkConnection */
#define NETWORK_CONNECTION_DISCON	(0x0000)
#define NETWORK_CONNECTION_CONN		(0x0001)

//	BULK ERRʒmMSGID
#define	CDC_DETECT_BULKIN_ERR		(100)

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/
/* Notifypobt@ */
static uhs_ubit8_t	g_notifyBuff[USBH_MAX_CLS_CDC_NUM][NOTIFY_BUFF_SIZE];


/* ^XNe[u */
static CDC_TASK_INFO g_CdcTaskInfoTbl[USBH_MAX_CLS_CDC_NUM];

/* ڑؒf^XNp[{bNXID */
ER_ID				g_mbxid_cdc_conn;

/* ڑؒf^XNp^XNID */
ER_ID				g_tskid_cdc_conn;

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern	int32_t AG903_VRAMMgrCreateMpl(AG903_VRAMMgrMplPrm* mplprm);
extern	int32_t AG903_VRAMMgrDeleteMpl(int32_t mplid);
extern	void* AG903_VRAMMgrMalloc(int32_t mplid, uint32_t blksz);
extern	int32_t AG903_VRAMMgrFree(int32_t mplid, void* blk);

/*****************************************************************************/
/*     function prototype                                                    */
/*****************************************************************************/
static void cdc_notifyCallback(PCDC_NOTIFY_INFO pNotifyInfo, uhs_status_t RetVal);
static int cdc_registTaskInfo(void* pContext);
static int cdc_unregistTaskInfo(void* pContext);
static ID cdc_getMbxId(void* pContext);
static uhs_ubit8_t* cdc_getNotifyBuff(void* pContext);
static void cdc_conn_task(void* context);
static void cdc_app_task(void* context);
static uhs_status_t cdc_attachDeviceInit(void* pContext);

/******************************************************************************
   FunctionF  cdc_appinit
   ArgumentF  Ȃ
   Return  F  Ȃ
   Summary F  CDCs܂
   Caution F  Ȃ
******************************************************************************/
void cdc_appinit(void)
{
	T_CMBX					cmbx;							/* [{bNXp[^		*/
	T_CTSK					ctsk;							/* ^XNp[^				*/
	uhs_ubit8_t				majorVersion, minorVersion;		/* o[W						*/
	uhs_status_t			retval;
	int						i;
	
	
	/*----------------*/
	/* o[W擾 */
	/*----------------*/
	retval = Usbh_Cdc_GetVersion(&majorVersion, &minorVersion);
	if(retval == USBCDC_API_SUCCESS) {
		SAMPLE_PRINT("CDC Driver version : ");
		SAMPLE_PRINT_BYTE_HEX(majorVersion);
		SAMPLE_PRINT(".");
		SAMPLE_PRINT_BYTE_HEX(minorVersion);
		SAMPLE_PRINT("\r\n");
	}
	
	/*--------------------------*/
	/* ^XNe[u */
	/*--------------------------*/
	for(i = 0; i < USBH_MAX_CLS_CDC_NUM; i++) {
		g_CdcTaskInfoTbl[i].tskid		= 0;
		g_CdcTaskInfoTbl[i].mbxid		= 0;
		g_CdcTaskInfoTbl[i].pNotifyBuff	= g_notifyBuff[i];
		g_CdcTaskInfoTbl[i].pBulkInBuff	= AG903_VRAMMgrMalloc(g_mplid_app, BUFF_SIZE);
		g_CdcTaskInfoTbl[i].pContext	= NULL;
	}
	
	/*--------------------*/
	/* [{bNX */
	/*--------------------*/
	/* p[^ݒ */
    cmbx.mbxatr		= TA_TFIFO | TA_MFIFO;
    cmbx.maxmpri	= 1;
    cmbx.mprihd		= NULL;

	/* ڑؒf^XNp[{bNX */
	g_mbxid_cdc_conn = acre_mbx(&cmbx);
	if(g_mbxid_cdc_conn < 0) {
		/* G[ */
		return;
	}

	/* AvP[V^XNp[{bNX~Q */
	for(i = 0; i < USBH_MAX_CLS_CDC_NUM; i++) {
		g_CdcTaskInfoTbl[i].mbxid = acre_mbx(&cmbx);
		if(g_CdcTaskInfoTbl[i].mbxid < 0) {
			/* G[ */
			return;
		}
	}

	/*----------------------*/
	/* ڑ^ؒf^XN */
	/*----------------------*/
	/* p[^ݒ */
	ctsk.tskatr		= TA_HLNG | TA_ACT | TA_FPU;
	ctsk.exinf		= (void *)NULL;							/* TASKÑp[^()			*/
	ctsk.task		= (FP)cdc_conn_task;					/* TASK̋NAhX					*/
	ctsk.itskpri	= (PRI)TSK_PRI_SAMPLE;					/* TASK̗Dx							*/
	ctsk.stksz		= (INT)TSK_STACK_SIZE_SAMPLE;			/* TASK̃X^bNSIZE					*/
	ctsk.stk		= NULL;									/* TASK̃X^bNAhX=NULL()	*/
	
	/* ^XN */
	g_tskid_cdc_conn = acre_tsk(&ctsk);
	if(g_tskid_cdc_conn < 0) {
		/* G[ */
		return;
	}

	/*----------------------------*/
	/* AvP[V^XN */
	/*----------------------------*/
	/* p[^ݒ */
	ctsk.task		= (FP)cdc_app_task;						/* TASK̋NAhX					*/

	/* ^XN */
	for(i = 0; i < USBH_MAX_CLS_CDC_NUM; i++) {
		ctsk.exinf = (void *)&g_CdcTaskInfoTbl[i];			/* TASKÑp[^(e[u)		*/
		g_CdcTaskInfoTbl[i].tskid = acre_tsk(&ctsk);
		if(g_CdcTaskInfoTbl[i].tskid < 0) {
			/* G[ */
			return;
		}
	}
}

/******************************************************************************
   FunctionF  cdc_append
   ArgumentF  Ȃ
   Return  F  Ȃ
   Summary F  CDCIs܂
   Caution F  Ȃ
******************************************************************************/
void cdc_append(void)
{
	int						i;

	del_mbx(g_mbxid_cdc_conn);
	
	for(i = 0; i < USBH_MAX_CLS_CDC_NUM; i++) {
		del_mbx(g_CdcTaskInfoTbl[i].mbxid);
	}

	ter_tsk(g_tskid_cdc_conn);
	del_tsk(g_tskid_cdc_conn);
	
	for(i = 0; i < USBH_MAX_CLS_CDC_NUM; i++) {
		ter_tsk(g_CdcTaskInfoTbl[i].tskid);
		del_tsk(g_CdcTaskInfoTbl[i].tskid);
	}

	return;
}

/******************************************************************************
   FunctionF  cdc_appstop
   ArgumentF  Ȃ
   Return  F  AG903_ENONE	 I
           F  -AG903_EFAULT   ُI
   Summary F  CDC̓]~s܂
   Caution F  Ȃ
******************************************************************************/
int32_t cdc_appstop(void)
{
	int32_t			retval=AG903_ENONE;
	uint32_t		loop;
	uhs_status_t	ret;
	
	for( loop=0 ; loop<USBH_MAX_CLS_CDC_NUM; loop++ ){
		if( NULL != g_CdcTaskInfoTbl[loop].pContext ) {
			ret = Usbh_Cdc_StopIntIN(g_CdcTaskInfoTbl[loop].pContext);
			if( (USBCDC_API_SUCCESS  != ret) &&
				(USBCDC_API_NOT_OPEN != ret) &&
				(USBCDC_API_ALREADY_STOP_INTIN != ret) ) {
				retval=-AG903_EFAULT;
			}
			ret = Usbh_Cdc_StopBulkIN(g_CdcTaskInfoTbl[loop].pContext);
			if( (USBCDC_API_SUCCESS  != ret) &&
				(USBCDC_API_NOT_OPEN != ret) &&
				(USBCDC_API_ALREADY_STOP_BULKIN != ret) ) {
				retval=-AG903_EFAULT;
			}
		}
	}
	
	return retval;
}

/******************************************************************************
   FunctionF  cdc_apprestart
   ArgumentF  Ȃ
   Return  F  AG903_ENONE	 I
           F  -AG903_EFAULT   ُI
   Summary F  CDC̓]ĊJs܂
   Caution F  Ȃ
******************************************************************************/
int32_t cdc_apprestart(void)
{
	int32_t			retval=AG903_ENONE;
	uint32_t		loop;
	uhs_status_t	ret;
	
	for( loop=0 ; loop<USBH_MAX_CLS_CDC_NUM; loop++ ){
		if( NULL != g_CdcTaskInfoTbl[loop].pContext ) {
			ret = Usbh_Cdc_RestartIntIN(g_CdcTaskInfoTbl[loop].pContext);
			if( (USBCDC_API_SUCCESS  != ret) &&
				(USBCDC_API_NOT_OPEN != ret) &&
				(USBCDC_API_ALREADY_START_INTIN != ret) ) {
				retval=-AG903_EFAULT;
			}
			ret = Usbh_Cdc_RestartBulkIN(g_CdcTaskInfoTbl[loop].pContext);
			if( (USBCDC_API_SUCCESS  != ret) &&
				(USBCDC_API_NOT_OPEN != ret) &&
				(USBCDC_API_ALREADY_START_BULKIN != ret) ) {
				retval=-AG903_EFAULT;
			}
		}
	}
	
	return retval;
}

/******************************************************************************
   FunctionF  cdc_callback
   ArgumentF  callback_id : R[obN
               pContext    : R[obNcontext
   Return  F  Ȃ
   Summary F  CDCNXhCo̐ڑ^ؒfR[obN
   Caution F  Ȃ
******************************************************************************/
void cdc_callback(int callback_id, void* pContext)
{
	CDC_CONN_MSG_PKT*		pk_msg;							/* bZ[WpPbg				*/
	uhs_status_t			retval;
	ER						ercd;
	
	
	/* bZ[Wobt@擾 */
	pk_msg = AG903_VRAMMgrMalloc(g_mplid_app, sizeof(CDC_CONN_MSG_PKT));
	/* bZ[We */
	pk_msg->msg = (uhs_ubit32_t)callback_id;
	/* ReLXg */
	pk_msg->pContext = pContext;
	
	switch(callback_id){
		/*--------*/
		/* ڑ   */
		/*--------*/
		case CBID_CDC_DEVATTACH:

//			SAMPLE_PRINT("CDC device attached\r\n");

			/* ReLXgo^ */
			cdc_registTaskInfo(pContext);

			/* R[obNo^ */
			retval = Usbh_Cdc_RegistCallBack(pContext, cdc_notifyCallback, (uhs_ubit8_t)(16));
			if(retval != USBCDC_API_SUCCESS){
				/* obt@ */
				AG903_VRAMMgrFree(g_mplid_app, pk_msg);
				return;
			}

			/* bZ[WM */
			ercd = snd_mbx(g_mbxid_cdc_conn, (T_MSG *)pk_msg);
			if(ercd != E_OK) {
				/* obt@ */
				AG903_VRAMMgrFree(g_mplid_app, pk_msg);
				return;
			}
			break;
		
		/*--------*/
		/* ؒf   */
		/*--------*/
		case CBID_CDC_DEVDETACH:

//			SAMPLE_PRINT("CDC device detached\r\n");

			/* ReLXg폜 */
			cdc_unregistTaskInfo(pContext);

			/* bZ[WM */
			ercd = snd_mbx(g_mbxid_cdc_conn, (T_MSG *)pk_msg);
			if(ercd != E_OK) {
				/* obt@ */
				AG903_VRAMMgrFree(g_mplid_app, pk_msg);
				return;
			}
			break;
		
		/*--------*/
		/* ̑ */
		/*--------*/
		default:

//			SAMPLE_PRINT("CDC callback other\r\n");
			/* obt@ */
			AG903_VRAMMgrFree(g_mplid_app, pk_msg);
			break;
	}
}

/******************************************************************************
   FunctionF  cdc_notifyCallback
   ArgumentF  pNotifyInfo : ʒm
               RetVal      : 
   Return  F  Ȃ
   Summary F  CDCNXhCoInterrupt]NotificationMR[obN
               
   Caution F  Ȃ
******************************************************************************/
static void cdc_notifyCallback(PCDC_NOTIFY_INFO pNotifyInfo, uhs_status_t RetVal)
{
	CDC_APP_MSG_PKT*		pk_msg;							/* bZ[WpPbg				*/
	uhs_ubit8_t*			pBuff;							/* Notifypobt@AhX			*/
	ER						ercd;
	uhs_ubit32_t			i;
	

	/* ʊmF */
	if(RetVal != USBCDC_API_SUCCESS) {

		if(pNotifyInfo->CallbackNotifyType == CDC_NOTIFY_TYPE_BULK_IN) {
			//	ڑ^ؒf^XNɓ
			pk_msg = AG903_VRAMMgrMalloc(g_mplid_app, sizeof(CDC_APP_MSG_PKT));  

			/* bZ[W */
			pk_msg->msg = CDC_DETECT_BULKIN_ERR;

			/* bZ[We */
			sample_memcpy((void *)&pk_msg->notify, (void *)pNotifyInfo, sizeof(CDC_NOTIFY_INFO));

			/* ReLXg */
			pk_msg->pContext = pNotifyInfo->pContext;

			/* bZ[WM */
			ercd = snd_mbx( g_mbxid_cdc_conn , (T_MSG *)pk_msg);
			if(ercd != E_OK) {
				SAMPLE_PRINT("  snd_mbx err : ");
				SAMPLE_PRINT_NUM(ercd);
				SAMPLE_PRINT("\r\n");

				/* obt@ */
				AG903_VRAMMgrFree(g_mplid_app, pk_msg);
			}
		}

		return;
	}

	/* bZ[Wobt@擾 */
	pk_msg = AG903_VRAMMgrMalloc(g_mplid_app, sizeof(CDC_APP_MSG_PKT));
	/* bZ[We */
	sample_memcpy((void *)&pk_msg->notify, (void *)pNotifyInfo, sizeof(CDC_NOTIFY_INFO));
	/* ReLXg */
	pk_msg->pContext = pNotifyInfo->pContext;

	/* Interrupt f[^ */
	if(pNotifyInfo->CallbackNotifyType == CDC_NOTIFY_TYPE_INTERRUPT_IN) {
		
		/* Interruptf[^Ȃ */
		if(pNotifyInfo->u32Length <= 0) {
			/* obt@ */
			AG903_VRAMMgrFree(g_mplid_app, pk_msg);
			return;
		}
		
		/* obt@擾 */
		pBuff = cdc_getNotifyBuff(pNotifyInfo->pContext);
		if(pBuff == NULL) {
			/* obt@ */
			AG903_VRAMMgrFree(g_mplid_app, pk_msg);
			return;
		}

		sample_memset(pBuff, 0, NOTIFY_BUFF_SIZE);

		/* f[^ */
		for(i = 0; i < pNotifyInfo->u32Length; i++) {
			pBuff[i] = pNotifyInfo->pu8Buff[i];
		};
		/* obt@u */
		pk_msg->notify.pu8Buff = pBuff;
	}

	/* bZ[WM */
	ercd = snd_mbx(cdc_getMbxId(pNotifyInfo->pContext), (T_MSG *)pk_msg);
	if(ercd != E_OK) {
		/* obt@ */
		AG903_VRAMMgrFree(g_mplid_app, pk_msg);
	}
}

/******************************************************************************
   FunctionF  cdc_registTaskInfo
   ArgumentF  pContext     : R[obNcontext
   Return  F  SAMPLE_TRUE  : 
               SAMPLE_FALSE : s
   Summary F  ^XNɃReLXgo^܂
   Caution F  Ȃ
******************************************************************************/
static int cdc_registTaskInfo(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_CDC_NUM; i++) {
		/* o^ */
		if(g_CdcTaskInfoTbl[i].pContext == NULL) {
			/* ReLXgo^ */
			g_CdcTaskInfoTbl[i].pContext = pContext;
			return SAMPLE_TRUE;
		}
	}
	/* 󂫂Ȃ */
	return SAMPLE_FALSE;
}

/******************************************************************************
   FunctionF  cdc_unregistTaskInfo
   ArgumentF  pContext     : R[obNcontext
   Return  F  SAMPLE_TRUE  : 
               SAMPLE_FALSE : s
   Summary F  ^XN񂩂ReLXg폜܂
   Caution F  Ȃ
******************************************************************************/
static int cdc_unregistTaskInfo(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_CDC_NUM; i++) {
		/* ReLXgv */
		if(g_CdcTaskInfoTbl[i].pContext == pContext) {
			/* ReLXg폜 */
			g_CdcTaskInfoTbl[i].pContext = NULL;
			return SAMPLE_TRUE;
		}
	}
	/* ReLXgȂ */
	return SAMPLE_FALSE;
}

/******************************************************************************
   FunctionF  cdc_getMbxId
   ArgumentF  pContext    : R[obNcontext
   Return  F  [{bNXID
   Summary F  o^ĂReLXgɕRtꂽ[{bNXID擾܂
   Caution F  Ȃ
******************************************************************************/
static ID cdc_getMbxId(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_CDC_NUM; i++) {
		/* ReLXgv */
		if(g_CdcTaskInfoTbl[i].pContext == pContext) {
			/* [{bNXIDԂ */
			return g_CdcTaskInfoTbl[i].mbxid;
		}
	}
	
	/* G[ */
	return 0;
}

/******************************************************************************
   FunctionF  cdc_getNotifyBuff
   ArgumentF  pContext    : R[obNcontext
   Return  F  Notifypobt@
   Summary F  o^ĂReLXgɕRtꂽNotifypobt@擾܂
   Caution F  Ȃ
******************************************************************************/
static uhs_ubit8_t *cdc_getNotifyBuff(void* pContext)
{
	int						i;


	/* e[uT[` */
	for(i = 0; i < USBH_MAX_CLS_CDC_NUM; i++) {
		/* ReLXgv */
		if(g_CdcTaskInfoTbl[i].pContext == pContext) {
			/* Notifypobt@Ԃ */
			return g_CdcTaskInfoTbl[i].pNotifyBuff;
		}
	}
	
	/* G[ */
	return NULL;
}

/******************************************************************************
   FunctionF  cdc_conn_task
   ArgumentF  context     : NULL
   Return  F  Ȃ
   Summary F  CDCڑ^ؒfm^XN
   Caution F  CDCfoCX
******************************************************************************/
static void cdc_conn_task(void* context)
{
	CDC_CONN_MSG_PKT*		pk_msg;							/* bZ[WpPbg				*/
	uhs_ubit32_t			msg;							/* bZ[We					*/
	void*					pContext;						/* ReLXg						*/
	uhs_status_t			retval;
	CDC_BUFF_INFO			writeData;						/* Mf[^						*/

	((void)context);

	while(1) {
		/* ڑ^ؒfbZ[W҂ */
		rcv_mbx(g_mbxid_cdc_conn, (T_MSG **)&pk_msg);
			
		/* ڑ^ꂽfoCX̃ReLXg擾 */
		pContext = pk_msg->pContext;
		/* 擾s */
		if(pContext == NULL) {
			/* obt@ */
			AG903_VRAMMgrFree(g_mplid_app, pk_msg);
			continue;
		}

		SAMPLE_PRINT("  context : 0x");
		SAMPLE_PRINT_LONG_HEX((unsigned long)pContext);
		SAMPLE_PRINT("\r\n");

		/* bZ[Weۑ */
		msg = pk_msg->msg;

		/* obt@ */
		AG903_VRAMMgrFree(g_mplid_app, pk_msg);
		
		/*------*/
		/* ڑ */
		/*------*/
		if(msg == CBID_CDC_DEVATTACH) {

			/* NXNGXgs */
			cdc_attachDeviceInit(pContext);
			
			/* CDC f[^NX] */
			retval = Usbh_Cdc_Open(pContext);
			if(retval != USBCDC_API_SUCCESS){
				continue;
			}
#if TEST_LOOPBAKC_DEVICE
			writeData.pu8Buff =  testdata;
			writeData.u32RequestLength = sizeof(testdata);
			retval = Usbh_Cdc_WriteData(pContext, &writeData);
			if(retval != USBCDC_API_SUCCESS){
				SAMPLE_PRINT("!!!!!!! CDC : Detect Write Error !!!!!\x0d\x0a");
			}
#endif
		}
		
		/*------*/
		/* ؒf */
		/*------*/
		else if(msg == CBID_CDC_DEVDETACH) {
			/* Ȃ */
		}

		/*---------*/
		/* ReStart */
		/*---------*/
		else if( msg == CDC_DETECT_BULKIN_ERR ){

			dly_tsk( 10 );

			//	Restart BULK_IN
			SAMPLE_PRINT("!!!!!!! CDC : Detect Status Error !!!!!\x0d\x0a");
			Usbh_Cdc_RestartBulkIN( pContext );
			SAMPLE_PRINT("!!!!!!! CDC : RESTART BULK_IN !!!!!\x0d\x0a ");
		}
	}
}

/******************************************************************************
   FunctionF  cdc_app_task
   ArgumentF  context     : ^XNNp[^(^XN)
   Return  F  Ȃ
   Summary F  CDCAvP[V^XN
   Caution F  foCXPʂŎgp
******************************************************************************/
static void cdc_app_task(void* context)
{
	CDC_TASK_INFO*			pCdcTaskInfo;					/* ^XN						*/
	CDC_APP_MSG_PKT*		pk_msg;							/* bZ[WpPbg				*/
	void*					pContext;						/* ReLXg						*/
	CDC_BUFF_INFO			readData;						/* Mf[^						*/
	CDC_BUFF_INFO			writeData;						/* Mf[^						*/
	uhs_ubit32_t			remainDataSize;					/* Mf[^̎cTCY				*/
	uhs_ubit32_t			remainBuffSize;					/* Mobt@̎cTCY			*/
	uhs_status_t			retval;
	uhs_ubit32_t			i, j;


	/* ^XN擾 */
	pCdcTaskInfo = (CDC_TASK_INFO *)context;

	while(1) {
		/*--------------------*/
		/* ʒmbZ[W҂ */
		/*--------------------*/
		rcv_mbx(pCdcTaskInfo->mbxid, (T_MSG **)&pk_msg);
		
		/* ڑꂽfoCX̃ReLXg擾 */
		pContext = pk_msg->pContext;
		/* 擾s */
		if(pContext == NULL) {
			/* obt@ */
			AG903_VRAMMgrFree(g_mplid_app, pk_msg);
			continue;
		}

		/* R[obNʒmʎ擾 */
		switch(pk_msg->notify.CallbackNotifyType) {
			
			/*----------*/
			/* oNIN */
			/*----------*/
			case (CDC_NOTIFY_TYPE_BULK_IN):
				
				/* NULL OXḾAbZ[WM҂ */
				if(pk_msg->notify.u32Length == 0) {
					/* obt@ */
					AG903_VRAMMgrFree(g_mplid_app, pk_msg);
					continue;
				}

				/* Mobt@ݒ */
				readData.pu8Buff = pCdcTaskInfo->pBulkInBuff;
				/* Mf[^ */
				remainDataSize = pk_msg->notify.u32Length;
				/* Mf[^obt@TCYȉ */
				if(remainDataSize <= BUFF_SIZE) {
					readData.u32RequestLength = remainDataSize;
				}
				/* Mf[^obt@TCY傫 */
				else {
					readData.u32RequestLength = BUFF_SIZE;
				}
				
				/*----------------------------------*/
				/* SMf[^[hA܂Ԃ */
				/*----------------------------------*/
				while(1) {
					/* f[^[h */
					retval = Usbh_Cdc_ReadData(pContext, &readData, &remainBuffSize);
					if(retval != USBCDC_API_SUCCESS){
						break;
					}
				
#if TEST_LOOPBAKC_DEVICE
					SAMPLE_PRINT(" data : ");
					SAMPLE_PRINT_NUM((*readData.pu8Buff));
					SAMPLE_PRINT("\r\n");
					dly_tsk( 20 );
					if(0xFF == (*readData.pu8Buff)) {
						Usbh_Cdc_StopBulkIN(pContext);
						Usbh_Cdc_Close(pContext);
						break;
					}
					if((0x0A==(*readData.pu8Buff)) || (0x0D==(*readData.pu8Buff))) {
						sample_memset(readData.pu8Buff, (*readData.pu8Buff)+1, readData.u32ActualLength);
					}
#endif
					/* Mobt@ݒ */
					writeData.pu8Buff = pCdcTaskInfo->pBulkInBuff;
					writeData.u32RequestLength = readData.u32ActualLength;

					/* f[^Cg */
					retval = Usbh_Cdc_WriteData(pContext, &writeData);
					if(retval != USBCDC_API_SUCCESS){
						break;
					}
					
					/* Mς݃f[^XV */
					remainDataSize -= readData.u32ActualLength;
					
					/* cf[^ */
					if(remainDataSize > 0) {
						/* cf[^obt@TCYȉ */
						if(remainDataSize <= BUFF_SIZE) {
							readData.u32RequestLength = remainDataSize;
						}
						/* cf[^obt@TCY傫 */
						else {
							readData.u32RequestLength = BUFF_SIZE;
						}
					}
					/* cf[^Ȃ */
					else {
						/* ܂ԂI */
						break;
					}
				}
				break;
			
			/*----------------*/
			/* C^vgIN */
			/*----------------*/
			case (CDC_NOTIFY_TYPE_INTERRUPT_IN):
				
				/* ʒmʎ擾 */
				switch(pk_msg->notify.ClassNotifyCode) {
					/* NetworkConnection */
					case CDC_NOTIFY_CODE_NETWORK_CONNECTION :
						SAMPLE_PRINT("  NetworkConnection : ");
						/* Disconnect */
						if(pk_msg->notify.u16wValue == NETWORK_CONNECTION_DISCON) {
							SAMPLE_PRINT("Disconnect\r\n");
						}
						else {
							SAMPLE_PRINT("Connect\r\n");
						}
						break;
					
					/* ResponseAvailable */
					case CDC_NOTIFY_CODE_RESPONSE_AVAILABLE :
						SAMPLE_PRINT("  ResponseAvailable\r\n");
						break;
					
					/* SerialState */
					case CDC_NOTIFY_CODE_SERIAL_STATE :
						SAMPLE_PRINT("  SerialState :");
						SAMPLE_PRINT("\r\n");
						break;

					/* ̑ */
					default:
						SAMPLE_PRINT("  Notify Code :");
						SAMPLE_PRINT("\r\n");
						break;
				}
				
				/* ʒmf[^\ */
				SAMPLE_PRINT("  --- recv length [");
				SAMPLE_PRINT_NUM(pk_msg->notify.u32Length);
				SAMPLE_PRINT("] byte");
				SAMPLE_PRINT("\r\n");
				for(i = 0, j = 0; i < pk_msg->notify.u32Length; i++, j++) {
					if(j == 16) {
						j = 0;
						SAMPLE_PRINT("\r\n");
					}
					if(j == 0) {
						SAMPLE_PRINT("      ");
					}
					else if(j == 8) {
						SAMPLE_PRINT(" ");
					}
					SAMPLE_PRINT_BYTE_HEX(pk_msg->notify.pu8Buff[i]);
					SAMPLE_PRINT(" ");
				}
				SAMPLE_PRINT("\r\n");

				break;
			
			/* ̑ */
			default:
				/* Do Nothing */
				break;
		}
		/* obt@ */
		AG903_VRAMMgrFree(g_mplid_app, pk_msg);
	}
}

/******************************************************************************
   FunctionF  cdc_attachDeviceInit
   ArgumentF  pContext    : ڑcontext
   Return  F  Ȃ
   Summary F  CDCfoCXڑ̃NXNGXgs
   Caution F  Ȃ
******************************************************************************/
static uhs_status_t cdc_attachDeviceInit(void* pContext)
{
	CDC_LINE_CODING			tmpLineCoding;					/* VAʐMݒ				*/
	CDC_LINE_CODING			lineCoding;						/* VAʐMݒ				*/
	CDC_CONTROL_LINE_STATE	controlLineState;				/* RS232 Mݒ			*/
	uhs_status_t			retval;


	/* GetLineCoding */
	retval = Usbh_Cdc_GetLineCoding(pContext, &tmpLineCoding);
	if(retval != USBCDC_API_SUCCESS){
		return retval;
	}

	/* SetControlLineState */
	controlLineState.u16Data = 0;
	retval = Usbh_Cdc_SetControlLineState(pContext, &controlLineState);
	if(retval != USBCDC_API_SUCCESS){
		return retval;
	}

	/* GetLineCoding */
	retval = Usbh_Cdc_GetLineCoding(pContext, &tmpLineCoding);
	if(retval != USBCDC_API_SUCCESS){
		return retval;
	}
	/* GetLineCoding */
	retval = Usbh_Cdc_GetLineCoding(pContext, &tmpLineCoding);
	if(retval != USBCDC_API_SUCCESS){
		return retval;
	}
    
	/* SetLineCoding */
	lineCoding.u32BaudRate	= 0x0001C200;				/* 115200bps	*/
	lineCoding.StopBit		= LINE_CODING_STOPBIT_1;	/* 1 Stop Bit	*/
	lineCoding.Parity 		= LINE_CODING_PARITY_NONE;	/* peBȂ	*/
	lineCoding.DataBit		= LINE_CODING_DATABIT_7;	/* 7 Data Bit	*/
	retval = Usbh_Cdc_SetLineCoding(pContext, &lineCoding);
	if(retval != USBCDC_API_SUCCESS){
		return retval;
	}

	/* GetLineCoding */
	retval = Usbh_Cdc_GetLineCoding(pContext, &tmpLineCoding);
	if(retval != USBCDC_API_SUCCESS){
		return retval;
	}

	/* SetControlLineState */
	controlLineState.u16Data = (LINE_STATE_DTR | LINE_STATE_RTS);
	retval = Usbh_Cdc_SetControlLineState(pContext, &controlLineState);
	if(retval != UDI_OK){
		return retval;
	}

	/* SetLineCoding */
	lineCoding.u32BaudRate	= 0x0001C200;				/* 115200bps	*/
	lineCoding.StopBit		= LINE_CODING_STOPBIT_1;	/* 1 Stop Bit	*/
	lineCoding.Parity 		= LINE_CODING_PARITY_NONE;	/* peBȂ	*/
	lineCoding.DataBit		= LINE_CODING_DATABIT_8;	/* 8 Data Bit	*/
	retval = Usbh_Cdc_SetLineCoding(pContext, &lineCoding);
	if(retval != USBCDC_API_SUCCESS){
		return retval;
	}

	/* GetLineCoding */
	retval = Usbh_Cdc_GetLineCoding(pContext, &tmpLineCoding);
	if(retval != USBCDC_API_SUCCESS){
		return retval;
	}

	return retval;
}
