/**
 * @brief       GPIO Primitive
 * @author      AXELL CORPORATION
 * @description GPIO Primitive Layer
 * @note        none 
 * @history     2017_02_22  
 * @history     2017_10_26  Ver2.0
 * @history     2021_01_29  [SDK3.2] GPIO|[g̔rLɂƂ̃AZu[`C (#2844)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2021 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_errno.h"
#include "AG903_common.h"
#include "gpio/gpioprm.h"
#include "register/AG903_gpioreg.h"


extern void GPIOPrm_ModifyBit(uintptr_t addr, uint32_t set, uint32_t clr);

/**
 * @brief           GPIOnDTOUT̃WX^Write(8rbgP)
 * @param           ch [in] Port`l
 * @param           offset [in] oCgItZbg
 * @param           data [in] f[^
 * @return          void
 * @description     GPIOnDTOUT̃WX^Write(8rbgP)
 */
void AG903_GPIOPrmSetByteData(uint8_t ch, uint8_t offset, uint8_t data)
{
	uint8_t* reg;

	ASSERT(AG903_GPIO_CH_NUM > ch);
	ASSERT((AG903_GPIO_PORTBIT_NUM/8) > offset);	/* 8rbgP */

	reg  	= (uint8_t*)&AG903_GPIOn(ch)->DTOUT;
	reg    += offset;
	(*reg) 	= data;
	return;
}

/**
 * @brief           GPIOnDTOUT̃WX^Read(8rbgP)
 * @param           ch [in] Port`l
 * @param           offset [in] oCgItZbg
 * @param           data [out] f[^
 * @return          void
 * @description     GPIOnDTOUT̃WX^Read(8rbgP)
 */
void AG903_GPIOPrmGetByteData(uint8_t ch, uint8_t offset, uint8_t* data)
{
	uint8_t* reg;

	ASSERT(AG903_GPIO_CH_NUM > ch);
	ASSERT((AG903_GPIO_PORTBIT_NUM/8) > offset);	/* 8rbgP */

	reg  	= (uint8_t*)&AG903_GPIOn(ch)->DTIN;
	reg    += offset;
	(*data)	= (*reg);
	return;
}

/**
 * @brief           GPIOnDTOUT̃WX^Write(rbgP)
 * @param           ch [in] Port`l
 * @param           set [in] ZbgΏہirbgwj
 * @param           clr [in] NAΏہirbgwj
 * @param           ext [in] r̗L
 * @return          void
 * @description     GPIOnDTOUT̃WX^Write(rbgP)
 */
void AG903_GPIOPrmModifyBit(uint8_t ch, uint32_t set, uint32_t clr, _Bool ext)
{
	uint32_t reg;

	ASSERT(AG903_GPIO_CH_NUM > ch);

	if(true == ext) {
		GPIOPrm_ModifyBit((uintptr_t)(&AG903_GPIOn(ch)->DTOUT), set, ~clr);
	}
	else {
		reg = AG903_GPIOn(ch)->DTOUT;
		reg |= set;
		reg &= ~clr;
		AG903_GPIOn(ch)->DTOUT = reg;
	}

	return;
}

/**
 * @brief           GPIOnDTOUT̃WX^Read
 * @param           ch [in] Port`l
 * @param           data [out] 擾f[^
 * @return          void
 * @description     GPIOnDTOUT̃WX^Read
 */
void AG903_GPIOPrmGetPortData(uint8_t ch, uint32_t* data)
{
	ASSERT(AG903_GPIO_CH_NUM > ch);

	(*data) = AG903_GPIOn(ch)->DTIN;
	return;
}

/**
 * @brief           GPIOnDIR̃WX^Write
 * @param           ch [in] Port`l
 * @param           dir [in] ói0:, 1:ój
 * @return          void
 * @description     GPIOnDIR̃WX^Write
 */
void AG903_GPIOPrmSetDirection(uint8_t ch, uint32_t dir)
{
	ASSERT(AG903_GPIO_CH_NUM > ch);
	
	AG903_GPIOn(ch)->DIR = dir;
	return;
}

/**
 * @brief           GPIOnDIR̃WX^Read
 * @param           ch [in] Port`l
 * @param           dir [out] ói0:, 1:ój
 * @return          void
 * @description     GPIOnDIR̃WX^Read
 */
void AG903_GPIOPrmGetDirection(uint8_t ch, uint32_t* dir)
{
	ASSERT(AG903_GPIO_CH_NUM > ch);
	
	(*dir) = AG903_GPIOn(ch)->DIR;
	return;
}

/**
 * @brief           GPIOnIOTYPẼWX^Write
 * @param           ch [in] Port`l
 * @param           type [in] ^Cvi0:ʏ, 1:I[vhCj
 * @return          void
 * @description     GPIOnIOTYPẼWX^Write
 */
void AG903_GPIOPrmSetType(uint8_t ch, uint32_t type)
{
	ASSERT(AG903_GPIO_CH_NUM > ch);
	
	AG903_GPIOn(ch)->IOTYPE = type;
	return;
}

/**
 * @brief           GPIOnIOTYPẼWX^Read
 * @param           ch [in] Port`l
 * @param           type [out] ^Cvi0:ʏ, 1:I[vhCj
 * @return          void
 * @description     GPIOnIOTYPẼWX^Read
 */
void AG903_GPIOPrmGetType(uint8_t ch, uint32_t* type)
{
	ASSERT(AG903_GPIO_CH_NUM > ch);
	
	(*type) = AG903_GPIOn(ch)->IOTYPE;
	return;
}

/**
 * @brief           GPIOnPOSEDGẼWX^Write
 * @param           ch [in] Port`l
 * @param           enable [in] oݒi0:, 1:Lj
 * @return          void
 * @description     GPIOnPOSEDGẼWX^Write
 */
void AG903_GPIOPrmSetPosEdgeDetect(uint8_t ch, uint32_t enable)
{
	ASSERT(AG903_GPIO_CH_NUM > ch);
	
	AG903_GPIOn(ch)->POSEDGE = enable;
	return;
}

/**
 * @brief           GPIOnPOSEDGẼWX^Read
 * @param           ch [in] Port`l
 * @param           enable [out] oݒi0:, 1:Lj
 * @return          void
 * @description     GPIOnPOSEDGẼWX^Read
 */
void AG903_GPIOPrmGetPosEdgeDetect(uint8_t ch, uint32_t* enable)
{
	ASSERT(AG903_GPIO_CH_NUM > ch);
	
	(*enable) = AG903_GPIOn(ch)->POSEDGE;
	return;
}

/**
 * @brief           GPIOnNEGEDGẼWX^Write
 * @param           ch [in] Port`l
 * @param           enable [in] oݒi0:, 1:Lj
 * @return          void
 * @description     GPIOnNEGEDGẼWX^Write
 */
void AG903_GPIOPrmSetNegEdgeDetect(uint8_t ch, uint32_t enable)
{
	ASSERT(AG903_GPIO_CH_NUM > ch);
	
	AG903_GPIOn(ch)->NEGEDGE = enable;
	return;
}

/**
 * @brief           GPIOnNEGEDGẼWX^Read
 * @param           ch [in] Port`l
 * @param           enable [out] oݒi0:, 1:Lj
 * @return          void
 * @description     GPIOnNEGEDGẼWX^Read
 */
void AG903_GPIOPrmGetNegEdgeDetect(uint8_t ch, uint32_t* enable)
{
	ASSERT(AG903_GPIO_CH_NUM > ch);
	
	(*enable) = AG903_GPIOn(ch)->NEGEDGE;
	return;
}

/**
 * @brief           GPIOnINTMASK̃WX^Write
 * @param           ch [in] Port`l
 * @param           mask [in] }XNݒi0:, 1:Lj
 * @return          void
 * @description     GPIOnINTMASK̃WX^Write
 */
void AG903_GPIOPrmSetMask(uint8_t ch, uint32_t mask)
{
	ASSERT(AG903_GPIO_CH_NUM > ch);
	
	AG903_GPIOn(ch)->INTMASK = mask;
	return;
}

/**
 * @brief           GPIOnINTMASK̃WX^Read
 * @param           ch [in] Port`l
 * @param           mask [out] }XNݒi0:, 1:Lj
 * @return          void
 * @description     GPIOnINTMASK̃WX^Read
 */
void AG903_GPIOPrmGetMask(uint8_t ch, uint32_t* mask)
{
	ASSERT(AG903_GPIO_CH_NUM > ch);
	
	(*mask) = AG903_GPIOn(ch)->INTMASK;
	return;
}

/**
 * @brief           GPIOnEDGESTAT̃WX^Read
 * @param           ch [in] Port`l
 * @param           status [out] GbWoXe[^X
 * @return          void
 * @description     GPIOnEDGESTAT̃WX^Read
 */
void AG903_GPIOPrmGetEdgeDetect(uint8_t ch, uint32_t* status)
{
	ASSERT(AG903_GPIO_CH_NUM > ch);

	(*status) = AG903_GPIOn(ch)->EDGESTAT;
	return;
}

/**
 * @brief           GPIOnEDGECLR̃WX^Write
 * @param           ch [in] Port`l
 * @param           clrbit [in] Ώہirbgwj
 * @return          void
 * @description     GPIOnEDGECLR̃WX^Write
 */
void AG903_GPIOPrmClearEdgeDetect(uint8_t ch, uint32_t clrbit)
{
	ASSERT(AG903_GPIO_CH_NUM > ch);

	AG903_GPIOn(ch)->EDGECLR = clrbit;
	return;
}
