/**
 * @brief           Movie Player Sample API
 * @author          AXELL CORPORATION
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2019_03_08  [SDK2.2] MPSł̃t@C͕sC (#1933)
 * @history         2019_03_08  [SDK2.2] MPSłGVDT[`W̐ݒɂăfR[_IȂȂsC (#2449)
 * @history         2019_03_08  [SDK2.2] MPSł̃Rei̓G[ǂ@ɕύX (#2473)
 * @history         2020_07_22  [SDK3.1] MPSł̃tO҂Ƀ^CAEgǉ (#3034)
 * @note            G[R[hAG903_error.hQƂ̂.
 */

/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2020 AXELL CORPORATION, all rights reserved.
 */

#include "mps/mps_api.h"

/** @brief GVDp[^ */
static gvdInitializeParam _GVDInitParam;
/** @brief MPSݒp[^ */
static mpsConfig _MPSConfig;
/** @brief ReLXg */
static mpsContext _MPSContext[16] = {{0}};
/** @brief BOẌʒu */
static mpsInfoPos _MPSInfoPos[16] = {{0}};
/** @brief SPS/PPSێ̈ */
static mpsAVCHeader _MPSAVCHeader[16] = {{0}};

static gvdFatalErrorInfo fatalinfo = {0,0};

/** @brief fR[hR[obN֐ */
static gvdCbFunc cbDecodeDone;

/** @brief 񓯊҂fBC */
#define TIME_ASYNC_WAIT 1

/** @brief ^CAEgԁi񓯊҂fBCPʁj, 0: */
#define MPS_API_TIMEOUT 1000

/*
 * w肳ꂽtOtrue(!=0)ɂȂ܂őҋ@.
 * vIG[ / ^CAEgłԂ.
 */
static int32_t waitforflag(bool volatile *flag, uint32_t timeout) {
    int32_t  rtcd = AG903_ENONE;
    uint32_t cnt  = 0;
	while(1)
    {
		GVD_GetFatalError(&fatalinfo);
		if(fatalinfo.cause != 0) {
			break;
		}
		if(*flag) {
			break;
		}
        if(timeout > 0 && cnt > timeout) {
            rtcd = -AG903_ETIMEDOUT;
            break;
        }
		MPS_Delay(TIME_ASYNC_WAIT);
        cnt++;
	}

    return rtcd;
}

/**
 * MPSɎIɐݒ肳܂A
 * [U̓AvݒeQƂ邱Ƃł܂.
 * @brief GVDݒl̎擾
 * @return GVDݒl\
 */
gvdInitializeParam *MPS_getGVDInitParam(void)
{
	return &_GVDInitParam;
}

/**
 * MPSݒl̎擾
 * @return MPSݒl\
 */
mpsConfig *MPS_getConfig(void)
{
	return &_MPSConfig;
}

/**
 * MPSReLXg̎擾
 * @param movie_id [in]Xg[ID
 * @return MPSReLXg\
 */
mpsContext *MPS_getContext(uint32_t movie_id)
{
	return &_MPSContext[movie_id];
}

/**
 * BoxItZbgʒu̎擾
 * @param movie_id [in]Xg[ID
 * @return BoxItZbgʒu\
 */
mpsInfoPos *MPS_getInfoPos(uint32_t movie_id)
{
	return &_MPSInfoPos[movie_id];
}

/**
 * X^[gR[h܂SPS/PPS擾܂. <p>
 * _MPSAVCHeadeŕAparse()@mps_mp4parser.cŊmہA`܂. <p>
 * Xg[SPS/PPS܂܂ȂMP4t@CĐꍇɎQƂ܂.
 * @brief AVCwb_̎擾
 * @return AVCwb_\
 */
mpsAVCHeader *MPS_getAVCHeader(uint32_t movie_id)
{
	return &_MPSAVCHeader[movie_id];
}

/**
 * MPS̏<p>
 * MPS̑SĂ̊֐͂̊֐ɎsĂ.
 * @brief MPS̏
 * @param setting MPSݒ\
 * @return G[R[h
 */
int32_t MPS_Initialize(mpsSetting setting)
{
	if(setting.max_stream == 0 || setting.max_stream > 16)
	    return -AG903_EINVAL;

	gvdError err;
	int32_t i, size;

	/* p[^ */
	_MPSConfig.memory_work_top = NULL;
	_MPSConfig.memory_work_size = 0;
	_MPSConfig.memory_heap_top = NULL;
    _MPSConfig.memory_heap_size = 0;
	_MPSConfig.output_select = GVD_OUTMOD_NONE;
    _MPSConfig.num_out_buffer = 0;

	size = (int32_t)sizeof(_MPSContext);
	for(i=0; i<size; i++)
	    *((uint8_t *)(_MPSContext) + i) = 0x00;

	size = (int32_t)sizeof(_MPSInfoPos);
	for(i=0; i<size; i++)
	    *((uint8_t *)(_MPSInfoPos) + i) = 0x00;

	size = (int32_t)sizeof(_MPSAVCHeader);
	for(i=0; i<size; i++)
	    *((uint8_t *)(_MPSAVCHeader) + i) = 0x00;

	cbDecodeDone = NULL;

	_GVDInitParam.func_notify_fatalerror = setting.func_fatalerror_handler;
	_GVDInitParam.param_notify_fatalerror = NULL;
	_GVDInitParam.vramaddr_mask = 0x00000000;
	_GVDInitParam.bmuaddr_mask = 0x00000000;
	_GVDInitParam.stream_buf_size = setting.stream_buffer_size;
	_GVDInitParam.stream_buf_num = setting.stream_buffer_num;
	_GVDInitParam.stream_num = setting.max_stream;

	cbDecodeDone = setting.func_decode_done_handler;

	err = GVD_InitInitializeParam(&_GVDInitParam);
	if (err != GVD_ERR_SUCCESS) {
	    return -AG903_EINVAL;
	}

	return AG903_ENONE;
}

/**
 * GVDv郁TCY̎擾
 * @brief [NKvTCY擾
 * @return KvTCY
 */
uint32_t MPS_GetRequiredWorkMemorySize(void)
{
	return GVD_GetRequiredMemorySize();
}

/**
 * GVD̏<p>
 * configŐݒ肵̈͂APIsgp܂.
 * @brief GVD̊Jn
 * @param config GVDp[^\
 * @return G[R[h
 */
int32_t MPS_Start(mpsConfig config)
{
	if(config.memory_work_top == NULL || config.memory_heap_top == NULL)
	    return -AG903_EINVAL;

	gvdError err;
	int32_t idx;

	_MPSConfig.memory_work_top = config.memory_work_top;
	_MPSConfig.memory_work_size = config.memory_work_size;
	_MPSConfig.memory_heap_top = config.memory_heap_top;
	_MPSConfig.memory_heap_size = config.memory_heap_size;
	_MPSConfig.output_select = config.output_select;
	_MPSConfig.num_out_buffer = config.num_out_buffer;

	err = GVD_SetWorkMemory(_MPSConfig.memory_work_top,
							_MPSConfig.memory_work_size);
	if (err != GVD_ERR_SUCCESS) {
	    return -AG903_EINVAL;
	}

	err = GVD_Initialize();
	if (err != GVD_ERR_SUCCESS) {
	    return -AG903_EINVAL;
	}

	{
	    /* R[obN̐ݒ */
	    gvdCbFuncs cbFuncs;
	    {
			int32_t i;
			int32_t size = (int32_t)sizeof(gvdCbFuncs);
			for(i=0; i<size; i++)
			{
				*((uint8_t *)(&cbFuncs) + i) = 0x00;
			}
	    }
	    cbFuncs.commit_output_buffer = cbDecodeDone;
	    cbFuncs.connect_done =
			(int32_t (*)(void *, void *, gvdError))cbMPSConnectDone;
	    cbFuncs.disconnect_done =
			(int32_t (*)(void *, void *, gvdError))cbMPSDisConnectDone;
	    cbFuncs.play_accepted =
			(int32_t (*)(void *, void *, gvdError))cbMPSPlayAccepted;
	    cbFuncs.rewind_accepted =
			(int32_t (*)(void *, void *, gvdError))cbMPSRewindAccepted;
	    cbFuncs.forward_accepted =
			(int32_t (*)(void *, void *, gvdError))cbMPSForwardAccepted;
	    cbFuncs.decode_stream_end =
			(int32_t (*)(void *, void *, gvdError))cbMPSDecodeStreamEnd;
	    cbFuncs.pause_done =
			(int32_t (*)(void *, void *, gvdError))cbMPSPauseDone;
	    cbFuncs.seek_done =
			(int32_t (*)(void *, void *, gvdError))cbMPSSeekDone;
		cbFuncs.rewind_done =
			(int32_t (*)(void *, void *, gvdError))cbMPSRewindDone;

	    /* R[obNp[^̐ݒ */
	    for (idx=0; idx<(int32_t)_GVDInitParam.stream_num; idx++)
	    {
			gvdCbParams cbParams;
			{
				int32_t i;
				int32_t size = (int32_t)sizeof(gvdCbParams);
				for(i=0; i<size; i++)
				{
					*((uint8_t *)(&cbParams) + i) = 0x00;
				}
			}
			cbParams.decode_stream_end = (void *)&_MPSContext[idx];
			cbParams.commit_output_buffer = (void *)&_MPSContext[idx];
			cbParams.rewind_done = (void *)&_MPSContext[idx];
			_MPSContext[idx].id = idx;

			/* ReLXg̎擾 */
			GVD_CreateContext(&_MPSContext[idx].gvdctx);

			/* R[obN̓o^ */
			GVD_SetCallbackFunctions(_MPSContext[idx].gvdctx, &cbFuncs);
			GVD_SetCallbackParams(_MPSContext[idx].gvdctx, &cbParams);

			/* o͐w */
			if(_MPSConfig.output_select == GVD_OUTMOD_VRAM)
				GVD_SelectOutputModule(_MPSContext[idx].gvdctx, GVD_OUTMOD_VRAM);
			else if(_MPSConfig.output_select == GVD_OUTMOD_BMU)
				GVD_SelectOutputModule(_MPSContext[idx].gvdctx, GVD_OUTMOD_BMU);
			else
				GVD_SelectOutputModule(_MPSContext[idx].gvdctx, GVD_OUTMOD_NONE);

			uint32_t heapsize = _MPSConfig.memory_heap_size / _GVDInitParam.stream_num;
			heapsize &= 0xFFFFF800;
			GVD_SetOutputHeap(_MPSContext[idx].gvdctx,
							  (void *)((uint32_t)_MPSConfig.memory_heap_top+(heapsize*idx)),
							  heapsize);

			/* ʒuobt@GVDɐݒ */
			if(_MPSContext[idx].info.position_count != 0 &&
			   _MPSContext[idx].info.position_buf != NULL)
				GVD_SetPositionBuffer(_MPSContext[idx].gvdctx,
									  _MPSContext[idx].info.position_buf,
									  _MPSContext[idx].info.position_count);
	    }
	}

	return AG903_ENONE;
}

/**
 * ΉReLXgɃRei݂܂.
 * @brief MP4t@C̃Reỉ
 * @param movie_id [in]Xg[ID
 * @param filename [in]Ώۃt@C
 * @return G[R[h
 */
int32_t MPS_Parse(uint32_t movie_id, char *filename)
{
	volatile mpsAsyncFlag *f = &_MPSContext[movie_id].flag;
	uint32_t fnamelen;
	if(filename == NULL || movie_id > 15)
	    return -AG903_EINVAL;
#ifdef MPS_USE_STDLIB
	char *sp = strrchr(filename, '.');
	char ext[5];
	strncpy(ext, &sp[1], 4);
	ext[4] = '\0';
	if(!strcmp(ext, "h264"))
#else
	fnamelen = 0;
	while(filename[fnamelen]!='\0'){
		fnamelen++;
	}
	uint32_t dot;
	for(dot=fnamelen; dot>0; dot--)
	{
	    if(filename[dot-1] == '.') break;
	}
	if(dot == 0 || fnamelen+1 > dot+4)
	    if(filename[dot-1] == '.' &&
	       filename[dot-0] == 'h' &&
	       filename[dot+1] == '2' &&
	       filename[dot+2] == '6' &&
	       filename[dot+3] == '4' &&
	       filename[dot+4] == '\0' )
#endif
        {
        	/* .h264 */
			int32_t i;
			for(i=0; i<MPS_MAX_FILENAME_LENGTH; i++)
			{
				_MPSContext[movie_id].filename[i] = filename[i];
				if(filename[i] =='\0')
					break;
			}
			mps_ParseMP4Container(movie_id); /* filesize check */
			f->bParsed = true;
			return AG903_ENONE;
        }
	if(!f->bParsed)
	{
	    _MPSContext[movie_id].fp = mps_fopen(filename, "rb");
	    if(_MPSContext[movie_id].fp == 0)
	    {
	    	return -AG903_ENOENT;
	    }

		int32_t rtcd;
		int32_t i;
		for(i=0; i<MPS_MAX_FILENAME_LENGTH; i++)
		{
			_MPSContext[movie_id].filename[i] = filename[i];
			if(filename[i] =='\0')
				break;
		}

		mps_invalidateCache(movie_id);

		rtcd = mps_ParseMP4Container(movie_id);
		mps_fclose(_MPSContext[movie_id].fp);
		_MPSContext[movie_id].fp = NULL;
		if(rtcd != 0)
		{
			MPS_ErrPrintf("ERROR: MP4 file parse error.\r\n");
			return rtcd;
		}

	    f->bParsed = true;
	}

	return AG903_ENONE;
}


/**
 * w肵pXMP4t@CJ<p>
 * t@Č`ɑΉłȂꍇ-AG903_EINVALԂ܂.<p>
 * ̊֐͏܂ŃubN܂.
 * @brief MP4t@CJ
 * @param movie_id [in]Xg[ID
 * @param filename [in]Ώۃt@CitpXj
 * @return G[R[h
 */
int32_t MPS_Open(uint32_t movie_id, char *filename)
{
	gvdError err;
	volatile mpsAsyncFlag *f = &_MPSContext[movie_id].flag;

	if(filename == NULL || movie_id > 15)
	    return -AG903_EINVAL;

	if(f->bOpened)
	{
	    return -AG903_EBUSY;
	}
	else
	{
	    if(!f->bParsed)
	    {
			_MPSContext[movie_id].fp = mps_fopen(filename, "rb");
			if(_MPSContext[movie_id].fp != 0)
			{
				int32_t rtcd;
				int32_t i;
				for(i=0; i<MPS_MAX_FILENAME_LENGTH; i++)
				{
					_MPSContext[movie_id].filename[i] = filename[i];
					if(filename[i] =='\0')
						break;
				}
				rtcd = mps_ParseMP4Container(movie_id);
				mps_fclose(_MPSContext[movie_id].fp);
				_MPSContext[movie_id].fp = NULL;
				if(rtcd != 0)
				{
					MPS_ErrPrintf("ERROR: MP4 file parse error.\r\n");
					return rtcd;
				}
			}
			if(_MPSContext[movie_id].info.position_count != 0 &&
			   _MPSContext[movie_id].info.position_buf != NULL)
				GVD_SetPositionBuffer(_MPSContext[movie_id].gvdctx,
									  _MPSContext[movie_id].info.position_buf,
									  _MPSContext[movie_id].info.position_count);
			f->bParsed = true;
	    }

	    err = GVD_OpenFile(_MPSContext[movie_id].gvdctx, filename, &_MPSContext[movie_id]);
	    if(err != GVD_ERR_SUCCESS) {
			MPS_ErrPrintf("Error: GVD_OpenFile() : %d\n", err);
			return -AG903_ENOENT;
	    }
        int32_t ret = waitforflag(&f->bOpened, 0);
        if(0 > ret) {
            return ret;
        }
	    f->bClosed = false;
	}

	return AG903_ENONE;
}

/**
 * GVDɍĐv<p>
 * ̊֐͗v󗝂܂ŃubN܂.
 * @brief ĐJn
 * @param movie_id [in]Xg[ID
 * @return G[R[h
 */
int32_t MPS_Play(uint32_t movie_id)
{
	volatile mpsAsyncFlag *f = &_MPSContext[movie_id].flag;

	if(movie_id > 15 || movie_id > _GVDInitParam.stream_num)
	    return -AG903_EINVAL;

	if(f->bPlayAccepted || !f->bOpened)
	{
	    return -AG903_EBUSY;
	}
	else
	{
	    GVD_Play(_MPSContext[movie_id].gvdctx, &_MPSContext[movie_id]);
        int32_t ret = waitforflag(&f->bPlayAccepted, 0);
        if(0 > ret) {
            return ret;
        }
	    f->bPaused = false;
	    f->bRewindAccepted = false;
	    f->bForwardAccepted = false;
	}

	return AG903_ENONE;
}

/**
 * GVDɈꎞ~v<p>
 * ̊֐͗v܂ŃubN܂.
 * @brief ꎞ~
 * @param movie_id [in]Xg[ID
 * @return G[R[h
 */
int32_t MPS_Pause(uint32_t movie_id)
{
	volatile mpsAsyncFlag *f = &_MPSContext[movie_id].flag;

	if(movie_id > 15 || movie_id > _GVDInitParam.stream_num)
	    return -AG903_EINVAL;

	if(f->bPaused || !f->bOpened)
	{
	    return -AG903_EBUSY;
	}
	else
	{
	    GVD_Pause(_MPSContext[movie_id].gvdctx, &_MPSContext[movie_id]);
        int32_t ret = waitforflag(&f->bPaused, 0);
        if(0 > ret) {
            return ret;
        }
	    f->bPlayAccepted = false;
	    f->bRewindAccepted = false;
	    f->bForwardAccepted = false;
	}

	return AG903_ENONE;
}

/**
 * GVDɃV[Nv<p>
 * V[Nʂ̓t[ ܂ [ms]I\<p>
 * ̊֐͗v܂ŃubN܂.
 * @brief V[Nioj
 * @param movie_id [in]Xg[ID
 * @param pos [in]V[NimodeɈ˂j
 * @param mode [in]V[N̎w
 * @return G[R[h
 * @see mpsSeekMode
 */
int32_t MPS_Seek(uint32_t movie_id, uint32_t pos, mpsSeekMode mode)
{
	volatile mpsAsyncFlag *f = &_MPSContext[movie_id].flag;

	if(movie_id > 15 || movie_id > _GVDInitParam.stream_num)
	    return -AG903_EINVAL;

	if(!f->bPaused || !f->bOpened)
	{
	    return -AG903_EBUSY;
	}
	else
	{
		bool bImme;
		gvdSeekType type;
		uint32_t offset, target, idr;
		gvdSeekParam seekparam;

		switch(mode)
		{
			case MPS_SEEK_INDEX:
			type = GVD_SEEK_BUFINDEX_ABSOLUTE;
			target = pos;
			bImme = false;
			break;

			case MPS_SEEK_RELATIVE_INDEX:
			type = GVD_SEEK_BUFINDEX_RELATIVE;
			target = pos;
			bImme = false;
			break;

			case MPS_SEEK_FRAME:
			type = GVD_SEEK_IMMEDIATE;
			offset = MPS_GetSeekPositionFromFrameID(movie_id, pos, &idr);
			target = idr;
			bImme = true;
			break;

			case MPS_SEEK_TIME:
			type = GVD_SEEK_IMMEDIATE;
			offset = MPS_GetSeekPositionFromTime(movie_id, pos, &idr);
			target = idr;
			bImme = true;
			break;

			default:
			return -AG903_EINVAL;
		}

		if(bImme)
		{
		    if(offset == 0)
		    {
				/* H264 ES:SeekΉ */
				return -AG903_ENOTSUP;
		    }
		    else
		    {
				/* MP4:ItZbgMPSőSĎZoĂ */
				seekparam.type            = type;
				seekparam.index_offset    = 0;
				seekparam.immediate_frame = target;
				seekparam.immediate_byte  = offset;
		    }
		}
		else
		{
			seekparam.type            = type;
			seekparam.index_offset    = target;
			seekparam.immediate_frame = 0;
			seekparam.immediate_byte  = 0;
		}

		f->bSought = false;
		GVD_Seek(_MPSContext[movie_id].gvdctx, &seekparam, &_MPSContext[movie_id]);
        int32_t ret = waitforflag(&f->bSought, 0);
        if(0 > ret) {
            return ret;
        }
	}

	return AG903_ENONE;
}

/**
 * GVDɑv<p>
 * ̊֐͗v󗝂܂ŃubN܂.
 * @brief Jn
 * @param movie_id [in]Xg[ID
 * @param speed [in]x
 * @return G[R[h
 */
int32_t MPS_Forward(uint32_t movie_id, uint32_t speed)
{
	volatile mpsAsyncFlag *f = &_MPSContext[movie_id].flag;

	if(movie_id > 15 || movie_id > _GVDInitParam.stream_num)
	    return -AG903_EINVAL;

	if(!f->bOpened)
	{
	    return -AG903_EBUSY;
	}
	else
	{
	    GVD_Forward(_MPSContext[movie_id].gvdctx, speed, &_MPSContext[movie_id]);
        int32_t ret = waitforflag(&f->bForwardAccepted, 0);
        if(0 > ret) {
            return ret;
        }
	    f->bPaused = false;
	    f->bPlayAccepted = false;
	    f->bRewindAccepted = false;
	}

	return AG903_ENONE;
}

/**
 * GVDɑ߂v<p>
 * ̊֐͗v󗝂܂ŃubN܂.
 * @brief ߂Jn
 * @param movie_id [in]Xg[ID
 * @param speed [in]x
 * @return G[R[h
 */
int32_t MPS_Rewind(uint32_t movie_id, uint32_t speed)
{
	volatile mpsAsyncFlag *f = &_MPSContext[movie_id].flag;

	if(movie_id > 15 || movie_id > _GVDInitParam.stream_num || speed == 0)
	    return -AG903_EINVAL;

	if(f->bRewindAccepted || !f->bOpened)
	{
	    return -AG903_EBUSY;
	}
	else
	{
	    GVD_Rewind(_MPSContext[movie_id].gvdctx, speed, (void *)&_MPSContext[movie_id]);
        int32_t ret = waitforflag(&f->bRewindAccepted, 0);
        if(0 > ret) {
            return ret;
        }
	    f->bPaused = false;
	    f->bPlayAccepted = false;
	    f->bForwardAccepted = false;
	}

	return AG903_ENONE;
}

/**
 * w肵ID̃t@C<p>
 * ̊֐͏܂ŃubN܂.
 * @brief MP4t@C
 * @param movie_id [in]Xg[ID
 * @return G[R[h
 */
int32_t MPS_Close(uint32_t movie_id)
{
	volatile mpsAsyncFlag *f = &_MPSContext[movie_id].flag;

	if(movie_id > 15 || movie_id > _GVDInitParam.stream_num)
	    return -AG903_EINVAL;

	if(!f->bPaused)
	{
	    return -AG903_EBUSY;
	}
	else
	{
		if(f->bParsed)
		{
			mpsMovieInfo *info = &_MPSContext[movie_id].info;
			if(info->keyframe != NULL)
			{
				MPS_Free(info->keyframe);
				info->keyframe = NULL;
			}
			if(info->position_buf != NULL)
			{
				MPS_Free(info->position_buf);
				info->position_buf = NULL;
			}

			mpsAVCHeader *AVCHeader = MPS_getAVCHeader(movie_id);
			if(AVCHeader->data != NULL)
			{
				MPS_Free(AVCHeader->data);
				AVCHeader->data = NULL;
			}

		    f->bParsed = false;
		}
		if(f->bOpened)
		{
		    GVD_CloseFile(_MPSContext[movie_id].gvdctx, &_MPSContext[movie_id]);
            int32_t ret = waitforflag(&f->bClosed, MPS_API_TIMEOUT);
            if(0 > ret) {
                return ret;
            }
		    f->bPaused = false;
		    f->bOpened = false;
		}
	}

	return AG903_ENONE;
}

/**
 * MPS̏Is<p>
 * ̊֐͏܂ŃubN܂.
 * @brief MPS̏I
 * @return G[R[h
 */
int32_t MPS_Finalize(void)
{
	int32_t i, err;

	GVD_GetFatalError(&fatalinfo);

	for(i=0; i<(int32_t)_GVDInitParam.stream_num; i++)
	{
		if(_MPSContext[i].flag.bOpened)
		{
			if(fatalinfo.cause == 0)
			{
					return -AG903_EBUSY;
			}
			else
			{
				if(_MPSContext[i].fp != NULL) {
					mps_fclose(_MPSContext[i].fp);
					_MPSContext[i].fp = NULL;
				}

				GVD_CloseFile(_MPSContext[i].gvdctx, NULL);
			}

			_MPSContext[i].flag.bOpened = 0;
		}
	}

	for(i=0; i<(int32_t)_GVDInitParam.stream_num; i++)
	{
	    err = GVD_DestroyContext(_MPSContext[i].gvdctx);
		if(fatalinfo.cause == 0)
		{
			if(err) { return err; }
		}
	}

	for(i=0; i<(int32_t)_GVDInitParam.stream_num; i++)
	{
		mpsMovieInfo *info = &_MPSContext[i].info;
	    if(info->keyframe != NULL)
	    {
			MPS_Free(info->keyframe);
			info->keyframe = NULL;
		}
	    if(info->position_buf != NULL)
	    {
			MPS_Free(info->position_buf);
			info->position_buf = NULL;
		}

	    mpsAVCHeader *AVCHeader = MPS_getAVCHeader(i);
	    if(AVCHeader->data != NULL)
	    {
			MPS_Free(AVCHeader->data);
			AVCHeader->data = NULL;
	    }
	}

	err = GVD_Finalize();

	return AG903_ENONE;
}

/**
 * o̓obt@Zbg
 * @brief o̓obt@̃Zbg
 * @param movie_id [in]Xg[ID
 * @param bufinfo [in]obt@
 * @return G[R[h
 * @return -AG903_EOVERFLOW obt@𒴂ăZbg悤Ƃ
 * @return -AG903_ENOTSUP BMUo͂Ȃ̂ŃR[łȂ
 * @return -AG903_EINVAL p[^s
 */
int32_t MPS_PutOutputBuffer(int32_t movie_id, mpsOutBufInfo *bufinfo)
{
	int32_t err;
	if(bufinfo == NULL)
	    return -AG903_EINVAL;
	err = GVD_PutOutputBuffer(_MPSContext[movie_id].gvdctx,
							  (gvdOutBufInfo *)bufinfo,
							  &_MPSContext[movie_id]);
	switch(err)
	{
	case GVD_ERR_INVALID_STATE:
	    return -AG903_EOVERFLOW;
	case GVD_ERR_INVALID_CALL:
	    return -AG903_ENOTSUP;
	case GVD_ERR_BAD_PARAMETER:
	    return -AG903_EINVAL;
	}
	return AG903_ENONE;
}

/**
 * 񓯊1R[<p>
 * ̔񓯊͕K1̃^XNReLXĝ݌Ăяo.
 *
 * @brief 񓯊
 * @return G[R[h
 */
int32_t MPS_Async(void)
{
	gvdError err;
	err = GVD_Execute();
	return err;
}


/**
 * GVDڑR[obN֐<p>
 * MPSŔ񓯊֐̊҂Ɏgp
 * @brief [R[obN] ڑ
 * @return G[R[h
 */
int32_t cbMPSConnectDone(void *param_gvd, void *param_user, gvdError error)
{
	((void)(param_gvd));
	((void)(error));

	mpsContext *ctx = (mpsContext *)param_user;
	volatile mpsAsyncFlag *f = &ctx->flag;
	f->bDecDone= false;

	f->bPaused = true;
	f->bOpened = true;
	return 0;
}

/**
 * GVDؒfR[obN֐<p>
 * MPSŔ񓯊֐̊҂Ɏgp
 * @brief [R[obN] ؒf
 * @return G[R[h
 */
int32_t cbMPSDisConnectDone(void *param_gvd, void *param_user, gvdError error)
{
	((void)(param_gvd));
	((void)(error));

	mpsContext *ctx = (mpsContext *)param_user;
	volatile mpsAsyncFlag *f = &ctx->flag;
	f->bDecDone= false;

	f->bClosed = true;
	return 0;
}

/**
 * GVDĐtR[obN֐<p>
 * MPSŔ񓯊֐̊҂Ɏgp
 * @brief [R[obN] Đt
 * @return G[R[h
 */
int32_t cbMPSPlayAccepted(void *param_gvd, void *param_user, gvdError error)
{
	((void)(param_gvd));
	((void)(error));

	mpsContext *ctx = (mpsContext *)param_user;
	volatile mpsAsyncFlag *f = &ctx->flag;
	f->bDecDone= false;
	f->bRewindDone = false;

	f->bPlayAccepted = true;
	return 0;
}

/**
 * GVD߂tR[obN֐<p>
 * MPSŔ񓯊֐̊҂Ɏgp
 * @brief [R[obN] ߂t
 * @return G[R[h
 */
int32_t cbMPSRewindAccepted(void *param_gvd, void *param_user, gvdError error)
{
	((void)(param_gvd));
	((void)(error));

	mpsContext *ctx = (mpsContext *)param_user;
	volatile mpsAsyncFlag *f = &ctx->flag;
	f->bDecDone= false;

	f->bRewindAccepted = true;
	return 0;
}

/**
 * GVDڑtR[obN֐<p>
 * MPSŔ񓯊֐̊҂Ɏgp
 * @brief [R[obN] ߂t
 * @return G[R[h
 */
int32_t cbMPSForwardAccepted(void *param_gvd, void *param_user, gvdError error)
{
	((void)(param_gvd));
	((void)(error));

	mpsContext *ctx = (mpsContext *)param_user;
	volatile mpsAsyncFlag *f = &ctx->flag;
	f->bDecDone= false;
	f->bRewindDone = false;

	f->bForwardAccepted = true;
	return 0;
}

/**
 * GVDfR[hR[obN֐<p>
 * MPSŔ񓯊֐̊҂Ɏgp
 * @brief [R[obN] fR[h
 * @return G[R[h
 */
int32_t cbMPSDecodeStreamEnd(void *param_gvd, void *param_user, gvdError error)
{
	((void)(param_gvd));
	((void)(error));

	mpsContext *ctx = (mpsContext *)param_user;
	volatile mpsAsyncFlag *f = &ctx->flag;
	f->bRewindAccepted = false;
	f->bPlayAccepted = false;
	f->bForwardAccepted = false;
	f->bSought = false;
	f->bPaused = true;

	f->bDecDone= true;
	return 0;
}

/**
 * GVDꎞ~R[obN֐<p>
 * MPSŔ񓯊֐̊҂Ɏgp
 * @brief [R[obN] ꎞ~
 * @return G[R[h
 */
int32_t cbMPSPauseDone(void *param_gvd, void *param_user, gvdError error)
{
	((void)(param_gvd));
	((void)(error));

	mpsContext *ctx = (mpsContext *)param_user;
	volatile mpsAsyncFlag *f = &ctx->flag;
	f->bRewindAccepted = false;
	f->bPlayAccepted = false;
	f->bForwardAccepted = false;

	f->bPaused = true;
	return 0;
}

/**
 * GVDV[NR[obN֐<p>
 * MPSŔ񓯊֐̊҂Ɏgp
 * @brief [R[obN] V[N
 * @return G[R[h
 */
int32_t cbMPSSeekDone(void *param_gvd, void *param_user, gvdError error)
{
	((void)(param_gvd));
	((void)(error));

	mpsContext *ctx = (mpsContext *)param_user;
	volatile mpsAsyncFlag *f = &ctx->flag;
	f->bRewindDone = false;
	f->bDecDone= false;

	f->bSought = true;
	return 0;
}

/**
 * GVD߂R[obN֐<p>
 * MPSŔ񓯊֐̊҂Ɏgp
 * @brief [R[obN] V[N
 * @return G[R[h
 */
int32_t cbMPSRewindDone(void *param_gvd, void *param_user, gvdError error)
{
	((void)(param_gvd));
	((void)(error));

	mpsContext *ctx = (mpsContext *)param_user;
	volatile mpsAsyncFlag *f = &ctx->flag;
	f->bPaused = true;
	f->bRewindAccepted = false;

	f->bRewindDone = true;
	return 0;
}

