/**
 * @brief           USBH CDC ACM Header
 * @author          AXELL CORPORATION
 * @description     USBH CDC ACM Header
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __USB_CDC_ACM_H__
#define __USB_CDC_ACM_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_cdc_coreinclude.h"
#include "usb_cdc_type.h"
#include "usb_cdc_log.h"
#include "usb_cdc_api.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/
// Core mۂ郁TCYɂ蒲Kv
#define USB_CDC_MAX_BULK_TRANS_SIZE		(0x7fff)
// Interrupt IN Mf[^̃wb_TCY(Byte)
#define USB_CDC_INTIN_HEAD_SIZE			(8)
// Bulk IN vs̒~҂(ms)
#define	BULKIN_STOP_WAIT				(3)
#define	INTIN_STOP_WAIT					(3)

#define ID_CLSREQ_DET					(0)		// NXNGXgƐؒf ID
#define ID_API_DET						(1)		// NXNGXgȊOAPIƐؒf ID
/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/
/* Bulk IN Mf[^̕ʃXe[^X */
typedef enum {
    CDC_BULKIN_COPY_STAT_NON,			/* ʂȂ */
    CDC_BULKIN_COPY_STAT_1,				/* ʂP */
    CDC_BULKIN_COPY_STAT_2				/* ʂQ */
} CDC_BULKIN_COPY_STAT;

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern CDC_FUNC_STATUS Usbh_Cdc_CreateCdcDriver(usb_common_callback_t pUserAttachCallback, usb_common_callback_t pUserDetachCallback );
extern CDC_FUNC_STATUS Usbh_Cdc_DeleteCdcDriver(void);
extern CDC_FUNC_STATUS Usbh_Cdc_Acm_Initialize(void);
extern CDC_FUNC_STATUS Usbh_Cdc_Acm_Finalize(void);
extern CDC_FUNC_STATUS Usbh_Cdc_IssueIntInMsg(PCDC_DEVICE pCdcDevice);

extern CDC_FUNC_STATUS Usbh_Cdc_IssueSyncCtrlInOutMsg(CDC_PIPE *pPipe, CDC_DEVICE *pCdcDevice, usb_device_request_t *pSetupData, void *pDataBuf);
extern CDC_FUNC_STATUS Usbh_Cdc_IssueBulkINMsg(PCDC_DEVICE pCdcDevice);
extern CDC_FUNC_STATUS Usbh_Cdc_StopBulkINMsg(PCDC_DEVICE pCdcDevice);
extern CDC_FUNC_STATUS Usbh_Cdc_StopIntINMsg(PCDC_DEVICE pCdcDevice);
//extern CDC_FUNC_STATUS Usbh_Cdc_IssueSyncBulkOutMsg(PCDC_DEVICE pCdcDevice, PCDC_BUFF_INFO pstData, uhs_ubit32_t u32Timeout);
extern CDC_FUNC_STATUS Usbh_Cdc_IssueSyncBulkOutMsg(PCDC_DEVICE pCdcDevice, PCDC_BUFF_INFO pstData, kernel_context_t* pApiDetAccessLock, uhs_ubit32_t u32Timeout);

extern CDC_FUNC_STATUS Usbh_Cdc_ExeBulkInReadBuff(PCDC_DEVICE pCdcDevice, PCDC_BUFF_INFO pstData, uhs_ubit32_t* pu32RemainBuffSize);
extern uhs_status_t Usbh_Cdc_CheckDeviceStatus(void* pContext, PCDC_DEVICE* ret_pCdcDevice, uhs_ubit8_t* ret_u8CntDeviceId, uhs_ubit8_t u8TransType);
/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/
#ifdef USBH_STACK_DEBUG_BUILD
#define ACM_CDC_REPORT_SUMMARY(err) Usbh_Cdc_Log_ReportError( g_filename, __LINE__, (err), (uhs_ubit8_t*)"1", 0 )
#define ACM_CDC_REPORT_WARNING_SUMMARY(warning) Usbh_Cdc_Log_ReportWarning( g_filename, __LINE__, (warning), (uhs_ubit8_t*)"2", 0 )
#define ACM_CDC_REPORT_DETAIL(err, mesg, len) Usbh_Cdc_Log_ReportError( g_filename, __LINE__, (err), (mesg), (len) )
#define ACM_CDC_REPORT_MILESTONE(num) Usbh_Cdc_Log_ReportMilestone((num))
#else
#define ACM_CDC_REPORT_SUMMARY(err) Usbh_Cdc_Log_ReportDummy(err)
#define ACM_CDC_REPORT_WARNING_SUMMARY(warning) Usbh_Cdc_Log_ReportDummy(warning)
#define ACM_CDC_REPORT_DETAIL(err, mesg, len) Usbh_Cdc_Log_ReportDummy(err)
#define ACM_CDC_REPORT_MILESTONE(num) Usbh_Cdc_Log_ReportMilestone((num))
#endif

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/

#endif /* __USB_CDC_ACM_H__ */
