/** 
 * @brief           USBH HID Boot Header
 * @author          AXELL CORPORATION
 * @description     USBH HID Boot Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */


#ifndef __USB_HID_BOOT_H__
#define __USB_HID_BOOT_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_hid_coreinclude.h"
#include "usb_hid_type.h"
#include "usb_hid_log.h"
#include "usb_hid_api.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/
// Interrupt IN Mf[^̃wb_TCY(Byte)
#define USB_HID_INTIN_HEAD_SIZE			(8)

#define	INTIN_STOP_WAIT					(3)
#define ID_CLSREQ_DET					(0)		// NXNGXgƐؒf ID
#define ID_API_DET						(1)		// NXNGXgȊOAPIƐؒf ID
/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern HID_FUNC_STATUS Usbh_Hid_CreateHidDriver(usb_common_callback_t pUserAttachCallback, usb_common_callback_t pUserDetachCallback );
extern HID_FUNC_STATUS Usbh_Hid_DeleteHidDriver(void);
extern HID_FUNC_STATUS Usbh_Hid_Boot_Initialize(void);
extern HID_FUNC_STATUS Usbh_Hid_Boot_Finalize(void);
extern HID_FUNC_STATUS Usbh_Hid_IssueIntInMsg(PHID_DEVICE pHidDevice);
extern HID_FUNC_STATUS Usbh_Hid_StopIntINMsg(PHID_DEVICE pHidDevice);

extern HID_FUNC_STATUS Usbh_Hid_IssueSyncCtrlInOutMsg(HID_PIPE *pPipe, HID_DEVICE *pHidDevice, usb_device_request_t *pSetupData, void *pDataBuff);

extern uhs_status_t Usbh_Hid_CheckDeviceStatus(void* pContext, PHID_DEVICE* ret_pHidDevice, uhs_ubit8_t* ret_u8CntDeviceId, uhs_ubit8_t u8TransType);
/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/
#ifdef USBH_STACK_DEBUG_BUILD
#define BOOT_HID_REPORT_SUMMARY(err) Usbh_Hid_Log_ReportError( g_filename, __LINE__, (err), (uhs_ubit8_t*)"1", 0 )
#define BOOT_HID_REPORT_WARNING_SUMMARY(warning) Usbh_Hid_Log_ReportWarning( g_filename, __LINE__, (warning), (uhs_ubit8_t*)"2", 0 )
#define BOOT_HID_REPORT_DETAIL(err, mesg, len) Usbh_Hid_Log_ReportError( g_filename, __LINE__, (err), (mesg), (len) )
#define BOOT_HID_REPORT_MILESTONE(num) Usbh_Hid_Log_ReportMilestone((num))
#else
#define BOOT_HID_REPORT_SUMMARY(err) Usbh_Hid_Log_ReportDummy(err)
#define BOOT_HID_REPORT_WARNING_SUMMARY(warning) Usbh_Hid_Log_ReportDummy(warning)
#define BOOT_HID_REPORT_DETAIL(err, mesg, len) Usbh_Hid_Log_ReportDummy(err)
#define BOOT_HID_REPORT_MILESTONE(num) Usbh_Hid_Log_ReportMilestone((num))
#endif

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/

#endif /* __USB_HID_BOOT_H__ */
