/** 
 * @brief           Human Interface Devices Class Driver API Header
 * @author          AXELL CORPORATION
 * @description     Human Interface Devices Class Driver񋟃wb_
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
#ifndef __USB_HID_CLASS_API_H__
#define __USB_HID_CLASS_API_H__
/* DOM-IGNORE-END */

#include "usb_hid_type.h"
#include "usb_hid_log.h"

/** HID hCoFW[o[W */
#define	HID_MAJOR_VERSION		(0x01)

/** HID hCoF}Ci[o[W */
#define	HID_MINOR_VERSION		(0x00)

/** HIDfBXNv^ */
#define USB_DESC_TYPE_HID		(0x21U)

/** |[gfBXNv^ */
#define USB_DESC_TYPE_REPORT	(0x22U)

/** |[g^Cv */
typedef enum {
	REPORT_TYPE_INPUT = 1,		/** Input|[g */
	REPORT_TYPE_OUTPUT,			/** Output|[g */
	REPORT_TYPE_FEATURE			/** Feature|[g */
} REPORT_TYPE_SELECTOR;


typedef struct HidDescInfo* PHID_DESC_INFO;	/** fBXNv^i[obt@^ւ̃|C^ */
typedef struct HidReportInfo* PHID_REPORT_INFO;	/** |[g^ւ̃|C^ */
typedef struct HidProtocol* PHID_PROTOCOL;	/** vgR^ւ̃|C^ */
typedef struct HidIdle* PHID_IDLE;	/** AChԏ^ւ̃|C^ */

/** HIDNXŗLfBXNv^<p>
    HIDNXŗLfBXNv^̏ڍׂɂẮAuDevice Class Definition for Human Interface Devices (HID) 
    Firmware SpecificationvQƂĉB<p>
    obt@͑ΏۃfBXNv^i[oTCYȏ̑傫̂̂LbV̈擾A
    AvP[VpӂĉB<p>
    ܂A{VXełBootvgR݂̂z肵Ă邽߁A{\̂ɂHIDfBXNv^A
    |[gfBXNv^̂݊i[܂B<p>
    ^C~O F HIDNXŗLfBXNv^擾O<p>
    폜^C~O F HIDNXŗLfBXNv^擾 */
typedef struct HidDescInfo {
	uhs_ubit16_t		u16Length;	/** 擾fBXNv^ */
    uhs_ubit8_t*		pu8Buff;	/** obt@̃|C^(LbV̈) */
} HID_DESC_INFO;

/** GetReportŎ擾郌|[g<p>
    obt@́A|[gi[oTCYȏ̑傫̂̂AvP[VpӂĉB<p>
    |[gID́A{VXełBootvgR݂̂z肵Ă邽߁Aʏ0z肵Ă܂B<p>
    ^C~O F GetReportɂ郌|[g擾O<p>
    폜^C~O F GetReportɂ郌|[g擾 */
typedef struct HidReportInfo {
	REPORT_TYPE_SELECTOR ReportTypeSelector; /** |[g^CvI */
	uhs_ubit8_t			u8Id;		/** |[gID */
	uhs_ubit16_t		u16Length;	/** |[g */
	uhs_ubit8_t*		pu8Buff;	/** f[^i[obt@̃|C^ */
} HID_REPORT_INFO;

/** vgRݒ<p>
    ݒ肷f[^̏ڍׂɂẮAuDevice Class Definition for Human Interface Devices (HID) 
    Firmware SpecificationvQƂĉB<p>
    ^C~O F vgRݒ擾EݒO<p>
    폜^C~O F vgRݒ擾Eݒ */
typedef struct HidProtocol {
	uhs_ubit8_t			u8Data;		/** vgRݒf[^ */
} HID_PROTOCOL;

/** |[gpx<p>
    Ԃ0ƂƁAfoCX̓f[^ωƂ̂݃|[gʒms܂B<p>
    |[gID́A{VXełBootvgR݂̂z肵Ă邽߁Aʏ0z肵Ă܂B<p>
    0̏ꍇ́AׂĂInput|[gɓKp܂B<p>
    ^C~O F |[gpxݒO<p>
    폜^C~O F |[gpxݒ */
typedef struct HidIdle {
	uhs_ubit8_t			u8Id;		/** |[gID */
	uhs_ubit8_t			u8Duration;	/** ԁi|[gԂ̍ő厞ԊԊujB4msecPʁB */
} HID_IDLE;


extern uhs_status_t Usbh_Hid_GetVersion(uhs_ubit8_t*  pu8MajorVersion, uhs_ubit8_t*  pu8MinorVersion);
extern uhs_status_t Usbh_Hid_RegistCallBack(void* pContext, hid_callback_t pUserNotifyCallback);
extern uhs_status_t Usbh_Hid_GetHIDDescriptor(void* pContext, PHID_DESC_INFO pstData);
extern uhs_status_t Usbh_Hid_GetReportDescriptor(void* pContext, PHID_DESC_INFO pstData);
extern uhs_status_t Usbh_Hid_GetReport(void* pContext, PHID_REPORT_INFO pstData);
extern uhs_status_t Usbh_Hid_GetProtocol(void* pContext, PHID_PROTOCOL pstData);
extern uhs_status_t Usbh_Hid_SetIdle(void* pContext, PHID_IDLE pstData);
extern uhs_status_t Usbh_Hid_SetProtocol(void* pContext, PHID_PROTOCOL pstData);
extern uhs_status_t Usbh_Hid_RestartIntIN(void* pContext);
extern uhs_status_t Usbh_Hid_StopIntIN(void* pContext);
/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/
#ifdef USBH_STACK_DEBUG_BUILD
#define CIAPI_HID_REPORT_SUMMARY(err) Usbh_Hid_Log_ReportError( g_filename, __LINE__, (err), (uhs_ubit8_t*)"1", 0 )
#define CIAPI_HID_REPORT_DETAIL(err, mesg, len) Usbh_Hid_Log_ReportError( g_filename, __LINE__, (err), (mesg), (len) )
#define CIAPI_HID_REPORT_MILESTONE(num) Usbh_Hid_Log_ReportMilestone((num))
#else
#define CIAPI_HID_REPORT_SUMMARY(err) Usbh_Hid_Log_ReportDummy(err)
#define CIAPI_HID_REPORT_DETAIL(err, mesg, len) Usbh_Hid_Log_ReportDummy(err)
#define CIAPI_HID_REPORT_MILESTONE(num) Usbh_Hid_Log_ReportMilestone((num))
#endif

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/

#endif /* __USB_HID_CLASS_API_H__ */
