/** 
 * @brief           USBH HID Type Header
 * @author          AXELL CORPORATION
 * @description	    USBH HID Type Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */


#ifndef __USB_HID_TYPE_H__
#define __USB_HID_TYPE_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_hid_coreinclude.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/
/** HIDfoCXڑ\Ȑ */
#define HID_SUPPORT_DEVICE_NUM	USBH_MAX_CLS_HID_NUM

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/
/* ========================================================================= */
/* HIDfoCX̏ */
/* ========================================================================= */
typedef enum {
    HID_DEVICE_STAT_CONNECTING,						/* foCXڑ */
    HID_DEVICE_STAT_REGIST,							/* foCXo^ */
    HID_DEVICE_STAT_NO_SUPPORT,						/* gps(Ή)foCX */
    HID_DEVICE_STAT_CLOSE,							/* N[Y */
    HID_DEVICE_STAT_OPEN							/* I[v */
} HID_DEVICE_STAT;

/* ========================================================================= */
/* ֐̖߂l */
/* ========================================================================= */
typedef enum {
	HID_FUNC_STATUS_SUCCESS,						/*  */
	HID_FUNC_STATUS_BASE = 0x200,					/* G[R[h̊l */
	HID_FUNC_STATUS_HALT_PIPE						/* PipeHALTĂ */,
	HID_FUNC_STATUS_NOT_INIT,						/* hCo */
	HID_FUNC_STATUS_NO_DEVICE,						/* foCXڑ */
	HID_FUNC_STATUS_NOT_USE,						/* foCX */
    HID_FUNC_STATUS_FAILED_BOOT_INIT,				/* Boot Protocol w̏Ɏs */
    HID_FUNC_STATUS_FAILED_BOOT_EXIT,				/* Boot Protocol w̏IɎs */
    HID_FUNC_STATUS_FAILED_CRE_HIDD,				/* HIDClassDriver̍쐬Ɏs */
    HID_FUNC_STATUS_FAILED_DEL_HIDD,				/* HIDClassDriver̍폜Ɏs */
    HID_FUNC_STATUS_FAILED_CTRL,					/* Rg[]Ɏs */
    HID_FUNC_STATUS_FAILED_INTERRUPT,				/* C^[vg]Ɏs */
    HID_FUNC_STATUS_FAILED_STDREQ,					/* WNGXgɎs */
    HID_FUNC_STATUS_FAILED_CLSREQ,					/* NXNGXgɎs */
	HID_FUNC_STATUS_FAILED_CRE_HDD,					/* HIDDevice̍쐬Ɏs */
	HID_FUNC_STATUS_FAILED_ADD_HDD,					/* HIDDevice̒ǉɎs */
    HID_FUNC_STATUS_FAILED_REMOVE_HDD,				/* HIDDevice̊JɎs */
	HID_FUNC_STATUS_FAILED_CRE_CPIPE,				/* ControlPIPE̍쐬Ɏs */
	HID_FUNC_STATUS_FAILED_OPEN_CPIPE,				/* ControlPIPEOpenɎs */
	HID_FUNC_STATUS_FAILED_CRE_IPIPE,				/* InterruptPIPE̍쐬Ɏs */
	HID_FUNC_STATUS_FAILED_OPEN_IPIPE,				/* InterruptPIPEOpenɎs */
    HID_FUNC_STATUS_INTERNAL_FAILED_CORE,			/* RAG[񍐂ꂽ */
    HID_FUNC_STATUS_INTERNAL_FAILED_HID,			/* hCoG[ */
    HID_FUNC_STATUS_SYS_SYSTEM_ERROR,				/* VXeG[ */
    HID_FUNC_STATUS_SYS_OUT_OF_RESOURCE,			/* VXe\[X(Z}tHAtOA)̃ANZXŃG[ */
    HID_FUNC_STATUS_SYS_PARAM_ERROR					/* p[^wɌ肪 */
} HID_FUNC_STATUS;

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/
/* ========================================================================= */
/* {^ւ̃|C^^ */
/* ========================================================================= */

/** [UAvP[Vwւ̒ʒmւ̃|C^ */
typedef struct HidNotifyInfo* PHID_NOTIFY_INFO;
/** HIDNXhCoւ̃|C^ */
typedef struct HidDriver* PHID_DRIVER;
/** HIDւ̃|C^ */
typedef struct HidDevice* PHID_DEVICE;
/** HIDpCvւ̃|C^ */
typedef struct HidPipe* PHID_PIPE;
/** HID Interrupt IN pMobt@ւ̃|C^ */
typedef struct HidIntInBuff* PHID_INTIN_BUFF;

/** [UAvP[Vw ʒm Callback ֐^` */
typedef void (*hid_callback_t)( PHID_NOTIFY_INFO pNotifyInfo, uhs_status_t RetVal );

/** [UAvP[Vwւ̒ʒmi|[gjێf[^^<p>
    R[obNʒm֐ŕKMf[^ĉB<p>
    R[obNʒm֐ŁA̒API֐̌Ăяo֎~܂B<p>
    ^C~O F [UAvP[Vւ̒ʒmO<p>
    폜^C~O F [UAvP[Vւ̒ʒm */
typedef struct HidNotifyInfo {
    void*				pContext;		/** foCXʎq */
    uhs_ubit32_t		u32Length;		/** f[^̃OX */
    uhs_ubit8_t*		pu8Buff;		/** obt@̃|C^ */
} HID_NOTIFY_INFO;

/* ========================================================================= */
/* HIDfoCXNXhCo ^̒` */
/* ========================================================================= */
typedef struct HidDriver {
    /* -- vpeB\o[ ----------------------------------------- */
    usb_common_callback_t			pUserAttachCallback;									/* [UAvP[Vw Attach Callback ֐ */
    usb_common_callback_t			pUserDetachCallback;									/* [UAvP[Vw Detach Callback ֐ */
    struct class_driver_reginfo*	pDrvRegInfo;											/* Core o^pe[ũobt@ */
    PHID_DEVICE						pHidDeviceHead;											/* {hCoǗfoCX̃Xg */
    kernel_context_t				oApiDetAccessLockObj[HID_SUPPORT_DEVICE_NUM];			/* API֐DetachpbNIuWFNg̎ */
    kernel_context_t*				pApiDetAccessLock[HID_SUPPORT_DEVICE_NUM];				/* API֐DetachpANZXbNւ̃|C^ */
    kernel_context_t				oClsReqDetAccessLockObj[HID_SUPPORT_DEVICE_NUM];		/* Class Request API֐DetachpbNIuWFNg̎ */
    kernel_context_t*				pClsReqDetAccessLock[HID_SUPPORT_DEVICE_NUM];			/* Class Request API֐DetachpANZXbNւ̃|C^ */
    kernel_context_t				oIntINDoneDetAccessLockObj[HID_SUPPORT_DEVICE_NUM];		/* Int IN ]R[obNDetachpbNIuWFNg̎ */
    kernel_context_t*				pIntINDoneDetBuffAccessLock[HID_SUPPORT_DEVICE_NUM];	/* Int IN ]R[obNDetachpANZXbNւ̃|C^ */
	PHID_DEVICE						pDeviceID[HID_SUPPORT_DEVICE_NUM];						/* ֐Ɛؒf̃Z}tHp foCXID */
} HID_DRIVER;

/* ========================================================================= */
/* HIDfBXNv^^̒` */
/* ========================================================================= */
typedef struct hid_descriptor {      // __st__
    uhs_ubit8_t data[9];
} HID_DESCRIPTOR;

/* ========================================================================= */
/* HIDfoCX ^̒` */
/* ========================================================================= */
typedef struct HidDevice {
    /* -- vpeB\o[ ----------------------------------------- */
    struct usbd_usb_deviceinfo*	pUsbCore_Dev;				/* USB Core ێfoCX */
    PHID_PIPE					pCtrlPipe_I;				/* {foCX Default Ctrl In Pipe */
    PHID_PIPE					pCtrlPipe_O;				/* {foCX Default Ctrl Out Pipe */
    PHID_PIPE					pIntInPipe;					/* {foCX Interrupt In Pipe */
    PHID_INTIN_BUFF				pIntInBuff;					/* Interrupt IN ]pMobt@ */
    HID_DEVICE_STAT				nDeviceStat;				/* foCX̏ */
    hid_callback_t				pUserNotifyCallback;		/* [UAvP[Vw ʒm Callback ֐ */
    uhs_ubit16_t				u16Intf_num;				/* C^tF[Xԍ */
    /* -- ̂߂̃o[ --------------------------------------------- */
    kernel_context_t			oHidExecuteLockObj;			/* HIDNXpbNIuWFNg̎(Control]IN/OUTɎgp) */
    kernel_context_t*			pHidExecuteLock;			/* HIDNXpsbNւ̃|C^ */
    kernel_context_t			oIntInExecuteLockObj;		/* C^vg]pbNIuWFNg̎(Interrupt]INɎgp) */
    kernel_context_t*			pIntInExecuteLock;			/* C^vg]psbNւ̃|C^ */
    kernel_context_t			oRegistExecuteLockObj;		/* R[obNo^pbNIuWFNg̎(Usbh_Hid_RegistCallBack API Ɏgp) */
    kernel_context_t*			pRegistExecuteLock;			/* R[obNo^psbNւ̃|C^ */
    /* -- \\o[ ----------------------------------------------- */
    PHID_DEVICE					pNext;						/* HIDfoCX */
    PHID_DRIVER					pParent;					/* {HIDfoCXǗehCo */
    uhs_boolean_t				(*Delete)(PHID_DEVICE);		/* foCX̍폜֐ */
    HID_DESCRIPTOR				hid_desc;					/* HIDfBXNv^ */
} HID_DEVICE;

/* ========================================================================= */
/* HIDfoCXpCv ^̒` */
/* ========================================================================= */
typedef struct HidPipe {
    /* -- vpeB\o[ ----------------------------------------- */
    uhs_ubit32_t				u32PipeInfo;			/* { Pipe  Core \LbV */
    struct usb_control_block*	pUcb;					/* { Pipe gp UCB  */
    struct usb_control_block*	pClearFeature;		    /* { Pipe gp CearFeaturep UCB  */  
    uhs_boolean_t				bIsOpen;				/* I[v */
    uhs_ubit32_t				u32MaxPacketSize;		/* { Pipe  MAX PACKET SIZE */
    uhs_ubit8_t					u8Interval;				/* { Pipe  Interval */
	uhs_ubit8_t					dummy1;
	uhs_ubit16_t				dummy2;
    uhs_sbit32_t				s32Cnt_Transfering;		/* ]JE^ */
    kernel_context_t*			oReq_Done;				/* ]CxgpIuWFNg(CtrlɎgp)ւ̃|C^ */
    /* -- \\o[ ----------------------------------------------- */
    struct usbd_usb_deviceinfo*	pParentDev;				/* { Pipe efoCX */
} HID_PIPE;

/* ========================================================================= */
/* HIDfoCX Interrupt IN pMobt@ ^̒` */
/* ========================================================================= */
typedef struct HidIntInBuff {
    uhs_ubit8_t*				pu8StartBuff;			/* Mobt@̐擪|C^ */
    uhs_ubit8_t					u8WritePos;				/* Mobt@̃Cgʒu */
    uhs_ubit8_t*				pu8TempBuff;			/* e|Bobt@̐擪|C^ */
    uhs_ubit8_t					u8ReceiveSize;			/* MTCY */
    uhs_boolean_t				isIntINUserFlag;		/* [Uw Bulk IN ]ԃtO */
} HID_INTIN_BUFF;

#endif  /* __USB_HID_TYPE_H__ */

