/** 
 * @brief           UHS config top Header
 * @author          AXELL CORPORATION
 * @description     Top level USB HOST Stack Config
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
 * @history         2020_07_22  [SDK3.1] usbh̃eXgp`폜 (#2997)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2020 AXELL CORPORATION, all rights reserved.
 */



#ifndef		__UHS_CONFIGTOP_H__
#define		__UHS_CONFIGTOP_H__
/* DOM-IGNORE-END */

#include	"depend_cfg.h"

//------------------------------------------------------------------------------
//	fobOLBuild
//------------------------------------------------------------------------------
#if ( USBH_CFG_DEBUG == YES)
	#define		USBH_STACK_DEBUG_BUILD											//	STATUS MONITORʒm(L/)
#endif


//------------------------------------------------------------------------------
//	ȉA[JDebugp}N`
//------------------------------------------------------------------------------
//#define		USBH_DBG_ADD_MESSAGE											//	ǉLogMessageL
//#define		USBH_MEM_LEAK_CHK												//	mem leak chk
#ifdef		USBH_MEM_LEAK_CHK												//	mem leak chk
//	#define		USBH_MEM_LEAK_CHK_ADDINFO										//	mem leak chk ǉ(file name , line num)
#endif
//#define		USBH_OS_RES_COUNT												//	os res cnt
//#define		USBH_OS_STACK_CHK												//	os stack cnt	(DummyStack ReleaseȂ̂Œ)
//#define		USBH_EHCI_MEM_LEAK_CHK
//#define		USBH_OS_RES_DISP												//	enable os resource manager log display
//#define		USBH_COMMON_DISP_MESSID											//	Display Recive Message ID

//#define		USBH_DBG_HUB_OVERCURRENT										//	`ɋ[IHUBŜ̃I[o[JgR[hB(1shot)
//#define		USBH_DBG_HUBPORT_OVERCURRENT									//	`ɋ[IHUB|[g̃I[o[JgR[hB(1shot)
//#define		USBH_DBG_SPLITERR												//	`ɋ[ISPLITG[B(1shot)


// *************************************************************************************************
//
//	IɁÂ܂܎gp鍀
//
// *************************************************************************************************
//------------------------------------------------------------------------------
//	őڑfoCX
//------------------------------------------------------------------------------
#define		USBH_MAX_CLS_ROOTHUB_NUM	(1)										//	[gHUBőڑ(ύXs)
#define		USBH_MAX_CLS_HUB_NUM		(2)										//	ėpHUBőڑ
#define		USBH_MAX_CLS_HID_NUM		(2)										//	HIDőڑ
#define		USBH_MAX_CLS_MSC_NUM		(2)										//	MSCDőڑ
#define		USBH_MAX_CLS_CDC_NUM		(2)										//	CDCDőڑ

//------------------------------------------------------------------------------
//	g[^ł̃T|[gfoCXi[gHUBx1܂ށj
//		ˊeNXhCoMAX䐔̍v
//------------------------------------------------------------------------------
#define		USBH_MAX_SUPPORT_DEVNUM		(	USBH_MAX_CLS_ROOTHUB_NUM + \
											USBH_MAX_CLS_HUB_NUM + \
											USBH_MAX_CLS_HID_NUM + \
											USBH_MAX_CLS_MSC_NUM + \
											USBH_MAX_CLS_CDC_NUM	)

//------------------------------------------------------------------------------
//	USBIRQԍ	(ύXs)
//------------------------------------------------------------------------------
#define		USBH_USBIRQ_NUM				(50)

//------------------------------------------------------------------------------
//	SYSTEM擾LbVԃTCY
//------------------------------------------------------------------------------
#define		USBH_APIWRAPP_MPL_SIZE		(0x40000)								//	API_WRAPPȏp̃ԗpTCY
#define		USBH_USBCORE_MPL_SIZE		(0x40000)								//	USB_COREȉp̃ԗpTCY

//-----------------------------------------------------------------------------
//	TASK-ID Ĕ͈
//-----------------------------------------------------------------------------
#define		USBH_RSC_NUM_TSK_ID			8										//	Č
#define		USBH_RSC_MAX_TSK_ID			(USBH_RSC_MIN_TSK_ID + USBH_RSC_NUM_TSK_ID -1)

//-----------------------------------------------------------------------------
//	MAIL_BOX-ID Ĕ͈
//-----------------------------------------------------------------------------
#define		USBH_RSC_NUM_MBOX_ID		16										//	Č
#define		USBH_RSC_MAX_MBOX_ID		(USBH_RSC_MIN_MBOX_ID + USBH_RSC_NUM_MBOX_ID -1)

//-----------------------------------------------------------------------------
//	SEM-ID Ĕ͈
//-----------------------------------------------------------------------------
#define		USBH_RSC_NUM_SEM_ID			28										//	Č
#define		USBH_RSC_MIN_SEM_ID			(USBH_RSC_SEM_ID + 1)					//	Đ擪IDԍ(Z}tĤ݁A}l[WpɂPp)
#define		USBH_RSC_MAX_SEM_ID			(USBH_RSC_MIN_SEM_ID + USBH_RSC_NUM_SEM_ID -1)

//-----------------------------------------------------------------------------
//	EVENT_FLG-ID Ĕ͈
//-----------------------------------------------------------------------------
#define		USBH_RSC_NUM_EVFLG_ID		8										//	Č
#define		USBH_RSC_MAX_EVFLG_ID		(USBH_RSC_MIN_EVFLG_ID + USBH_RSC_NUM_EVFLG_ID -1)

//-----------------------------------------------------------------------------
//	CYC_HANDL-ID Ĕ͈
//-----------------------------------------------------------------------------
#define		USBH_RSC_NUM_CYC_ID			1										//	Č	(ύXs)
#define		USBH_RSC_MAX_CYC_ID			(USBH_RSC_MIN_CYC_ID + USBH_RSC_NUM_CYC_ID -1)

//-----------------------------------------------------------------------------
//	DTQ-ID Ĕ͈
//-----------------------------------------------------------------------------
#define		USBH_RSC_NUM_DTQ_ID			1										//	Č	(ύXs)
#define		USBH_RSC_MAX_DTQ_ID			(USBH_RSC_MIN_DTQ_ID + USBH_RSC_NUM_DTQ_ID -1)

//-----------------------------------------------------------------------------
//	MEMPOOL-ID Ĕ͈
//-----------------------------------------------------------------------------
#define		USBH_RSC_NUM_MPL_ID			2										//	Č	(ύXs)
#define		USBH_RSC_MAX_MPL_ID			(USBH_RSC_MIN_MPL_ID + USBH_RSC_NUM_MPL_ID -1)



//-----------------------------------------------------------------------------
//	Predeined Macro	(C89Œ`ς݂Au\ɂB)
//-----------------------------------------------------------------------------
#define		__FILENAME__				__FILE__								//	t@C
#define		__LINENUM__					__LINE__								//	sԍ

//------------------------------------------------------------------------------
//	BIT Filed zu												[ r` ]
//------------------------------------------------------------------------------
#define	USBH_BITFIELD_LSB														//	LSB l߂
//#define	USBH_BITFIELD_MSB													//	MSB l߂


//------------------------------------------------------------------------------
//	EHCI TESTWX^ANZX֐̗L
//------------------------------------------------------------------------------
//#define		USBH_EHCI_TESTFUNC_ENABLE

// *************************************************************************************************
//
//	[Uɍ킹āAvJX^}CY
//
// *************************************************************************************************
//------------------------------------------------------------------------------
//	USB݃nh̊݃x
//------------------------------------------------------------------------------
#define		USBH_USBIRQ_INTLVL			(4)										//	

//------------------------------------------------------------------------------
//	LbVԐ擪AhX
//------------------------------------------------------------------------------
#define		USBH_NONCACHE_MEM_TOP_WRAPP		(0x83E10000)
#define		USBH_NONCACHE_MEM_TOP_CORE		(USBH_NONCACHE_MEM_TOP_WRAPP + USBH_APIWRAPP_MPL_SIZE)

//-----------------------------------------------------------------------------
//	USB HOST \[XID}l[WANZX gpJn\[XIDԍ̒`
//-----------------------------------------------------------------------------
#define		USBH_RSC_SEM_ID				(1)									//	rpSEM IDî݌Œlwj
#define		USBH_RSC_MIN_TSK_ID			(1)									//	TSK-IDĐ擪IDԍ
#define		USBH_RSC_MIN_MBOX_ID		(1)									//	MAIL_BOX-IDĐ擪IDԍ
#define		USBH_RSC_MIN_EVFLG_ID		(1)									//	EVENT_FLG-IDĐ擪IDԍ
#define		USBH_RSC_MIN_CYC_ID			(1)									//	CYC_HNDL-IDĐ擪IDԍ
#define		USBH_RSC_MIN_DTQ_ID			(1)									//	DATA_QUE-IDĐ擪IDԍ
#define		USBH_RSC_MIN_MPL_ID			(1)									//	MEMPOOL-IDĐ擪IDԍ

//-----------------------------------------------------------------------------
//	USB HOST STACK ^XND揇ʁi֘AThread̗͂D揇ʁ{Őݒ肳j
//-----------------------------------------------------------------------------
#define		USBH_TASK_PRI_BASE			(5)										//	USB HOST X^bNpDxx[X

//------------------------------------------------------------------------------
//	RESUMEsɎԐ̃K[h`(RESUME=OFF ==> RUN3msȓɎs)
//	Z~R֐`Lډ\B
//------------------------------------------------------------------------------
//	RESUMEDISPATCH֎~̊Jn֐
#define		USBH_START_RESUME_CRITICAL_PATH				

//	RESUMEDISPATCH֎~̏I֐
#define		USBH_END_RESUME_CRITICAL_PATH				


//------------------------------------------------------------------------------
//	SUSPEND/RESUMEPHYL(`)
//------------------------------------------------------------------------------
#define		USBH_SUSPEND_PHY_CTRL_ENABLE


#endif	//	__UHS_CONFIGTOP_H__
