/**
 * @brief       WDT Primitive
 * @author      AXELL CORPORATION
 * @description WDT Primitive Layer
 * @note        none
 * @history     2017_02_22  
 * @history     2017_10_26  Ver2.0
 * @history     2019_03_08  [SDK2.2] WDT̃WX^l擾֐ǉ (#2474)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_errno.h"
#include "AG903_common.h"
#include "wdt/wdtprm.h"
#include "register/AG903_wdtreg.h"

#define	AG903_WDT_READ_REG(REG)			((AG903_WDT)->REG)
#define	AG903_WDT_WRITE_REG(REG,VAL)	((AG903_WDT)->REG  = (uint32_t)(VAL))
#define	AG903_WDT_SET_REG(REG,VAL)		((AG903_WDT)->REG |= (uint32_t)(VAL))
#define	AG903_WDT_CLR_REG(REG,VAL)		((AG903_WDT)->REG &= (uint32_t)(~VAL))

#define AG903_WDT_PASSWORD		(0x5AB9)

/**
 * @brief           WDTWdCounter̃WX^Read
 * @param           cnt [out] JE^l
 * @return          void
 * @description     WDTWdCounter̃WX^Read
*/
void AG903_WDTPrmGetCount(uint32_t* cnt)
{
	ASSERT(NULL != cnt);
	
	(*cnt) = AG903_WDT_READ_REG(WdCounter);
}

/**
 * @brief           WDTWdLoad̃WX^Write
 * @param           cnt [in] JE^l
 * @return          void
 * @description     WDTWdLoad̃WX^Write
*/
void AG903_WDTPrmSetCount(uint32_t cnt)
{
	AG903_WDT_WRITE_REG(WdLoad, cnt);
}

/**
 * @brief           WDTWdLoad̃WX^Read
 * @param           cnt [out] JE^l
 * @return          void
 * @description     WDTWdLoad̃WX^Read
*/
void AG903_WDTPrmGetLoad(uint32_t *load)
{
	ASSERT(NULL != load);

	(*load) = AG903_WDT_READ_REG(WdLoad);
}

/**
 * @brief           WDTWdRestart̃WX^Write
 * @param           none
 * @return          void
 * @description     WDTWdRestart̃WX^Write
*/
void AG903_WDTPrmRestartCount(void)
{
	AG903_WDT_WRITE_REG(WdRestart, AG903_WDT_PASSWORD);
}

/**
 * @brief           WDTWdCR̃WX^Write
 * @param           rst [in] system reset
 * @param           intr [in] system interrupt
 * @param           ext [in] external signal
 * @return          void
 * @description     WDTWdCR̃WX^Write<p>
 *                  rst , intr , ext  true=Enable , false=Disable łB
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_WDTPrmSetControl(_Bool rst, _Bool intr, _Bool ext)
{
	uint32_t set=0;
	uint32_t clr=0;
	
	if(true == rst) {
		set |= (1<<AG903_WDT_WdCR_WdRst_POS);
	}
	if(true == intr) {
		set |= (1<<AG903_WDT_WdCR_WdIntr_POS);
	}
	if(true == ext) {
		set |= (1<<AG903_WDT_WdCR_WdExt_POS);
	}
	clr  = ~set & (AG903_WDT_WdCR_WdRst_MSK|AG903_WDT_WdCR_WdIntr_MSK|AG903_WDT_WdCR_WdExt_POS);
	clr |= (1<<AG903_WDT_WdCR_WdClock_POS);	/* PCLKw */

	AG903_WDT_CLR_REG(WdCR, clr);
	AG903_WDT_SET_REG(WdCR, set);
}

/**
 * @brief           WDTWdCR̃WX^Read
 * @param           rst [out] system reset
 * @param           intr [out] system interrupt
 * @param           ext [out] external signal
 * @return          void
 * @description     WDTWdCR̃WX^Read<p>
 *                  rst , intr , ext  true=Enable , false=Disable łB
*/
void AG903_WDTPrmGetControl(_Bool *rst, _Bool *intr, _Bool *ext)
{
	uint32_t cr=0;
	ASSERT(NULL != rst);
	ASSERT(NULL != intr);
	ASSERT(NULL != ext);

	cr = AG903_WDT_READ_REG(WdCR);
	if (cr & (1<<AG903_WDT_WdCR_WdRst_POS)) {
		(*rst) = true;
	} else {
		(*rst) = false;
	}
	if (cr & (1<<AG903_WDT_WdCR_WdIntr_POS)) {
		(*intr) = true;
	} else {
		(*intr) = false;
	}
	if (cr & (1<<AG903_WDT_WdCR_WdExt_POS)) {
		(*ext) = true;
	} else {
		(*ext) = false;
	}
}

/**
 * @brief           WDTWdCRWX^WdEnablerbgSet
 * @param           none
 * @return          void
 * @description     WDTWdCRWX^WdEnablerbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_WDTPrmEnableCount(void)
{
	AG903_WDT_SET_REG(WdCR, (1<<AG903_WDT_WdCR_WdEnable_POS));
}

/**
 * @brief           WDTWdCRWX^WdEnablerbgClear
 * @param           none
 * @return          void
 * @description     WDTWdCRWX^WdEnablerbgClear
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_WDTPrmDisableCount(void)
{
	AG903_WDT_CLR_REG(WdCR, (1<<AG903_WDT_WdCR_WdEnable_POS));
}

/**
 * @brief           WDTWdStatus̃WX^Read
 * @param           status [out] Xe[^X
 * @return          void
 * @description     WDTWdStatus̃WX^Read
*/
void AG903_WDTPrmGetStatus(uint32_t* status)
{
	ASSERT(NULL != status);
	
	(*status) = AG903_WDT_READ_REG(WdStatus);
}

/**
 * @brief           WDTWdClear̃WX^Write
 * @param           none
 * @return          void
 * @description     WDTWdClear̃WX^Write
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_WDTPrmClearStatus(void)
{
	AG903_WDT_SET_REG(WdClear, (1<<AG903_WDT_WdClear_WdClear_POS));
}

/**
 * @brief           WDTWdIntrleñWX^Write
 * @param           intrlen [in] wd_rstAT[g [clk]
 * @return          void
 * @description     WDTWdIntrleñWX^Write
*/
void AG903_WDTPrmSetIntrlen(uint8_t intrlen)
{
	AG903_WDT_WRITE_REG(WdIntrlen, intrlen);
}

/**
 * @brief           WDTWdIntrleñWX^Read
 * @param           intrlen [out] wd_rstAT[g [clk]
 * @return          void
 * @description     WDTWdIntrleñWX^Read
*/
void AG903_WDTPrmGetIntrlen(uint8_t *intrlen)
{
	ASSERT(NULL != intrlen);
	(*intrlen) = AG903_WDT_READ_REG(WdIntrlen);
}

/**
 * @brief           WDTWdRevisioñWX^Read
 * @param           revision [out] revisionԍ
 * @return          void
 * @description     WDTWdRevisioñWX^Read
*/
void AG903_WDTPrmGetRevision(uint8_t *revision)
{
	ASSERT(NULL != revision);
	(*revision) = AG903_WDT_READ_REG(WdRevision);
}
