/** 
 * @brief           USB HOST Stack Config Header
 * @author          AXELL CORPORATION
 * @description     USB HOST Stack Config  [ Internal ]
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */



#ifndef __UHS_CONFIG_H__
#define __UHS_CONFIG_H__


// *************************************************************************************************
//	include
// *************************************************************************************************
#include	"uhs_configtop.h"													//	top level usb host stack configuration file
#include	"uhs_type.h"
#include	"open_usbdi.h"
#include	"wrapper_kernel.h"
#include	"uhs_list.h"
#include	"uhs_stdlib.h"														//	for USB HOST Standard Lib (ex. memcpy...)
#include	"kernel_itron4.h"
#include	"usbh_errormon.h"
#include	"debug.h"															//	for Debug function
#include	"AG903_regmap.h"

// *************************************************************************************************
//	define
// *************************************************************************************************
//	USB HOST IPʂ̒`
#define		AG903_USB_IP														//	AG903 USB IPgp`

#ifndef __USBC_MAIN_C__
	extern unsigned char interrupt_counter;
#endif

#define in_interrupt()  interrupt_counter										//intr_count


//------------------------------------------------------------------------------
//	T|[gDriver
//------------------------------------------------------------------------------
#define USB_HCD_SUPPORT					(1)										//	HCD support
#define SUPPORT_HCDEHCI					(1)										//	EHCI support

//------------------------------------------------------------------------------
// hCoŔFUSBfoCX̃RtBO[V
//------------------------------------------------------------------------------
#define USB_MAX_CONFIG_NUM              (10)

//------------------------------------------------------------------------------
// ucb ̍ŏ^CAEgl
//------------------------------------------------------------------------------
#define USB_MIN_TIMEOUT                 (10)

//------------------------------------------------------------------------------
// ftHgpCvőpPbgTCY
//------------------------------------------------------------------------------
#define USB_REQ_MAX_LENGTH              (0x10000)

//-----------------------------------------------------------------------------
//	USB HOST STACK ^XNDx
//		x[XDx́A"uhs_configtop.h"Œ`
//-----------------------------------------------------------------------------
#define USBH_INTC_TASK_PRIORITY			(USBH_TASK_PRI_BASE+0)					//	USBzXg荞(EHCI)^XN
#define USBH_HUB_TASK_PRIORITY  		(USBH_TASK_PRI_BASE+1)					//	HUBNXhCo[^XN
#define USBH_CALLBACK_TASK_PRIORITY		(USBH_TASK_PRI_BASE+2)					//	API_WRAPPzXgR[obNXbh(API_WRAPPXbh荂)
#define USBH_APIWRAPP_TASK_PRIORITY		(USBH_TASK_PRI_BASE+3)					//	API_WRAPPXbh
#define	USBH_STSMON_TASK_PRIORITY		(USBH_TASK_PRI_BASE+2)					//	STATUSj^^XN
#define USBH_CLASSDRVTASK_PRIORITY  	(USBH_TASK_PRI_BASE+3)					//	USBzXgNXhCo[^XN

//-----------------------------------------------------------------------------
//	USB HOST STACK X^bNETCY
//-----------------------------------------------------------------------------
#define USBH_INTC_TASK_STACK			(4 * 1024)								//	USBzXg荞ݏ^XN
#define USBH_HUB_STACK					(4 * 1024)								//	(HUB)NXhCo[^XN
#define USBH_CALLBACK_TASK_STACK		(4 * 1024)								//	USBzXgR[obN^XN
#define USBH_APIWRAPP_TASK_STACK		(4 * 1024)								//	API_WRAPP^XN
#define USBH_STSMON_TASK_STACK			(4 * 1024)								//	STATUSj^^XN
#define USBH_CLASSDRVTASK_STACK			(4 * 1024)								//	USBzXg(HUB)NXhCo[^XN

//------------------------------------------------------------------------------
// EHCIhCoŎgp^XN̗DxƃX^bNTCY
//------------------------------------------------------------------------------
#define USB_HC_EHCI_INTHDLR_PRI         (USBH_INTC_TASK_PRIORITY)
#define USB_HC_EHCI_INTHDLR_STKSZ       (USBH_INTC_TASK_STACK)

//------------------------------------------------------------------------------
// nuhCoŎgp^XN̗DxƃX^bNTCY
//------------------------------------------------------------------------------
#define USB_CL_HUB_TASK_PRI             (USBH_HUB_TASK_PRIORITY)
#define USB_CL_HUB_TASK_STKSZ           (USBH_HUB_STACK)

//--------------------------------------------------------------------------
// APIbpŎgp^XN̗DxƃX^bNTCY
//--------------------------------------------------------------------------
#define USBWRAP_DRVSUBTASK_PRI			(USBH_APIWRAPP_TASK_PRIORITY)
#define USBWRAP_DRVSUBTASK_STKSZ		(USBH_APIWRAPP_TASK_STACK)

//------------------------------------------------------------------------------
// R[obNŎgp^XN̗DxƃX^bNTCY
//------------------------------------------------------------------------------
#define USBWRAP_CALLBACK_PRI            (USBH_CALLBACK_TASK_PRIORITY)
#define USBWRAP_CALLBACK_STKSZ          (USBH_CALLBACK_TASK_STACK)

//------------------------------------------------------------------------------
//	STATUSj^
//------------------------------------------------------------------------------
#define	USBWRAP_STSMON_PRI				(USBH_STSMON_TASK_PRIORITY)
#define	USBWRAP_STSMON_STKSZ			(USBH_STSMON_TASK_STACK)

//------------------------------------------------------------------------------
//	USB EHCI Rg[pp[^
//------------------------------------------------------------------------------
#define		USB_MAX_INTERVAL_UFRAME		(8 * 32)								//	Interrupt ʐMŃT|[g\ȍő	(32ms)
#define		USB_MIN_LS_INTERVAL_UFRAME	(8 * 8)									//	LS Interrupt ʐMŃT|[g\ȍŏ	(ms)
#define		USB_MIN_FS_INTERVAL_UFRAME	(8 * 8)									//	FS Interrupt ʐMŃT|[g\ȍŏ	(ms)
#define		USB_LS_START_OFFSET_CORRECT	(0)										//	LS Interrupt ʐMindexL莞̕␳lW
#define		USB_HW_PORT_NUM				(1)										//	ROOT HUB |[g
#define		USBH_EHCI_BAR_VALUE			(AG903_USB_BASE)						//	EHCI Rg[̃x[XAhX(0xEB20_0000)
#define		USB_HC_EHCI_PFLST_SIZE		(1024)									//	EHCIzXgRg[ Periodic Frame List ̃TCY	(1024/512/256)
#define		EHCI_PFL_NEED_TRANSENDIAN											//	Periodic Frame List ̒lɃGfBAϊKv

//------------------------------------------------------------------------------
//	MISC
//------------------------------------------------------------------------------
#define THREAD_OFF  					(0)
#define THREAD_ON   					(1)

//------------------------------------------------------------------------------
//	EHCI REGISTER/MEMORY ACCESS oCgI[_ϊ
//------------------------------------------------------------------------------
//#define	USBH_EHCI_REGACC_YES_BYTEORDER											//	EHCIWX^ANZXbyteI[_ϊ	=	L
//#define	USBH_EHCI_MEMACC_NO_BYTEORDER											//	EHCIANZXbyteI[_ϊ	=	
#define	USBH_EHCI_REGACC_NO_BYTEORDER											//	EHCIWX^ANZXbyteI[_ϊ	=	
#define	USBH_EHCI_MEMACC_NO_BYTEORDER											//	EHCIANZXbyteI[_ϊ	=	


#endif		//	__UHS_CONFIG_H__

