/**
 * @brief           PGP Manager Header
 * @author          AXELL CORPORATION
 * @description     PGP Manager Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2018_01_24  [SDK2.1] 摜O̐ڂɂG[`FbNƐ̒ǉ (#1773)
 * @history         2018_01_24  [SDK2.1] fBUO@\LɂĂK؂ȃpCvCĂȂsΉ (#1767)
 * @history         2018_01_24  [SDK2.1] pCvC̓|[gɎw肷fW^rfI̓|[gnȟ^Ɍ (#1757)
 * @history         2019_03_08  [SDK2.2] PGPłMALLOC/FREE̒`ɃvtBbNXǉ (#2432)
 * @history         2019_12_27  [SDK3.0] PGP̃xO͊֐mۂ\[X֐ǉ (#1951)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef PGPMGRH
#define PGPMGRH
/* DOM-IGNORE-END */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>
#include "AG903_errno.h"

/* 
 * pCvC̎gpȂꍇ͈ȉ̒`Lɂ邱ƂŃ\[X̍팸ł܂<p> 
 * ł́ÁuDisanblev ŎgpĉB
*/
#define AG903_PGP_MGR_TS_FORCE_DISABLE

#ifdef AG903_PGP_MGR_TS_FORCE_DISABLE
/** pCvCnh̍ől */
#define AG903_PGP_MGR_MAX_PIPELINE_HANDLE       (6)
/** VRAM̓nh̍ől */
#define AG903_PGP_MGR_MAX_VRAMI_HANDLE          (4)
/** t[ԉZnh̍ől */
#define AG903_PGP_MGR_MAX_FRAME_CALC_HANDLE     (2)
/** Zxϊe[u̍ől */
#define AG903_PGP_MGR_MAX_DGC_LUT               (8)
#else
#define AG903_PGP_MGR_MAX_PIPELINE_HANDLE       (16)
#define AG903_PGP_MGR_MAX_VRAMI_HANDLE          (16)
#define AG903_PGP_MGR_MAX_FRAME_CALC_HANDLE     (16)
#define AG903_PGP_MGR_MAX_DGC_LUT               (16)
#endif

/** IȃpCvCnh̐ */
#define AG903_PGP_MGR_PIPELINE_NUM              (6)
/** IVRAM͂̐ */
#define AG903_PGP_MGR_VRAMI_NUM                 (4)
/** IȉZpCvC̐ */
#define AG903_PGP_MGR_CALC_PIPELINE_NUM         (2)

/** ZpCvC0 */
#define AG903_PGP_MGR_CALC_PIPELINE0            (0)
/** ZpCvC1 */
#define AG903_PGP_MGR_CALC_PIPELINE1            (1)
/** ͉摜pCvC0 */
#define AG903_PGP_MGR_INPUT_PIPELINE0           (2)
/** ͉摜pCvC1 */
#define AG903_PGP_MGR_INPUT_PIPELINE1           (3)
/** t[ۑpCvC0 */
#define AG903_PGP_MGR_FRAME_PIPELINE0           (4)
/** t[ۑpCvC1 */
#define AG903_PGP_MGR_FRAME_PIPELINE1           (5)

/** pCvC̎sR}h𗭂߂L[̍ől */
#define AG903_PGP_MGR_PIPELINE_CMD_MAX_QUEUE    (4)
/** VRAM͂̎sR}h𗭂߂L[̍ől */
#define AG903_PGP_MGR_VI_CMD_MAX_QUEUE          (4)
/** xOsR}h𗭂߂L[̍ől */
#define AG903_PGP_MGR_LBL_CMD_MAX_QUEUE         (4)
/** qXgOsR}h𗭂߂L[̍ől */
#define AG903_PGP_MGR_HGM_CMD_MAX_QUEUE         (4)

/** OpCvCnhʂID */
#define AG903_PGP_MGR_PIPELINE_HANDLE_ID        (0x11223344)
/** VRAM̓nhʂID */
#define AG903_PGP_MGR_VRAM_INPUT_HANDLE_ID      (0x55667788)
/** t[ԉZnhʂID */
#define AG903_PGP_MGR_FRAME_CALC_HANDLE_ID      (0x99AABBCC)
/** Zxϊe[uʂID */
#define AG903_PGP_MGR_DGC_LUT_ID                (0xDDEEFF00)

/** pCvCR}hiȂj */
#define AG903_PGP_MGR_CMD_NONE                  (0x0)
/** pCvCR}hi1VbgLv`sj */
#define AG903_PGP_MGR_CMD_EXEC                      (0x1)
/** pCvCR}hiALv`sj */
#define AG903_PGP_MGR_CMD_EXEC_CONTINUE             (0x2)
/** pCvCR}higKNLv`sj */
#define AG903_PGP_MGR_CMD_TRIG                      (0x3)
/** pCvCR}higKNALv`sj */
#define AG903_PGP_MGR_CMD_TRIG_CONTINUE             (0x4)
/** pCvCR}hiAChԂֈڍsAR}hL[폜j */
#define AG903_PGP_MGR_CMD_IDLE                      (0x8)
/** pCvCR}hi^CvX^vJE^Zbgj */
#define AG903_PGP_MGR_CMD_RESET_TIMESTAMP_CNT       (0x9)
/** pCvCR}hit[ʂԍJE^Zbgj */
#define AG903_PGP_MGR_CMD_RESET_FRAME_CNT           (0xA)
/** pCvCR}hi荞ݗpt[JE^Zbgj */
#define AG903_PGP_MGR_CMD_RESET_INTR_CNT            (0xB)
/** pCvCR}hiLv`Iin[hZbgj */
#define AG903_PGP_MGR_CMD_FORCE_QUIT                (0xF)

/** VSYNC荞݂𔭐tB[htB[hɐݒ */
#define AG903_PGP_MGR_INTR_CTRL_FIELD_ODD       (0x1)
/** VSYNC荞݂𔭐tB[htB[hɐݒ */
#define AG903_PGP_MGR_INTR_CTRL_FIELD_EVEN      (0x2)
/** VSYNC荞݂𔭐tB[hEtB[hɐݒ */
#define AG903_PGP_MGR_INTR_CTRL_FIELD_ODD_EVEN  (0x3)

/** o͊荞݂̃t[JE^ől */
#define AG903_PGP_MGR_INTR_CTRL_MAX_FRAME_CNT   (16)

/** ̓C荞݂𔭐郉Cԍ̍ől */
#define AG903_PGP_MGR_INTR_CTRL_MAX_INPUT_LINE  (8191)
/** o̓C荞݂𔭐郉Cԍ̍ől */
#define AG903_PGP_MGR_INTR_CTRL_MAX_OUTPUT_LINE (4095)

/** pCvCXe[giAChԁj */
#define AG903_PGP_MGR_STATE_IDLE                (0x0)
/** pCvCXe[gi1VbgLv`sj */
#define AG903_PGP_MGR_STATE_1SHOT               (0x1)
/** pCvCXe[giALv`sj */
#define AG903_PGP_MGR_STATE_CONTINUE            (0x2)
/** pCvCXe[gigKNLv`sj */
#define AG903_PGP_MGR_STATE_TRIG                (0x3)
/** pCvCXe[gigKNALv`sj */
#define AG903_PGP_MGR_STATE_TRIG_CONTINUE       (0x4)
/** pCvCXe[giIj */
#define AG903_PGP_MGR_STATE_FORCE_QUIT          (0xF)
/** pCvCTuXe[gigK҂j */
#define AG903_PGP_MGR_SUBSTATE_TRIG_WAIT        (0x1)
/** pCvCTuXe[giVSYNC҂j */
#define AG903_PGP_MGR_SUBSTATE_VSYNC_WAIT       (0x2)
/** pCvCTuXe[giLv`sj */
#define AG903_PGP_MGR_SUBSTATE_EXEC             (0x3)

/** VSYNCgK𔭐tB[htB[hɐݒ */
#define AG903_PGP_MGR_TRIG_CTRL_FIELD_ODD       (0x1)
/** VSYNCgK𔭐tB[htB[hɐݒ */
#define AG903_PGP_MGR_TRIG_CTRL_FIELD_EVEN      (0x2)
/** VSYNCgK𔭐tB[hEtB[hɐݒ */
#define AG903_PGP_MGR_TRIG_CTRL_FIELD_ODD_EVEN  (0x3)

/** gK̃t[JE^ől */
#define AG903_PGP_MGR_TRIG_CTRL_MAX_FRAME_CNT   (16)

/** ̓CgK𔭐郉Cԍ̍ől */
#define AG903_PGP_MGR_TRIG_CTRL_MAX_INPUT_LINE  (8191)
/** o̓CgK𔭐郉Cԍ̍ől */
#define AG903_PGP_MGR_TRIG_CTRL_MAX_OUTPUT_LINE (4095)

/** Lv`͂HSYNCɑ΂x̍ől */
#define AG903_PGP_MGR_MAX_INPUT_HSYNC_DELAY     (0x7)

/** Lv`JnEIVSYNC */
#define AG903_PGP_MGR_INPUT_MD_VSYNC            (0)
/** Lv`JnEIODDtB[hVSYNC */
#define AG903_PGP_MGR_INPUT_MD_ODD_VSYNC        (1)

/** ^CX^vɃNbN\[X0p */
#define AG903_PGP_MGR_INPUT_TIME_CLK0           (0)
/** ^CX^vɃNbN\[X1p */
#define AG903_PGP_MGR_INPUT_TIME_CLK1           (1)

/** gKN^C}W[̃`lԍ */
#define AG903_PGP_MGR_MAX_TRIG_TIMER_CHANNEL    (7)

/** AiO0 */
#define AG903_PGP_MGR_INPUT_PORT_VIA_0          (0)
/** AiO1 */
#define AG903_PGP_MGR_INPUT_PORT_VIA_1          (1)
/** AiO2 */
#define AG903_PGP_MGR_INPUT_PORT_VIA_2          (2)
/** AiO3 */
#define AG903_PGP_MGR_INPUT_PORT_VIA_3          (3)
/** fW^0 */
#define AG903_PGP_MGR_INPUT_PORT_VID_0          (4)
/** fW^1 */
#define AG903_PGP_MGR_INPUT_PORT_VID_1          (5)
/** fW^2 */
#define AG903_PGP_MGR_INPUT_PORT_VID_2          (6)
/** fW^3 */
#define AG903_PGP_MGR_INPUT_PORT_VID_3          (7)
/** VRAM0 */
#define AG903_PGP_MGR_INPUT_PORT_VRAM_0         (8)
/** VRAM1 */
#define AG903_PGP_MGR_INPUT_PORT_VRAM_1         (9)

/** Lv`tH[}bgRGB888 */
#define AG903_PGP_MGR_INPUT_FMT_RGB888          (0x0)
/** Lv`tH[}bgRGB565 */
#define AG903_PGP_MGR_INPUT_FMT_RGB565          (0x1)
/** Lv`tH[}bgYCbCr444 */
#define AG903_PGP_MGR_INPUT_FMT_YCBCR444        (0x2)
/** Lv`tH[}bgYCbCr422 I/PϊȂ */
#define AG903_PGP_MGR_INPUT_FMT_YCBCR422_WO_IP  (0x3)
/** Lv`tH[}bgYCbCr422 I/Pϊ */
#define AG903_PGP_MGR_INPUT_FMT_YCBCR422_W_IP   (0x4)
/** Lv`tH[}bgCLUT8 */
#define AG903_PGP_MGR_INPUT_FMT_CLUT8           (0x5)
/** Lv`tH[}bgCLUT1 */
#define AG903_PGP_MGR_INPUT_FMT_CLUT1           (0x6)

/** ZpCvCɂāAt[ԉZZ̏ŏ */
#define AG903_PGP_MGR_IFCODR_FRAME_TO_OTHER     (0x0)
/** ZpCvCɂāAZt[ԉZ̏ŏ */
#define AG903_PGP_MGR_IFCODR_OTHER_TO_FRAME     (0x1)

/** Lv`TCY̍őliATCYj */
#define AG903_PGP_MGR_MAX_INPUT_SIZE            (4096)

/** Lv`JnW̍őliʒuAʒuj */
#define AG903_PGP_MGR_MAX_INPUT_POS             (8191)

/** t[ۑ̃pfBOl̍ől */
#define AG903_PGP_MGR_MAX_OUTPUT_PAD            (255)

/** ~bg */
#define AG903_PGP_MGR_LIMIT_NONE                (0x0)
/** ~bg0`255ɐ */
#define AG903_PGP_MGR_LIMIT_0_255               (0x0)
/** ~bg16`235([23:16]), 240([15:8], [7:0])ɐ */
#define AG903_PGP_MGR_LIMIT_16_235_AND_240      (0x1)
/** ~bg-128`127ɐ */
#define AG903_PGP_MGR_LIMIT_M128_127            (0x2)

/** t[@vObVu */
#define AG903_PGP_MGR_SCAN_PROGRESSIVE          (0x0)
/** t[@C^[X */
#define AG903_PGP_MGR_SCAN_INTERLACE            (0x1)

/** AhXw1AhX */
#define AG903_PGP_MGR_ADDR_DIMENTION_1          (0x0)
/** AhXw2AhX */
#define AG903_PGP_MGR_ADDR_DIMENTION_2          (0x1)

/** 2AhX̃XgChoCg̍ől */
#define AG903_PGP_MGR_OUTPUT_MAX_STRIDE_BYTE    (16384)

/** C^[X͂̃t[ۑ@Ɋt[݂̂w */
#define AG903_PGP_MGR_OUTPUT_FRAME_SAVE_ODD             (0x0)
/** C^[X͂̃t[ۑ@ɋt[݂̂w */
#define AG903_PGP_MGR_OUTPUT_FRAME_SAVE_EVEN            (0x1)
/** C^[X͂̃t[ۑ@ɃtB[hw */
#define AG903_PGP_MGR_OUTPUT_FRAME_SAVE_IGNORE_FIELD    (0x2)
/** C^[X͂̃t[ۑ@ɃtB[hɏ]w */
#define AG903_PGP_MGR_OUTPUT_FRAME_SAVE_FIELD           (0x3)
/** C^[X͂̃t[ۑ@Weavew */
#define AG903_PGP_MGR_OUTPUT_FRAME_SAVE_WEAVE           (0x4)

/** obt@Ǘjbg */
#define AG903_PGP_MGR_OUTPUT_BMU_NONE           (0x0)
/** obt@ǗjbgLBtB[hɊ֌WȂXV */
#define AG903_PGP_MGR_OUTPUT_BMU_ENABLE         (0x1)
/** obt@ǗjbgLBEVENtB[hIJnɍXV */
#define AG903_PGP_MGR_OUTPUT_BMU_ENABLE_EVEN    (0x2)

/** o̓tH[}bgRGB888RGB888i32bitj */
#define AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_RGB888_32BIT     (0x0)
/** o̓tH[}bgRGB888RGB888i24bitj */
#define AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_RGB888_24BIT     (0x1)
/** o̓tH[}bgRGB888RGB565 */
#define AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_RGB565           (0x2)
/** o̓tH[}bgRGB888ARGB1555 */
#define AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_ARGB1555         (0x3)
/** o̓tH[}bgRGB888ARGB4444 */
#define AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_ARGB4444         (0x4)
/** o̓tH[}bgRGB888RGB888 RGB */
#define AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_RGB888_SEP       (0x5)
/** o̓tH[}bgYCbCr444YCbCr444i32bitj */
#define AG903_PGP_MGR_OUTPUT_FMT_YCBCR444_TO_YCBCR444_32BIT (0x8)
/** o̓tH[}bgYCbCr444YCbCr444i24bitj */
#define AG903_PGP_MGR_OUTPUT_FMT_YCBCR444_TO_YCBCR444_24BIT (0x9)
/** o̓tH[}bgYCbCr444YCbCr422 */
#define AG903_PGP_MGR_OUTPUT_FMT_YCBCR444_TO_YCBCR422       (0xA)
/** o̓tH[}bgYCbCr444YCbCr444 RGB */
#define AG903_PGP_MGR_OUTPUT_FMT_YCBCR444_TO_YCBCR444_SEP   (0xB)
/** o̓tH[}bgCLUT8CLUT8 */
#define AG903_PGP_MGR_OUTPUT_FMT_CLUT8_TO_CLUT8             (0xE)
/** o̓tH[}bgCLUT1CLUT1 */
#define AG903_PGP_MGR_OUTPUT_FMT_CLUT1_TO_CLUT1             (0xF)

/** C^[X[hłEVENt[VPOŜ܂ܗp */
#define AG903_PGP_MGR_INPUT_INTERLACE_EPOS_ZERO (0x0)
/** C^[X[hłEVENt[VPOS+1ėp */
#define AG903_PGP_MGR_INPUT_INTERLACE_EPOS_ONE  (0x1)
/** C^[X[hłODDt[VPOŜ܂ܗp */
#define AG903_PGP_MGR_INPUT_INTERLACE_OPOS_ZERO (0x0)
/** C^[X[hłODDt[VPOS+1ėp */
#define AG903_PGP_MGR_INPUT_INTERLACE_OPOS_ONE  (0x1)

/** I/PϊH̃uNԂ̍ől */
#define AG903_PGP_MGR_MAX_IP_BLANK              (255)

/** FԕϊZõ͎Vtgʂ̍ől */
#define AG903_PGP_MGR_MAX_COLOR_SPACE_SHIFT     (15)

/** ktB^i|CgTvj */
#define AG903_PGP_MGR_FILTER_NEAREST            (0x0)
/** ktB^ijAtB^j */
#define AG903_PGP_MGR_FILTER_LINEAR             (0x1)

/** XP[O̕qAɎw\ȍől */
#define AG903_PGP_MGR_MAX_SCALING_VALUE         (16)

/** YUViBT.601 Full RangejRGB̐Fԕϊ̃vZbg */
#define AG903_PGP_MGR_CSC_YUV_BT_601_FULL_TO_RGB    (0)
/** RGBYUViBT.601 Full Rangej̐Fԕϊ̃vZbg */
#define AG903_PGP_MGR_CSC_RGB_TO_YUV_BT_601_FULL    (1)
/** YUViBT.601 Limit RangejRGB̐Fԕϊ̃vZbg */
#define AG903_PGP_MGR_CSC_YUV_BT_601_LIMIT_TO_RGB   (2)
/** RGBYUViBT.601 Limit Rangej̐Fԕϊ̃vZbg */
#define AG903_PGP_MGR_CSC_RGB_TO_YUV_BT_601_LIMIT   (3)
/** YUViBT.709 Full RangejRGB̐Fԕϊ̃vZbg */
#define AG903_PGP_MGR_CSC_YUV_BT_709_FULL_TO_RGB    (4)
/** RGBYUViBT.709 Full Rangej̐Fԕϊ̃vZbg */
#define AG903_PGP_MGR_CSC_RGB_TO_YUV_BT_709_FULL    (5)
/** YUViBT.709 Limit RangejRGB̐Fԕϊ̃vZbg */
#define AG903_PGP_MGR_CSC_YUV_BT_709_LIMIT_TO_RGB   (6)
/** RGBYUViBT.709 Limit Rangej̐Fԕϊ̃vZbg */
#define AG903_PGP_MGR_CSC_RGB_TO_YUV_BT_709_LIMIT   (7)

/** ԃtB^̃Vtgʂ̍ől */
#define AG903_PGP_MGR_MAX_SPF_SHIFT             (15)

/** EɌŒJ[gp */
#define AG903_PGP_MGR_SPF_BORDER_COLOR          (0x0)
/** EɍŋߖTsNZgp */
#define AG903_PGP_MGR_SPF_BORDER_NEIGHBOR       (0x1)

/** HSVAHLSϊH̏o̓tH[}bgHSVI */
#define AG903_PGP_MGR_CONVERT_HSV               (0x0)
/** HSVAHLSϊH̏o̓tH[}bgHLSI */
#define AG903_PGP_MGR_CONVERT_HLS               (0x1)

/** qXgOR}hi܂j */
#define AG903_PGP_MGR_HGM_CMD_NONE              (0x0)
/** qXgOR}hiqXgOv̎siVRAM_vjj */
#define AG903_PGP_MGR_HGM_CMD_EXEC              (0x1)
/** qXgOR}hiqXgOv̎siVRAM_vȂjj */
#define AG903_PGP_MGR_HGM_CMD_EXEC_WO_VRAM      (0x2)
/** qXgOR}hiL[AR}h̍폜j */
#define AG903_PGP_MGR_HGM_CMD_DELETE            (0x4)
/** qXgOR}hiHZbgj */
#define AG903_PGP_MGR_HGM_CMD_RESET             (0x7)

/** qXgOo̒lOȂ */
#define AG903_PGP_MGR_HGM_EXC_NONE              (0x0)
/** qXgOo0O */
#define AG903_PGP_MGR_HGM_EXC_0                 (0x1)
/** qXgOo0`16O */
#define AG903_PGP_MGR_HGM_EXC_0_16              (0x2)
/** qXgOo0OBRvfiDATA[23:16]j͏OȂ */
#define AG903_PGP_MGR_HGM_EXC_0_WO_R            (0x3)

/** qXgȌo͖Ԃ̍ől */
#define AG903_PGP_MGR_MAX_HGM_OUTPUT_INVALIDATE (15)

/** qXgOWo̕~n̍ől */
#define AG903_PGP_MGR_MAX_HGM_THR               (15)

/** qXgOvf[^õ͎f[^VtgʁiEVtgj̍ől */
#define AG903_PGP_MGR_MAX_HGM_SHIFT             (15)

/** qXgOo̊Ԉʂ̍ől */
#define AG903_PGP_MGR_MAX_HGM_INC               (15)

/** qXgOvTCY̍ől */
#define AG903_PGP_MGR_MAX_HGM_SIZE              (1024)

/** qXgOvJnW̍ől */
#define AG903_PGP_MGR_MAX_HGM_POS               (4095)

/** 臒l̏o͂ɉ摜I */
#define AG903_PGP_MGR_THR_OUT_SEL_RGB           (0x0)
/** 臒l̏o͂8bitMUXo͂I */
#define AG903_PGP_MGR_THR_OUT_SEL_MUX8          (0x1)
/** 臒l̏o͂1bitԃtB^o͂I */
#define AG903_PGP_MGR_THR_OUT_SEL_SPF1          (0x2)
/** 臒l̏o͂ɃxOo͂I */
#define AG903_PGP_MGR_THR_OUT_SEL_LBL           (0x3)

/** 臒lCLUT8̏o͂BluevfiDATA[7:0]jI */
#define AG903_PGP_MGR_THR_CLUT8_OUT_B           (0x0)
/** 臒lCLUT8̏o͂GreenvfiDATA[15:8]jI */
#define AG903_PGP_MGR_THR_CLUT8_OUT_G           (0x1)
/** 臒lCLUT8̏o͂RedvfiDATA[23:16]jI */
#define AG903_PGP_MGR_THR_CLUT8_OUT_R           (0x2)

/** 臒l̐ݒɂBluevfiDATA[7:0]j̃p[^ݒΏۂɎw肵܂ */
#define AG903_PGP_MGR_THR_CHANNEL_B             (0)
/** 臒l̐ݒɂGreenvfiDATA[15:8]j̃p[^ݒΏۂɎw肵܂ */
#define AG903_PGP_MGR_THR_CHANNEL_G             (1)
/** 臒l̐ݒɂRedvfiDATA[23:16]j̃p[^ݒΏۂɎw肵܂ */
#define AG903_PGP_MGR_THR_CHANNEL_R             (2)

/** 8bit臒l̎ނThreshold BinaryI */
#define AG903_PGP_MGR_THR_8BIT_TYPE_THR_BIN             (0x0)
/** 8bit臒l̎ނThreshold Binary, InvertedI */
#define AG903_PGP_MGR_THR_8BIT_TYPE_THR_BIN_INV         (0x1)
/** 8bit臒l̎ނTruncateI */
#define AG903_PGP_MGR_THR_8BIT_TYPE_TRU                 (0x2)
/** 8bit臒l̎ނThreshold to ZeroI */
#define AG903_PGP_MGR_THR_8BIT_TYPE_THR_ZERO            (0x3)
/** 8bit臒l̎ނThreshold to Zero, InvertedI */
#define AG903_PGP_MGR_THR_8BIT_TYPE_THR_ZERO_INV        (0x4)
/** 8bit臒l̎ނThreshold Binary, ExtendedI */
#define AG903_PGP_MGR_THR_8BIT_TYPE_THR_BIN_EXT         (0x8)
/** 8bit臒l̎ނThreshold Binary, Inverted, ExtendedI */
#define AG903_PGP_MGR_THR_8BIT_TYPE_THR_BIN_INV_EXT     (0x9)
/** 8bit臒l̎ނTruncate, ExtendedI */
#define AG903_PGP_MGR_THR_8BIT_TYPE_TRU_EXT             (0xA)
/** 8bit臒l̎ނThreshold to Zero, ExtendedI */
#define AG903_PGP_MGR_THR_8BIT_TYPE_THR_ZERO_EXT        (0xB)
/** 8bit臒l̎ނThreshold to Zero, Inverted, ExtendedI */
#define AG903_PGP_MGR_THR_8BIT_TYPE_THR_ZERO_INV_EXT    (0xC)

/** xOR}hi܂j */
#define AG903_PGP_MGR_LBL_CMD_NONE              (0x0)
/** xOR}hixO̎sj */
#define AG903_PGP_MGR_LBL_CMD_EXEC              (0x1)
/** xOR}hiL[AR}h̍폜j */
#define AG903_PGP_MGR_LBL_CMD_DELETE            (0x4)
/** xOR}hiHZbgj */
#define AG903_PGP_MGR_LBL_CMD_RESET             (0x7)

/** xȌo͗LԂ̍ől */
#define AG903_PGP_MGR_MAX_LBL_OUTPUT_VALIDATE   (16)
/** xȌo͖Ԃ̍ől */
#define AG903_PGP_MGR_MAX_LBL_OUTPUT_INVALIDATE (15)

/** xOɘA8Aw */
#define AG903_PGP_MGR_LBL_CNCT_8                (0x0)
/** xOɘA4Aw */
#define AG903_PGP_MGR_LBL_CNCT_4                (0x1)

/** xOte[ũtbVs臒l̍ől */
#define AG903_PGP_MGR_MAX_LBL_FLUSH_THR         (255)

/** xOte[uID ̍ől */
#define AG903_PGP_MGR_MAX_LBL_ID                (255)

/** xO̐TCY̍ől */
#define AG903_PGP_MGR_MAX_LBL_VSIZE             (1024)

/** xO̐TCY̍ől */
#define AG903_PGP_MGR_MAX_LBL_HSIZE             (640)

/** xOJnW̍ől */
#define AG903_PGP_MGR_MAX_LBL_POS               (4095)

/** t[ԉZ̃X[u͂VRAMi8bitȂjI */
#define AG903_PGP_MGR_IFC_SLAVE_VRAM_UI         (0x0)
/** t[ԉZ̃X[u͂VRAMi8bitjI */
#define AG903_PGP_MGR_IFC_SLAVE_VRAM_I          (0x1)
/** t[ԉZ̃X[u͂ɉZpCvCI */
#define AG903_PGP_MGR_IFC_SLAVE_PIPELINE        (0x2)

/** t[ԉZ̃QCZʏo͎̍őVtg */
#define AG903_PGP_MGR_MAX_IFC_GAIN_SHIFT        (7)

/** t[ԉZ̃~bg0`255ɐ */
#define AG903_PGP_MGR_IFC_LIMIT_0_255           (0x0)
/** t[ԉZ̃~bg16`235([23:16]), 240([15:8], [7:0])ɐ */
#define AG903_PGP_MGR_IFC_LIMIT_16_235_AND_240  (0x1)
/** t[ԉZ̃~bg-128`127ɐ */
#define AG903_PGP_MGR_IFC_LIMIT_M128_127        (0x2)

/** t[ԉZ@ANDI */
#define AG903_PGP_MGR_IFC_OP_AND                (0x0)
/** t[ԉZ@ORI */
#define AG903_PGP_MGR_IFC_OP_OR                 (0x1)
/** t[ԉZ@XORI */
#define AG903_PGP_MGR_IFC_OP_XOR                (0x2)
/** t[ԉZ@ADDI */
#define AG903_PGP_MGR_IFC_OP_ADD                (0x3)
/** t[ԉZ@ABSI */
#define AG903_PGP_MGR_IFC_OP_ABS                (0x4)

/** VRAM̓R}hi܂j */
#define AG903_PGP_MGR_VI_CMD_NONE               (0x0)
/** VRAM̓R}hi1Vbg̓ǂݏosj */
#define AG903_PGP_MGR_VI_CMD_EXEC               (0x1)
/** VRAM̓R}hiAł̓ǂݏosj */
#define AG903_PGP_MGR_VI_CMD_EXEC_CONTINUE      (0x2)
/** VRAM̓R}hiAChԂ֑Jځj */
#define AG903_PGP_MGR_VI_CMD_IDLE               (0x8)
/** VRAM̓R}hiHZbgj */
#define AG903_PGP_MGR_VI_CMD_RESET              (0xF)
/** VRAM̓R}hiIj */
#define AG903_PGP_MGR_VI_CMD_FORCE_QUIT         (0xF)

/** obt@Ǘjbg */
#define AG903_PGP_MGR_VI_BMU_NONE               (0x0)
/** obt@ǗjbgLBtB[hɊ֌WȂXV */
#define AG903_PGP_MGR_VI_BMU_ENABLE             (0x1)
/** obt@ǗjbgLBODDtB[hJnɍXV */
#define AG903_PGP_MGR_VI_BMU_ENABLE_ODD         (0x2)

/** C^[Xt[̓ǂݏo@Ɋt[݂̂w */
#define AG903_PGP_MGR_VI_FRAME_READ_ODD         (0x0)
/** C^[Xt[̓ǂݏo@ɋt[݂̂w */
#define AG903_PGP_MGR_VI_FRAME_READ_EVEN        (0x1)
/** C^[Xt[̓ǂݏo@ɃtB[hw */
#define AG903_PGP_MGR_VI_FRAME_READ_FIELD       (0x2)
/** C^[Xt[̓ǂݏo@Weavew */
#define AG903_PGP_MGR_VI_FRAME_READ_WEAVE       (0x4)

/** VRAMo͊Ԃ̈΂̍ől */
#define AG903_PGP_MGR_MAX_VI_DIV                (256)

/** VRAMo͗LԂ̍ől */
#define AG903_PGP_MGR_MAX_VI_VALIDATE           (16)
/** VRAMo͖Ԃ̍ől */
#define AG903_PGP_MGR_MAX_VI_INVALIDATE         (15)

/** VRAM̓tH[}bgRGB888i32bitj */
#define AG903_PGP_MGR_VI_FMT_RGB888_32          (0x0)
/** VRAM̓tH[}bgRGB888i24bitj */
#define AG903_PGP_MGR_VI_FMT_RGB888_24          (0x1)
/** VRAM̓tH[}bgRGB565 */
#define AG903_PGP_MGR_VI_FMT_RGB565             (0x2)
/** VRAM̓tH[}bgYCbCr444i32bitj */
#define AG903_PGP_MGR_VI_FMT_YCBCR444_32        (0x8)
/** YCbCr444i24bitj */
#define AG903_PGP_MGR_VI_FMT_YCBCR444_24        (0x9)
/** YCbCr422 */
#define AG903_PGP_MGR_VI_FMT_YCBCR422           (0xA)
/** CLUT8 */
#define AG903_PGP_MGR_VI_FMT_CLUT8              (0xE)
/** CLUT1 */
#define AG903_PGP_MGR_VI_FMT_CLUT1              (0xF)

/** VRAM2AhX̏ꍇ̃XgChoCg */
#define AG903_PGP_MGR_VI_MAX_STRIDE_BYTE        (16384)

/** VRAM͂̐MpX̍ől */
#define AG903_PGP_MGR_MAX_VI_H_PULES_WIDTH      (4096)

/** VRAM͂̐tg|[`̍ől */
#define AG903_PGP_MGR_MAX_VI_H_FRONT_PORCH      (4096)

/** VRAM͂̐obN|[`̍ől */
#define AG903_PGP_MGR_MAX_VI_H_BACK_PORCH       (4096)

/** VRAM͂̐MpX̍ől */
#define AG903_PGP_MGR_MAX_VI_V_PULES_WIDTH      (4096)

/** VRAM͂̐tg|[`̍ől */
#define AG903_PGP_MGR_MAX_VI_V_FRONT_PORCH      (4096)

/** VRAM͂̐obN|[`̍ől */
#define AG903_PGP_MGR_MAX_VI_V_BACK_PORCH       (4096)

/** VRAM͂̐TCY̍ől */
#define AG903_PGP_MGR_MAX_VI_H_SIZE             (4096)
/** VRAM͂̐TCY̍ől */
#define AG903_PGP_MGR_MAX_VI_V_SIZE             (4096)

/** ͊荞 */
#define AG903_PGP_MGR_INTR_INPUT                (0)
/** o͊荞 */
#define AG903_PGP_MGR_INTR_OUTPUT               (1)
/** pCvC̊荞 */
#define AG903_PGP_MGR_INTR_DONE                 (2)
/** VRAMo͂̃G[荞 */
#define AG903_PGP_MGR_INTR_VRAM_ERROR           (3)
/** xÕG[荞 */
#define AG903_PGP_MGR_INTR_LBL_ERROR            (4)
/** qXgÕG[荞 */
#define AG903_PGP_MGR_INTR_HGM_ERROR            (5)
/** Mo荞 */
#define AG903_PGP_MGR_INTR_ND                   (6)
/** t[ԉZI[o[t[荞 */
#define AG903_PGP_MGR_INTR_IFC_OVF              (7)
/** ̓C荞 */
#define AG903_PGP_MGR_INTR_INPUT_LINE           (8)
/** o̓C荞 */
#define AG903_PGP_MGR_INTR_OUTPUT_LINE          (9)
/** xO荞 */
#define AG903_PGP_MGR_INTR_LBL_DONE             (10)
/** qXgO荞 */
#define AG903_PGP_MGR_INTR_HGM_DONE             (11)

/** pCvC̃p[^ݒ֐R[ꂽƂǗtO */
#define AG903_PGP_MGR_CONFIG_DIRTY_NUM          (29)
/** pCvC̓o͊荞݂̐ݒtO */
#define AG903_PGP_MGR_CONFIG_INTR_CTRL          (0)
/** rfÍAt[o̓gK̐ݒtO */
#define AG903_PGP_MGR_CONFIG_TRIG_CTRL          (1)
/** gKÑ^C}W[̃`lԍ̐ݒtO */
#define AG903_PGP_MGR_CONFIG_INPUT_TRIG_CH      (2)
/** t[ۑ̃pfBOl̐ݒtO */
#define AG903_PGP_MGR_CONFIG_OUTPUT_CTRL        (3)
/** pCvCõ͎J[}XN̐ݒtO */
#define AG903_PGP_MGR_CONFIG_OUTPUT_COLOR_MASK  (4)
/** pCvC̏o͐x[XAhX̐ݒtO */
#define AG903_PGP_MGR_CONFIG_OUTPUT_BASE_ADDR   (5)
/** I/PϊH̃p[^̐ݒtO */
#define AG903_PGP_MGR_CONFIG_IP_CONV            (6)
/** Fԕϊ𐧌䂷p[^̐ݒtO */
#define AG903_PGP_MGR_CONFIG_COLOR_SPACE        (7)
/** XP[Õp[^̐ݒtO */
#define AG903_PGP_MGR_CONFIG_SCALING            (8)
/** ԃtB^𐧌䂷p[^̐ݒtO */
#define AG903_PGP_MGR_CONFIG_SP_FILTER          (9)
/** HSVAHLSϊH̏o̓tH[}bg̐ݒtO */
#define AG903_PGP_MGR_CONFIG_HSVHSL_CONV        (10)
/** qXgÕp[^̐ݒtO */
#define AG903_PGP_MGR_CONFIG_HGM_PARAM          (11)
/** qXgÕp[^̐ݒtO */
#define AG903_PGP_MGR_CONFIG_HGM_SIZE           (12)
/** qXgOvJnW̐ݒtO */
#define AG903_PGP_MGR_CONFIG_HGM_POS            (13)
/** qXgOvo͐x[XAhX̐ݒtO */
#define AG903_PGP_MGR_CONFIG_HGM_BASE_ADDR      (14)
/** 臒l̋@\̐ݒtO */
#define AG903_PGP_MGR_CONFIG_THR                (15)
/** 臒lHSVAHLSϊH̏o̓tH[}bg@\̐ݒtO */
#define AG903_PGP_MGR_CONFIG_THR_HSCHLS_CONV    (16)
/** 臒l̐Fԕϊ𐧌䂷p[^̐ݒtO */
#define AG903_PGP_MGR_CONFIG_THR_COLOR_SPACE    (17)
/** 臒l̃}XN̐ݒtO */
#define AG903_PGP_MGR_CONFIG_THR_MASK           (18)
/** 臒l8bit臒l̃p[^}XN̐ݒtO */
#define AG903_PGP_MGR_CONFIG_THR_8BIT           (19)
/** 臒l1bit臒l̐ݒtO */
#define AG903_PGP_MGR_CONFIG_THR_1BIT           (20)
/** 臒l1bitԃtB^̐ݒtO */
#define AG903_PGP_MGR_CONFIG_THR_SP_FILTER_1BIT (21)
/** xȌo͗Lԃp[^̐ݒtO */
#define AG903_PGP_MGR_CONFIG_LBL_PARAM          (22)
/** xOTCY̐ݒtO */
#define AG903_PGP_MGR_CONFIG_LBL_SIZE           (23)
/** xOJnW̐ݒtO */
#define AG903_PGP_MGR_CONFIG_LBL_POS            (24)
/** xOto͐̃x[XAhX̐ݒtO */
#define AG903_PGP_MGR_CONFIG_LBL_BASE_ADDR      (25)
/** t[ԉZp[^̐ݒtO */
#define AG903_PGP_MGR_CONFIG_IFC_PARAM          (26)
/** t[ԉZ̃QCp[^̐ݒtO */
#define AG903_PGP_MGR_CONFIG_IFC_GAIN           (27)
/** 荞݂̃R[obN֐̓o^tO */
#define AG903_PGP_MGR_CONFIG_INTR_ENABLE        (28)
/** VRAM͂̃p[^ݒ֐R[ꂽƂǗtO */
#define AG903_PGP_MGR_CONFIG_VI_DIRTY_NUM       (4)
/** VRAM͂̃f[^Xbv̐ݒtO */
#define AG903_PGP_MGR_CONFIG_VI_CTRL            (0)
/** VRAM͂̏o͗Lԃp[^̐ݒtO */
#define AG903_PGP_MGR_CONFIG_VI_CTRL1           (1)
/** VRAM͂̏o͐x[XAhX̐ݒtO */
#define AG903_PGP_MGR_CONFIG_VI_BASE            (2)
/** VRAM͂̃C^[X[hłEVEN/ODDt[̒tO */
#define AG903_PGP_MGR_CONFIG_VI_ADJUST_FRAME    (3)

/** R[obN֐̃^Cv */
typedef void (*PGPMGRCALLBACK) (int32_t id, void *handle);

/**
 * Zxϊe[unh
 */
typedef struct _AG903_PgpMgrDGCLookupTable {
    uint32_t  id;                           /** Zxϊe[uʂׂID */
    _Bool     is_used;                      /** e[u擾Ԃł邱ƂmFtO */
    uint32_t  ref_cnt;                      /** t@XJEg */
    uint8_t   lut_data[3][256];             /** Zxϊe[ũWX^f[^ێ̈ */
} AG903_PgpMgrDGCLookupTable;


/**
 * pCvCnh
 */
typedef struct _AG903_PgpMgrPipelineHandle {
    uint32_t  id;                           /** OpCvCnhʂׂID */
    int32_t   pipeline_no;                  /** IɊ蓖ĂꂽpCvC̔ԍ */
    _Bool     is_used;                      /** nh擾Ԃł邱ƂmFtO */
    _Bool     is_assign;                    /** pCvCnh蓖čς݂ł邱Ƃ𔻒肷tO */
    _Bool     is_dirty;                     /** pCvCnhɑ΂ݒ肪ύXꂽԂł邱Ƃ𔻒肷tO */
    _Bool     is_config_dirty[AG903_PGP_MGR_CONFIG_DIRTY_NUM];  /** pCvCnhɑ΂Config̐ݒ֐ɂp[^XVꂽƂǗtO */
    _Bool     is_used_frame_calc;           /** pCvCnht[ԉZɎgpĂ邱Ƃ𔻒肷tO */
    _Bool     dgc_lut_dirty;                /** Zxϊe[uύXꂽƂǗtO */
    AG903_PgpMgrDGCLookupTable *dgc_lut;    /** ֘AtĂZxϊe[u */
    void      *input_handle;                /** ̓\[Xnh */
    uint32_t  input_intr_field;             /** ͊荞ݐɂVSYNC荞݂o͂tB[h */
    uint32_t  input_intr_fcnt;              /** ͊荞ݐɂt[JE^̍ől */
    uint32_t  input_intr_line;              /** ͊荞ݐɂ郉C荞݂𔭐郉Cԍ */
    uint32_t  output_intr_field;            /** o͊荞ݐɂVSYNC荞݂o͂tB[h */
    uint32_t  output_intr_fcnt;             /** o͊荞ݐɂt[JE^̍ől */
    uint32_t  output_intr_line;             /** o͊荞ݐɂ郉C荞݂𔭐郉Cԍ */
    _Bool     intr_nd_enable;               /** Mo荞ݗLtO */
    _Bool     intr_voicpl_enable;           /** VRAMo͖荞ݗLtO */
    _Bool     intr_vooflw_enable;           /** VRAMo̓I[o[t[荞ݗLtO */
    _Bool     intr_ifcofs_enable;           /** t[ԉZX[uI[ot[荞ݗLtO */
    _Bool     intr_ifcofm_enable;           /** t[ԉZ}X^I[o[t[荞ݗLtO */
    _Bool     intr_lblcrpt_enable;          /** xOf[^j荞ݗLtO */
    _Bool     intr_lblcpl_enable;           /** xOf[^o͊荞ݗLtO */
    _Bool     intr_hgmicpl_enable;          /** qXgOo͖荞ݗLtO */
    _Bool     intr_hgmcpl_enable;           /** qXgOo͊荞ݗLtO */
    _Bool     intr_vsynco_enable;           /** t[o͉H̐荞ݗLtO */
    _Bool     intr_vlineo_enable;           /** t[o͉H̃C荞ݗLtO */
    _Bool     intr_vsynci_enable;           /** ͒i̐荞ݗLtO */
    _Bool     intr_vlinei_enable;           /** ͒ĩC荞ݗLtO */
    uint32_t  input_trig_field;             /** rfI̓gKɂVSYNCgKo͂tB[h */
    uint32_t  input_trig_fcnt;              /** rfI̓gKɂt[JE^̍ől */
    uint32_t  input_trig_line;              /** rfI̓gKɂ郉CgK𔭐郉Cԍ */
    uint32_t  output_trig_field;            /** t[o̓gKɂVSYNCgKo͂tB[h */
    uint32_t  output_trig_fcnt;             /** t[o̓gKɂt[JE^̍ől */
    uint32_t  output_trig_line;             /** t[o̓gKɂ郉CgK𔭐郉Cԍ */
    _Bool     trig_vsynco_enable;           /** t[o͉H̐gKLtO */
    _Bool     trig_vlineo_enable;           /** t[o͉H̃CgKLtO */
    _Bool     trig_vsynci_enable;           /** rfI͂̐gKLtO */
    _Bool     trig_vlinei_enable;           /** rfI͂̃CgKLtO */
    uint32_t  input_hsync_delay;            /** Lv`͂HSYNCɑ΂x */
    uint32_t  input_mode;                   /** Lv`͂̓샂[h */
    uint32_t  input_timer_clk;              /** Lv`͂̃^CX^ṽNbN\[X */
    uint32_t  input_trig_timer_ch;          /** gKƂėp^C}W[̃`lԍ */
    uint32_t  input_port;                   /** pCvC̓̓|[g */
    uint32_t  input_format;                 /** Lv`͂̃tH[}bg */
    _Bool     frame_out_enable;             /** t[o͋@\̗LtO */
    uint32_t  ifc_order;                    /** t[ԉZ̏ */
    _Bool     ifc_enable;                   /** t[ԉZ̗LtO */
    _Bool     thr_enable;                   /** 臒l̗LtO */
    _Bool     dgc_enable;                   /** Zxϊ̗LtO */
    _Bool     hsv1_enable;                  /** HLSAHSVϊ1̗LtO */
    _Bool     spf_enable;                   /** ԃtB^̗LtO */
    _Bool     scale_enable;                 /** XP[OH̗LtO */
    _Bool     csc1_enable;                  /** Fԕϊ1̗LtO */
    _Bool     nrf_enable;                   /** 3^bvmCYtB^̗LtO */
    _Bool     hgm_enable;                   /** qXgO̗LtO */
    _Bool     lbl_enable;                   /** xO̗LtO */
    uint32_t  input_vsize;                  /** Lv`̐TCY */
    uint32_t  input_hsize;                  /** Lv`̓̓TCY */
    _Bool     input_epos;                   /** C^[X[hEVENt[sEsȂ̃tO */
    _Bool     input_opos;                   /** C^[X[hODDt[sEsȂ̃tO */
    uint32_t  input_scan;                   /** Lv`̃t[@ */
    uint32_t  input_vpos;                   /** Lv`̐ʒu */
    uint32_t  input_hpos;                   /** Lv`̐ʒu */
    uint32_t  output_pad;                   /** t[ۑ̃pfBOl */
    uint32_t  output_limit;                 /** 24bit͒l̃~bg */
    _Bool     output_fai_enable;            /** t[t̏o͗LtO */
    _Bool     output_dither_enable;         /** fBUO̗LtO */
    uint32_t  output_bmu;                   /** obt@Ǘjbg̐ݒ */
    uint32_t  output_scan;                  /** t[@ */
    uint32_t  output_dim;                   /** AhXw@ */
    _Bool     output_word_swap_enable;      /** o̓f[^̃[hf[^̃XbvLtO */
    _Bool     output_hword_swap_enable;     /** o̓f[^̃n[t[hf[^̃XbvLtO */
    _Bool     output_1bit_swap_enable;      /** o̓f[^4bitf[^̃XbvLtO */
    _Bool     output_4bit_swap_enable;      /** o̓f[^1bitf[^̃XbvLtO */
    uint32_t  output_md;                    /** C^[X͂̃t[ۑ@ */
    uint32_t  output_format;                /** o̓tH[}bg */
    _Bool     output_red_enable;            /** Rvf̏o͗LtO */
    _Bool     output_green_enable;          /** Gvf̏o͗LtO */
    _Bool     output_blue_enable;           /** Bvf̏o͗LtO */
    uint32_t  output_base_addr;             /** o͐̃x[XAhX */
    uint32_t  output_vram_stride;           /** o͐VRAMTCYiXgChoCgj */
    uint32_t  ipc_limit;                    /** I/PϊH̏o͒l~bg */
    uint32_t  ipc_blk_y;                    /** I/PϊH̃uNY̏o͒l */
    uint32_t  ipc_blk_c;                    /** I/PϊH̃uNCbACȑo͒l */
    uint32_t  csc1_limit;                   /** Fԕϊ1̏o͒l~bg */
    uint32_t  csc1_shift;                   /** Fԕϊ1̉Zõ͎Vtg */
    int32_t   csc1_matrix[3][4];            /** Fԕϊ1Matrixl */
    uint32_t  scale_limit;                  /** XP[Oo͒l̃~bg */
    uint32_t  scale_mtd;                    /** XP[Ok@ */
    uint32_t  scale_v_nmr;                  /** XP[Ok̕q */
    uint32_t  scale_v_dnm;                  /** XP[Ok̕ */
    uint32_t  scale_h_nmr;                  /** XP[Ok̕q */
    uint32_t  scale_h_dnm;                  /** XP[Ok̕ */
    uint32_t  spf_shift;                    /** ԃtB^̉Zõ͎Vtg */
    uint32_t  spf_border_sel;               /** ԃtB^̋ElJ[̑I */
    uint32_t  spf_border_red;               /** ԃtB^̋EŒJ[liԁj */
    uint32_t  spf_border_green;             /** ԃtB^̋EŒJ[li΁j */
    uint32_t  spf_border_blue;              /** ԃtB^̋EŒJ[lij */
    int32_t   spf_coeff[9];                 /** ԃtB^̌W */
    int32_t   spf_offset;                   /** ԃtB^p[^̃ItZbgl */
    uint32_t  hsv_hls_sel;                  /** HSVAHLSϊH̏o̓tH[}bg */
    uint32_t  hgm_invalidate;               /** qXgOo͖ */
    _Bool     hgm_bmu;                      /** qXgÕobt@Ǘjbggp̗LtO */
    uint32_t  hgm_exc;                      /** qXgOv̍ŕplAőŏlo̒lO@ */
    uint32_t  hgm_thr;                      /** qXgOv̍őŏl臒l */
    uint32_t  hgm_shift;                    /** qXgOvZf[^õ͎f[^Vtg */
    uint32_t  hgm_vinc;                     /** qXgOvZ̐Ԉݒ */
    uint32_t  hgm_hinc;                     /** qXgOvZ̐Ԉݒ */
    uint32_t  hgm_vsize;                    /** qXgOvTCY */
    uint32_t  hgm_hsize;                    /** qXgOvTCY */
    uint32_t  hgm_vpos;                     /** qXgOvJnW */
    uint32_t  hgm_hpos;                     /** qXgOvW */
    uint32_t  hgm_addr;                     /** qXgOo͐AhX */
    uint32_t  thr_limit;                    /** 臒l̏o͒l~bgݒ */
    _Bool     thr_spf1_enable;              /** 臒l1bitԃtB^̗LtO */
    _Bool     thr_msk_enable;               /** 臒l̉摜؂o̗LtO */
    _Bool     thr_csc2_enable;              /** 臒l̐Fԕϊ2̗LtO */
    _Bool     thr_hsv2_enable;              /** 臒lHSVAHLSϊ2̗LtO */
    _Bool     thr_thr8bit_enable;           /** 臒l8bit臒l̗LtO */
    uint32_t  thr_out_sel;                  /** 臒l̏o̓ZN^̃\[XI */
    uint32_t  thr_clut8_sel;                /** 臒lCLUT8o͂̃\[XI */
    uint32_t  thr_hsv_hls_sel;              /** 臒lHLSAHSVϊH̏o̓tH[}bgI */
    uint32_t  thr_csc2_limit;               /** 臒l̐Fԕϊ2̏o͒l~bg */
    uint32_t  thr_csc2_shift;               /** 臒l̐Fԕϊ2̉Zõ͎Vtg */
    int32_t   thr_csc2_matrix[3][4];        /** 臒l̐Fԕϊ2Matrixl */
    uint32_t  thr_msk_h[3];                 /** 臒l̃}XN0`2Hl */
    uint32_t  thr_msk_l[3];                 /** 臒l̃}XN0`2Ll */
    uint32_t  thr_msk_x[3];                 /** 臒l̃}XN0`2Xl */
    uint32_t  thr_msk_hmax[3];              /** 臒l̃}XN0`2HMAXl */
    uint32_t  thr_msk_hmin[3];              /** 臒l̃}XN0`2HMINl */
    uint32_t  thr_msk_lmax[3];              /** 臒l̃}XN0`2LMAXl */
    uint32_t  thr_msk_lmin[3];              /** 臒l̃}XN0`2LMINl */
    uint32_t  thr_thr8_prm_type[3];         /** 臒l8bit臒lp[^0`2̃^Cv */
    uint32_t  thr_thr8_prm_maxval[3];       /** 臒l8bit臒lp[^0`2maxValue */
    uint32_t  thr_thr8_prm_maxthr[3];       /** 臒l8bit臒lp[^0`2maxThreshold */
    uint32_t  thr_thr8_prm_minthr[3];       /** 臒l8bit臒lp[^0`2minThreshold */
    uint32_t  thr_thr1_h;                   /** 臒l1bit臒lHl */
    uint32_t  thr_thr1_l;                   /** 臒l1bit臒lLl */
    uint32_t  thr_thr1_x;                   /** 臒l1bit臒lXl */
    uint32_t  thr_thr1_hmax;                /** 臒l1bit臒lHMAXl */
    uint32_t  thr_thr1_hmin;                /** 臒l1bit臒lHMINl */
    uint32_t  thr_thr1_lmax;                /** 臒l1bit臒lLMAXl */
    uint32_t  thr_thr1_lmin;                /** 臒l1bit臒lLMINl */
    int32_t   thr_spf1_coeff[9];            /** 臒l1bitԃtB^̌W */
    int32_t   thr_spf1_thr;                 /** 臒l1bitԃtB^臒l */
    uint32_t  lbl_valid;                    /** xȌo͗L */
    uint32_t  lbl_invalid;                  /** xȌo͖ */
    uint32_t  lbl_connect;                  /** xO̘A@ */
    _Bool     lbl_bmu;                      /** xÕobt@Ǘjbggp̗LtO */
    uint32_t  lbl_flush_thr;                /** xO̕te[ũtbVs臒l */
    uint32_t  lbl_maxid;                    /** xO̕te[uID̍ől */
    uint32_t  lbl_vsize;                    /** xO̐TCY */
    uint32_t  lbl_hsize;                    /** xO̐TCY */
    uint32_t  lbl_vpos;                     /** xOJnʒu̐W */
    uint32_t  lbl_hpos;                     /** xOJnʒu̐W */
    uint32_t  lbl_addr;                     /** xOto͐AhX */
    uint32_t  ifc_scan;                     /** t[ԉZ̃t[@ */
    uint32_t  ifc_limit;                    /** t[ԉZ̏o͒l̃~bg */
    uint32_t  ifc_slave_src;                /** t[ԉZ̃X[u̓\[X̑I */
    uint32_t  ifc_operation;                /** t[ԉZ̉Z@ */
    uint32_t  ifc_slave_shift;              /** t[ԉZ̃X[u͂̃QCZ̃Vtg */
    uint32_t  ifc_master_shift;             /** t[ԉZ̃}X^͂̃QCZ̃Vtg */
    int32_t   ifc_slave_gain;               /** t[ԉZ̃X[u͂̃QC */
    int32_t   ifc_master_gain;              /** t[ԉZ̃}X^͂̃QC */
    PGPMGRCALLBACK intr_input_func;         /** ͊荞݂̃R[obN֐ */
    PGPMGRCALLBACK intr_output_func;        /** o͊荞݂̃R[obN֐ */
    PGPMGRCALLBACK intr_done_func;          /** pCvC荞݂̃R[obN֐ */
    PGPMGRCALLBACK intr_vram_error_func;    /** VRAMo̓G[荞݂̃R[obN֐ */
    PGPMGRCALLBACK intr_lbl_error_func;     /** xOG[荞݂̃R[obN֐ */
    PGPMGRCALLBACK intr_hgm_error_func;     /** qXgOG[荞݂̃R[obN֐ */
    PGPMGRCALLBACK intr_nd_func;            /** Mo荞݂̃R[obN֐ */
    PGPMGRCALLBACK intr_ifc_ovf_func;       /** t[ԉZI[o[t[荞݂̃R[obN֐ */
    PGPMGRCALLBACK intr_input_line_func;    /** ̓C荞݂̃R[obN֐ */
    PGPMGRCALLBACK intr_output_line_func;   /** o̓C荞݂̃R[obN֐ */
    PGPMGRCALLBACK intr_lbl_done_func;      /** xO荞݂̃R[obN֐ */
    PGPMGRCALLBACK intr_hgm_done_func;      /** qXgO荞݂̃R[obN֐ */
} AG903_PgpMgrPipelineHandle;


/**
 * VRAM̓nh
 */
typedef struct _AG903_PgpMgrVRAMInputHandle {
    uint32_t  id;                           /** VRAM̓nhʂׂID */
    uint32_t  ref_cnt;                      /** VRAM̓nh̃t@XJEg */
    int32_t   port_no;                      /** 蓖ĂĂVRAM̓|[g̔ԍ */
    _Bool     is_used;                      /** nh擾Ԃł邱ƂmFtO */
    _Bool     is_dirty;                     /** VRAM̓nhɑ΂ݒ肪ύXꂽԂł邱Ƃ𔻒肷tO */
    _Bool     is_config_dirty[AG903_PGP_MGR_CONFIG_VI_DIRTY_NUM];   /** VRAM̓nhɑ΂Config̐ݒ֐ɂp[^XVꂽƂǗtO */
    _Bool     fai_enable;                   /** t[ẗ̗XLbv@\̗LtO */
    uint32_t  bmu;                          /** obt@Ǘjbg̑I */
    uint32_t  scan;                         /** t[@ */
    uint32_t  dim;                          /** AhX̎w@ */
    _Bool     vram_word_swap_enable;        /** [hf[^̃XbvI */
    _Bool     vram_hword_swap_enable;       /** n[t[hf[^̃XbvI */
    _Bool     vram_1bit_swap_enable;        /** 1bitf[^̃XbvI */
    _Bool     vram_4bit_swap_enable;        /** 4bitf[^̃XbvI */
    uint32_t  md;                           /** C^[Xt[̓ǂݏo@ */
    uint32_t  format;                       /** VRAM̊i[tH[}bg */
    uint32_t  div;                          /** o͊Ԉ΂ */
    uint32_t  valid;                        /** o͗L */
    uint32_t  invalid;                      /** o͖ */
    uint32_t  addr;                         /** x[XAhX */
    uint32_t  stride;                       /** 2AhXVRAMoCgTCY */
    uint32_t  h_pulse_width;                /** MpX */
    uint32_t  h_front_porch;                /** tg|[` */
    uint32_t  h_back_porch;                 /** obN|[` */
    uint32_t  h_frame_size;                 /** t[TCY */
    _Bool     adjust_even_vbp;              /** C^[X[hłEvent[VBP */
    _Bool     adjust_even_vfp;              /** C^[X[hłEvent[VFP */
    _Bool     adjust_odd_vbp;               /** C^[X[hłOddt[VBP */
    _Bool     adjust_odd_vfp;               /** C^[X[hłOddt[VFP */
    uint32_t  v_pulse_width;                /** MpX */
    uint32_t  v_front_porch;                /** tg|[` */
    uint32_t  v_back_porch;                 /** tg|[` */
    uint32_t  v_frame_size;                 /** t[TCY */
    _Bool     adjust_odd_vsize;             /** C^[X[hłOddt[VSIZE */
} AG903_PgpMgrVRAMInputHandle;


/**
 * t[ԉZnh
 */
typedef struct _AG903_PgpMgrFrameCalcHandle {
    uint32_t             id;                    /** t[ԉZnhʂׂID */
    _Bool                is_used;               /** nh擾Ԃł邱ƂmFtO */
    AG903_PgpMgrPipelineHandle *master_handle;  /** }X^̃nh */
    void                 *slave_handle;         /** X[ũnh */
    _Bool                slave_pipeline;        /** X[upCvCnhł邩mF邽߂̃tO */
} AG903_PgpMgrFrameCalcHandle;


/* WCubv}N`܂ */
#ifndef AG903_PGP_COMMON_MALLOC
/** 
 * @brief       ImۃC^tF[X
 * @param       size [in] mۂTCY
 * @return      mۂAhX
 * @description ׃O͎Ƀmۂs܂.<p>
 * @note        mۂ, 8oCgEɔzuĂKv܂.
 * @seealso     AG903_PgpMgrAnalyzeLabelingTable ag903_pgp_common_free
 */
extern void *ag903_pgp_common_malloc(uint32_t size);
/** mۊ֐` */
#define AG903_PGP_COMMON_MALLOC ag903_pgp_common_malloc
#endif

#ifndef AG903_PGP_COMMON_FREE
/** @brief       IC^tF[X
 *  @description ׃O͎ɊmۂJ܂.<p>
 *               W֐free̓҂Ă܂.
 *  @seealso     AG903_PgpMgrAnalyzeLabelingTable ag903_pgp_common_malloc
 */
extern void ag903_pgp_common_free(void *ptr);
/** ֐` */
#define AG903_PGP_COMMON_FREE   ag903_pgp_common_free
#endif

#ifndef AG903_PGP_MGR_TS_FORCE_DISABLE
int32_t AG903_PgpMgrEnableTimeSharingPipeline(_Bool enable);
#endif
int32_t AG903_PgpMgrGetPipelineHandle(int32_t num, AG903_PgpMgrPipelineHandle **handles);
int32_t AG903_PgpMgrReleasePipelineHandle(AG903_PgpMgrPipelineHandle *handle);
int32_t AG903_PgpMgrAssignPipeline(void *handle);
int32_t AG903_PgpMgrForceAssignPipeline(void *handle, uint32_t pipeline);
int32_t AG903_PgpMgrReleaseAssignment(void *handle);
int32_t AG903_PgpMgrCheckFunctionValidation(AG903_PgpMgrPipelineHandle *handle, uint32_t pipeline);
int32_t AG903_PgpMgrExecPipeline(void *handle, uint32_t cmd);
int32_t AG903_PgpMgrSetIntrCallbackFunc(AG903_PgpMgrPipelineHandle *handle, uint32_t type, void (*func)(int32_t id, void *handle));
int32_t AG903_PgpMgrSetConfigIntrCtrl(AG903_PgpMgrPipelineHandle *handle, uint32_t input_field, uint32_t input_fcnt, uint32_t input_line, uint32_t output_field, uint32_t output_fcnt, uint32_t output_line);
int32_t AG903_PgpMgrGetPipelineStatus(AG903_PgpMgrPipelineHandle *handle, uint32_t *blank, _Bool *is_vram_out, uint32_t *queue_cnt, uint32_t *sub_status, uint32_t *status);
int32_t AG903_PgpMgrEnableParamTrigCtrl(AG903_PgpMgrPipelineHandle *handle, _Bool vlinei_enable, _Bool vsynci_enable, _Bool vlineo_enable, _Bool vsynco_enable);
int32_t AG903_PgpMgrSetConfigTrigCtrl(AG903_PgpMgrPipelineHandle *handle, uint32_t input_field, uint32_t input_fcnt, uint32_t input_line, uint32_t output_field, uint32_t output_fcnt, uint32_t output_line);
int32_t AG903_PgpMgrSetParamInputHSyncDelay(AG903_PgpMgrPipelineHandle *handle, uint32_t h_delay);
int32_t AG903_PgpMgrSetParamInputMode(AG903_PgpMgrPipelineHandle *handle, uint32_t md);
int32_t AG903_PgpMgrSetParamInputTimeCLK(AG903_PgpMgrPipelineHandle *handle, uint32_t tick);
int32_t AG903_PgpMgrSetConfigInputTrigChannel(AG903_PgpMgrPipelineHandle *handle, uint32_t timer_ch);
int32_t AG903_PgpMgrSetInputPort(AG903_PgpMgrPipelineHandle *handle, void *src);
int32_t AG903_PgpMgrSetParamInputFormat(AG903_PgpMgrPipelineHandle *handle, uint32_t format);
int32_t AG903_PgpMgrSetParamInputSize(AG903_PgpMgrPipelineHandle *handle, uint32_t vsize, uint32_t hsize);
int32_t AG903_PgpMgrSetParamInputPosition(AG903_PgpMgrPipelineHandle *handle, uint32_t vpos, uint32_t hpos);
int32_t AG903_PgpMgrSetParamInputScan(AG903_PgpMgrPipelineHandle *handle, uint32_t scan, _Bool epos,_Bool opos);
int32_t AG903_PgpMgrSetConfigOutputFramePadding(AG903_PgpMgrPipelineHandle *handle, uint32_t pad);
int32_t AG903_PgpMgrSetConfigOutputLimit(AG903_PgpMgrPipelineHandle *handle, uint32_t limit);
int32_t AG903_PgpMgrEnableConfigOutputFrameInfo(AG903_PgpMgrPipelineHandle *handle, _Bool enable);
int32_t AG903_PgpMgrEnableConfigOutputDither(AG903_PgpMgrPipelineHandle *handle, _Bool enable);
int32_t AG903_PgpMgrSetParamOutputScan(AG903_PgpMgrPipelineHandle *handle, uint32_t scan);
int32_t AG903_PgpMgrSetParamOutputAddrDim(AG903_PgpMgrPipelineHandle *handle, uint32_t dim);
int32_t AG903_PgpMgrSetConfigOutputDataSwap(AG903_PgpMgrPipelineHandle *handle, _Bool word, _Bool hword, _Bool four_bit, _Bool one_bit);
int32_t AG903_PgpMgrSetConfigOutputInterlaceFrame(AG903_PgpMgrPipelineHandle *handle, uint32_t frame_save);
int32_t AG903_PgpMgrSetParamOutputBMU(AG903_PgpMgrPipelineHandle *handle, uint32_t bmu);
int32_t AG903_PgpMgrSetParamOutputFormat(AG903_PgpMgrPipelineHandle *handle, uint32_t format);
int32_t AG903_PgpMgrEnableConfigOutputColorMask(AG903_PgpMgrPipelineHandle *handle, _Bool red, _Bool green, _Bool blue);
int32_t AG903_PgpMgrSetConfigOutputBaseAddr(AG903_PgpMgrPipelineHandle *handle, void *addr);
int32_t AG903_PgpMgrSetParamOutputStride(AG903_PgpMgrPipelineHandle *handle, uint32_t stride);
int32_t AG903_PgpMgrGetFrameInfo(AG903_PgpMgrPipelineHandle *handle, uint32_t *tmstmp, uint32_t *field, uint32_t *port, uint32_t *fnum);
int32_t AG903_PgpMgrSetParamFrameCalcOrder(AG903_PgpMgrPipelineHandle *handle, uint32_t order);
int32_t AG903_PgpMgrEnableParamThresholdOp(AG903_PgpMgrPipelineHandle *handle, _Bool enable);
int32_t AG903_PgpMgrEnableParamDGC(AG903_PgpMgrPipelineHandle *handle, _Bool enable);
int32_t AG903_PgpMgrEnableParamHSV(AG903_PgpMgrPipelineHandle *handle, _Bool enable);
int32_t AG903_PgpMgrEnableParamSpatialFilter(AG903_PgpMgrPipelineHandle *handle, _Bool enable);
int32_t AG903_PgpMgrEnableParamScaling(AG903_PgpMgrPipelineHandle *handle, _Bool enable);
int32_t AG903_PgpMgrEnableParamColorSpace(AG903_PgpMgrPipelineHandle *handle, _Bool enable);
int32_t AG903_PgpMgrEnableParamNRF(AG903_PgpMgrPipelineHandle *handle, _Bool enable);
int32_t AG903_PgpMgrEnableParamHistogram(AG903_PgpMgrPipelineHandle *handle, _Bool enable);
int32_t AG903_PgpMgrEnableParamLabeling(AG903_PgpMgrPipelineHandle *handle, _Bool enable);
int32_t AG903_PgpMgrSetConfigIPConversion(AG903_PgpMgrPipelineHandle *handle, uint32_t limit, uint32_t blky, uint32_t blkc);
int32_t AG903_PgpMgrSetConfigColorSpace(AG903_PgpMgrPipelineHandle *handle, uint32_t limit, uint32_t shift, int32_t mtx[3][4]);
int32_t AG903_PgpMgrSetConfigPresetColorSpace(AG903_PgpMgrPipelineHandle *handle, uint32_t format);
int32_t AG903_PgpMgrSetConfigScaling(AG903_PgpMgrPipelineHandle *handle, uint32_t limit, uint32_t filter, uint32_t nmr_v, uint32_t dnm_v, uint32_t nmr_h, uint32_t dnm_h);
int32_t AG903_PgpMgrSetConfigSpatialFilter(AG903_PgpMgrPipelineHandle *handle, uint32_t shift, uint32_t border, uint32_t border_red, uint32_t border_green, uint32_t border_blue, int32_t coeff[9], int32_t offset);
int32_t AG903_PgpMgrSetConfigHSVHLSConversion(AG903_PgpMgrPipelineHandle *handle, uint32_t sel);
int32_t AG903_PgpMgrExecHistogram(AG903_PgpMgrPipelineHandle *handle, uint32_t cmd);
int32_t AG903_PgpMgrSetConfigHistogramParameter(AG903_PgpMgrPipelineHandle *handle, uint32_t inv, uint32_t exc, uint32_t thr, uint32_t shift, uint32_t v_inc, uint32_t h_inc);
int32_t AG903_PgpMgrSetConfigHistogramSize(AG903_PgpMgrPipelineHandle *handle, uint32_t vsize, uint32_t hsize);
int32_t AG903_PgpMgrSetConfigHistogramPosition(AG903_PgpMgrPipelineHandle *handle, uint32_t vpos, uint32_t hpos);
int32_t AG903_PgpMgrSetConfigHistogramBaseAddr(AG903_PgpMgrPipelineHandle *handle, void *addr);
int32_t AG903_PgpMgrEnableParamHistogramBMU(AG903_PgpMgrPipelineHandle *handle, _Bool enable);
int32_t AG903_PgpMgrGetHistogramParameter(AG903_PgpMgrPipelineHandle *handle, uint32_t *most_r, uint32_t *max_r, uint32_t *min_r, uint32_t *most_g, uint32_t *max_g, uint32_t *min_g, uint32_t *most_b, uint32_t *max_b, uint32_t *min_b);
int32_t AG903_PgpMgrGetHistogramStatus(AG903_PgpMgrPipelineHandle *handle, _Bool *is_init, _Bool *is_vram_out, _Bool *is_act, uint32_t *queue_cnt, uint32_t *exec_cmd);
int32_t AG903_PgpMgrSetConfigThreshold(AG903_PgpMgrPipelineHandle *handle, uint32_t limit, _Bool spf, _Bool mask, _Bool csc, _Bool hsv_hls, _Bool thr8, uint32_t sel_out, uint32_t sel_clut8);
int32_t AG903_PgpMgrSetConfigThresholdHSVHLSConversion(AG903_PgpMgrPipelineHandle *handle, uint32_t sel);
int32_t AG903_PgpMgrSetConfigThresholdColorSpace(AG903_PgpMgrPipelineHandle *handle, uint32_t limit, uint32_t shift, int32_t mtx[3][4]);
int32_t AG903_PgpMgrSetConfigThresholdPresetColorSpace(AG903_PgpMgrPipelineHandle *handle, uint32_t format);
int32_t AG903_PgpMgrSetConfigThresholdMask(AG903_PgpMgrPipelineHandle *handle, uint32_t ch, uint32_t h, uint32_t l, uint32_t x, uint32_t hmax, uint32_t hmin, uint32_t lmax, uint32_t lmin);
int32_t AG903_PgpMgrSetConfigThreshold8Bit(AG903_PgpMgrPipelineHandle *handle, uint32_t ch, uint32_t type, uint32_t maxval, uint32_t maxthr, uint32_t minthr);
int32_t AG903_PgpMgrSetConfigThreshold1Bit(AG903_PgpMgrPipelineHandle *handle, uint32_t h, uint32_t l, uint32_t x, uint32_t hmax, uint32_t hmin, uint32_t lmax, uint32_t lmin);
int32_t AG903_PgpMgrSetConfigThresholdSpatialFilter1Bit(AG903_PgpMgrPipelineHandle *handle, int32_t coeff[9], int32_t thr);
int32_t AG903_PgpMgrExecLabeling(AG903_PgpMgrPipelineHandle *handle, uint32_t cmd);
int32_t AG903_PgpMgrSetConfigLabelingValidTime(AG903_PgpMgrPipelineHandle *handle, uint32_t vld, uint32_t inv);
int32_t AG903_PgpMgrSetConfigLabelingParameter(AG903_PgpMgrPipelineHandle *handle, uint32_t connect, uint32_t flush_thr, uint32_t max_id);
int32_t AG903_PgpMgrSetConfigLabelingSize(AG903_PgpMgrPipelineHandle *handle, uint32_t vsize, uint32_t hsize);
int32_t AG903_PgpMgrSetConfigLabelingPosition(AG903_PgpMgrPipelineHandle *handle, uint32_t vpos, uint32_t hpos);
int32_t AG903_PgpMgrSetConfigLabelingBaseAddr(AG903_PgpMgrPipelineHandle *handle, void *addr);
int32_t AG903_PgpMgrEnableParamLabelingBMU(AG903_PgpMgrPipelineHandle *handle, _Bool enable);
int32_t AG903_PgpMgrGetLabelingStatus(AG903_PgpMgrPipelineHandle *handle, uint32_t *id, _Bool *is_vram_out, _Bool *is_act, uint32_t *queue_cnt, uint32_t *exec_cmd);
int32_t AG903_PgpMgrAnalyzeLabelingTable(void *src, uint32_t tbl_num, void **dst);
int32_t AG903_PgpMgrReleaseLabelingTable(void *dst);
int32_t AG903_PgpMgrGetFrameCalcHandle(AG903_PgpMgrFrameCalcHandle **handle, AG903_PgpMgrPipelineHandle *master, void *slave);
int32_t AG903_PgpMgrReleaseFrameCalcHandle(AG903_PgpMgrFrameCalcHandle *handle);
int32_t AG903_PgpMgrSetConfigFrameCalcParameter(AG903_PgpMgrFrameCalcHandle *handle, uint32_t scan, uint32_t limit, uint32_t slave_src, uint32_t operation);
int32_t AG903_PgpMgrSetConfigFrameCalcGain(AG903_PgpMgrFrameCalcHandle *handle, int32_t master_gain, int32_t slave_gain, uint32_t master_shift, uint32_t slave_shift);
int32_t AG903_PgpMgrGetVRAMInputHandle(int32_t num, AG903_PgpMgrVRAMInputHandle **handles);
int32_t AG903_PgpMgrReleaseVRAMInputHandle(AG903_PgpMgrVRAMInputHandle *handle);
int32_t AG903_PgpMgrExecVRAMInput(AG903_PgpMgrVRAMInputHandle *handle, uint32_t cmd);
int32_t AG903_PgpMgrGetVRAMStatus(AG903_PgpMgrVRAMInputHandle *handle, _Bool *is_vram_out, uint32_t *queue_cnt, uint32_t *exec_cmd);
int32_t AG903_PgpMgrSetParamVRAMInputBMU(AG903_PgpMgrVRAMInputHandle *handle, uint32_t bmu);
int32_t AG903_PgpMgrSetParamVRAMInputScan(AG903_PgpMgrVRAMInputHandle *handle, uint32_t scan);
int32_t AG903_PgpMgrSetParamVRAMInputAddrDim(AG903_PgpMgrVRAMInputHandle *handle, uint32_t dim);
int32_t AG903_PgpMgrSetConfigVRAMDataSwap(AG903_PgpMgrVRAMInputHandle *handle, _Bool word, _Bool hword, _Bool four_bit, _Bool one_bit);
int32_t AG903_PgpMgrSetConfigVRAMInterlaceFrame(AG903_PgpMgrVRAMInputHandle *handle, uint32_t frame_read, _Bool fai);
int32_t AG903_PgpMgrSetConfigVRAMValidTime(AG903_PgpMgrVRAMInputHandle *handle, uint32_t div, uint32_t vld, uint32_t inv);
int32_t AG903_PgpMgrSetParamVRAMFormat(AG903_PgpMgrVRAMInputHandle *handle, uint32_t format);
int32_t AG903_PgpMgrSetConfigVRAMBaseAddr(AG903_PgpMgrVRAMInputHandle *handle, void *addr);
int32_t AG903_PgpMgrSetParamVRAMStride(AG903_PgpMgrVRAMInputHandle *handle, uint32_t stride);
int32_t AG903_PgpMgrSetParamVRAMSyncSignal(AG903_PgpMgrVRAMInputHandle *handle, uint32_t h_pw, uint32_t h_fp, uint32_t h_bp, uint32_t v_pw, uint32_t v_fp, uint32_t v_bp);
int32_t AG903_PgpMgrSetParamVRAMSize(AG903_PgpMgrVRAMInputHandle *handle, uint32_t h_size, uint32_t v_size);
int32_t AG903_PgpMgrAdjustVRAMFrame(AG903_PgpMgrVRAMInputHandle *handle, _Bool e_vbp, _Bool e_vfp, _Bool o_vbp, _Bool o_vfp, _Bool o_vsize);
int32_t AG903_PgpMgrCheckVRAMParameter(AG903_PgpMgrVRAMInputHandle *vram, AG903_PgpMgrPipelineHandle *pipeline);
int32_t AG903_PgpMgrSetJPEG(AG903_PgpMgrPipelineHandle *handle);
int32_t AG903_PgpMgrEnableJPEG(_Bool enable);
int32_t AG903_PgpMgrGetDGCLUT(uint8_t red[256], uint8_t green[256], uint8_t blue[256], AG903_PgpMgrDGCLookupTable **table);
int32_t AG903_PgpMgrReleaseDGCLUT(AG903_PgpMgrDGCLookupTable *table);
int32_t AG903_PgpMgrSetConfigDGCLUT(AG903_PgpMgrPipelineHandle *pipeline, AG903_PgpMgrDGCLookupTable *dgc_lut);


#ifdef __cplusplus
}
#endif


#endif

