/**
 * @brief           IIC Register Definition
 * @author          AXELL CORPORATION
 * @description     IIC Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_IIC_REGMAP_H_
#define _AG903_IIC_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** IICn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  CR;

        struct {
            __IO uint32_t  I2C_RST                        :  1;
            __IO uint32_t  I2C_EN                         :  1;
            __IO uint32_t  SCL_EN                         :  1;
            __IO uint32_t  GC_EN                          :  1;
            __IO uint32_t  START                          :  1;
            __IO uint32_t  STOP                           :  1;
            __IO uint32_t  NACK                           :  1;
            __IO uint32_t  TB_EN                          :  1;
            __IO uint32_t  DTI_EN                         :  1;
            __IO uint32_t  DRI_EN                         :  1;
            __IO uint32_t  BERRI_EN                       :  1;
            __IO uint32_t  STOPI_EN                       :  1;
            __IO uint32_t  SAMI_EN                        :  1;
            __IO uint32_t  ALI_EN                         :  1;
            __IO uint32_t  STARTI_EN                      :  1;
            __IO uint32_t  SCL_LOW                        :  1;
            __IO uint32_t  SDA_LOW                        :  1;
            __IO uint32_t  Test_bit                       :  1;
        } CR_bits;
    };

    union {
        __I  uint32_t  SR;

        struct {
            __I  uint32_t  RW                             :  1;
            __I  uint32_t  ACK                            :  1;
            __I  uint32_t  I2CB                           :  1;
            __I  uint32_t  BB                             :  1;
            __I  uint32_t  DT                             :  1;
            __I  uint32_t  DR                             :  1;
            __I  uint32_t  BERR                           :  1;
            __I  uint32_t  STOP                           :  1;
            __I  uint32_t  SAM                            :  1;
            __I  uint32_t  GC                             :  1;
            __I  uint32_t  AL                             :  1;
            __I  uint32_t  START                          :  1;
            __I  uint32_t  SEXT                           :  1;
            __I  uint32_t  MEXT                           :  1;
            __I  uint32_t  TOUTMin                        :  1;
            __I  uint32_t  TOUTMax                        :  1;
            __I  uint32_t  ALERT                          :  1;
            __I  uint32_t  SUSPEND                        :  1;
            __I  uint32_t  RESUME                         :  1;
            __I  uint32_t  ARA                            :  1;
            __I  uint32_t  DDA                            :  1;
            __I  uint32_t  SAL                            :  1;
        } SR_bits;
    };

    union {
        __IO uint32_t  CDR;

        struct {
            __IO uint32_t  COUNT                          : 18;
        } CDR_bits;
    };

    union {
        __IO uint32_t  DR;

        struct {
            __IO uint32_t  DR                             :  8;
        } DR_bits;
    };

    union {
        __IO uint32_t  SAR;

        struct {
            __IO uint32_t  SAR                            :  7;
            __IO uint32_t  SAR10                          :  3;
                 uint32_t                                 : 21;
            __IO uint32_t  EN10                           :  1;
        } SAR_bits;
    };

    union {
        __IO uint32_t  TGSR;

        struct {
            __IO uint32_t  TSR                            : 10;
            __IO uint32_t  GSR                            :  4;
        } TGSR_bits;
    };

    union {
        __I  uint32_t  BMR;

        struct {
            __I  uint32_t  SDAin                          :  1;
            __I  uint32_t  SCLin                          :  1;
        } BMR_bits;
    };

    __I  uint32_t  RESERVED1[5];

    union {
        __I  uint32_t  Revision;
    };

    union {
        __I  uint32_t  Feature;

        struct {
            __I  uint32_t  SMBUS                          :  1;
        } Feature_bits;
    };

/* DOM-IGNORE-END */
}AG903_IICn_Type;

#define AG903_IICn(ch)                           ((volatile AG903_IICn_Type *)(AG903_IIC0_BASE + 0x100000 * ch))         /** IICn Base Address (n=0..1) */
#define AG903_IICn_CR(ch)                        AG903_IICn(ch)->CR                                                      /** IICnCR Address (n=0..1) */
#define AG903_IICn_SR(ch)                        AG903_IICn(ch)->SR                                                      /** IICnSR Address (n=0..1) */
#define AG903_IICn_CDR(ch)                       AG903_IICn(ch)->CDR                                                     /** IICnCDR Address (n=0..1) */
#define AG903_IICn_DR(ch)                        AG903_IICn(ch)->DR                                                      /** IICnDR Address (n=0..1) */
#define AG903_IICn_SAR(ch)                       AG903_IICn(ch)->SAR                                                     /** IICnSAR Address (n=0..1) */
#define AG903_IICn_TGSR(ch)                      AG903_IICn(ch)->TGSR                                                    /** IICnTGSR Address (n=0..1) */
#define AG903_IICn_BMR(ch)                       AG903_IICn(ch)->BMR                                                     /** IICnBMR Address (n=0..1) */
#define AG903_IICn_Revision(ch)                  AG903_IICn(ch)->Revision                                                /** IICnRevision Address (n=0..1) */
#define AG903_IICn_Feature(ch)                   AG903_IICn(ch)->Feature                                                 /** IICnFeature Address (n=0..1) */

#define AG903_IIC0                               ((volatile AG903_IICn_Type *) AG903_IIC0_BASE)                          /** IICn Base Address */
#define AG903_IIC1                               ((volatile AG903_IICn_Type *) AG903_IIC1_BASE)                          /** IICn Base Address */


#define AG903_IICn_CR_I2C_RST_POS                          0                                                             /** IICnCR I2C_RST-bit position */
#define AG903_IICn_CR_I2C_RST_MSK                          (0x1UL << AG903_IICn_CR_I2C_RST_POS)                          /** IICnCR I2C_RST-bit mask */
#define AG903_IICn_CR_I2C_EN_POS                           1                                                             /** IICnCR I2C_EN-bit position */
#define AG903_IICn_CR_I2C_EN_MSK                           (0x1UL << AG903_IICn_CR_I2C_EN_POS)                           /** IICnCR I2C_EN-bit mask */
#define AG903_IICn_CR_SCL_EN_POS                           2                                                             /** IICnCR SCL_EN-bit position */
#define AG903_IICn_CR_SCL_EN_MSK                           (0x1UL << AG903_IICn_CR_SCL_EN_POS)                           /** IICnCR SCL_EN-bit mask */
#define AG903_IICn_CR_GC_EN_POS                            3                                                             /** IICnCR GC_EN-bit position */
#define AG903_IICn_CR_GC_EN_MSK                            (0x1UL << AG903_IICn_CR_GC_EN_POS)                            /** IICnCR GC_EN-bit mask */
#define AG903_IICn_CR_START_POS                            4                                                             /** IICnCR START-bit position */
#define AG903_IICn_CR_START_MSK                            (0x1UL << AG903_IICn_CR_START_POS)                            /** IICnCR START-bit mask */
#define AG903_IICn_CR_STOP_POS                             5                                                             /** IICnCR STOP-bit position */
#define AG903_IICn_CR_STOP_MSK                             (0x1UL << AG903_IICn_CR_STOP_POS)                             /** IICnCR STOP-bit mask */
#define AG903_IICn_CR_NACK_POS                             6                                                             /** IICnCR NACK-bit position */
#define AG903_IICn_CR_NACK_MSK                             (0x1UL << AG903_IICn_CR_NACK_POS)                             /** IICnCR NACK-bit mask */
#define AG903_IICn_CR_TB_EN_POS                            7                                                             /** IICnCR TB_EN-bit position */
#define AG903_IICn_CR_TB_EN_MSK                            (0x1UL << AG903_IICn_CR_TB_EN_POS)                            /** IICnCR TB_EN-bit mask */
#define AG903_IICn_CR_DTI_EN_POS                           8                                                             /** IICnCR DTI_EN-bit position */
#define AG903_IICn_CR_DTI_EN_MSK                           (0x1UL << AG903_IICn_CR_DTI_EN_POS)                           /** IICnCR DTI_EN-bit mask */
#define AG903_IICn_CR_DRI_EN_POS                           9                                                             /** IICnCR DRI_EN-bit position */
#define AG903_IICn_CR_DRI_EN_MSK                           (0x1UL << AG903_IICn_CR_DRI_EN_POS)                           /** IICnCR DRI_EN-bit mask */
#define AG903_IICn_CR_BERRI_EN_POS                         10                                                            /** IICnCR BERRI_EN-bit position */
#define AG903_IICn_CR_BERRI_EN_MSK                         (0x1UL << AG903_IICn_CR_BERRI_EN_POS)                         /** IICnCR BERRI_EN-bit mask */
#define AG903_IICn_CR_STOPI_EN_POS                         11                                                            /** IICnCR STOPI_EN-bit position */
#define AG903_IICn_CR_STOPI_EN_MSK                         (0x1UL << AG903_IICn_CR_STOPI_EN_POS)                         /** IICnCR STOPI_EN-bit mask */
#define AG903_IICn_CR_SAMI_EN_POS                          12                                                            /** IICnCR SAMI_EN-bit position */
#define AG903_IICn_CR_SAMI_EN_MSK                          (0x1UL << AG903_IICn_CR_SAMI_EN_POS)                          /** IICnCR SAMI_EN-bit mask */
#define AG903_IICn_CR_ALI_EN_POS                           13                                                            /** IICnCR ALI_EN-bit position */
#define AG903_IICn_CR_ALI_EN_MSK                           (0x1UL << AG903_IICn_CR_ALI_EN_POS)                           /** IICnCR ALI_EN-bit mask */
#define AG903_IICn_CR_STARTI_EN_POS                        14                                                            /** IICnCR STARTI_EN-bit position */
#define AG903_IICn_CR_STARTI_EN_MSK                        (0x1UL << AG903_IICn_CR_STARTI_EN_POS)                        /** IICnCR STARTI_EN-bit mask */
#define AG903_IICn_CR_SCL_LOW_POS                          15                                                            /** IICnCR SCL_LOW-bit position */
#define AG903_IICn_CR_SCL_LOW_MSK                          (0x1UL << AG903_IICn_CR_SCL_LOW_POS)                          /** IICnCR SCL_LOW-bit mask */
#define AG903_IICn_CR_SDA_LOW_POS                          16                                                            /** IICnCR SDA_LOW-bit position */
#define AG903_IICn_CR_SDA_LOW_MSK                          (0x1UL << AG903_IICn_CR_SDA_LOW_POS)                          /** IICnCR SDA_LOW-bit mask */
#define AG903_IICn_CR_Test_bit_POS                         17                                                            /** IICnCR Test_bit-bit position */
#define AG903_IICn_CR_Test_bit_MSK                         (0x1UL << AG903_IICn_CR_Test_bit_POS)                         /** IICnCR Test_bit-bit mask */

#define AG903_IICn_SR_RW_POS                               0                                                             /** IICnSR RW-bit position */
#define AG903_IICn_SR_RW_MSK                               (0x1UL << AG903_IICn_SR_RW_POS)                               /** IICnSR RW-bit mask */
#define AG903_IICn_SR_ACK_POS                              1                                                             /** IICnSR ACK-bit position */
#define AG903_IICn_SR_ACK_MSK                              (0x1UL << AG903_IICn_SR_ACK_POS)                              /** IICnSR ACK-bit mask */
#define AG903_IICn_SR_I2CB_POS                             2                                                             /** IICnSR I2CB-bit position */
#define AG903_IICn_SR_I2CB_MSK                             (0x1UL << AG903_IICn_SR_I2CB_POS)                             /** IICnSR I2CB-bit mask */
#define AG903_IICn_SR_BB_POS                               3                                                             /** IICnSR BB-bit position */
#define AG903_IICn_SR_BB_MSK                               (0x1UL << AG903_IICn_SR_BB_POS)                               /** IICnSR BB-bit mask */
#define AG903_IICn_SR_DT_POS                               4                                                             /** IICnSR DT-bit position */
#define AG903_IICn_SR_DT_MSK                               (0x1UL << AG903_IICn_SR_DT_POS)                               /** IICnSR DT-bit mask */
#define AG903_IICn_SR_DR_POS                               5                                                             /** IICnSR DR-bit position */
#define AG903_IICn_SR_DR_MSK                               (0x1UL << AG903_IICn_SR_DR_POS)                               /** IICnSR DR-bit mask */
#define AG903_IICn_SR_BERR_POS                             6                                                             /** IICnSR BERR-bit position */
#define AG903_IICn_SR_BERR_MSK                             (0x1UL << AG903_IICn_SR_BERR_POS)                             /** IICnSR BERR-bit mask */
#define AG903_IICn_SR_STOP_POS                             7                                                             /** IICnSR STOP-bit position */
#define AG903_IICn_SR_STOP_MSK                             (0x1UL << AG903_IICn_SR_STOP_POS)                             /** IICnSR STOP-bit mask */
#define AG903_IICn_SR_SAM_POS                              8                                                             /** IICnSR SAM-bit position */
#define AG903_IICn_SR_SAM_MSK                              (0x1UL << AG903_IICn_SR_SAM_POS)                              /** IICnSR SAM-bit mask */
#define AG903_IICn_SR_GC_POS                               9                                                             /** IICnSR GC-bit position */
#define AG903_IICn_SR_GC_MSK                               (0x1UL << AG903_IICn_SR_GC_POS)                               /** IICnSR GC-bit mask */
#define AG903_IICn_SR_AL_POS                               10                                                            /** IICnSR AL-bit position */
#define AG903_IICn_SR_AL_MSK                               (0x1UL << AG903_IICn_SR_AL_POS)                               /** IICnSR AL-bit mask */
#define AG903_IICn_SR_START_POS                            11                                                            /** IICnSR START-bit position */
#define AG903_IICn_SR_START_MSK                            (0x1UL << AG903_IICn_SR_START_POS)                            /** IICnSR START-bit mask */
#define AG903_IICn_SR_SEXT_POS                             12                                                            /** IICnSR SEXT-bit position */
#define AG903_IICn_SR_SEXT_MSK                             (0x1UL << AG903_IICn_SR_SEXT_POS)                             /** IICnSR SEXT-bit mask */
#define AG903_IICn_SR_MEXT_POS                             13                                                            /** IICnSR MEXT-bit position */
#define AG903_IICn_SR_MEXT_MSK                             (0x1UL << AG903_IICn_SR_MEXT_POS)                             /** IICnSR MEXT-bit mask */
#define AG903_IICn_SR_TOUTMin_POS                          14                                                            /** IICnSR TOUTMin-bit position */
#define AG903_IICn_SR_TOUTMin_MSK                          (0x1UL << AG903_IICn_SR_TOUTMin_POS)                          /** IICnSR TOUTMin-bit mask */
#define AG903_IICn_SR_TOUTMax_POS                          15                                                            /** IICnSR TOUTMax-bit position */
#define AG903_IICn_SR_TOUTMax_MSK                          (0x1UL << AG903_IICn_SR_TOUTMax_POS)                          /** IICnSR TOUTMax-bit mask */
#define AG903_IICn_SR_ALERT_POS                            16                                                            /** IICnSR ALERT-bit position */
#define AG903_IICn_SR_ALERT_MSK                            (0x1UL << AG903_IICn_SR_ALERT_POS)                            /** IICnSR ALERT-bit mask */
#define AG903_IICn_SR_SUSPEND_POS                          17                                                            /** IICnSR SUSPEND-bit position */
#define AG903_IICn_SR_SUSPEND_MSK                          (0x1UL << AG903_IICn_SR_SUSPEND_POS)                          /** IICnSR SUSPEND-bit mask */
#define AG903_IICn_SR_RESUME_POS                           18                                                            /** IICnSR RESUME-bit position */
#define AG903_IICn_SR_RESUME_MSK                           (0x1UL << AG903_IICn_SR_RESUME_POS)                           /** IICnSR RESUME-bit mask */
#define AG903_IICn_SR_ARA_POS                              19                                                            /** IICnSR ARA-bit position */
#define AG903_IICn_SR_ARA_MSK                              (0x1UL << AG903_IICn_SR_ARA_POS)                              /** IICnSR ARA-bit mask */
#define AG903_IICn_SR_DDA_POS                              20                                                            /** IICnSR DDA-bit position */
#define AG903_IICn_SR_DDA_MSK                              (0x1UL << AG903_IICn_SR_DDA_POS)                              /** IICnSR DDA-bit mask */
#define AG903_IICn_SR_SAL_POS                              21                                                            /** IICnSR SAL-bit position */
#define AG903_IICn_SR_SAL_MSK                              (0x1UL << AG903_IICn_SR_SAL_POS)                              /** IICnSR SAL-bit mask */

#define AG903_IICn_CDR_COUNT_POS                           0                                                             /** IICnCDR COUNT-bit position */
#define AG903_IICn_CDR_COUNT_MSK                           (0x3ffffUL << AG903_IICn_CDR_COUNT_POS)                       /** IICnCDR COUNT-bit mask */

#define AG903_IICn_DR_DR_POS                               0                                                             /** IICnDR DR-bit position */
#define AG903_IICn_DR_DR_MSK                               (0xffUL << AG903_IICn_DR_DR_POS)                              /** IICnDR DR-bit mask */

#define AG903_IICn_SAR_SAR_POS                             0                                                             /** IICnSAR SAR-bit position */
#define AG903_IICn_SAR_SAR_MSK                             (0x7fUL << AG903_IICn_SAR_SAR_POS)                            /** IICnSAR SAR-bit mask */
#define AG903_IICn_SAR_SAR10_POS                           7                                                             /** IICnSAR SAR10-bit position */
#define AG903_IICn_SAR_SAR10_MSK                           (0x7UL << AG903_IICn_SAR_SAR10_POS)                           /** IICnSAR SAR10-bit mask */
#define AG903_IICn_SAR_EN10_POS                            31                                                            /** IICnSAR EN10-bit position */
#define AG903_IICn_SAR_EN10_MSK                            (0x1UL << AG903_IICn_SAR_EN10_POS)                            /** IICnSAR EN10-bit mask */

#define AG903_IICn_TGSR_TSR_POS                            0                                                             /** IICnTGSR TSR-bit position */
#define AG903_IICn_TGSR_TSR_MSK                            (0x3ffUL << AG903_IICn_TGSR_TSR_POS)                          /** IICnTGSR TSR-bit mask */
#define AG903_IICn_TGSR_GSR_POS                            10                                                            /** IICnTGSR GSR-bit position */
#define AG903_IICn_TGSR_GSR_MSK                            (0xfUL << AG903_IICn_TGSR_GSR_POS)                            /** IICnTGSR GSR-bit mask */

#define AG903_IICn_BMR_SDAin_POS                           0                                                             /** IICnBMR SDAin-bit position */
#define AG903_IICn_BMR_SDAin_MSK                           (0x1UL << AG903_IICn_BMR_SDAin_POS)                           /** IICnBMR SDAin-bit mask */
#define AG903_IICn_BMR_SCLin_POS                           1                                                             /** IICnBMR SCLin-bit position */
#define AG903_IICn_BMR_SCLin_MSK                           (0x1UL << AG903_IICn_BMR_SCLin_POS)                           /** IICnBMR SCLin-bit mask */

#define AG903_IICn_Revision_REVISION_POS                   0                                                             /** IICnRevision REVISION-bit position */
#define AG903_IICn_Revision_REVISION_MSK                   (0xffffffffUL << AG903_IICn_Revision_REVISION_POS)            /** IICnRevision REVISION-bit mask */

#define AG903_IICn_Feature_SMBUS_POS                       0                                                             /** IICnFeature SMBUS-bit position */
#define AG903_IICn_Feature_SMBUS_MSK                       (0x1UL << AG903_IICn_Feature_SMBUS_POS)                       /** IICnFeature SMBUS-bit mask */

#endif /* _AG903_IIC_REGMAP_H_ */

