/**
 * @brief           DMAC Register Definition
 * @author          AXELL CORPORATION
 * @description     DMAC Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_DMAC_REGMAP_H_
#define _AG903_DMAC_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** DMAC Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __I  uint32_t  INT;

        struct {
            __I  uint32_t  Intr                           :  8;
        } INT_bits;
    };

    union {
        __I  uint32_t  TIMECOUNT_INT;

        struct {
            __I  uint32_t  TCIntr                         :  8;
        } TIMECOUNT_INT_bits;
    };

    union {
        __O  uint32_t  TIMECOUNT_INT_CLEAR;

        struct {
            __O  uint32_t  TCIntrClr                      :  8;
        } TIMECOUNT_INT_CLEAR_bits;
    };

    union {
        __I  uint32_t  ERR_ABORT_INT;

        struct {
            __I  uint32_t  ErrIntr                        :  8;
            __I  uint32_t  WdtIntr                        :  8;
            __I  uint32_t  AbtIntr                        :  8;
        } ERR_ABORT_INT_bits;
    };

    union {
        __O  uint32_t  ERR_ABORT_INT_CLEAR;

        struct {
            __O  uint32_t  ErrIntrClr                     :  8;
            __O  uint32_t  WdtIntrClr                     :  8;
            __O  uint32_t  AbtIntrClr                     :  8;
        } ERR_ABORT_INT_CLEAR_bits;
    };

    union {
        __I  uint32_t  TIMECOUNT_STATUS;

        struct {
            __I  uint32_t  TCStatus                       :  8;
        } TIMECOUNT_STATUS_bits;
    };

    union {
        __I  uint32_t  ERR_ABORT_STATUS;

        struct {
            __I  uint32_t  ErrStatus                      :  8;
            __I  uint32_t  WdtStatus                      :  8;
            __I  uint32_t  AbtStatus                      :  8;
        } ERR_ABORT_STATUS_bits;
    };

    union {
        __IO uint32_t  CHANNEL_ENABLE;

        struct {
            __IO uint32_t  ChEnable                       :  8;
        } CHANNEL_ENABLE_bits;
    };

    union {
        __IO uint32_t  SYNC_PERI_IF;

        struct {
            __IO uint32_t  SyncDmaReq                     : 16;
        } SYNC_PERI_IF_bits;
    };

    union {
        __IO uint32_t  LOCAL_DESC_MEM_BASE;

        struct {
                 uint32_t                                 : 20;
            __IO uint32_t  LDMBase                        : 12;
        } LOCAL_DESC_MEM_BASE_bits;
    };

    union {
        __IO uint32_t  WATCHDOG_TIMER;

        struct {
            __IO uint32_t  WDTimer                        : 16;
        } WATCHDOG_TIMER_bits;
    };

    union {
        __IO uint32_t  GLOBAL_EVENT;

        struct {
            __I  uint32_t  GlbEvent                       :  8;
            __O  uint32_t  GlbEventSet                    :  8;
            __O  uint32_t  GlbEventClr                    :  8;
        } GLOBAL_EVENT_bits;
    };

    union {
        __IO uint32_t  PSLVERR_ENABLE;

        struct {
            __IO uint32_t  PSlvErrEn                      :  1;
        } PSLVERR_ENABLE_bits;
    };

    union {
        __I  uint32_t  REVISION_NUMBER;
    };

    union {
        __I  uint32_t  HW_FEATURE;

        struct {
            __I  uint32_t  ChNum                          :  3;
            __I  uint32_t  UnalignMode                    :  1;
            __I  uint32_t  DWidth                         :  2;
            __I  uint32_t  SLVDWidth                      :  2;
            __I  uint32_t  DFDepth                        :  3;
                 uint32_t                                 :  1;
            __I  uint32_t  PriOn                          :  1;
                 uint32_t                                 :  3;
            __I  uint32_t  PriNum                         :  4;
            __I  uint32_t  LdmOn                          :  1;
                 uint32_t                                 :  3;
            __I  uint32_t  LdmDepth                       :  2;
                 uint32_t                                 :  2;
            __I  uint32_t  CmdDepth                       :  2;
        } HW_FEATURE_bits;
    };

    union {
        __IO uint32_t  LOCAL_DESC_MEM_FREE_FLAG_SET_0;
    };

    union {
        __IO uint32_t  LOCAL_DESC_MEM_FREE_FLAG_SET_1;
    };

    union {
        __IO uint32_t  LOCAL_DESC_MEM_FREE_FLAG_SET_2;
    };

    union {
        __IO uint32_t  LOCAL_DESC_MEM_FREE_FLAG_SET_3;
    };

    union {
        __IO uint32_t  ENDIAN_CONVERSION;

        struct {
            __IO uint32_t  EndianConvert                  :  8;
                 uint32_t                                 :  8;
            __IO uint32_t  LMEC                           :  1;
        } ENDIAN_CONVERSION_bits;
    };

    union {
        __IO uint32_t  CONSTANT_VALUE_WRITE_ONLY;
    };

/* DOM-IGNORE-END */
}AG903_DMAC_Type;

/** DMACn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  CTRL_REG;

        struct {
            __IO uint32_t  ChWEvent                       :  8;
            __IO uint32_t  WSync                          :  1;
            __IO uint32_t  ChSEvent                       :  3;
            __IO uint32_t  SEventEn                       :  1;
            __IO uint32_t  WEventEn                       :  1;
            __IO uint32_t  DEn                            :  1;
            __IO uint32_t  ExpEn                          :  1;
            __IO uint32_t  ChEn                           :  1;
            __IO uint32_t  WDTEn                          :  1;
            __IO uint32_t  DstCtrl                        :  2;
            __IO uint32_t  SrcCtrl                        :  2;
            __IO uint32_t  DstWidth                       :  3;
            __IO uint32_t  SrcWidth                       :  3;
            __IO uint32_t  TCMsk                          :  1;
            __IO uint32_t  SrcTcnt                        :  3;
        } CTRL_REG_bits;
    };

    union {
        __IO uint32_t  CFG_REG;

        struct {
            __IO uint32_t  TCIntMsk                       :  1;
            __IO uint32_t  ErrIntMsk                      :  1;
            __IO uint32_t  AbtIntMsk                      :  1;
            __IO uint32_t  SrcRS                          :  4;
            __IO uint32_t  SrcHEn                         :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  DstRS                          :  4;
            __IO uint32_t  DstHEn                         :  1;
                 uint32_t                                 :  2;
            __I  uint32_t  LLPCnt                         :  4;
            __IO uint32_t  ChGntWin                       :  8;
            __IO uint32_t  ChPri                          :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  WOMode                         :  1;
            __IO uint32_t  UnalignMode                    :  1;
        } CFG_REG_bits;
    };

    union {
        __IO uint32_t  SRC_ADDR;
    };

    union {
        __IO uint32_t  DST_ADDR;
    };

    union {
        __IO uint32_t  LINK_LIST_POINTER;
    };

    union {
        __IO uint32_t  TRNS_SIZE_1D;

        struct {
            __IO uint32_t  TCnt                           : 22;
        } TRNS_SIZE_1D_bits;

        __IO uint32_t  TRNS_SIZE_2D;

        struct {
            __IO uint32_t  XTCnt                          : 16;
            __IO uint32_t  YTCnt                          : 16;
        } TRNS_SIZE_2D_bits;
    };

    union {
        __IO uint32_t  STRIDE_SRC_DST_ADDR;

        struct {
            __IO uint32_t  SrcStride                      : 16;
            __IO uint32_t  DstStride                      : 16;
        } STRIDE_SRC_DST_ADDR_bits;
    };

/* DOM-IGNORE-END */
}AG903_DMACn_Type;

#define AG903_DMACn(ch)                          ((volatile AG903_DMACn_Type *)(AG903_DMAC0_BASE + 0x20 * ch))           /** DMACn Base Address (n=0..7) */
#define AG903_DMACn_CTRL_REG(ch)                 AG903_DMACn(ch)->CTRL_REG                                               /** DMACnCTRL_REG Address (n=0..7) */
#define AG903_DMACn_CFG_REG(ch)                  AG903_DMACn(ch)->CFG_REG                                                /** DMACnCFG_REG Address (n=0..7) */
#define AG903_DMACn_SRC_ADDR(ch)                 AG903_DMACn(ch)->SRC_ADDR                                               /** DMACnSRC_ADDR Address (n=0..7) */
#define AG903_DMACn_DST_ADDR(ch)                 AG903_DMACn(ch)->DST_ADDR                                               /** DMACnDST_ADDR Address (n=0..7) */
#define AG903_DMACn_LINK_LIST_POINTER(ch)        AG903_DMACn(ch)->LINK_LIST_POINTER                                      /** DMACnLINK_LIST_POINTER Address (n=0..7) */
#define AG903_DMACn_TRNS_SIZE_1D(ch)             AG903_DMACn(ch)->TRNS_SIZE_1D                                           /** DMACnTRNS_SIZE_1D Address (n=0..7) */
#define AG903_DMACn_TRNS_SIZE_2D(ch)             AG903_DMACn(ch)->TRNS_SIZE_2D                                           /** DMACnTRNS_SIZE_2D Address (n=0..7) */
#define AG903_DMACn_STRIDE_SRC_DST_ADDR(ch)      AG903_DMACn(ch)->STRIDE_SRC_DST_ADDR                                    /** DMACnSTRIDE_SRC_DST_ADDR Address (n=0..7) */

#define AG903_DMAC                               ((volatile AG903_DMAC_Type *) AG903_DMAC_BASE)                          /** DMAC Base Address */
#define AG903_DMAC0                              ((volatile AG903_DMACn_Type *) AG903_DMAC0_BASE)                        /** DMACn Base Address */
#define AG903_DMAC1                              ((volatile AG903_DMACn_Type *) AG903_DMAC1_BASE)                        /** DMACn Base Address */
#define AG903_DMAC2                              ((volatile AG903_DMACn_Type *) AG903_DMAC2_BASE)                        /** DMACn Base Address */
#define AG903_DMAC3                              ((volatile AG903_DMACn_Type *) AG903_DMAC3_BASE)                        /** DMACn Base Address */
#define AG903_DMAC4                              ((volatile AG903_DMACn_Type *) AG903_DMAC4_BASE)                        /** DMACn Base Address */
#define AG903_DMAC5                              ((volatile AG903_DMACn_Type *) AG903_DMAC5_BASE)                        /** DMACn Base Address */
#define AG903_DMAC6                              ((volatile AG903_DMACn_Type *) AG903_DMAC6_BASE)                        /** DMACn Base Address */
#define AG903_DMAC7                              ((volatile AG903_DMACn_Type *) AG903_DMAC7_BASE)                        /** DMACn Base Address */


#define AG903_DMAC_INT_Intr_POS                            0                                                             /** DMACINT Intr-bit position */
#define AG903_DMAC_INT_Intr_MSK                            (0xffUL << AG903_DMAC_INT_Intr_POS)                           /** DMACINT Intr-bit mask */

#define AG903_DMAC_TIMECOUNT_INT_TCIntr_POS                0                                                             /** DMACTIMECOUNT_INT TCIntr-bit position */
#define AG903_DMAC_TIMECOUNT_INT_TCIntr_MSK                (0xffUL << AG903_DMAC_TIMECOUNT_INT_TCIntr_POS)               /** DMACTIMECOUNT_INT TCIntr-bit mask */

#define AG903_DMAC_TIMECOUNT_INT_CLEAR_TCIntrClr_POS       0                                                             /** DMACTIMECOUNT_INT_CLEAR TCIntrClr-bit position */
#define AG903_DMAC_TIMECOUNT_INT_CLEAR_TCIntrClr_MSK       (0xffUL << AG903_DMAC_TIMECOUNT_INT_CLEAR_TCIntrClr_POS)      /** DMACTIMECOUNT_INT_CLEAR TCIntrClr-bit mask */

#define AG903_DMAC_ERR_ABORT_INT_ErrIntr_POS               0                                                             /** DMACERR_ABORT_INT ErrIntr-bit position */
#define AG903_DMAC_ERR_ABORT_INT_ErrIntr_MSK               (0xffUL << AG903_DMAC_ERR_ABORT_INT_ErrIntr_POS)              /** DMACERR_ABORT_INT ErrIntr-bit mask */
#define AG903_DMAC_ERR_ABORT_INT_WdtIntr_POS               8                                                             /** DMACERR_ABORT_INT WdtIntr-bit position */
#define AG903_DMAC_ERR_ABORT_INT_WdtIntr_MSK               (0xffUL << AG903_DMAC_ERR_ABORT_INT_WdtIntr_POS)              /** DMACERR_ABORT_INT WdtIntr-bit mask */
#define AG903_DMAC_ERR_ABORT_INT_AbtIntr_POS               16                                                            /** DMACERR_ABORT_INT AbtIntr-bit position */
#define AG903_DMAC_ERR_ABORT_INT_AbtIntr_MSK               (0xffUL << AG903_DMAC_ERR_ABORT_INT_AbtIntr_POS)              /** DMACERR_ABORT_INT AbtIntr-bit mask */

#define AG903_DMAC_ERR_ABORT_INT_CLEAR_ErrIntrClr_POS      0                                                             /** DMACERR_ABORT_INT_CLEAR ErrIntrClr-bit position */
#define AG903_DMAC_ERR_ABORT_INT_CLEAR_ErrIntrClr_MSK      (0xffUL << AG903_DMAC_ERR_ABORT_INT_CLEAR_ErrIntrClr_POS)     /** DMACERR_ABORT_INT_CLEAR ErrIntrClr-bit mask */
#define AG903_DMAC_ERR_ABORT_INT_CLEAR_WdtIntrClr_POS      8                                                             /** DMACERR_ABORT_INT_CLEAR WdtIntrClr-bit position */
#define AG903_DMAC_ERR_ABORT_INT_CLEAR_WdtIntrClr_MSK      (0xffUL << AG903_DMAC_ERR_ABORT_INT_CLEAR_WdtIntrClr_POS)     /** DMACERR_ABORT_INT_CLEAR WdtIntrClr-bit mask */
#define AG903_DMAC_ERR_ABORT_INT_CLEAR_AbtIntrClr_POS      16                                                            /** DMACERR_ABORT_INT_CLEAR AbtIntrClr-bit position */
#define AG903_DMAC_ERR_ABORT_INT_CLEAR_AbtIntrClr_MSK      (0xffUL << AG903_DMAC_ERR_ABORT_INT_CLEAR_AbtIntrClr_POS)     /** DMACERR_ABORT_INT_CLEAR AbtIntrClr-bit mask */

#define AG903_DMAC_TIMECOUNT_STATUS_TCStatus_POS           0                                                             /** DMACTIMECOUNT_STATUS TCStatus-bit position */
#define AG903_DMAC_TIMECOUNT_STATUS_TCStatus_MSK           (0xffUL << AG903_DMAC_TIMECOUNT_STATUS_TCStatus_POS)          /** DMACTIMECOUNT_STATUS TCStatus-bit mask */

#define AG903_DMAC_ERR_ABORT_STATUS_ErrStatus_POS          0                                                             /** DMACERR_ABORT_STATUS ErrStatus-bit position */
#define AG903_DMAC_ERR_ABORT_STATUS_ErrStatus_MSK          (0xffUL << AG903_DMAC_ERR_ABORT_STATUS_ErrStatus_POS)         /** DMACERR_ABORT_STATUS ErrStatus-bit mask */
#define AG903_DMAC_ERR_ABORT_STATUS_WdtStatus_POS          8                                                             /** DMACERR_ABORT_STATUS WdtStatus-bit position */
#define AG903_DMAC_ERR_ABORT_STATUS_WdtStatus_MSK          (0xffUL << AG903_DMAC_ERR_ABORT_STATUS_WdtStatus_POS)         /** DMACERR_ABORT_STATUS WdtStatus-bit mask */
#define AG903_DMAC_ERR_ABORT_STATUS_AbtStatus_POS          16                                                            /** DMACERR_ABORT_STATUS AbtStatus-bit position */
#define AG903_DMAC_ERR_ABORT_STATUS_AbtStatus_MSK          (0xffUL << AG903_DMAC_ERR_ABORT_STATUS_AbtStatus_POS)         /** DMACERR_ABORT_STATUS AbtStatus-bit mask */

#define AG903_DMAC_CHANNEL_ENABLE_ChEnable_POS             0                                                             /** DMACCHANNEL_ENABLE ChEnable-bit position */
#define AG903_DMAC_CHANNEL_ENABLE_ChEnable_MSK             (0xffUL << AG903_DMAC_CHANNEL_ENABLE_ChEnable_POS)            /** DMACCHANNEL_ENABLE ChEnable-bit mask */

#define AG903_DMAC_SYNC_PERI_IF_SyncDmaReq_POS             0                                                             /** DMACSYNC_PERI_IF SyncDmaReq-bit position */
#define AG903_DMAC_SYNC_PERI_IF_SyncDmaReq_MSK             (0xffffUL << AG903_DMAC_SYNC_PERI_IF_SyncDmaReq_POS)          /** DMACSYNC_PERI_IF SyncDmaReq-bit mask */

#define AG903_DMAC_LOCAL_DESC_MEM_BASE_LDMBase_POS         20                                                            /** DMACLOCAL_DESC_MEM_BASE LDMBase-bit position */
#define AG903_DMAC_LOCAL_DESC_MEM_BASE_LDMBase_MSK         (0xfffUL << AG903_DMAC_LOCAL_DESC_MEM_BASE_LDMBase_POS)       /** DMACLOCAL_DESC_MEM_BASE LDMBase-bit mask */

#define AG903_DMAC_WATCHDOG_TIMER_WDTimer_POS              0                                                             /** DMACWATCHDOG_TIMER WDTimer-bit position */
#define AG903_DMAC_WATCHDOG_TIMER_WDTimer_MSK              (0xffffUL << AG903_DMAC_WATCHDOG_TIMER_WDTimer_POS)           /** DMACWATCHDOG_TIMER WDTimer-bit mask */

#define AG903_DMAC_GLOBAL_EVENT_GlbEvent_POS               0                                                             /** DMACGLOBAL_EVENT GlbEvent-bit position */
#define AG903_DMAC_GLOBAL_EVENT_GlbEvent_MSK               (0xffUL << AG903_DMAC_GLOBAL_EVENT_GlbEvent_POS)              /** DMACGLOBAL_EVENT GlbEvent-bit mask */
#define AG903_DMAC_GLOBAL_EVENT_GlbEventSet_POS            8                                                             /** DMACGLOBAL_EVENT GlbEventSet-bit position */
#define AG903_DMAC_GLOBAL_EVENT_GlbEventSet_MSK            (0xffUL << AG903_DMAC_GLOBAL_EVENT_GlbEventSet_POS)           /** DMACGLOBAL_EVENT GlbEventSet-bit mask */
#define AG903_DMAC_GLOBAL_EVENT_GlbEventClr_POS            16                                                            /** DMACGLOBAL_EVENT GlbEventClr-bit position */
#define AG903_DMAC_GLOBAL_EVENT_GlbEventClr_MSK            (0xffUL << AG903_DMAC_GLOBAL_EVENT_GlbEventClr_POS)           /** DMACGLOBAL_EVENT GlbEventClr-bit mask */

#define AG903_DMAC_PSLVERR_ENABLE_PSlvErrEn_POS            0                                                             /** DMACPSLVERR_ENABLE PSlvErrEn-bit position */
#define AG903_DMAC_PSLVERR_ENABLE_PSlvErrEn_MSK            (0x1UL << AG903_DMAC_PSLVERR_ENABLE_PSlvErrEn_POS)            /** DMACPSLVERR_ENABLE PSlvErrEn-bit mask */

#define AG903_DMAC_REVISION_NUMBER_RevNum_POS              0                                                             /** DMACREVISION_NUMBER RevNum-bit position */
#define AG903_DMAC_REVISION_NUMBER_RevNum_MSK              (0xffffffffUL << AG903_DMAC_REVISION_NUMBER_RevNum_POS)       /** DMACREVISION_NUMBER RevNum-bit mask */

#define AG903_DMAC_HW_FEATURE_ChNum_POS                    0                                                             /** DMACHW_FEATURE ChNum-bit position */
#define AG903_DMAC_HW_FEATURE_ChNum_MSK                    (0x7UL << AG903_DMAC_HW_FEATURE_ChNum_POS)                    /** DMACHW_FEATURE ChNum-bit mask */
#define AG903_DMAC_HW_FEATURE_UnalignMode_POS              3                                                             /** DMACHW_FEATURE UnalignMode-bit position */
#define AG903_DMAC_HW_FEATURE_UnalignMode_MSK              (0x1UL << AG903_DMAC_HW_FEATURE_UnalignMode_POS)              /** DMACHW_FEATURE UnalignMode-bit mask */
#define AG903_DMAC_HW_FEATURE_DWidth_POS                   4                                                             /** DMACHW_FEATURE DWidth-bit position */
#define AG903_DMAC_HW_FEATURE_DWidth_MSK                   (0x3UL << AG903_DMAC_HW_FEATURE_DWidth_POS)                   /** DMACHW_FEATURE DWidth-bit mask */
#define AG903_DMAC_HW_FEATURE_SLVDWidth_POS                6                                                             /** DMACHW_FEATURE SLVDWidth-bit position */
#define AG903_DMAC_HW_FEATURE_SLVDWidth_MSK                (0x3UL << AG903_DMAC_HW_FEATURE_SLVDWidth_POS)                /** DMACHW_FEATURE SLVDWidth-bit mask */
#define AG903_DMAC_HW_FEATURE_DFDepth_POS                  8                                                             /** DMACHW_FEATURE DFDepth-bit position */
#define AG903_DMAC_HW_FEATURE_DFDepth_MSK                  (0x7UL << AG903_DMAC_HW_FEATURE_DFDepth_POS)                  /** DMACHW_FEATURE DFDepth-bit mask */
#define AG903_DMAC_HW_FEATURE_PriOn_POS                    12                                                            /** DMACHW_FEATURE PriOn-bit position */
#define AG903_DMAC_HW_FEATURE_PriOn_MSK                    (0x1UL << AG903_DMAC_HW_FEATURE_PriOn_POS)                    /** DMACHW_FEATURE PriOn-bit mask */
#define AG903_DMAC_HW_FEATURE_PriNum_POS                   16                                                            /** DMACHW_FEATURE PriNum-bit position */
#define AG903_DMAC_HW_FEATURE_PriNum_MSK                   (0xfUL << AG903_DMAC_HW_FEATURE_PriNum_POS)                   /** DMACHW_FEATURE PriNum-bit mask */
#define AG903_DMAC_HW_FEATURE_LdmOn_POS                    20                                                            /** DMACHW_FEATURE LdmOn-bit position */
#define AG903_DMAC_HW_FEATURE_LdmOn_MSK                    (0x1UL << AG903_DMAC_HW_FEATURE_LdmOn_POS)                    /** DMACHW_FEATURE LdmOn-bit mask */
#define AG903_DMAC_HW_FEATURE_LdmDepth_POS                 24                                                            /** DMACHW_FEATURE LdmDepth-bit position */
#define AG903_DMAC_HW_FEATURE_LdmDepth_MSK                 (0x3UL << AG903_DMAC_HW_FEATURE_LdmDepth_POS)                 /** DMACHW_FEATURE LdmDepth-bit mask */
#define AG903_DMAC_HW_FEATURE_CmdDepth_POS                 28                                                            /** DMACHW_FEATURE CmdDepth-bit position */
#define AG903_DMAC_HW_FEATURE_CmdDepth_MSK                 (0x3UL << AG903_DMAC_HW_FEATURE_CmdDepth_POS)                 /** DMACHW_FEATURE CmdDepth-bit mask */

#define AG903_DMAC_LOCAL_DESC_MEM_FREE_FLAG_SET_0_FreeFlagS0_POS 0                                                       /** DMACLOCAL_DESC_MEM_FREE_FLAG_SET_0 FreeFlagS0-bit position */
#define AG903_DMAC_LOCAL_DESC_MEM_FREE_FLAG_SET_0_FreeFlagS0_MSK (0xffffffffUL << AG903_DMAC_LOCAL_DESC_MEM_FREE_FLAG_SET_0_FreeFlagS0_POS) /** DMACLOCAL_DESC_MEM_FREE_FLAG_SET_0 FreeFlagS0-bit mask */

#define AG903_DMAC_LOCAL_DESC_MEM_FREE_FLAG_SET_1_FreeFlagS1_POS 0                                                       /** DMACLOCAL_DESC_MEM_FREE_FLAG_SET_1 FreeFlagS1-bit position */
#define AG903_DMAC_LOCAL_DESC_MEM_FREE_FLAG_SET_1_FreeFlagS1_MSK (0xffffffffUL << AG903_DMAC_LOCAL_DESC_MEM_FREE_FLAG_SET_1_FreeFlagS1_POS) /** DMACLOCAL_DESC_MEM_FREE_FLAG_SET_1 FreeFlagS1-bit mask */

#define AG903_DMAC_LOCAL_DESC_MEM_FREE_FLAG_SET_2_FreeFlagS2_POS 0                                                       /** DMACLOCAL_DESC_MEM_FREE_FLAG_SET_2 FreeFlagS2-bit position */
#define AG903_DMAC_LOCAL_DESC_MEM_FREE_FLAG_SET_2_FreeFlagS2_MSK (0xffffffffUL << AG903_DMAC_LOCAL_DESC_MEM_FREE_FLAG_SET_2_FreeFlagS2_POS) /** DMACLOCAL_DESC_MEM_FREE_FLAG_SET_2 FreeFlagS2-bit mask */

#define AG903_DMAC_LOCAL_DESC_MEM_FREE_FLAG_SET_3_FreeFlagS3_POS 0                                                       /** DMACLOCAL_DESC_MEM_FREE_FLAG_SET_3 FreeFlagS3-bit position */
#define AG903_DMAC_LOCAL_DESC_MEM_FREE_FLAG_SET_3_FreeFlagS3_MSK (0xffffffffUL << AG903_DMAC_LOCAL_DESC_MEM_FREE_FLAG_SET_3_FreeFlagS3_POS) /** DMACLOCAL_DESC_MEM_FREE_FLAG_SET_3 FreeFlagS3-bit mask */

#define AG903_DMAC_ENDIAN_CONVERSION_EndianConvert_POS     0                                                             /** DMACENDIAN_CONVERSION EndianConvert-bit position */
#define AG903_DMAC_ENDIAN_CONVERSION_EndianConvert_MSK     (0xffUL << AG903_DMAC_ENDIAN_CONVERSION_EndianConvert_POS)    /** DMACENDIAN_CONVERSION EndianConvert-bit mask */
#define AG903_DMAC_ENDIAN_CONVERSION_LMEC_POS              16                                                            /** DMACENDIAN_CONVERSION LMEC-bit position */
#define AG903_DMAC_ENDIAN_CONVERSION_LMEC_MSK              (0x1UL << AG903_DMAC_ENDIAN_CONVERSION_LMEC_POS)              /** DMACENDIAN_CONVERSION LMEC-bit mask */

#define AG903_DMAC_CONSTANT_VALUE_WRITE_ONLY_WOValue_POS   0                                                             /** DMACCONSTANT_VALUE_WRITE_ONLY WOValue-bit position */
#define AG903_DMAC_CONSTANT_VALUE_WRITE_ONLY_WOValue_MSK   (0xffffffffUL << AG903_DMAC_CONSTANT_VALUE_WRITE_ONLY_WOValue_POS) /** DMACCONSTANT_VALUE_WRITE_ONLY WOValue-bit mask */

#define AG903_DMACn_CTRL_REG_ChWEvent_POS                  0                                                             /** DMACnCTRL_REG ChWEvent-bit position */
#define AG903_DMACn_CTRL_REG_ChWEvent_MSK                  (0xffUL << AG903_DMACn_CTRL_REG_ChWEvent_POS)                 /** DMACnCTRL_REG ChWEvent-bit mask */
#define AG903_DMACn_CTRL_REG_WSync_POS                     8                                                             /** DMACnCTRL_REG WSync-bit position */
#define AG903_DMACn_CTRL_REG_WSync_MSK                     (0x1UL << AG903_DMACn_CTRL_REG_WSync_POS)                     /** DMACnCTRL_REG WSync-bit mask */
#define AG903_DMACn_CTRL_REG_ChSEvent_POS                  9                                                             /** DMACnCTRL_REG ChSEvent-bit position */
#define AG903_DMACn_CTRL_REG_ChSEvent_MSK                  (0x7UL << AG903_DMACn_CTRL_REG_ChSEvent_POS)                  /** DMACnCTRL_REG ChSEvent-bit mask */
#define AG903_DMACn_CTRL_REG_SEventEn_POS                  12                                                            /** DMACnCTRL_REG SEventEn-bit position */
#define AG903_DMACn_CTRL_REG_SEventEn_MSK                  (0x1UL << AG903_DMACn_CTRL_REG_SEventEn_POS)                  /** DMACnCTRL_REG SEventEn-bit mask */
#define AG903_DMACn_CTRL_REG_WEventEn_POS                  13                                                            /** DMACnCTRL_REG WEventEn-bit position */
#define AG903_DMACn_CTRL_REG_WEventEn_MSK                  (0x1UL << AG903_DMACn_CTRL_REG_WEventEn_POS)                  /** DMACnCTRL_REG WEventEn-bit mask */
#define AG903_DMACn_CTRL_REG_DEn_POS                       14                                                            /** DMACnCTRL_REG DEn-bit position */
#define AG903_DMACn_CTRL_REG_DEn_MSK                       (0x1UL << AG903_DMACn_CTRL_REG_DEn_POS)                       /** DMACnCTRL_REG DEn-bit mask */
#define AG903_DMACn_CTRL_REG_ExpEn_POS                     15                                                            /** DMACnCTRL_REG ExpEn-bit position */
#define AG903_DMACn_CTRL_REG_ExpEn_MSK                     (0x1UL << AG903_DMACn_CTRL_REG_ExpEn_POS)                     /** DMACnCTRL_REG ExpEn-bit mask */
#define AG903_DMACn_CTRL_REG_ChEn_POS                      16                                                            /** DMACnCTRL_REG ChEn-bit position */
#define AG903_DMACn_CTRL_REG_ChEn_MSK                      (0x1UL << AG903_DMACn_CTRL_REG_ChEn_POS)                      /** DMACnCTRL_REG ChEn-bit mask */
#define AG903_DMACn_CTRL_REG_WDTEn_POS                     17                                                            /** DMACnCTRL_REG WDTEn-bit position */
#define AG903_DMACn_CTRL_REG_WDTEn_MSK                     (0x1UL << AG903_DMACn_CTRL_REG_WDTEn_POS)                     /** DMACnCTRL_REG WDTEn-bit mask */
#define AG903_DMACn_CTRL_REG_DstCtrl_POS                   18                                                            /** DMACnCTRL_REG DstCtrl-bit position */
#define AG903_DMACn_CTRL_REG_DstCtrl_MSK                   (0x3UL << AG903_DMACn_CTRL_REG_DstCtrl_POS)                   /** DMACnCTRL_REG DstCtrl-bit mask */
#define AG903_DMACn_CTRL_REG_SrcCtrl_POS                   20                                                            /** DMACnCTRL_REG SrcCtrl-bit position */
#define AG903_DMACn_CTRL_REG_SrcCtrl_MSK                   (0x3UL << AG903_DMACn_CTRL_REG_SrcCtrl_POS)                   /** DMACnCTRL_REG SrcCtrl-bit mask */
#define AG903_DMACn_CTRL_REG_DstWidth_POS                  22                                                            /** DMACnCTRL_REG DstWidth-bit position */
#define AG903_DMACn_CTRL_REG_DstWidth_MSK                  (0x7UL << AG903_DMACn_CTRL_REG_DstWidth_POS)                  /** DMACnCTRL_REG DstWidth-bit mask */
#define AG903_DMACn_CTRL_REG_SrcWidth_POS                  25                                                            /** DMACnCTRL_REG SrcWidth-bit position */
#define AG903_DMACn_CTRL_REG_SrcWidth_MSK                  (0x7UL << AG903_DMACn_CTRL_REG_SrcWidth_POS)                  /** DMACnCTRL_REG SrcWidth-bit mask */
#define AG903_DMACn_CTRL_REG_TCMsk_POS                     28                                                            /** DMACnCTRL_REG TCMsk-bit position */
#define AG903_DMACn_CTRL_REG_TCMsk_MSK                     (0x1UL << AG903_DMACn_CTRL_REG_TCMsk_POS)                     /** DMACnCTRL_REG TCMsk-bit mask */
#define AG903_DMACn_CTRL_REG_SrcTcnt_POS                   29                                                            /** DMACnCTRL_REG SrcTcnt-bit position */
#define AG903_DMACn_CTRL_REG_SrcTcnt_MSK                   (0x7UL << AG903_DMACn_CTRL_REG_SrcTcnt_POS)                   /** DMACnCTRL_REG SrcTcnt-bit mask */

#define AG903_DMACn_CFG_REG_TCIntMsk_POS                   0                                                             /** DMACnCFG_REG TCIntMsk-bit position */
#define AG903_DMACn_CFG_REG_TCIntMsk_MSK                   (0x1UL << AG903_DMACn_CFG_REG_TCIntMsk_POS)                   /** DMACnCFG_REG TCIntMsk-bit mask */
#define AG903_DMACn_CFG_REG_ErrIntMsk_POS                  1                                                             /** DMACnCFG_REG ErrIntMsk-bit position */
#define AG903_DMACn_CFG_REG_ErrIntMsk_MSK                  (0x1UL << AG903_DMACn_CFG_REG_ErrIntMsk_POS)                  /** DMACnCFG_REG ErrIntMsk-bit mask */
#define AG903_DMACn_CFG_REG_AbtIntMsk_POS                  2                                                             /** DMACnCFG_REG AbtIntMsk-bit position */
#define AG903_DMACn_CFG_REG_AbtIntMsk_MSK                  (0x1UL << AG903_DMACn_CFG_REG_AbtIntMsk_POS)                  /** DMACnCFG_REG AbtIntMsk-bit mask */
#define AG903_DMACn_CFG_REG_SrcRS_POS                      3                                                             /** DMACnCFG_REG SrcRS-bit position */
#define AG903_DMACn_CFG_REG_SrcRS_MSK                      (0xfUL << AG903_DMACn_CFG_REG_SrcRS_POS)                      /** DMACnCFG_REG SrcRS-bit mask */
#define AG903_DMACn_CFG_REG_SrcHEn_POS                     7                                                             /** DMACnCFG_REG SrcHEn-bit position */
#define AG903_DMACn_CFG_REG_SrcHEn_MSK                     (0x1UL << AG903_DMACn_CFG_REG_SrcHEn_POS)                     /** DMACnCFG_REG SrcHEn-bit mask */
#define AG903_DMACn_CFG_REG_DstRS_POS                      9                                                             /** DMACnCFG_REG DstRS-bit position */
#define AG903_DMACn_CFG_REG_DstRS_MSK                      (0xfUL << AG903_DMACn_CFG_REG_DstRS_POS)                      /** DMACnCFG_REG DstRS-bit mask */
#define AG903_DMACn_CFG_REG_DstHEn_POS                     13                                                            /** DMACnCFG_REG DstHEn-bit position */
#define AG903_DMACn_CFG_REG_DstHEn_MSK                     (0x1UL << AG903_DMACn_CFG_REG_DstHEn_POS)                     /** DMACnCFG_REG DstHEn-bit mask */
#define AG903_DMACn_CFG_REG_LLPCnt_POS                     16                                                            /** DMACnCFG_REG LLPCnt-bit position */
#define AG903_DMACn_CFG_REG_LLPCnt_MSK                     (0xfUL << AG903_DMACn_CFG_REG_LLPCnt_POS)                     /** DMACnCFG_REG LLPCnt-bit mask */
#define AG903_DMACn_CFG_REG_ChGntWin_POS                   20                                                            /** DMACnCFG_REG ChGntWin-bit position */
#define AG903_DMACn_CFG_REG_ChGntWin_MSK                   (0xffUL << AG903_DMACn_CFG_REG_ChGntWin_POS)                  /** DMACnCFG_REG ChGntWin-bit mask */
#define AG903_DMACn_CFG_REG_ChPri_POS                      28                                                            /** DMACnCFG_REG ChPri-bit position */
#define AG903_DMACn_CFG_REG_ChPri_MSK                      (0x1UL << AG903_DMACn_CFG_REG_ChPri_POS)                      /** DMACnCFG_REG ChPri-bit mask */
#define AG903_DMACn_CFG_REG_WOMode_POS                     30                                                            /** DMACnCFG_REG WOMode-bit position */
#define AG903_DMACn_CFG_REG_WOMode_MSK                     (0x1UL << AG903_DMACn_CFG_REG_WOMode_POS)                     /** DMACnCFG_REG WOMode-bit mask */
#define AG903_DMACn_CFG_REG_UnalignMode_POS                31                                                            /** DMACnCFG_REG UnalignMode-bit position */
#define AG903_DMACn_CFG_REG_UnalignMode_MSK                (0x1UL << AG903_DMACn_CFG_REG_UnalignMode_POS)                /** DMACnCFG_REG UnalignMode-bit mask */

#define AG903_DMACn_SRC_ADDR_SrcAddr_POS                   0                                                             /** DMACnSRC_ADDR SrcAddr-bit position */
#define AG903_DMACn_SRC_ADDR_SrcAddr_MSK                   (0xffffffffUL << AG903_DMACn_SRC_ADDR_SrcAddr_POS)            /** DMACnSRC_ADDR SrcAddr-bit mask */

#define AG903_DMACn_DST_ADDR_DstAddr_POS                   0                                                             /** DMACnDST_ADDR DstAddr-bit position */
#define AG903_DMACn_DST_ADDR_DstAddr_MSK                   (0xffffffffUL << AG903_DMACn_DST_ADDR_DstAddr_POS)            /** DMACnDST_ADDR DstAddr-bit mask */

#define AG903_DMACn_LINK_LIST_POINTER_LLP_POS              0                                                             /** DMACnLINK_LIST_POINTER LLP-bit position */
#define AG903_DMACn_LINK_LIST_POINTER_LLP_MSK              (0xffffffffUL << AG903_DMACn_LINK_LIST_POINTER_LLP_POS)       /** DMACnLINK_LIST_POINTER LLP-bit mask */

#define AG903_DMACn_TRNS_SIZE_1D_TCnt_POS                  0                                                             /** DMACnTRNS_SIZE_1D TCnt-bit position */
#define AG903_DMACn_TRNS_SIZE_1D_TCnt_MSK                  (0x3fffffUL << AG903_DMACn_TRNS_SIZE_1D_TCnt_POS)             /** DMACnTRNS_SIZE_1D TCnt-bit mask */

#define AG903_DMACn_TRNS_SIZE_2D_XTCnt_POS                 0                                                             /** DMACnTRNS_SIZE_2D XTCnt-bit position */
#define AG903_DMACn_TRNS_SIZE_2D_XTCnt_MSK                 (0xffffUL << AG903_DMACn_TRNS_SIZE_2D_XTCnt_POS)              /** DMACnTRNS_SIZE_2D XTCnt-bit mask */
#define AG903_DMACn_TRNS_SIZE_2D_YTCnt_POS                 16                                                            /** DMACnTRNS_SIZE_2D YTCnt-bit position */
#define AG903_DMACn_TRNS_SIZE_2D_YTCnt_MSK                 (0xffffUL << AG903_DMACn_TRNS_SIZE_2D_YTCnt_POS)              /** DMACnTRNS_SIZE_2D YTCnt-bit mask */

#define AG903_DMACn_STRIDE_SRC_DST_ADDR_SrcStride_POS      0                                                             /** DMACnSTRIDE_SRC_DST_ADDR SrcStride-bit position */
#define AG903_DMACn_STRIDE_SRC_DST_ADDR_SrcStride_MSK      (0xffffUL << AG903_DMACn_STRIDE_SRC_DST_ADDR_SrcStride_POS)   /** DMACnSTRIDE_SRC_DST_ADDR SrcStride-bit mask */
#define AG903_DMACn_STRIDE_SRC_DST_ADDR_DstStride_POS      16                                                            /** DMACnSTRIDE_SRC_DST_ADDR DstStride-bit position */
#define AG903_DMACn_STRIDE_SRC_DST_ADDR_DstStride_MSK      (0xffffUL << AG903_DMACn_STRIDE_SRC_DST_ADDR_DstStride_POS)   /** DMACnSTRIDE_SRC_DST_ADDR DstStride-bit mask */

#endif /* _AG903_DMAC_REGMAP_H_ */

