/**
 * @brief           GVD extern I/F Header
 * @author          AXELL CORPORATION
 * @description     GVD OI/F`
 * @note            ɒ`Ă֐̓AvP[VŎKv܂.
 * @note            GVDTv ܂ MPSCuTvQƂĂ.
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef GVD_EXTERN_H
#define GVD_EXTERN_H
/* DOM-IGNORE-END */

#include <stddef.h>
#include <stdbool.h>
#include "gvd_error.h"

/**
 * @brief           GVD mۃC^tF[X
 * @param           size [in] mۃTCY
 * @return          mۂAhX
 * @retval          NULL mێs
 * @description     GVD̃mۗpC^tF[Xł.
 * @note            ̓AvP[V̎Ɉˑ܂.
 */
void* gvdMemAlloc(size_t size);
/**
 * @brief           GVD C^tF[X
 * @param           blk [in] mۍς݃AhX
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @description     GVD̃pC^tF[Xł.
 * @note            ̓AvP[V̎Ɉˑ܂.
 */
gvdError gvdMemFree(void *blk);

typedef int32_t	gvdFilePos;	/** Xg[ʒu */

/** t@Cp\ */
typedef struct {
	int32_t		*fd;			/** t@CfBXNv^ */
	gvdFilePos	size;			/** t@CTCY */
	gvdFilePos	pos;			/** ItZbg */
	bool		error;			/** G[R[h */
	uint32_t	id;				/** Xg[ID */
	uint32_t	nal_size;		/** NALTCY */
	uint32_t	nal_prev;		/** NALΈʒuiOj */
	uint32_t	nal_next;		/** NALΈʒuij */
} gvdFile[1];

/**
 * @brief           GVD t@CǗ\̏C^tF[X
 * @param           gvdfile [in,out] GVDt@CǗ\
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @description     GVD̃t@CXg[}ɃR[܂.
 * @note            ̓AvP[V̎Ɉˑ܂.
 */
gvdError gvdFileInitialize(gvdFile gvdfile);
/**
 * @brief           GVD t@CI[vC^tF[X
 * @param           gvdfile [in,out] GVDt@CǗ\
 * @param           filename [in] t@C
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @description     t@CXg[}gp, fR[_ڑɃR[܂.
 * @note            ̓AvP[V̎Ɉˑ܂.<p>
 *                  GVDCu̓oCi[hŃt@CJ邱Ƃ҂܂.
 */
gvdError gvdFileOpen(gvdFile gvdfile, const char *filename);
/**
 * @brief           GVD t@C[hC^tF[X
 * @param           gvdfile [in,out] GVDt@CǗ\
 * @param           buf [out] [hobt@
 * @param           rdsize [in] [hTCY
 * @param           actual_rdsize [out] bufւ̏݃TCY
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @description     t@CXg[}gp, Xg[ǂݏoɃR[܂.
 * @note            ̓AvP[V̎Ɉˑ܂.<p>
 *                  t@CXg[}gp, {֐GVD_Execute֐ŃR[܂.<p>
 *                  Ot@CXg[}gp, {֐̓R[܂.<p>
 *                  G[R[hFGVD_ERR_FILE_OPERATION_TIMEDOUTԂƂ, t@CXg[}ɃgC邱Ƃł܂.
 */
gvdError gvdFileRead(gvdFile gvdfile, void *buf, size_t rdsize, size_t *actual_rdsize);
/**
 * @brief           GVD t@CEOF`FbNC^tF[X
 * @param           gvdfile [in,out] GVDt@CǗ\
 * @return          EOF`FbN
 * @retval          true Xg[I[܂œǂݏI
 * @retval          false Xg[I[܂œǂݏIĂȂ
 * @description     ݂̃Xg[ʒuI[`FbN܂.
 * @note            ̓AvP[V̎Ɉˑ܂.
 */
bool gvdFileIsEOF(gvdFile gvdfile);
/**
 * @brief           GVD t@CV[NC^tF[X
 * @param           gvdfile [in,out] GVDt@CǗ\
 * @param           pos [in] Xg[̃ItZbgʒu [Byte]
 * @return          V[N
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_FILE_OPERATION_FAILURE V[Ns
 * @description     w肳ꂽ΃ItZbgɃV[N܂.
 * @note            ̓AvP[V̎Ɉˑ܂.<p>
 *                  GVD_ERR_FILE_OPERATION_FAILUREԂꍇ, GVDCu͏p邱ƂłȂߒvIG[ԂƂȂ܂B
 */
gvdError gvdFileSeekAbs(gvdFile gvdfile, gvdFilePos pos);
/**
 * @brief           GVD t@CN[YC^tF[X
 * @param           gvdfile [in,out] GVDt@CǗ\
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @description     t@CXg[}gp, fR[_ؒfɃR[܂.
 * @note            ̓AvP[V̎Ɉˑ܂.
 */
gvdError gvdFileClose(gvdFile gvdfile);
/**
 * @brief           GVD t@CIC^tF[X
 * @param           gvdfile [in,out] GVDt@CǗ\
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @description     GVD̃t@CXg[}jɃR[܂.
 * @note            ̓AvP[V̎Ɉˑ܂.
 */
gvdError gvdFileFinalize(gvdFile gvdfile);

/**
 * @brief           ~[ebNX̏
 * @param           pMutex [out] ~[ebNXID
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH s
 * @description     ~[ebNX𐶐IDԂ܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["acre_mtx"ɑ鏈ĉ.
*/
gvdError gvdOsMutexInit(int32_t *pMutex);

/**
 * @brief           ~[ebNX̃bN
 * @param           pMutex [in] ~[ebNXID
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH bNs
 * @description     ~[ebNXbN܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["loc_mtx"ɑ鏈ĉ.
*/
gvdError gvdOsMutexLock(int32_t *pMutex);

/**
 * @brief           ~[ebNX̃bNi|[Oj
 * @param           pMutex [in] ~[ebNXID
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH bNs
 * @description     ~[ebNXbN܂i|[Oj.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["pol_mtx""tloc_mtx(timeout=0)"ɑ鏈ĉ.
*/
gvdError gvdOsMutexTryLock(int32_t *pMutex);

/**
 * @brief           ~[ebNX̃bN
 * @param           pMutex [in] ~[ebNXID
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH bNs
 * @description     ~[ebNX̃bN܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["unl_mtx"ɑ鏈ĉ.
*/
gvdError gvdOsMutexUnlock(int32_t *pMutex);

/**
 * @brief           ~[ebNX̍폜
 * @param           pMutex [in] ~[ebNXID
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH 폜s
 * @description     ~[ebNX폜܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["del_mtx"ɑ鏈ĉ.
*/
gvdError gvdOsMutexDestroy(int32_t *pMutex);

/**
 * @brief           CxgtȌ
 * @param           pEvent [out] CxgtOID
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH s
 * @description     CxgtO𐶐IDԂ܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["acre_flg"ɑ鏈ĉ.
*/
gvdError gvdOsEventInit(int32_t *pEvent);

/**
 * @brief           CxgtÕZbg
 * @param           pEvent [in] CxgtOID
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH Zbgs
 * @description     CxgtOZbg܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["set_flg"ɑ鏈ĉ.
*/
gvdError gvdOsEventSignal(int32_t *pEvent);

/**
 * @brief           CxgtÕZbgi荞݂̌Ăяoj
 * @param           pEvent [in] CxgtOID
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH Zbgs
 * @description     i荞ݓjCxgtOZbg܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["iset_flg"ɑ鏈ĉ.
*/
gvdError gvdOsIntEventSignal(int32_t *pEvent);

/**
 * @brief           CxgtO҂
 * @param           pEvent [in] CxgtOID
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH ҂s
 * @description     CxgtO҂܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["wai_flg"ɑ鏈ĉ.
*/
gvdError gvdOsEventWait(int32_t *pEvent);

/**
 * @brief           CxgtO҂i^CAEgtj
 * @param           pEvent [in] CxgtOID
 * @param           msec [in] ^CAEg [ms]
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH ҂s
 * @description     ^CAEgtŃCxgtO҂܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["twai_flg"ɑ鏈ĉ.
*/
gvdError gvdOsEventTimedWait(int32_t *pEvent, uint32_t msec);

/**
 * @brief           CxgtO̍폜
 * @param           pEvent [in] CxgtOID
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH 폜s
 * @description     CxgtO폜܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["del_flg"ɑ鏈ĉ.
*/
gvdError gvdOsEventDestroy(int32_t* pEvent);

/**
 * @brief           ݃nh̐
 * @param           intno [in] ݔԍ
 * @param           hdlr [out] nhID
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH s
 * @description     ݃nh𐶐IDԂ܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["acre_isr"ɑ鏈ĉ.
 *                  INT Manager gp AG903_INTMgrSetHandler Y܂.
*/
void gvdOsHandlerCreate(int intno, void* hdlr);

/**
 * @brief           ݃nh̍폜
 * @param           intno [in] ݔԍ
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH s
 * @description     ݃nh폜܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["del_isr"ɑ鏈ĉ.
 *                  INT Manager gp AG903_INTMgrDeleteHandler Y܂.
*/
void gvdOsHandlerDelete(int intno);

/**
 * @brief           ݂̏
 * @param           intno [in] ݔԍ
 * @return          none
 * @description     ݂̏iDxݒj܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  ݂ɑ΂鏉KvȏꍇɎĉ.
 *                  INT Manager gp AG903_INTMgrSetPriority ɂDxݒ蓙܂.
*/
void gvdIntrInit(int intno);

/**
 * @brief           ݂̋
 * @param           intno [in] ݔԍ
 * @return          none
 * @description     ݂̋ݒ܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["ena_int"ɑ鏈ĉ.
 *                  INT Manager gp AG903_INTMgrEnableInt Y܂.
*/
void gvdIntrEnable(int intno);

/**
 * @brief           ݂̋֎~
 * @param           intno [in] ݔԍ
 * @return          none
 * @description     ݂̋֎~ݒ܂.
 * @note            {֐̓AvP[VŎKv܂.<p>
 *                  uITRONOS̃VXeR["dis_int"ɑ鏈ĉ.
 *                  INT Manager gp AG903_INTMgrDisableInt Y܂.
*/
void gvdIntrDisable(int intno);

#endif
