/**
 * @brief           BMU Primitive Header
 * @author          AXELL CORPORATION
 * @description     BMU Primitive Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _BMUPRM_H_
#define _BMUPRM_H_
/* DOM-IGNORE-END */

#ifdef __cplusplus
//extern "C" {
#endif

#include "register/AG903_bmureg.h"

#ifndef AG903_BMU_UNIT_NUM
	/** BMU̍ő`l */
	#define AG903_BMU_UNIT_NUM (16)
#endif

/** BMUnSTATWX^̐ݒ󂯓np\ */
typedef struct _BMUPrmParamSTAT {
	uint32_t val;			/** obt@ݏ */
	uint32_t empty;		/** obt@󂩂ǂ */
	uint32_t rwa;			/** VNW[̃EFCg */
	uint32_t rbsy;		/** NW[̃obt@gp */
	uint32_t rnum;		/** VNW[gp̃obt@ԍ */
	uint32_t full;		/** obt@tǂ */
	uint32_t wwa;			/** \[XW[̃EFCg */
	uint32_t wbsy;		/** \[XW[̃obt@gp */
	uint32_t wnum;		/** \[XW[gp̃obt@ԍ */
}BMUPrmParamSTAT;


void AG903_BMUPrmSetCTRL(uint8_t unit, uint8_t en);
void AG903_BMUPrmGetCTRL(uint8_t unit, uint8_t *en);
void AG903_BMUPrmSetMOD(uint8_t unit, uint8_t ini, uint8_t mgr, uint8_t src);
void AG903_BMUPrmGetMOD(uint8_t unit, uint8_t *ini, uint8_t *mgr, uint8_t *src);
void AG903_BMUPrmSetSINKMODULE(uint8_t unit, uint32_t valid);
void AG903_BMUPrmGetSINKMODULE(uint8_t unit, uint32_t* valid);
void AG903_BMUPrmGetSINKSTAT(uint8_t unit, uint32_t* stat);
void AG903_BMUPrmSetBASEADR(uint8_t unit, uint32_t adr);
void AG903_BMUPrmGetBASEADR(uint8_t unit, uint32_t *adr);
void AG903_BMUPrmSetSTRIDE(uint8_t unit, uint32_t stride);
void AG903_BMUPrmGetSTRIDE(uint8_t unit, uint32_t *stride);
void AG903_BMUPrmSetBUFNUM(uint8_t unit, uint32_t num);
void AG903_BMUPrmGetBUFNUM(uint8_t unit, uint32_t *num);
void AG903_BMUPrmGetSTAT(uint8_t unit, BMUPrmParamSTAT *stat);

#ifdef __cplusplus
}
#endif
#endif
