/**
 * @brief           TIMR Primitive Header
 * @author          AXELL CORPORATION
 * @description     TIMR Primitive񋟃wb_B<p>TIMR PrimitivegpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _TIMRPRM_H_
#define _TIMRPRM_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include "lib_common/AG903_common.h"
#include "register/AG903_timreg.h"

#ifdef __cplusplus
extern "C" {
#endif

#if AG903_LIB_USE_GVD
/** TIMR`l<p>
	GVDgpch7GVDL */
#define AG903_TIMR_CH_NUM			(7)
#else
/** TIMR`l */
#define AG903_TIMR_CH_NUM			(8)
#endif

/** TIMRCxg */
#define AG903_TIMR_EVENT_NUM		(64)

/** TIMRo͒[q */
#define AG903_TIMR_EXTOUT_NUM		(4)

/** o̓pXiMaxlj*/
#define AG903_TIMR_PLUSEWIDTH_MAX	(0xFFFFF)

/** TIMnINMOD/TIMnRSTTRG RESݒl */
enum _AG903_TimrInmodResType {
	AG903_TIMR_RES_SYSCLK = 0,		/** VXeNbN */
	AG903_TIMR_RES_RESEVE,			/** \ */
	AG903_TIMR_RES_TICK0,			/** TICK0 */
	AG903_TIMR_RES_TICK1,			/** TICK1 */
};

/** TIMnCTRL MODݒl */
enum _AG903_TimrTIMnCtrlMod {
	AG903_TIMR_CTRLMOD_STOP = 0,	/** ~ */
	AG903_TIMR_CTRLMOD_REIN,		/** [^[GR[_ */
	AG903_TIMR_CTRLMOD_PWMIN,		/** PWM  */
	AG903_TIMR_CTRLMOD_RESEVE,		/** \ */
	AG903_TIMR_CTRLMOD_TICKCNT,		/** NbN/TICK v */
	AG903_TIMR_CTRLMOD_EVENTCNT,	/** Cxgv */
	AG903_TIMR_CTRLMOD_PLUSECNT,	/** ͒[qpXv */
	AG903_TIMR_CTRLMOD_LEVELCNT,	/** ͒[qxv */
	AG903_TIMR_CTRLMOD_MODENUM,		/** [h */
};

/** TIMnOUTMOD MODݒl */
enum _AG903_TimrOutMod {
	AG903_TIMR_OUTMOD_DISABLE = 0,	/** o͂Ȃ */
	AG903_TIMR_OUTMOD_PWM,			/** PWMo */
	AG903_TIMR_OUTMOD_PLUSE,		/** pXo */
	AG903_TIMR_OUTMOD_LEVEL,		/** xo */
	AG903_TIMR_OUTMOD_MODENUM,		/** [h */
};

/** TIMnRSTTRG BOOTݒl */
enum _AG903_TimrRstBoot {
	AG903_TIMR_RSTBOOT_TICKCNT = 0,	/** NbN/TICK v */
	AG903_TIMR_RSTBOOT_EVENTCNT,	/** Cxgv */
	AG903_TIMR_RSTBOOT_PLUSECNT,	/** ͒[qpXv */
	AG903_TIMR_RSTBOOT_LEVELCNT,	/** ͒[qxv */
	AG903_TIMR_RSTBOOT_MODENUM,		/** [h */
};

/** TIMnRSTTRG ENݒl */
enum _AG903_TimrRstEn {
	AG903_TIMR_RSTEN_DISABLE = 0,	/** ZbggK */
	AG903_TIMR_RSTEN_RESEVE,		/** \ */
	AG903_TIMR_RSTEN_EXTPORT,		/** ZbggKL(O[q) */
	AG903_TIMR_RSTEN_EVENT,			/** ZbggKL(Cxg) */
	AG903_TIMR_RSTEN_MODENUM,		/** [h */
};

#define AG903_TIMR_INTMSK_CM_BIT	(1<<AG903_TIMn_INTMASK_CM_POS)	/** TIMnINTMASK CM-bit */
#define AG903_TIMR_INTMSK_OVF_BIT	(1<<AG903_TIMn_INTMASK_OVF_POS)	/** TIMnINTMASK OVF-bit */

#define AG903_TIMR_TRIGGER_CM_BIT	(1<<AG903_TIMn_TRIGGER_CM_POS)	/** TIMnTRIGGER CM-bit */
#define AG903_TIMR_TRIGGER_OVF_BIT	(1<<AG903_TIMn_TRIGGER_OVF_POS)	/** TIMnTRIGGER OVF-bit */

#define AG903_TIMR_DMAREQ_CM_BIT	(1<<AG903_TIMn_DMAREQ_CM_POS)	/** TIMnDMAREQ CM-bit */
#define AG903_TIMR_DMAREQ_OVF_BIT	(1<<AG903_TIMn_DMAREQ_OVF_POS)	/** TIMnDMAREQ OVF-bit */

#define AG903_TIMR_STAT_CM_BIT		(1<<AG903_TIMn_STAT_CM_POS)		/** TIMnSTAT CM-bit */
#define AG903_TIMR_STAT_OVF_BIT		(1<<AG903_TIMn_STAT_OVF_POS)	/** TIMnSTAT OVF-bit */

/** TIMnINMOD ݒl */
typedef struct _AG903_TIMRPrmInModeParam{
	uint8_t		eve;	/** EVE ݒl */
	uint8_t		lo;		/** LO ݒl */
	uint8_t		ch;		/** CH ݒl */
	uint8_t		pol;	/** POL ݒl */
	uint8_t		res;	/** RES ݒl */
}AG903_TIMRPrmInModeParam;

/** TIMnOUTMOD ݒl */
typedef struct _AG903_TIMRPrmOutModeParam{
	uint8_t		cm;		/** CM ݒl */
	uint8_t		ovf;	/** OVF ݒl */
	uint8_t		ch;		/** CH ݒl */
	uint8_t		pol;	/** POL ݒl */
	uint8_t		mod;	/** MOD ݒl */
}AG903_TIMRPrmOutModeParam;

/** TIMnRSTTRG ݒl */
typedef struct _AG903_TIMRPrmResetTriggerParam{
	uint8_t		eve;	/** EVE ݒl */
	uint8_t		lo;		/** LO ݒl */
	uint8_t		ch;		/** CH ݒl */
	uint8_t		pol;	/** POL ݒl */
	uint8_t		res;	/** RES ݒl */
	uint8_t		boot;	/** BOOT ݒl */
	uint8_t		en;		/** EN ݒl */
}AG903_TIMRPrmResetTriggerParam;


void AG903_TIMRPrmSetInMode(uint8_t ch, AG903_TIMRPrmInModeParam* param);
void AG903_TIMRPrmSetOutMode(uint8_t ch, AG903_TIMRPrmOutModeParam* param);
void AG903_TIMRPrmSetResetTrigger(uint8_t ch, AG903_TIMRPrmResetTriggerParam* param);
void AG903_TIMRPrmEnableOneshot(uint8_t ch);
void AG903_TIMRPrmDisableOneshot(uint8_t ch);
void AG903_TIMRPrmSetCntMode(uint8_t ch, uint8_t mode);
void AG903_TIMRPrmGetCntMode(uint8_t ch, uint8_t* mode);
void AG903_TIMRPrmSetCount(uint8_t ch, uint32_t count);
void AG903_TIMRPrmGetCount(uint8_t ch, uint32_t* count);
void AG903_TIMRPrmSetPeriod(uint8_t ch, uint32_t period);
void AG903_TIMRPrmGetPeriod(uint8_t ch, uint32_t* period);
void AG903_TIMRPrmSetMatch(uint8_t ch, uint32_t match);
void AG903_TIMRPrmGetMatch(uint8_t ch, uint32_t* match);
void AG903_TIMRPrmSetPluseWidth(uint8_t ch, uint32_t width);
void AG903_TIMRPrmGetPluseWidth(uint8_t ch, uint32_t* width);
void AG903_TIMRPrmEnableMask(uint8_t ch, uint32_t setbit);
void AG903_TIMRPrmDisableMask(uint8_t ch, uint32_t clrbit);
void AG903_TIMRPrmEnableEventTrigger(uint8_t ch, uint32_t setbit);
void AG903_TIMRPrmDisableEventTrigger(uint8_t ch, uint32_t clrbit);
void AG903_TIMRPrmEnableDmaRequest(uint8_t ch, uint32_t setbit);
void AG903_TIMRPrmDisableDmaRequest(uint8_t ch, uint32_t clrbit);
void AG903_TIMRPrmGetStatus(uint8_t ch, uint32_t* status);
void AG903_TIMRPrmClearStatus(uint8_t ch, uint32_t setbit);
void AG903_TIMRPrmSetBootTrigger(uint8_t chbit);

#ifdef __cplusplus
}
#endif
#endif /* _TIMRPRM_H_ */
