/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

static VGubyte rect_cmd[] = {
    VG_MOVE_TO_ABS, VG_LINE_TO_ABS, VG_LINE_TO_ABS, VG_LINE_TO_ABS, VG_CLOSE_PATH
};

static VGuint rect_coord[] = {
    0, 0,  200, 0, 200, 200, 0, 200,
};

static VGfloat color[4] = {
    1.0F, 0.5F, 0.5F, 1.0F
};

static VGfloat linearGradient[4] = {
    50, 50, 150, 150
};

static VGfloat radialGradient[5] = {
    100, 100, 40, 40, 80
};

static VGfloat rampStops[] = {
    0.0F, 1.0F, 0.0F, 0.0F, 1.0F,
    0.5F, 0.0F, 1.0F, 0.0F, 1.0F,
    1.0F, 0.0F, 0.0F, 1.0F, 1.0F,
};

/* IuWFNg */
static VGPath path;
static VGImage image;

static void *image_data;

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {1.0F, 1.0F, 1.0F, 1.0F};

    /* 摜Ǎ */
    image_data = GfxGetFreeArea(PAT_WIDTH, PAT_HEIGHT, PAT_BPP<<3);
    GfxFsRead((int8_t*)PAT_NAME, PAT_STRIDE * PAT_HEIGHT, (void*)image_data);

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);

    /* VGPathIuWFNg̐ */
    path = vgCreatePath(VG_PATH_FORMAT_STANDARD, VG_PATH_DATATYPE_S_32, 1.0F, 0.0F, 0, 0, VG_PATH_CAPABILITY_ALL);

    /* VGPathIuWFNgɌ`f[^o^ */
    vgAppendPathData(path, sizeof(rect_cmd), rect_cmd, rect_coord);

    /* VGImageIuWFNg̐ */
    image = vgCreateImage(VG_sRGBA_8888, PAT_WIDTH, PAT_HEIGHT, VG_IMAGE_QUALITY_NONANTIALIASED | VG_IMAGE_QUALITY_FASTER | VG_IMAGE_QUALITY_BETTER);

    /* VGImageIuWFNgɃC[Wf[^o^ */
    vgImageSubData(image, image_data, PAT_STRIDE, VG_sRGBA_8888, 0, 0, PAT_WIDTH, PAT_HEIGHT);

    /* Jg}gNXPATH_USER_TO_SURFACEɐݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_PATH_USER_TO_SURFACE);
}

static void DrawWithPaint(void)
{
    VGPaint paint;

    /* VGPaintIuWFNg̐ */
    paint = vgCreatePaint();

    /* yCgFILL`ɐݒ */
    vgSetPaint(paint, VG_FILL_PATH);

    /* J[yCg̐ݒƕ` */
    vgSetParameteri(paint, VG_PAINT_TYPE, VG_PAINT_TYPE_COLOR);
    /* yCgJ[̎w */
    vgSetParameterfv(paint, VG_PAINT_COLOR, 4, color);
    /* ʍɕ` */
    vgLoadIdentity();
    vgTranslate(80, 30);
    vgDrawPath(path, VG_FILL_PATH);

    /* J[ve[uiOf[Vj̐ݒ */
    vgSetParameterfv(paint, VG_PAINT_COLOR_RAMP_STOPS, sizeof(rampStops)/sizeof(rampStops[0]), rampStops);

    /* jAOfBGg̐ݒƕ` */
    vgSetParameteri(paint, VG_PAINT_TYPE, VG_PAINT_TYPE_LINEAR_GRADIENT);
    /* jAOfBGg̃p[^ݒ */
    vgSetParameterfv(paint, VG_PAINT_LINEAR_GRADIENT, 4, linearGradient);
    /* ʉEɕ` */
    vgLoadIdentity();
    vgTranslate(360, 30);
    vgDrawPath(path, VG_FILL_PATH);

    /* fBAOfBGg̐ݒƕ` */
    vgSetParameteri(paint, VG_PAINT_TYPE, VG_PAINT_TYPE_RADIAL_GRADIENT);
    /* fBAOfBGg̃p[^ݒ */
    vgSetParameterfv(paint, VG_PAINT_RADIAL_GRADIENT, 5, radialGradient);
    /* ʍɕ` */
    vgLoadIdentity();
    vgTranslate(80, 250);
    vgDrawPath(path, VG_FILL_PATH);

    /* p^yCg̐ݒƕ` */
    vgSetParameteri(paint, VG_PAINT_TYPE, VG_PAINT_TYPE_PATTERN);
    /* p^yCgƂĎgpVGImageݒ */
    vgPaintPattern(paint, image);
    /* p^yCgJԂ[hɎw */
    vgSetParameteri(paint, VG_PAINT_PATTERN_TILING_MODE, VG_TILE_REPEAT);
    /* ʉEɕ` */
    vgLoadIdentity();
    vgTranslate(360, 250);
    vgDrawPath(path, VG_FILL_PATH);

    /* yCgIuWFNg̔j */
    vgDestroyPaint(paint);

    /* FILL` */
    vgSetPaint(VG_INVALID_HANDLE, VG_FILL_PATH);
}

static void TestTerm(void)
{
    GfxReleaseFreeArea(image_data);

    /* IuWFNg̔j */
    vgDestroyPath(path);
    vgDestroyImage(image);
}

void PaintMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* yCg`揈 */
    DrawWithPaint();

    /* obt@Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}
