/**
 * @brief
 * @file		board.h
 * @author		AXELL
 * @history     2016_07_07	<p>
 *				2018_03_13	#1895 ^NgXCb`̐ڑ/ڑ̐ݒǉ.
 *              2025_03_06  [SDK3.7] SSPCuSPI[hł̑MANZX@\ǉ (#5662)
 * @description	Board_xxxx()֐gpꍇincludeB
 * @note        Ȃ
*/

/*
 * This program was created by Axell Corporation.
 * Copyright (C) 2017-2025 Axell Corporation, all rights reserved.
 */
#ifndef _BOARD_H_
#define _BOARD_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

/**
 * AiOrfI͐ݒ
 */
#define	TEST_CVBS_NONE				(0)
#define	TEST_CVBS_NTSC_BT			(1)
#define	TEST_CVBS_NTSC_SQ			(2)
#define	TEST_CVBS_NTSC_4F			(3)
#define	TEST_CVBS_PAL_BT			(4)
#define	TEST_CVBS_PAL_SQ			(5)
#define	TEST_CVBS_NUM_SET			(6)
#define	TEST_CVBS_MODE				TEST_CVBS_NTSC_BT		//͎ɎgptH[}bg`p

#define	TEST_CVBS_WIDTH				(720)
#define	TEST_CVBS_HEIGHT			(480)

#define AG903_CAPTURE_VPOS_NTSC_BT	(13)	/** Lv`̊JnW ʒu (NTSC/ITU-BT.601) */
#define AG903_CAPTURE_HPOS_NTSC_BT	(112)	/** Lv`̊JnW ʒu (NTSC/ITU-BT.601) */

#define AG903_FPGA_I2C_CH		(1)		/* FPGA I2C`l */
#define AG903_FPGA_SADDR		(0x22)	/* FPGA Slave Addr */
#define AG903_RTC_I2C_CH		(1)		/* RX-8025 I2C`l */
#define AG903_RTC_SADDR			(0x64)	/* RX-8025 Slave Addr */
#define AG903_SENSOR_I2C_CH		(1)		/* EMC1412 I2C`l */
#define AG903_SENSOR_SADDR		(0x98)	/* EMC1412 Slave Addr */
#define	AG903_CODEC_I2C_CH		(1)		/* Audio Codec I2C`l */
#define	AG903_CODEC_I2C_SADDR	(0x90)	/* Audio Codec Slave Address */

#define	AG903_VER_PKG_M02		(0x12)	/* FPGA {[ho[W M02 */
#define	AG903_UART0_TACTSW		(0x10)	/* FPGA UART0 ^NgXCb`ڑ */

enum {	/* UARTڑ */
	AG903_UART_CONNECT_NONE = 0,
	AG903_UART_CONNECT_COM1,
	AG903_UART_CONNECT_COM2,
	AG903_UART_CONNECT_COM3,
	AG903_UART_CONNECT_COM4,
	AG903_UART_CONNECT_RS485 = 7,
};

enum {	/* BLPڑ */
	AG903_BLP_CONNECT_NONE = 0,
	AG903_BLP_CONNECT_BL0,
	AG903_BLP_CONNECT_LED,
	AG903_BLP_CONNECT_LED_DELAY,
	AG903_BLP_CONNECT_GPIO,
	AG903_BLP_CONNECT_BL1,
};

enum {	/* EthernetI */
	AG903_ETHER_NONE = 0,
	AG903_ETHER_RMII,
	AG903_ETHER_MII,
};

enum {	/* SSPݒ */
	AG903_I2S_MASTER_READ,
	AG903_I2S_MASTER_WRITE,
};

enum {	/* USB[hݒ */
	AG903_USB_MODE_FUNCTION,
	AG903_USB_MODE_HOST,
};

void Board_SetPotrFunc(void);
int32_t Board_SetupCvbs(int32_t cvbs_mode);
void Board_BacklightSel(uint32_t ch, uint32_t sel);
void Board_SelectDviTX(void);
void Board_SelectDviRX(void);
void Board_ConnectEqsAndRam(void);
void Board_SelectUartConnection(uint8_t ch, uint8_t sel);
void Board_SelectBlpConnection(uint8_t port, uint8_t sel);
void Board_SetLedStatus(uint8_t led);
void Board_GetLedStatus(uint8_t* led);
void Board_ActivateAudioCodec(void);
void Board_SelectEthernetType(uint8_t type);
void Board_SelectUsbMode(uint8_t mode);
void Board_SetSspCommuType(uint8_t ch, uint8_t type);
void Board_SetSpiFlashInterface(void);
void Board_UnsetSpiFlashInterface(void);
void Board_WriteAudioCodec(uint8_t addr, uint8_t data);
void Board_EnablePbInt(uint8_t num, _Bool en);
void Board_ConnectTactSwitchs(_Bool en);

#ifdef  AG903_SAMPLE_USE_FS
void Board_SetCfInterface(void);
void Board_SetSdInterface(void);
#endif/*AG903_SAMPLE_USE_FS*/


#ifdef __cplusplus
}
#endif
#endif /* _BOARD_H_ */

