/** 
 * @brief           USBH MSC Scsictrl Header
 * @author          AXELL CORPORATION
 * @description     USBH MSC Scsictrl Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __USB_MSC_SCSICTRL_H__
#define __USB_MSC_SCSICTRL_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_msc_coreinclude.h"
#include "usb_msc_scsicmd.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/
typedef struct {
    uhs_ubit8_t u8VendorName[MAX_VENDOR_NAME_LENGTH + 1];   /* Җ */
    uhs_ubit8_t u8ProductName[MAX_PRODUCT_NAME_LENGTH + 1]; /* i */
    uhs_boolean_t bRemovable;                           /* [outO */
} STOR_SCSI_PRODUCT_INFO;

typedef struct {
    uhs_ubit16_t u16BlockSize;                          /* ZN^̃ubNTCY */
    uhs_ubit32_t u32LastBlockAddress;                   /* ŏIubNAhX */
} STOR_SCSI_CAPACITY_INFO;

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern USB_SCSI_STATUS Usbh_Stor_ScsiCtrl_Initialize(void);
extern uhs_boolean_t Usbh_Stor_ScsiCtrl_Finalize(void);
extern uhs_boolean_t Usbh_Stor_ScsiCtrl_AttachStorUnit(STOR_UNIT *pStorUnit);
extern uhs_boolean_t Usbh_Stor_ScsiCtrl_DetachStorUnit(STOR_UNIT *pStorUnit);
extern USB_SCSI_STATUS Usbh_Stor_ScsiCtrl_GetProductInfo(STOR_UNIT *pStorUnit, STOR_SCSI_PRODUCT_INFO *pInfo);
extern USB_SCSI_STATUS Usbh_Stor_ScsiCtrl_GetCapacityInfo(STOR_UNIT *pStorUnit, STOR_SCSI_CAPACITY_INFO *pInfo);
extern USB_SCSI_STATUS Usbh_Stor_ScsiCtrl_GetUnitStatus(STOR_UNIT *pStorUnit);
extern USB_SCSI_STATUS Usbh_Stor_ScsiCtrl_TestUnitReady( STOR_UNIT *pStorUnit );
extern USB_SCSI_STATUS Usbh_Stor_ScsiCtrl_ReadSector( STOR_UNIT *pStorUnit, uhs_ubit32_t u32LBA, uhs_ubit16_t u16BlockCnt, uhs_ubit8_t *pBuff );
extern USB_SCSI_STATUS Usbh_Stor_ScsiCtrl_WriteSector( STOR_UNIT *pStorUnit, uhs_ubit32_t u32LBA, uhs_ubit16_t u16BlockCnt, uhs_ubit8_t *pBuff );
extern USB_SCSI_STATUS Usbh_Stor_ScsiCtrl_StartStopUnit( STOR_UNIT *pStorUnit,uhs_ubit8_t u8Immed,uhs_ubit8_t u8LoEj,uhs_ubit8_t u8Start );

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_MSC_SCSICTRL_H__ */
