/**
 * @brief           User API Wrapper Header
 * @author          AXELL CORPORATION
 * @description     API_WRAPP  API֐i֐j̒`wb_
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */




#ifndef __APIWRAPPER_H__
#define __APIWRAPPER_H__
/* DOM-IGNORE-END */

// *************************************************************************************************
//	include
// *************************************************************************************************
#include	"uhs_config.h"
#include	"usbh_api.h"


// *************************************************************************************************
//	define
// *************************************************************************************************
#define GLOBAL

//	Lower[]̍ő吔iLOOPŎgpj
#define USB_ENUMDEV_MAXDEV (USB_MAX_LOWER_DEV+1)


/***********************************************************************
 * bpf[^\ ()
 ***********************************************************************/

// NGXgER[obN^XNNGXgs̃^CAEg
#define USB_TRANS_TIMEOUT               (1500)
#define USB_TRANS_TIMEOUT2              (USB_TRANS_TIMEOUT*2)
#define USB_TRANS_CANCELTIMEOUT         (1500)
#define USB_TRANS_CANCELTIMEOUT2        (USB_TRANS_CANCELTIMEOUT*2)

#define USB_CMPWAIT_ON_DETACH_TIMEOUT   ((USB_TRANS_TIMEOUT/10)+200)


#define USB_REQUEST_NOTABORTED          (0x00<<0)
#define USB_REQUEST_ABORTED             (0x01<<0)

#define	USBWRAP_MAJOR_VERSION			(0x01)									/* USB bpFW[o[W */
#define	USBWRAP_MINOR_VERSION			(0x00)									/* USB bpF}Ci[o[W */


// *************************************************************************************************
//	structure
// *************************************************************************************************

//------------------------------------------------------------------------------
//	API_WRAPPXbhɑ΂Message
//------------------------------------------------------------------------------
typedef enum _usb_wrap_msgtype {
    USBWRAP_MSG_NONE,
    USBWRAP_MSG_REQUEST_ISSUE,
    USBWRAP_MSG_REQUEST_ADDED,
    USBWRAP_MSG_REQUEST_COMP,
    USBWRAP_MSG_REQUEST_CANCEL,
    USBWRAP_MSG_RESTARTTASK,
    USBWRAP_MSG_ENDTASK,
    USBWRAP_MSG_ENDTASK_RECEIVE
} usb_wrap_msgtype;

//------------------------------------------------------------------------------
//	API_WRAPPXbhɑ΂Message SUB 
//------------------------------------------------------------------------------
typedef enum _usb_wrap_msgsubtype {
    USBWRAP_SUBMSG_NONE,
    USBWRAP_SUBMSG_CTLREQ,
    USBWRAP_SUBMSG_CTLREQ_CANCEL,
    USBWRAP_SUBMSG_BLKREQ,
    USBWRAP_SUBMSG_BLKREQ_CANCEL,
    USBWRAP_SUBMSG_INTREQ,
    USBWRAP_SUBMSG_INTREQ_CANCEL,
    USBWRAP_SUBMSG_ISOREQ,
    USBWRAP_SUBMSG_ISOREQ_CANCEL
} usb_wrap_msgsubtype;

//------------------------------------------------------------------------------
//	USB_HOSTŜ̃Xe[^XHH
//			́AgpĂȂIIII
//------------------------------------------------------------------------------
typedef enum  _usb_host_status{
	USBHSTAT_STARTUP,
	USBHSTAT_INITIAL,
	USBHSTAT_RUN,
	USBHSTAT_TERMINATE,
	USBHSTAT_IDLE
}usb_host_status;




//------------------------------------------------------------------------------
//	tf[^̈̒`
//------------------------------------------------------------------------------
typedef union _usb_wrap_msgdata {
        struct usb_control_block 	* ucb;
        void 						*context;
} usb_wrap_msgdata;


//------------------------------------------------------------------------------
//	API_WRAPPXbhɑMMessagetH[}bg̒`B
//------------------------------------------------------------------------------
typedef struct _usb_wrap_msg {
    usb_wrap_msgtype 				msgtype;									//	Message
    usb_wrap_msgsubtype 			msgsubtype;									//	Message SUB 
    usb_wrap_msgdata 				data;										//	tf[^̃|C^iucbAcontext̃|C^j
} usb_wrap_msg;


//------------------------------------------------------------------------------
//	NXhCo̓o^	iAPI_WRAPPŊǗNXhCoj
//------------------------------------------------------------------------------
typedef struct _usb_wrap_drvinfo {

    /* NXhCo */
    void							* drvreginfo;								// NXhCõhCoo^		iʂ̃f[^̂܂܁j
    struct class_driver_reginfo		* core_drvreginfo;							// RÃhCoo^					iCOREɓo^f[^AA^b`CBAPI_WRAPPɍւj
    udi_ubit8_t 					device_num;									// ݁ÃhCoœ쒆̃foCX

} usb_wrap_drvinfo;


//------------------------------------------------------------------------------
//	API_WRAPPXbhɑ΂郊NGXg
//------------------------------------------------------------------------------
typedef enum _usb_wrap_reqtype {

    USBWRAP_REQ_NONE,

    USBWRAP_REQ_CTL_OTHER,
    USBWRAP_REQ_CTL_GET_STATUS,
    USBWRAP_REQ_CTL_CLEAR_FEATURE,
    USBWRAP_REQ_CTL_SET_FEATURE,
    USBWRAP_REQ_CTL_SET_ADDRESS,
    USBWRAP_REQ_CTL_GET_DESC,
    USBWRAP_REQ_CTL_SET_DESC,
    USBWRAP_REQ_CTL_GET_CONFIG,
    USBWRAP_REQ_CTL_SET_CONFIG,
    USBWRAP_REQ_CTL_GET_INTERFACE,
    USBWRAP_REQ_CTL_SET_INTERFACE,
    USBWRAP_REQ_CTL_SYNCH_FRAME,

    USBWRAP_REQ_BULK,
    USBWRAP_REQ_INTERRUPT,
    USBWRAP_REQ_ISOCHRONOUS

} usb_wrap_reqtype;


//------------------------------------------------------------------------------
//	LZ
//			͖gpB
//------------------------------------------------------------------------------
typedef enum _usb_wrap_canceltype {
    USBWRAP_CANCELTYPE_NONE,
    USBWRAP_CANCELTYPE_NOTCANCELED,
    USBWRAP_CANCELTYPE_CANCELED,
    USBWRAP_CANCELTYPE_ABORTED
} usb_wrap_canceltype;


//------------------------------------------------------------------------------
//	ʂ̃NGXgAPI_WRAPPŏׂ̍\́B
//	mallocŊmۂāAdevinfoLISTɒǉĂB
//------------------------------------------------------------------------------
typedef struct _req_ucb_info {
    void 						* class_driver_request;							// NXhCõNGXg		NXhCo̗v̂܂ܕۑBi]MessageɂāÃ|C^CB֐ĂяoAj
    struct usb_control_block 	ucb;											// USB Rg[ubN			API_WRAPPCB֐ɍւpiCOREɓn̂́Aj
																				//	܂Ŏ

    usb_wrap_reqtype 			reqtype;										// NGXg^Cv
    udi_ubit32_t  				timeout;										// c莞
    udi_ubit32_t  				reqrecpttime;									// M
    uhs_boolean_t 				is_timeout;										// ^CAEgH
} requcb_info;


//------------------------------------------------------------------------------
//	API_WRAPPł́AfoCXǗ		iڑfoCXɊ蓖ĂBj
//		A^b`@ˁ@malloc
//		f^b`@ˁ@free
//------------------------------------------------------------------------------
typedef struct _usb_wrap_devinfo {

    kernel_context_t semid;														// {\̂̓pZ}tH

    kernel_context_t req_semid;													// NGXgǗpZ}tH			// add req_ sem

    /* NXhCo */
    usb_wrap_drvinfo *drvinfo;													// ΉhCoo^

    /* USB HOST X^bN */
    struct usbd_usb_deviceinfo* usbdev;											// USBfoCX

    uhs_list_node_t requcb_list;												// NGXgXgB̃NGXgێ
																				//	ɁArequcb_info ȂB

	//	OS \[X
	//^^^^^^^^^^^^^^^^^^^^^
    kernel_context_t reqtaskid;													// NGXg^XNID
    kernel_context_t cmptaskid;													// ^XNID
    kernel_context_t reqmsgid;													// NGXg XNpMessageQue ID
    kernel_context_t cmpmsgid;													// ^XNpMessageQue ID

    udi_ubit32_t  proc_reqnum;													// ̃NGXg(ł͍ő1)

    uhs_boolean_t  is_connected;												// foCX̃RlNg(TRUE: ڑAFALSE: ؒf)

} usb_wrap_devinfo;


//------------------------------------------------------------------------------
//	USB_HOST̏ςݏԁB
//			́AUsbh_Init(~)ŁANXhCo̓o^Ȃk
//			킹čŝŁȀ񎩑̂ɂ͑債Ӗ͖B
//			ς݂ǂBBB
//------------------------------------------------------------------------------
typedef enum _usb_wrap_status {
    USBWRAP_STAT_INIT_NOT_START,												//	
    USBWRAP_STAT_CNFSFT_INITCOMP,												//	API_WRAPP=ς݁^CORE=		̎_͉LISTɓo^
    USBWRAP_STAT_USBD_INITCOMP													//	API_WRAPP=ς݁^CORE=ς	̎_͖{LISTɓo^
   } usb_wrap_status;


//------------------------------------------------------------------------------
//	USB BUS 
//------------------------------------------------------------------------------
typedef enum _usb_bus_status {
    USBWRAP_STAT_USBBUS_NON_ACTIVE,
    USBWRAP_STAT_USBBUS_ACTIVE,
    USBWRAP_STAT_USBBUS_SUSPEND
} usb_bus_status;


//------------------------------------------------------------------------------
//	API_WRAPP ŊǗS̏
//------------------------------------------------------------------------------
typedef struct _usb_wrap_info {
																				//	ANZXpZ}tH
																				//	usb_wrap_drvinfo, usb_wrap_devinfo, tmp_drvlist, apiwrap_stat ANZXƂɎgp
    kernel_context_t drvinfo_semid;

																				//	{o^pNXhCoXg(usb_wrap_drvinfo \̂̃Xg)
    uhs_list_node_t usb_wrap_drvinfo_list;

																				//	o^foCXphCo
    usb_wrap_drvinfo unknowndev_driver;

																				//	API_WRAPPŁAA^b`ꂽfoCXLIST
    uhs_list_node_t usb_wrap_devinfo_list;

																				//	o^pNXhCoXg(USBS_CNFSFT_NOTIFICATION \̂̃Xg)
																				//	 USBH_USBD_Init sO̓NXhCoo^̓bpŕێĂB
																				//	 o^̓XgɂȂf[^j邱ƁB
    uhs_list_node_t tmp_drvlist;
    
																				//	apibp̃Xe[^X
																				//	 USBWRAP_STAT_CNFSFT_INITCOMP: 
																				//	   USBH_CNFSFT_Init() sς݁AUSBH_USBD_InitsO
																				//	 USBWRAP_STAT_USBD_INITCOMP:
																				//	   USBH_CNFSFT_Init() sς݁AUSBH_USBD_Initsς
    usb_wrap_status apiwrap_stat;
    
																				//	USB oX̃Xe[g
    usb_bus_status bus_stat;

																				//	apibppv[
    kernel_context_t mpl_osc;
    
																				//	ߓdR[obN
    usb_common_callback_t 		overload_callback;
    usb_common_callback_t		split_err_notify_callback;

} usb_wrap_info;


/***********************************************************************
 * bpf[^\ (܂)
 ***********************************************************************/

extern usb_wrap_info g_apiwrap_info;


// *************************************************************************************************
//	֐vg^Cv錾
// *************************************************************************************************
// NXhCoo^
uhs_status_t Usbh_RegistAppCallback( app_callback_info* app_cb );
uhs_status_t Usbh_InitClassDriver( usbh_regist_info init );
uhs_status_t Usbh_DriverRegister( void * class_driver_reg );
//static uhs_status_t Usbh_DriverRegisterForSpecificDevice( void * class_driver_reg );	/* [warning] never defined  .cֈړ */
//static uhs_status_t Usbh_DriverRegisterForUnknownDevice( void * class_driver_reg );	/* [warning] never defined  .cֈړ */
uhs_status_t Usbh_DriverUnRegister( void * class_driver_reg );
void Usbh_RegistOverCurrentCallback( usb_common_callback_t callback );
void		Usbh_RegistSplitErrNotifyCallback( usb_common_callback_t callback );
void Usbh_UnRegistAllAppCallback( void );

void         Usbh_EnableRegisteredDriver( void );

// foCXڑEؒf
//static int  Usbh_DevAttached( int mod_id, int callback_id, void* context );			/* [warning] never defined  .cֈړ */
int         Usbh_DevDetached( int mod_id, int callback_id, void* context );
//static uhs_status_t  Usbh_PrepareDeviceTask( usb_wrap_devinfo* wrap_devinfo );		/* [warning] never defined  .cֈړ */
//static uhs_status_t  Usbh_FinishDeviceTask( usb_wrap_devinfo* wrap_devinfo );			/* [warning] never defined  .cֈړ */

uhs_boolean_t Usbh_UnknownDevAttached( struct usbd_usb_deviceinfo* usbdev );

// NGXg
uhs_status_t Usbh_ProcSyncRequest( struct usb_control_block* ucb, usb_wrap_msgsubtype msgsubtype );
//static uhs_status_t Usbh_UsbRequestIssue( usb_wrap_devinfo* devinfo, struct uhs_mbxbuf* usbc_message );	/* [warning] never defined  .cֈړ */
//static int          Usbh_UsbRequestIssue_Completion( int mod_id, int callback_id, void* context );		/* [warning] never defined  .cֈړ */
//static uhs_status_t Usbh_UsbRequestComp( usb_wrap_devinfo* devinfo, struct uhs_mbxbuf* usbc_message );	/* [warning] never defined  .cֈړ */
//static uhs_status_t Usbh_ProcUsbRequestTmout( usb_wrap_devinfo *devinfo, requcb_info* requcb );			/* [warning] never defined  .cֈړ */
//static uhs_status_t Usbh_CancelRequestInPipe( usb_wrap_devinfo *devinfo, struct usb_control_block* ucb );	/* [warning] never defined  .cֈړ */
//static uhs_status_t Usbh_AbortAllRequest( usb_wrap_devinfo *devinfo );	/* [warning] never defined  .cֈړ */
//static uhs_status_t Usbh_Callback( void *req );							/* [warning] never defined  .cֈړ */
void Usbh_CallbackTask( void *context );
//static uhs_status_t Usbh_CallbackCanceledRequest( usb_wrap_devinfo *devinfo, void *req, uhs_status_t status );	/* [warning] never defined  .cֈړ */
//static uhs_status_t Usbh_Control_Request( usb_wrap_devinfo* devinfo, void * class_driver_request );		/* [warning] never defined  .cֈړ */
//static uhs_status_t Usbh_Bulk_Request( usb_wrap_devinfo* devinfo, void * class_driver_request );			/* [warning] never defined  .cֈړ */
//static uhs_status_t Usbh_Interrupt_Request( usb_wrap_devinfo* devinfo, void * class_driver_request );		/* [warning] never defined  .cֈړ */
//#ifdef USB_ENABLE_SET_CFG
//static uhs_status_t Usbh_Set_Configuration_Completion( struct usbd_usb_deviceinfo* usbdev, void * class_driver_request );	/* [warning] never defined  .cֈړ */
//#endif
//#ifdef USB_ENABLE_SET_IF
//static uhs_status_t Usbh_Set_Interface_Completion( struct usbd_usb_deviceinfo* usbdev, void * class_driver_request );		/* [warning] never defined  .cֈړ */
//#endif

void         Usbh_ReqProcTask( void* context );
void         Usbh_ReqCmpTask( void* context );


// bZ[W
uhs_status_t Usbh_SendRequest( void* class_driver_request, const uhs_ubit8_t address, const usb_wrap_msgtype msgtype, const usb_wrap_msgsubtype msgsubtype );
void         Usbh_SignalTask( kernel_context_t* taskmsgid, usb_wrap_msgtype msgtype, void* context );

// ̑
//static usb_bus_status Usbh_check_usbbus( void );		/* [warning] never defined  .cֈړ */
void           Usbh_Rh_Set_PortPower( const udi_ubit8_t port_num );
void           Usbh_Rh_Clear_PortPower( const udi_ubit8_t port_num );

void Usbh_call_overload_callback( const uhs_ubit8_t kind , struct usbd_usb_deviceinfo *usbhub, const uhs_ubit8_t port_num );
void	Usbh_call_split_err_notify_callback( struct	usbd_usb_spliterrinfo *ucb );


// [eBeB
//static struct class_driver_reginfo * Usbh_CreateClassDriverReginfo( void * class_driver_reg, usb_wrap_drvinfo * wrap_drvinfo );	/* [warning] never defined  .cֈړ */
//static void         Usbh_ReleaseClassDriverReginfo( struct class_driver_reginfo * );						/* [warning] never defined  .cֈړ */
//static requcb_info* Usbh_AllocReqUcbInfo( void * class_driver_request );									/* [warning] never defined  .cֈړ */
//static void         Usbh_ReleaseReqUcbInfo( requcb_info* requcb );										/* [warning] never defined  .cֈړ */
//static requcb_info* Usbh_GetRequcbInfo( usb_wrap_devinfo* devinfo, void * class_driver_request );			/* [warning] never defined  .cֈړ */
//static requcb_info* Usbh_GetRequcbInfoByUcb( usb_wrap_devinfo* devinfo, struct usb_control_block* ucb );	/* [warning] never defined  .cֈړ */
//static uhs_status_t Usbh_AddRequestToRequestList( usb_wrap_devinfo *devinfo, void *req );					/* [warning] never defined  .cֈړ */
//static uhs_status_t Usbh_DelRequestFromRequestList( usb_wrap_devinfo *devinfo, void *req );				/* [warning] never defined  .cֈړ */
//static udi_ubit32_t Usbh_GetMinTimeoutFromReqList( usb_wrap_devinfo* devinfo );							/* [warning] never defined  .cֈړ */
//static requcb_info* Usbh_GetReqMinTimeoutFromReqList( usb_wrap_devinfo* devinfo );						/* [warning] never defined  .cֈړ */
//static void         Usbh_UpdateLeftTime( requcb_info* requcb );											/* [warning] never defined  .cֈړ */
//static uhs_ubit32_t Usbh_getCurrentTime( void );															/* [warning] never defined  .cֈړ */
//static usb_wrap_msgtype    Usbh_GetMsgType( struct uhs_mbxbuf* usbc_message );							/* [warning] never defined  .cֈړ */
//static usb_wrap_msgsubtype Usbh_GetMsgSubType( struct uhs_mbxbuf* usbc_message );							/* [warning] never defined  .cֈړ */
//static void*        Usbh_GetMsgData( struct uhs_mbxbuf* usbc_message );									/* [warning] never defined  .cֈړ */
void         Usbh_Setup_Ucb( struct usb_control_block* ucb, void* data_buf, const uhs_ubit32_t data_len, usb_device_request_t* setup_data, const usb_common_callback_t complete_func, const uhs_ubit32_t time_out );
//static void         Usbh_decreqnum( udi_ubit32_t *reqnum );			/* [warning] never defined  .cֈړ */
//static struct uhs_mbxbuf*  Usbh_AllocMsg( void );						/* [warning] never defined  .cֈړ */
//static void         Usbh_FreeMsg( struct uhs_mbxbuf* usbc_message );	/* [warning] never defined  .cֈړ */
usb_device_request_t* Usbh_AllocDevReqInfo( void );
void         Usbh_FreeDevReqInfo( usb_device_request_t* devreq );
//static udi_sbit32_t Usbh_trans_statuscode( udi_sbit32_t statuscode );	/* [warning] never defined  .cֈړ */
//static usb_wrap_devinfo* Usbh_GetDevInfo( udi_ubit8_t devicenum );	/* [warning] never defined  .cֈړ */

#endif // __APIWRAPPER_H__

