/** 
 * @brief           USBH HID API Header
 * @author          AXELL CORPORATION
 * @description     USBH HID API Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef __USB_HID_API_H__
#define __USB_HID_API_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_hid_type.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/
/* I */
#define	USBHID_API_SUCCESS				0
/* l */
#define	USBHID_API_ERRCODE_BASE			(-0x0100)
/* p[^wɌ肪 */
#define	USBHID_API_PARAM_ERROR			(USBHID_API_ERRCODE_BASE - 1)
/* gpĂȂ */
#define	USBHID_API_NOT_READY			(USBHID_API_ERRCODE_BASE - 2)
/* HIDfoCXڑł */
#define	USBHID_API_NO_HID				(USBHID_API_ERRCODE_BASE - 3)
/* ΉHIDfoCXڑĂ */
#define	USBHID_API_NO_SUPPORT			(USBHID_API_ERRCODE_BASE - 4)
/* CallBack o^Ɏ{ς */
#define	USBHID_API_ALREADY_REGIST		(USBHID_API_ERRCODE_BASE - 5)
/* NXNGXg̓]ŃG[ */
#define	USBHID_API_TRANS_CLSREQ_FAILED	(USBHID_API_ERRCODE_BASE - 6)
/* VXe\[X(Z}tHAtOA)̃ANZXŃG[ */
#define	USBHID_API_SYS_OUT_OF_RESOURCE	(USBHID_API_ERRCODE_BASE - 7)
/* ̑̃VXeG[ */
#define	USBHID_API_SYS_SYSTEM_ERROR		(USBHID_API_ERRCODE_BASE - 8)
/* C^vg]ŃG[ */
#define	USBHID_API_TRANS_INT_FAILED		(USBHID_API_ERRCODE_BASE - 9)
/* Intrrupt IN vɔsς */
#define	USBHID_API_ALREADY_START_INTIN	(USBHID_API_ERRCODE_BASE - 10)
/* Intrrupt IN vɒ~ς */
#define	USBHID_API_ALREADY_STOP_INTIN	(USBHID_API_ERRCODE_BASE - 11)

/** R[obNID */
typedef enum _HID_CALLBACK_ID {
    CBID_HID_DEVATTACH,									/** foCXڑꂽ(gp\) */
    CBID_HID_DEVATTACH_NOT_USE,							/** foCXڑꂽ(gps) */
    CBID_HID_DEVDETACH									/** foCXؒfꂽ */
} HID_CALLBACK_ID;

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/
extern PHID_DRIVER g_pHidDriver;

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/

#endif /* __USB_HID_API_H__ */
