/** 
 * @brief           Communication Device Class Driver API Headerij
 * @author          AXELL CORPORATION
 * @description     Communication Device Class Driver񋟃wb_ij
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
#ifndef __USB_CDC_INTERNAL_API_H__
#define __USB_CDC_INTERNAL_API_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_cdc_coreinclude.h"
#include "usb_cdc_log.h"


extern uhs_status_t Usbh_Cdc_Init(app_callback_info* stCallback);
extern uhs_status_t Usbh_Cdc_Exit(void* stCallback);
extern uhs_status_t Usbh_Cdc_ReregisterCallback(app_callback_info* stCallback);

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/
#ifdef USBH_STACK_DEBUG_BUILD
#define IAPI_CDC_REPORT_SUMMARY(err) Usbh_Cdc_Log_ReportError( g_filename, __LINE__, (err), (uhs_ubit8_t*)"1", 0 )
#define IAPI_CDC_REPORT_DETAIL(err, mesg, len) Usbh_Cdc_Log_ReportError( g_filename, __LINE__, (err), (mesg), (len) )
#define IAPI_CDC_REPORT_MILESTONE(num) Usbh_Cdc_Log_ReportMilestone((num))
#else
#define IAPI_CDC_REPORT_SUMMARY(err) Usbh_Cdc_Log_ReportDummy(err)
#define IAPI_CDC_REPORT_DETAIL(err, mesg, len) Usbh_Cdc_Log_ReportDummy(err)
#define IAPI_CDC_REPORT_MILESTONE(num) Usbh_Cdc_Log_ReportMilestone((num))
#endif

#endif // __USB_CDC_INTERNAL_API_H__
