/**
 * Copyright (c) 2015 eForce.,Co.Ltd.
 * Linker script
 *
 * Code:        0x80000000 ~ 0x801FFFFF
 * TLB:         0x80200000 ~ 0x8027FFFF
 * Data:        0x80280000 ~ 0x806FFFFF
 * Vram:        0x80700000 ~ 0x83EDFFFF
 * Uncached:    0x83EE0000 ~ 0x83EEFFFF
 */

/* The size of the stack. */
_STACK_SIZE = DEFINED(_STACK_SIZE)  ? _STACK_SIZE : 0x4000;
_HEAP_SIZE  = DEFINED(_HEAP_SIZE)   ? _HEAP_SIZE  : 0x10000;
_heap_size = _HEAP_SIZE;

_IRQ_STACK_SIZE         = DEFINED(_IRQ_STACK_SIZE)        ? _IRQ_STACK_SIZE        : 0x400;
_FIQ_STACK_SIZE         = DEFINED(_FIQ_STACK_SIZE)        ? _FIQ_STACK_SIZE        : 0x100;
_SUPERVISOR_STACK_SIZE  = DEFINED(_SUPERVISOR_STACK_SIZE) ? _SUPERVISOR_STACK_SIZE : 0x400;
_ABORT_STACK_SIZE       = DEFINED(_ABORT_STACK_SIZE)      ? _ABORT_STACK_SIZE      : 0x100;
_UNDEFINED_STACK_SIZE   = DEFINED(_UNDEFINED_STACK_SIZE)  ? _UNDEFINED_STACK_SIZE  : 0x100;
_MONITOR_STACK_SIZE     = DEFINED(_MONITOR_STACK_SIZE)    ? _MONITOR_STACK_SIZE    : 0x400;

MEMORY
{
  SDRAM_CODE(rxw)       : ORIGIN = 0x80000000, LENGTH = 0x00200000  /* 2MB    */
  SDRAM_DATA(rw)        : ORIGIN = 0x80300000, LENGTH = 0x00200000  /* 2MB    */
  UNCACHED(rw)          : ORIGIN = 0x83EE0000, LENGTH = 0x00020000  /* 128KB  */
  TLB(rw)               : ORIGIN = 0x80200000, LENGTH = 0x00100000  /* 1MB    */
}

/* Specify the default entry point to the program */

ENTRY(_vector_table)

SECTIONS
{
  .vectors :
  {
    _svect = . ;
    KEEP(*(.vectors .vectors.*))
  } >SDRAM_CODE

  .text :
  {
    _stext = . ; _rom_base = . ;
    *(.text .stub .text.* .gnu.linkonce.t.*)
    *(.plt) 
    *(.gnu.warning) 
    *(.glue_7t) *(.glue_7) *(.vfp11_veneer)
    . = ALIGN(4) ;

    _ctor_list = . ;
    KEEP (*(SORT(.init_array.*)))
    KEEP (*(.init_array))
    LONG (0);

    _dtor_list = . ;
    KEEP (*(.fini_array))
    KEEP (*(SORT(.fini_array.*)))
    LONG (0);
    _etext  = . ;
  } >SDRAM_CODE

  .rodata :
  {
    . = ALIGN(4);
    _srodata = . ;
    *(SORT_BY_ALIGNMENT(.rodata*))
    *(.gnu.linkonce.r.*)
    . = ALIGN(4);
    _erdata  = . ;
  } >SDRAM_CODE

  .ARM.extab : 
  { 
    *(.ARM.extab* .gnu.linkonce.armextab.*) 
  } >SDRAM_CODE
  .ARM.exidx :
  {
    __exidx_start = .;
    *(.ARM.exidx*)
    *(.gnu.linkonce.armexidix.*.*)
    __exidx_end = .;
  } >SDRAM_CODE

  _erodata = . ;

  .data :
  {
    . = ALIGN(4);
    _data  = LOADADDR(.data);
    _sdata = . ;
    *(SORT_BY_ALIGNMENT(.data*))
    *(.gnu.linkonce.d.*)
    . = ALIGN (8);
    _edata = . ;
  } >SDRAM_DATA

  .bss : {
    _sbss = . ;
    _fbss = . ;
    *(.shbss)
    *(.bss)
    *(.bss.*)
    *(.gnu.linkonce.b.*)
    *(COMMON)
    _ebss = . ;
    . = ALIGN(16) ;
    _heap = .;
    . += _HEAP_SIZE;
    _eheap = . ;
  } >SDRAM_DATA

  _end = . ;

  .stack :
  {
    . = ALIGN(16);

    _stack_end = .;
    . += _STACK_SIZE;
    . = ALIGN(16);
    _stack = .;
    __stack = _stack;

    _irq_stack_end = .;
    . += _IRQ_STACK_SIZE;
    __irq_stack = .;

    _fiq_stack_end = .;
    . += _FIQ_STACK_SIZE;
    . = ALIGN(16);
    __fiq_stack = .;

    _supervisor_stack_end = .;
    . += _SUPERVISOR_STACK_SIZE;
    . = ALIGN(16);
    __supervisor_stack = .;

    _abort_stack_end = .;
    . += _ABORT_STACK_SIZE;
    . = ALIGN(16);
    __abort_stack = .;

    _undefined_stack_end = .;
    . += _UNDEFINED_STACK_SIZE;
    . = ALIGN(16);
    __undefined_stack = .;

    _monitor_stack_end = .;
    . += _MONITOR_STACK_SIZE;
    . = ALIGN(16);
    __monitor_stack = .;

  } >SDRAM_DATA

  .system (NOLOAD) :
  {
    . = ALIGN(4);
    __vecttbl_begin = .;
    *(.vecttbl)
    __vecttbl_end = .;
    . = ALIGN(4);
    __vinftbl_begin = .;
    *(.vinftbl)
    __vinftbl_end = .;
    . = ALIGN(4);
    *(.localmplmem)
    *(.localstkmem)
    *(.mplmem)
    *(.sys)
    *(.sysmem)
    *(.stkmem)
    *(.mplmem)
  } >SDRAM_DATA

  .mmu_tbl : {
    . = ALIGN(0x4000);  /* TLB area must be aligned to 16Kb */
    __mmu_tbl_start = .;
    *(.mmu_tbl)
    __mmu_tbl_end = .;
  } > TLB

  .uncache : 
  {
    . = ALIGN(0x20);    /* aligned to the cache line size */
    *(.uncache)
  } > UNCACHED


  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }

  .debug_info     0 : { *(.debug_info) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
}
