/**
 * @brief           WDT Register Definition
 * @author          AXELL CORPORATION
 * @description     WDT Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_WDT_REGMAP_H_
#define _AG903_WDT_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** WDT Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __I  uint32_t  WdCounter;
    };

    union {
        __IO uint32_t  WdLoad;
    };

    union {
        __O  uint32_t  WdRestart;

        struct {
            __O  uint32_t  WdRestart                      : 16;
        } WdRestart_bits;
    };

    union {
        __IO uint32_t  WdCR;

        struct {
            __IO uint32_t  WdEnable                       :  1;
            __IO uint32_t  WdRst                          :  1;
            __IO uint32_t  WdIntr                         :  1;
            __IO uint32_t  WdExt                          :  1;
            __IO uint32_t  WdClock                        :  1;
        } WdCR_bits;
    };

    union {
        __I  uint32_t  WdStatus;

        struct {
            __I  uint32_t  WdStatus                       :  1;
        } WdStatus_bits;
    };

    union {
        __O  uint32_t  WdClear;

        struct {
            __O  uint32_t  WdClear                        :  1;
        } WdClear_bits;
    };

    union {
        __IO uint32_t  WdIntrlen;

        struct {
            __IO uint32_t  WdIntrlen                      :  8;
        } WdIntrlen_bits;
    };

    union {
        __I  uint32_t  WdRevision;
    };

/* DOM-IGNORE-END */
}AG903_WDT_Type;

#define AG903_WDT                                ((volatile AG903_WDT_Type *) AG903_WDT_BASE)                            /** WDT Base Address */


#define AG903_WDT_WdCounter_WdCounter_POS                  0                                                             /** WDTWdCounter WdCounter-bit position */
#define AG903_WDT_WdCounter_WdCounter_MSK                  (0xffffffffUL << AG903_WDT_WdCounter_WdCounter_POS)           /** WDTWdCounter WdCounter-bit mask */

#define AG903_WDT_WdLoad_WdLoad_POS                        0                                                             /** WDTWdLoad WdLoad-bit position */
#define AG903_WDT_WdLoad_WdLoad_MSK                        (0xffffffffUL << AG903_WDT_WdLoad_WdLoad_POS)                 /** WDTWdLoad WdLoad-bit mask */

#define AG903_WDT_WdRestart_WdRestart_POS                  0                                                             /** WDTWdRestart WdRestart-bit position */
#define AG903_WDT_WdRestart_WdRestart_MSK                  (0xffffUL << AG903_WDT_WdRestart_WdRestart_POS)               /** WDTWdRestart WdRestart-bit mask */

#define AG903_WDT_WdCR_WdEnable_POS                        0                                                             /** WDTWdCR WdEnable-bit position */
#define AG903_WDT_WdCR_WdEnable_MSK                        (0x1UL << AG903_WDT_WdCR_WdEnable_POS)                        /** WDTWdCR WdEnable-bit mask */
#define AG903_WDT_WdCR_WdRst_POS                           1                                                             /** WDTWdCR WdRst-bit position */
#define AG903_WDT_WdCR_WdRst_MSK                           (0x1UL << AG903_WDT_WdCR_WdRst_POS)                           /** WDTWdCR WdRst-bit mask */
#define AG903_WDT_WdCR_WdIntr_POS                          2                                                             /** WDTWdCR WdIntr-bit position */
#define AG903_WDT_WdCR_WdIntr_MSK                          (0x1UL << AG903_WDT_WdCR_WdIntr_POS)                          /** WDTWdCR WdIntr-bit mask */
#define AG903_WDT_WdCR_WdExt_POS                           3                                                             /** WDTWdCR WdExt-bit position */
#define AG903_WDT_WdCR_WdExt_MSK                           (0x1UL << AG903_WDT_WdCR_WdExt_POS)                           /** WDTWdCR WdExt-bit mask */
#define AG903_WDT_WdCR_WdClock_POS                         4                                                             /** WDTWdCR WdClock-bit position */
#define AG903_WDT_WdCR_WdClock_MSK                         (0x1UL << AG903_WDT_WdCR_WdClock_POS)                         /** WDTWdCR WdClock-bit mask */

#define AG903_WDT_WdStatus_WdStatus_POS                    0                                                             /** WDTWdStatus WdStatus-bit position */
#define AG903_WDT_WdStatus_WdStatus_MSK                    (0x1UL << AG903_WDT_WdStatus_WdStatus_POS)                    /** WDTWdStatus WdStatus-bit mask */

#define AG903_WDT_WdClear_WdClear_POS                      0                                                             /** WDTWdClear WdClear-bit position */
#define AG903_WDT_WdClear_WdClear_MSK                      (0x1UL << AG903_WDT_WdClear_WdClear_POS)                      /** WDTWdClear WdClear-bit mask */

#define AG903_WDT_WdIntrlen_WdIntrlen_POS                  0                                                             /** WDTWdIntrlen WdIntrlen-bit position */
#define AG903_WDT_WdIntrlen_WdIntrlen_MSK                  (0xffUL << AG903_WDT_WdIntrlen_WdIntrlen_POS)                 /** WDTWdIntrlen WdIntrlen-bit mask */

#define AG903_WDT_WdRevision_WdRevision_POS                0                                                             /** WDTWdRevision WdRevision-bit position */
#define AG903_WDT_WdRevision_WdRevision_MSK                (0xffffffffUL << AG903_WDT_WdRevision_WdRevision_POS)         /** WDTWdRevision WdRevision-bit mask */

#endif /* _AG903_WDT_REGMAP_H_ */

