/** 
 * @brief           USBH MSC Type Header
 * @author          AXELL CORPORATION
 * @description     USBH MSC Type Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __USB_MSC_TYPE_H__
#define __USB_MSC_TYPE_H__
/* DOM-IGNORE-END */

#include "usbh_api.h"
#include "usbc_api.h"
#include "usb_msc_api.h"
#include "usb_msc_scsierror.h"
#include "usb_msc_param.h"

/* ================================================================================================= */
/* {^ւ̃|C^^ */
/* ================================================================================================= */
typedef struct StorClassDriver* PSTOR_CLASS_DRIVER;
typedef struct StorDevice* PSTOR_DEVICE;
typedef struct StorPipe* PSTOR_PIPE;

/* ================================================================================================= */
/* CBW, CSW i[obt@^ */
/* ================================================================================================= */
typedef uhs_ubit8_t STOR_BUFF;

/* ================================================================================================= */
/* Command Block f[^] */
/* ================================================================================================= */
typedef enum {
    CBDATA_NONE,                                        /* f[^]Ȃ */
    CBDATA_IN,                                          /* IN  */
    CBDATA_OUT                                          /* OUT  */
} CB_DATA_DIR;

/* ================================================================================================= */
/* Command Block f[^obt@ */
/* ================================================================================================= */
typedef struct StorCbDataBuffer {
    uhs_ubit8_t *pBuff;                                 /* f[^obt@ */
    uhs_ubit32_t u32Size;                               /* f[^obt@̃TCY */
    uhs_ubit32_t u32Length;                             /* ]f[^ */
    CB_DATA_DIR nDir;                                   /* ] */
    uhs_boolean_t bSelfMalloc;                          /* f[^obt@̎ȒBtO */
} STOR_CB_DATA_BUFF;

/* ================================================================================================= */
/* Xg[WfoCX̏ */
/* ================================================================================================= */
typedef enum {
    DEVICE_STAT_GOOD,                                   /* gp\ */
    DEVICE_STAT_BAD                                     /* gps\ */
} DEVICE_STAT;

/* ================================================================================================= */
/* Xg[Wjbg̏ */
/* ================================================================================================= */
typedef enum {
    STOR_STAT_READY,                                    /* gp\ */
    STOR_STAT_NOT_READY,                                /* gps(fBA) */
    STOR_STAT_NOT_USE                                   /* gps(G[L) */
} STOR_STAT;

/* ================================================================================================= */
/* Xg[WNXhCo ^̒` */
/* ================================================================================================= */
typedef struct StorClassDriver {
    /* -- vpeB\o[ ----------------------------------------------------------------- */
    usb_common_callback_t pUserAttachCallback;                      /* [UAvP[Vw Attach Callback ֐ */
    usb_common_callback_t pUserDetachCallback;                      /* [UAvP[Vw Detach Callback ֐ */
    int (*pApiLayerAttachCallback)(PSTOR_UNIT pStorUnit);           /* MSC API w Attach Callback ֐ */
    int (*pApiLayerDetachCallback)(PSTOR_UNIT pStorUnit);           /* MSC API w Detach Callback ֐ */
    uhs_boolean_t (*pCmdLayerAttachCallback)(PSTOR_UNIT pStorUnit); /* R}hw Attach Callback ֐ */
    uhs_boolean_t (*pCmdLayerDetachCallback)(PSTOR_UNIT pStorUnit); /* R}hw Detach Callback ֐ */
    uhs_sbit32_t s32LastError;                                      /* ŌɔG[ */
    struct class_driver_reginfo *pDrvRegInfo;                       /* Core o^pe[ũobt@ */
    /* -- \\o[ ----------------------------------------------------------------------- */
    struct StorDevice*  pStorDeviceHead;                            /* {hCoǗfoCX̃Xg */
} STOR_CLASS_DRIVER;

/* ================================================================================================= */
/* Xg[WfoCX ^̒` */
/* ================================================================================================= */
typedef struct StorDevice {
    /* -- vpeB\o[ ----------------------------------------------------------------- */
    struct usbd_usb_deviceinfo *pUsbCore_Dev;           /* USB Core ێfoCX */
    uhs_ubit8_t u8MaxLUN;                               /* {foCX̍ő LUN  */
    struct StorUnit* pStorUnitHead;                     /* {foCXǗ StorUnit ̃Xg */
    struct StorPipe*  pDCtrlPipe_I;                     /* {foCX Default Ctrl Pipe */
    struct StorPipe*  pDCtrlPipe_O;                     /* {foCX Default Ctrl Pipe */
    struct StorPipe*  pBulkInPipe;                      /* {foCX Bulk In Pipe */
    struct StorPipe*  pBulkOutPipe;                     /* {foCX Bulk Out Pipe */
    DEVICE_STAT nDeviceStat;                            /* foCX̏ */
    /* -- ̂߂̃o[ --------------------------------------------------------------------- */
    kernel_context_t oExecuteLockObj;                   /* bNIuWFNg̎() */
    kernel_context_t* pExecuteLock;                     /* Command Block sbNւ̃|C^ */
    /* -- \\o[ ----------------------------------------------------------------------- */
    struct StorDevice*  pNext;                          /* ̃Xg[WfoCX */
    struct StorClassDriver*  pParent;                   /* {Xg[WfoCXǗehCo */
    uhs_boolean_t (*Delete)(PSTOR_DEVICE);              /* foCX̍폜֐ */
} STOR_DEVICE;

/* ================================================================================================= */
/* Xg[WpCv ^̒` */
/* ================================================================================================= */
typedef struct StorPipe {
    /* -- vpeB\o[ ----------------------------------------------------------------- */
    uhs_ubit32_t u32PipeInfo;                           /* { Pipe  Core \LbV */
    struct usb_control_block *pUcb;                     /* { Pipe gp UCB  */
    struct usb_control_block *pClearFeatureUcb;         /* { Pipe gp ClearFeaturepUCB  */
    uhs_boolean_t bIsOpen;                              /* I[v */
    /* -- \\o[ ----------------------------------------------------------------------- */
    struct usbd_usb_deviceinfo *pParentDev;             /* { Pipe efoCX */
} STOR_PIPE;

/* ================================================================================================= */
/* Xg[Wjbg ^̒` */
/* ================================================================================================= */
typedef struct StorUnit {
    /* -- vpeB\o[ ----------------------------------------------------------------- */
    uhs_ubit8_t u8UnitNumber;                               /* {jbg̃jbgԍ */
    uhs_ubit8_t u8VendorName[MAX_VENDOR_NAME_LENGTH + 1];   /* Җobt@ */
    uhs_ubit8_t u8ProductName[MAX_PRODUCT_NAME_LENGTH + 1]; /* iobt@ */
    uhs_boolean_t bRemovable;                               /* [outO */
    uhs_ubit16_t u16BlockSize;                              /* ZN^̃ubNTCY */
    uhs_ubit32_t u32LastBlockAddress;                       /* ŏIubNAhX */
    STOR_STAT nStorStat;                                    /* jbg̏ */
    /* -- BulkOnlyTransport wgp郁o[ --------------------------------------------------- */
    STOR_BUFF *pCBW;                                        /* { StorUnit gp CBW obt@ */
    STOR_BUFF *pCSW;                                        /* { StorUnit gp CSW obt@ */
    STOR_CB_DATA_BUFF *pDATA;                               /* { StorUnit gpf[^obt@ */
    uhs_ubit32_t u32CBWTag;                                 /* { StorUnit  CBWTag l */
    /* -- SCSI wgp郁o[ ---------------------------------------------------------------- */
    USB_SCSI_STATUS (*ExecuteCmd)(PSTOR_UNIT pStorUnit,
                                  uhs_ubit8_t *pCb,
                                  uhs_ubit8_t u8CbLen,
                                  uhs_ubit8_t *pDataBuf,
                                  uhs_ubit32_t u32DataLen,
                                  CB_DATA_DIR nDataDir);    /* Command Block ̎s֐ */
    /* -- API wgp郁o[ ----------------------------------------------------------------- */
    uhs_sbit32_t s32LastError;                              /* ŌɔG[ */
    /* -- \\o[ ----------------------------------------------------------------------- */
    PSTOR_UNIT pNext;                                       /* ̃jbg */
    struct StorDevice*  pParent;                            /* {jbgeXg[WfoCX */
    uhs_boolean_t (*Delete)(PSTOR_UNIT);                    /* jbg̍폜֐ */
} STOR_UNIT;

#endif  /* __USB_MSC_TYPE_H__ */

