/**
 * @brief           OpenVGpVRAMv[Ǘ֐wb_
 * @author          AXELL CORPORATION
 * @description     OpenVG̐pVRAMv[̃Ǘ̒`
 * @note            none
 * @history         2017_02_22  
 * @history         2019_03_08  [SDK2.2] gmInitializeŖ̂ƂVRAM̈悪dsC (#2155)
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef GMALLOC_H
#define GMALLOC_H
/* DOM-IGNORE-END */

#include <stdint.h>

#if 0
#define GMLIB(func)    XXXX_##func
#else
#define GMLIB(func)    func
#endif

#if !defined(MemAddr)
    typedef unsigned long   MemAddr;
#endif

#define GMAPI extern
#define GM_BAD_ADDR                 (MemAddr)0xFFFFFFFF

/* Default OpneVG VRAM pool size */
#define GM_DEFAULT_START_ADDR       0x83000000
#define GM_DEFAULT_HEAP_SIZE        0x00FF0000

#ifdef __cplusplus
extern "C" {
#endif
GMAPI       int   GMLIB(gmInitialize)(MemAddr start_addr, unsigned int size);
GMAPI       void  GMLIB(gmTerminate)(void);
GMAPI       void* GMLIB(gmMalloc)(unsigned int size, unsigned int align);
GMAPI       void  GMLIB(gmFree)(void *p);

/* Porting functions */
#include <stddef.h>
void *malloc_ovg(size_t size);
void free_ovg(void *ptr);
void *realloc_ovg(void *ptr, size_t size);

/* Address space translation OpenVG core from/to CPU */
#define GM2M(GM)  ((uintptr_t)(  (MemAddr)(GM) | 0x80000000))
#define M2GM(M)   (  (MemAddr)((uintptr_t)(M)  & 0x7fffffff))

#ifdef __cplusplus
}
#endif
#endif /* GMALLOC_H */

