/** 
 * @brief           BSC Primitive Header
 * @author          AXELL CORPORATION
 * @description     BSC Primitive񋟃wb_B<p>BSC PrimitivegpincludeĉB
 * @note            none
 * @history         2017_10_26  Ver2.0  
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
#ifndef _BSCPRM_H_
#define _BSCPRM_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include "lib_common/AG903_common.h"

#ifdef __cplusplus
extern "C" {
#endif

/** poX HOST[h */
#define	AG903_BSC_PBMODE_HOST			(0)
/** poX DEVICE[h */
#define AG903_BSC_PBMODE_DEVICE 		(1)
/** poX f[^16bit */
#define	AG903_BSC_DTWIDTH_16			(0)
/** poX f[^32bit */
#define AG903_BSC_DTWIDTH_32			(1)
/** ΏۃRg[ CF */
#define AG903_BSC_CFMODE_CF				(1)
/** ΏۃRg[ ATA */
#define AG903_BSC_CFMODE_ATA			(2)
/** [qɐ (_) */
#define AG903_BSC_POL_NEGATIVE			(0)
/** [qɐ (_) */
#define AG903_BSC_POL_POSITIVE			(1)

/**
 * oXXe[^X
 */
typedef struct _AG903_BSCPrmPbstat{
	uint8_t		ata_ctr;	/** ATARg[̏ */
	uint8_t		cf_ctr;		/** CFRg[̏ */
	uint8_t		bus_req;	/** oXv */
	uint8_t		bus_grt;	/** oX */
	uint8_t		pbus_mode;	/** poX[h */
	uint8_t		bus_wid;	/** poX̃f[^ */
}AG903_BSCPrmPbstat;


void AG903_BSCPrmGetPbstat(AG903_BSCPrmPbstat* stat);
void AG903_BSCPrmSetIntMask(uint8_t mask);
void AG903_BSCPrmGetIntMask(uint8_t* mask);
void AG903_BSCPrmSetIntMode(uint8_t mode);
void AG903_BSCPrmGetIntMode(uint8_t* mode);
void AG903_BSCPrmSetIntPol(uint8_t pol);
void AG903_BSCPrmGetIntPol(uint8_t* pol);
void AG903_BSCPrmSetIntClr(uint8_t clr);
void AG903_BSCPrmSetCfMode(uint8_t mode);
void AG903_BSCPrmGetCfMode(uint8_t* mode);
void AG903_BSCPrmSetDmaPol(uint8_t req, uint8_t ack);
void AG903_BSCPrmGetDmaPol(uint8_t* req, uint8_t* ack);
void AG903_BSCPrmSetCfpmCmd(uint8_t slp, uint8_t act, uint8_t cmd);
void AG903_BSCPrmGetCfpmCmd(uint8_t* slp, uint8_t* act);
void AG903_BSCPrmGetCfpmStat(uint8_t* cd, uint8_t* stat);
void AG903_BSCPrmSetCfpmTon(uint32_t cycle);
void AG903_BSCPrmGetCfpmTon(uint32_t* cycle);
void AG903_BSCPrmSetCfpmTr0(uint32_t cycle);
void AG903_BSCPrmGetCfpmTr0(uint32_t* cycle);
void AG903_BSCPrmSetCfpmTr1(uint32_t cycle);
void AG903_BSCPrmGetCfpmTr1(uint32_t* cycle);
void AG903_BSCPrmSetCfpmTr2(uint32_t cycle);
void AG903_BSCPrmGetCfpmTr2(uint32_t* cycle);
void AG903_BSCPrmSetCfpmTpr(uint32_t cycle);
void AG903_BSCPrmGetCfpmTpr(uint32_t* cycle);

#ifdef __cplusplus
}
#endif
#endif /* _BSCPRM_H_ */

